import "core-js/modules/es.object.freeze.js";
import "core-js/modules/es.symbol.js";
import "core-js/modules/es.symbol.description.js";
import "core-js/modules/es.object.to-string.js";
import "core-js/modules/es.symbol.iterator.js";
import "core-js/modules/es.string.iterator.js";
import "core-js/modules/es.array.iterator.js";
import "core-js/modules/web.dom-collections.iterator.js";
import "core-js/modules/es.function.name.js";
import "core-js/modules/es.array.from.js";

var _templateObject;

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

import "core-js/modules/es.string.search.js";
import "core-js/modules/es.regexp.exec.js";
import "core-js/modules/es.array.join.js";
import "core-js/modules/es.object.keys.js";
import "core-js/modules/web.dom-collections.for-each.js";
import "core-js/modules/es.string.split.js";
import "core-js/modules/es.array.slice.js";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import global from 'global';
import { logger } from '@storybook/client-logger';
import AnsiToHtml from 'ansi-to-html';
import dedent from 'ts-dedent';
import qs from 'qs';
var document = global.document;
var layoutClassMap = {
  centered: 'sb-main-centered',
  fullscreen: 'sb-main-fullscreen',
  padded: 'sb-main-padded'
};
var Mode;

(function (Mode) {
  Mode["MAIN"] = "MAIN";
  Mode["NOPREVIEW"] = "NOPREVIEW";
  Mode["PREPARING_STORY"] = "PREPARING_STORY";
  Mode["PREPARING_DOCS"] = "PREPARING_DOCS";
  Mode["ERROR"] = "ERROR";
})(Mode || (Mode = {}));

var classes = {
  PREPARING_STORY: 'sb-show-preparing-story',
  PREPARING_DOCS: 'sb-show-preparing-docs',
  MAIN: 'sb-show-main',
  NOPREVIEW: 'sb-show-nopreview',
  ERROR: 'sb-show-errordisplay'
};
var ansiConverter = new AnsiToHtml({
  escapeXML: true
});
export var WebView = /*#__PURE__*/function () {
  function WebView() {
    _classCallCheck(this, WebView);

    this.currentLayoutClass = void 0;
    this.testing = false;

    // Special code for testing situations
    var _qs$parse = qs.parse(document.location.search, {
      ignoreQueryPrefix: true
    }),
        __SPECIAL_TEST_PARAMETER__ = _qs$parse.__SPECIAL_TEST_PARAMETER__;

    switch (__SPECIAL_TEST_PARAMETER__) {
      case 'preparing-story':
        {
          this.showPreparingStory();
          this.testing = true;
          break;
        }

      case 'preparing-docs':
        {
          this.showPreparingDocs();
          this.testing = true;
          break;
        }

      default: // pass;

    }
  } // Get ready to render a story, returning the element to render to


  _createClass(WebView, [{
    key: "prepareForStory",
    value: function prepareForStory(story) {
      this.showStory();
      this.applyLayout(story.parameters.layout);
      document.documentElement.scrollTop = 0;
      document.documentElement.scrollLeft = 0;
      return this.storyRoot();
    }
  }, {
    key: "storyRoot",
    value: function storyRoot() {
      return document.getElementById('root');
    }
  }, {
    key: "prepareForDocs",
    value: function prepareForDocs() {
      this.showMain();
      this.showDocs();
      this.applyLayout('fullscreen');
      return this.docsRoot();
    }
  }, {
    key: "docsRoot",
    value: function docsRoot() {
      return document.getElementById('docs-root');
    }
  }, {
    key: "applyLayout",
    value: function applyLayout() {
      var layout = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'padded';

      if (layout === 'none') {
        document.body.classList.remove(this.currentLayoutClass);
        this.currentLayoutClass = null;
        return;
      }

      this.checkIfLayoutExists(layout);
      var layoutClass = layoutClassMap[layout];
      document.body.classList.remove(this.currentLayoutClass);
      document.body.classList.add(layoutClass);
      this.currentLayoutClass = layoutClass;
    }
  }, {
    key: "checkIfLayoutExists",
    value: function checkIfLayoutExists(layout) {
      if (!layoutClassMap[layout]) {
        logger.warn(dedent(_templateObject || (_templateObject = _taggedTemplateLiteral(["The desired layout: ", " is not a valid option.\n         The possible options are: ", ", none."])), layout, Object.keys(layoutClassMap).join(', ')));
      }
    }
  }, {
    key: "showMode",
    value: function showMode(mode) {
      Object.keys(Mode).forEach(function (otherMode) {
        if (otherMode === mode) {
          document.body.classList.add(classes[otherMode]);
        } else {
          document.body.classList.remove(classes[otherMode]);
        }
      });
    }
  }, {
    key: "showErrorDisplay",
    value: function showErrorDisplay(_ref) {
      var _ref$message = _ref.message,
          message = _ref$message === void 0 ? '' : _ref$message,
          _ref$stack = _ref.stack,
          stack = _ref$stack === void 0 ? '' : _ref$stack;
      var header = message;
      var detail = stack;
      var parts = message.split('\n');

      if (parts.length > 1) {
        var _parts = _slicedToArray(parts, 1);

        header = _parts[0];
        detail = parts.slice(1).join('\n');
      }

      document.getElementById('error-message').innerHTML = ansiConverter.toHtml(header);
      document.getElementById('error-stack').innerHTML = ansiConverter.toHtml(detail);
      this.showMode(Mode.ERROR);
    }
  }, {
    key: "showNoPreview",
    value: function showNoPreview() {
      var _this$storyRoot, _this$docsRoot;

      if (this.testing) return;
      this.showMode(Mode.NOPREVIEW); // In storyshots this can get called and these two can be null

      (_this$storyRoot = this.storyRoot()) === null || _this$storyRoot === void 0 ? void 0 : _this$storyRoot.setAttribute('hidden', 'true');
      (_this$docsRoot = this.docsRoot()) === null || _this$docsRoot === void 0 ? void 0 : _this$docsRoot.setAttribute('hidden', 'true');
    }
  }, {
    key: "showPreparingStory",
    value: function showPreparingStory() {
      this.showMode(Mode.PREPARING_STORY);
    }
  }, {
    key: "showPreparingDocs",
    value: function showPreparingDocs() {
      this.showMode(Mode.PREPARING_DOCS);
    }
  }, {
    key: "showMain",
    value: function showMain() {
      this.showMode(Mode.MAIN);
    }
  }, {
    key: "showDocs",
    value: function showDocs() {
      this.storyRoot().setAttribute('hidden', 'true');
      this.docsRoot().removeAttribute('hidden');
    }
  }, {
    key: "showStory",
    value: function showStory() {
      this.docsRoot().setAttribute('hidden', 'true');
      this.storyRoot().removeAttribute('hidden');
    }
  }]);

  return WebView;
}();