"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.diffStrings__ = exports.diff__ = void 0;
const jest_diff_1 = require("jest-diff");
/**
 * @internal Definitely not stable! Please don't use!
 *
 * Logs the diff between two objects.
 */
function diff__(a, b, diffOptions) {
    return (0, jest_diff_1.diff)(a, b, diffOptions);
}
exports.diff__ = diff__;
/**
 * @internal Definitely not stable! Please don't use!
 *
 * Logs the diff between two strings.
 */
function diffStrings__(a, b, diffOptions) {
    // jest-diff recommends using `diffLinesUnified` if string lengths are above 20,000 for performance
    if (a.length > 20000 || b.length > 20000) {
        return (0, jest_diff_1.diffLinesUnified)(a.split('\n'), b.split('\n'), diffOptions);
    }
    return (0, jest_diff_1.diffStringsUnified)(a, b, diffOptions);
}
exports.diffStrings__ = diffStrings__;
//# sourceMappingURL=diff.js.map