"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Reporter = void 0;
const render_1 = require("@betterer/render");
const tasks_1 = require("@betterer/tasks");
const default_1 = require("./default");
const watch_1 = require("./watch");
const Reporter = function Reporter(props) {
    const { context } = props;
    const { isRawModeSupported } = (0, render_1.useStdin)();
    isRawModeSupported &&
        (0, render_1.useInput)((input, key) => {
            if (key.ctrl && input === 'c') {
                void context.stop();
                return;
            }
        });
    const ReporterComponent = context.config.watch ? watch_1.WatchReporter : default_1.DefaultReporter;
    return (render_1.React.createElement(render_1.Box, { flexDirection: "column" },
        render_1.React.createElement(tasks_1.BettererLogo, null),
        render_1.React.createElement(ReporterComponent, Object.assign({}, props))));
};
exports.Reporter = Reporter;
//# sourceMappingURL=Reporter.js.map