"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.watchEnd = exports.watchStart = exports.filesChecked = exports.filesChecking = exports.unexpectedChangesInstructions = exports.unexpectedChanges = exports.updateInstructions = exports.testsChanged = exports.testWorse = exports.testUpdated = exports.testSkipped = exports.testSame = exports.testRunning = exports.testNew = exports.testFailed = exports.testExpired = exports.testComplete = exports.testChecked = exports.testBetter = void 0;
function testBetter(context, delta = '') {
    return `${context} got better!${delta} 😍`;
}
exports.testBetter = testBetter;
function testChecked(context) {
    return `${context} got checked. 🤔`;
}
exports.testChecked = testChecked;
function testComplete(context, isNew = false) {
    return `${context}${isNew ? ' has already' : ''} met its goal! ${isNew ? '✨' : '🎉'}`;
}
exports.testComplete = testComplete;
function testExpired(context) {
    return `${context} has passed its deadline. 👻`;
}
exports.testExpired = testExpired;
function testFailed(context) {
    return `${context} failed to run. 🔥`;
}
exports.testFailed = testFailed;
function testNew(context, delta = '') {
    return `${context} got checked for the first time!${delta} 🎉`;
}
exports.testNew = testNew;
function testRunning(context) {
    return `running ${context}!`;
}
exports.testRunning = testRunning;
function testSame(context, delta = '') {
    return `${context} stayed the same.${delta} 😐`;
}
exports.testSame = testSame;
function testSkipped(context, delta = '') {
    return `${context} got skipped.${delta} 🚫`;
}
exports.testSkipped = testSkipped;
function testUpdated(context, delta = '') {
    return `${context} got force updated.${delta} 🆙`;
}
exports.testUpdated = testUpdated;
function testWorse(context, delta = '') {
    return `${context} got worse.${delta} 😔`;
}
exports.testWorse = testWorse;
function testsChanged() {
    return 'Your tests have changed, re-checking everything...\nThis could take a sec. ⏰';
}
exports.testsChanged = testsChanged;
function updateInstructions() {
    return 'You should try to fix the new issues! As a last resort, you can run `betterer --update` to force an update of the results file. 🆙';
}
exports.updateInstructions = updateInstructions;
function unexpectedChanges() {
    return 'Unexpected changes detected in these tests while running in CI mode:';
}
exports.unexpectedChanges = unexpectedChanges;
function unexpectedChangesInstructions() {
    return 'You should make sure the results file is up-to-date before committing! You might want to run `betterer precommit` in a commit hook. 💍';
}
exports.unexpectedChangesInstructions = unexpectedChangesInstructions;
function filesChecking(files) {
    return `Checking ${files} ${getFiles(files)}... 🤔`;
}
exports.filesChecking = filesChecking;
function filesChecked(files) {
    return `Checked ${files} ${getFiles(files)}! 🔍`;
}
exports.filesChecked = filesChecked;
function watchStart() {
    return 'Starting Betterer in watch mode! 🎉';
}
exports.watchStart = watchStart;
function watchEnd() {
    return 'Stopping watch mode... 👋';
}
exports.watchEnd = watchEnd;
function getFiles(count) {
    return count === 1 ? 'file' : 'files';
}
//# sourceMappingURL=messages.js.map