import React, { FunctionComponent, ComponentType, ReactNode } from "react";
import { I18n } from "@lingui/core";
export declare type I18nContext = {
    i18n: I18n;
    defaultComponent?: ComponentType<{
        children?: ReactNode;
    }>;
};
export declare type withI18nProps = {
    i18n: I18n;
};
export declare type I18nProviderProps = I18nContext & {
    forceRenderOnLocaleChange?: boolean;
    children?: React.ReactNode;
};
export declare function useLingui(): I18nContext;
export declare function withI18n(o?: object): <P extends withI18nProps>(Component: ComponentType<P>) => React.ComponentType<Omit<P, 'i18n'>>;
export declare const I18nProvider: FunctionComponent<I18nProviderProps>;
//# sourceMappingURL=I18nProvider.d.ts.map