"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = command;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _chalk = _interopRequireDefault(require("chalk"));

var _commander = _interopRequireDefault(require("commander"));

var _conf = require("@lingui/conf");

var _catalog = require("./api/catalog");

var _detect = require("./api/detect");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function command(config, options) {
  // `react-app` babel plugin used by CRA requires either BABEL_ENV or NODE_ENV to be
  // set. We're setting it here, because lingui macros are going to use them as well.
  if (!process.env.BABEL_ENV && !process.env.NODE_ENV) {
    process.env.BABEL_ENV = "development";
  } // We need macros to keep imports, so extract-messages plugin know what componets
  // to collect. Users usually use both BABEN_ENV and NODE_ENV, so it's probably
  // safer to introduce a new env variable. LINGUI_EXTRACT=1 during `lingui extract`


  process.env.LINGUI_EXTRACT = "1";
  options.verbose && console.error("Extracting messages from source files…");
  var catalogs = (0, _catalog.getCatalogs)(config);
  var catalogStats = {};
  catalogs.forEach(function (catalog) {
    catalog.makeTemplate(_objectSpread(_objectSpread({}, options), {}, {
      orderBy: config.orderBy,
      projectType: (0, _detect.detect)()
    }));
    catalogStats[catalog.templateFile] = Object.keys(catalog.readTemplate()).length;
  });
  Object.entries(catalogStats).forEach(function (_ref) {
    var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
        key = _ref2[0],
        value = _ref2[1];

    console.log("Catalog statistics for ".concat(_chalk.default.bold(key), ": ").concat(_chalk.default.green(value), " messages"));
    console.log();
  });
  return true;
}

if (require.main === module) {
  _commander.default.option("--config <path>", "Path to the config file").option("--verbose", "Verbose output").parse(process.argv);

  var config = (0, _conf.getConfig)({
    configPath: _commander.default.config || process.env.LINGUI_CONFIG
  });
  var result = command(config, {
    verbose: _commander.default.verbose || false,
    configPath: _commander.default.config || process.env.LINGUI_CONFIG
  });
  if (!result) process.exit(1);
}