// Generated by CoffeeScript 1.10.0
(function() {
  var families;

  module.exports = {
    icon: 'icons/typekit.svg',
    name: 'typekit',
    title: 'Typekit',
    link: 'typekit.com',
    getNames: function() {
      return Object.keys(families);
    },
    getLink: function(name) {
      return "https://typekit.com/fonts/" + families[name];
    },
    normalizeName: function(name) {
      return name.toLowerCase().replace(/( )/g, '-');
    }
  };

  families = {
    "Aaux Next": "lgmv",
    "Abigail": "nmpn",
    "Abolition": "xbrs",
    "Abolition Soft": "kwhz",
    "Abril Display": "dvwp",
    "Abril Fatface": "lgrs",
    "Abril Text": "gjst",
    "Abril Titling": "phpr",
    "Abril Titling Condensed": "lvlr",
    "Abril Titling Narrow": "tdxy",
    "Abril Titling Semicondensed": "hzms",
    "Acier BAT Gris": "jtwn",
    "Acier BAT Text Noir": "rkkv",
    "Acier BAT Text Outline": "dzyw",
    "Acier BAT Text Solid": "kplv",
    "Acier BAT Text Strokes": "nxmp",
    "Acroterion JF": "tccs",
    "Acta Display": "jtgy",
    "Acta Poster": "spmb",
    "Acta Poster Swashes": "drlt",
    "Acumin Pro": "nyty",
    "Acumin Pro Condensed": "tvpw",
    "Acumin Pro Extra Condensed": "vktn",
    "Acumin Pro Semi Condensed": "zhgz",
    "Acumin Pro Wide": "vcxq",
    "Acuta": "zcmv",
    "Adage Script JF": "htjy",
    "Adaptive Mono": "dhjt",
    "Adelle": "gmsj",
    "Adelle Condensed": "rrcf",
    "Adelle Sans": "jcyh",
    "Adobe Caslon Pro": "hmqz",
    "Adobe Garamond Pro": "tmmf",
    "Adobe Jenson Pro": "flbr",
    "Adobe Jenson Pro Caption": "cpvz",
    "Adobe Jenson Pro Display": "vgdt",
    "Adobe Jenson Pro Subhead": "xybl",
    "Adobe Text Pro": "ffcc",
    "Adonis": "qdyr",
    "Adorn Smooth Condensed Sans": "tlpt",
    "Adorn Smooth Engraved": "yyys",
    "Adorn Smooth Pomander": "pkyz",
    "Adorn Smooth Serif": "gbxh",
    "Adorn Smooth Slab Serif": "nyzk",
    "Adriane Text": "rhsr",
    "Adrianna": "bbvs",
    "Adrianna Condensed": "xvgd",
    "Adrianna Extended": "cxxc",
    "Adso": "mlgy",
    "Aisha Latin": "vskw",
    "Akagi Pro": "txql",
    "Aktiv Grotesk": "tscy",
    "Al Fresco": "cynx",
    "Alana": "gfmx",
    "Alber New Web": "dqrj",
    "Alda ": "tlkf",
    "Alegreya": "bjtl",
    "Alegreya SC": "xrsc",
    "Alexa Std": "nztd",
    "Alize": "rphd",
    "Aller": "hmtn",
    "Aller Display": "wfbs",
    "Allumi Std": "qrvl",
    "Allumi Std Extended": "cxnr",
    "Almaq Refined": "wnzw",
    "Almaq Rough": "gqjh",
    "Alpha Echo": "kvxq",
    "Alphatier Pro": "hjlw",
    "Alta California": "glpn",
    "Alternate Gothic No. 1 D": "fwtm",
    "Alternate Gothic No. 2 D": "rjss",
    "Alternate Gothic No. 3 D": "lbmp",
    "Alverata Informal PE": "zwsf",
    "Alverata Irregular PE": "wtzj",
    "Alverata PE": "nszc",
    "Alwyn New Rounded Web": "byws",
    "Alwyn New Web": "ymqr",
    "Amador": "vsmx",
    "Amboy Black": "zfkr",
    "Amboy Inline": "bhxz",
    "Ambroise Std": "sskw",
    "Ambroise Std Firmin": "zmms",
    "Ambroise Std Francois ": "lmnc",
    "American Scribe": "wqmz",
    "Americane": "mwwr",
    "Americane Condensed": "ztct",
    "Anago": "blrk",
    "Anca": "fkmt",
    "Angie Sans Std": "gxdg",
    "Anisette Std": "pckz",
    "Anisette Std Petite": "nrky",
    "Anisette Std Petite 2": "bdys",
    "Anisette Std Petite SC": "bfnx",
    "Anivers": "rnhy",
    "Anivers SC": "xqhs",
    "Annabelle": "bdyq",
    "Annabelle JF": "lysj",
    "Anonymous Pro": "fbln",
    "Antiquarian": "lyqf",
    "Antiquarian Scribe": "hxfq",
    "Antique Olive": "svsp",
    "Antique Olive Compact": "jclx",
    "Antique Olive Condensed": "qzhr",
    "Antique Olive Nord": "bxtq",
    "Anzeigen Grotesk": "snkd",
    "Apertura": "wshm",
    "Apertura Condensed": "zkbh",
    "Apolline Std": "hfbt",
    "Apolline Std SC": "vzsq",
    "Aragon": "bqqw",
    "Arbitrary ": "njny",
    "Archetype": "mqsr",
    "Ardoise Std": "pxnw",
    "Ardoise Std Compact": "hvjg",
    "Ardoise Std Narrow": "hvvn",
    "Ardoise Std Tight": "jznx",
    "Arek Latin": "nlmf",
    "Arimo": "nlwf",
    "Armalite Rifle": "czzb",
    "Arno Pro": "xgpm",
    "Arno Pro Caption": "kdvt",
    "Arno Pro Display": "vbkz",
    "Arno Pro Small Text": "kttz",
    "Arno Pro Subhead": "hwmr",
    "Arvo": "tsyb",
    "AsimovSans": "lwmy",
    "Astoria": "zkls",
    "Astoria Condensed": "ywgs",
    "Astoria Sans": "ccst",
    "Astoria Sans Condensed": "xnvx",
    "Athelas": "zwkx",
    "Atrament Web": "dfjt",
    "Attic Antique": "dlll",
    "Aurea Ultra": "hmcs",
    "Automate": "djqb",
    "Avebury Black": "ntrj",
    "Avebury Inline": "hznn",
    "Aviano": "fftt",
    "Aviano Didone": "lyqr",
    "Aviano Flare": "rtjn",
    "Aviano Future": "dknz",
    "Aviano Sans": "vbkn",
    "Aviano Serif": "qnpv",
    "Aviano Slab": "bymb",
    "AW Conqueror Carved": "jgkq",
    "AW Conqueror Carved Four": "zvkc",
    "AW Conqueror Carved One": "mytn",
    "AW Conqueror Carved Three": "dyrm",
    "AW Conqueror Carved Two": "nxfz",
    "AW Conqueror Didot": "wcts",
    "AW Conqueror Inline": "hfcb",
    "AW Conqueror Sans": "lwvg",
    "AW Conqueror Slab": "ynqr",
    "Azo Sans": "lyqy",
    "Azo Sans Uber": "dktb",
    "Azote": "fwqx",
    "Backspacer Round": "pjqz",
    "Backspacer Square": "ytfp",
    "Bad Dog": "jdgx",
    "Badaboom Pro": "phmy",
    "Baileywick JF Gothic": "sbjc",
    "Baker Signet Web": "fhzy",
    "Balboa": "nxnq",
    "Balboa Condensed": "hhrt",
    "Balboa Extra Condensed": "sjfg",
    "Balboa Plus Fill": "jwnl",
    "Balboa Plus Gradient": "dlxz",
    "Balboa Plus Inline": "mjzn",
    "Balboa Plus Primary": "vbwt",
    "Ballers Delight": "jkjn",
    "Balloon URW": "trjt",
    "Balloon URW Drop Shadow": "mwyg",
    "Balloon URW Outline": "zptl",
    "Baltica Web": "nkcn",
    "Baltica Web Extra Condensed": "nmhl",
    "Balzano Std": "cyjw",
    "Banshee Std": "yrtq",
    "Barge": "hrjj",
    "Baroque Text JF": "bhcz",
    "Base 12 Sans ": "vqrt",
    "Base 12 Serif ": "wjdk",
    "Base 9 Sans ": "dwfx",
    "Base 900 Sans ": "jvkw",
    "Base Mono Narrow ": "vvkn",
    "Base Mono Wide ": "zddb",
    "Basel Neue": "hxxn",
    "Baskerville URW": "twzr",
    "BattleStation": "vygz",
    "Baucher Gothic URW": "dwgs",
    "Baucher Gothic URW Alternates": "zlyn",
    "Baucher Gothic URW Alternates Extended": "ymzw",
    "Baucher Gothic URW Extended": "cqtv",
    "BD Brick": "ksgm",
    "BD Colonius": "xvch",
    "BD Geminis": "clbv",
    "BD Jupiter": "fghq",
    "BD Jupiter Stencil": "gzsg",
    "BD Nippori": "xpbt",
    "BD Plakatbau": "xrhd",
    "BD Retrocentric": "ymsd",
    "BD Viewmaster": "ymvm",
    "BDR A3MIK": "blmf",
    "BDR Mono": "kfdw",
    "Bebas Neue": "nrgs",
    "Bee": "lmjs",
    "Bell Centennial Std Address": "nglj",
    "Bell Centennial Std Bold Listing": "tnpd",
    "Bell Centennial Std Name & Number": "zkqy",
    "Bell Centennial Std Sub-Caption": "ljlv",
    "Bello Caps": "cjrb",
    "Bello Pro": "ykqk",
    "Bernhard Gothic URW": "jccl",
    "Bickham Script Pro 3": "xrpj",
    "Bigfish": "xbgb",
    "BigSmalls Bold": "wrtz",
    "BigSmalls Regular": "pbkk",
    "Birch Std": "hpcm",
    "Bistro Script Web ": "dxwq",
    "Black Beard": "wdsw",
    "Blackcurrant": "wypf",
    "Blackcurrant Cameo": "jxgn",
    "Blackcurrant Squash": "wstc",
    "Blackoak Std": "bcnr",
    "Blakely": "lrpq",
    "Blambot Casual": "srfh",
    "Blambot FX Pro": "zsfy",
    "Blambot Pro": "kxqg",
    "Blenny": "frvd",
    "Bligh": "vbpx",
    "Blockhead Black Face": "wzgy",
    "Blockhead Dark Side": "jpbj",
    "Blockhead Plain": "pdgy",
    "Blockhead Unplugged": "sdqn",
    "Blow Up": "hrbg",
    "Blue Goblet": "shwc",
    "Blue Goblet Alternate One": "hlkz",
    "Bodedo": "rypf",
    "Bodoni URW": "zjhz",
    "BonvenoCF": "fxvw",
    "Bookman JF Pro": "sqcf",
    "Bookmania": "dzzb",
    "Boston Traffic": "dkyc",
    "Botanika Mono Web": "qssm",
    "Botanika Web": "tfhb",
    "Boucherie Block": "tdrd",
    "Boucherie Cursive": "yxsr",
    "Boucherie Flared": "gptr",
    "Boucherie Sans": "sbmm",
    "Boucherie Sans Inline": "cvls",
    "Bouffant": "ppdm",
    "Bourbon": "cvsc",
    "Brandon Grotesque": "yvxn",
    "Bree": "ymzk",
    "Bree Serif": "qnhg",
    "Brevia": "yywq",
    "Brigade": "hstx",
    "Brim Narrow": "bswl",
    "Brim Narrow Combined 1": "rkhy",
    "Brim Narrow Combined 2": "lgjj",
    "Brim Narrow Combined 3": "krsq",
    "Brioso Pro": "hvfx",
    "Brioso Pro Caption": "jfyp",
    "Brioso Pro Display": "zgsj",
    "Brioso Pro Poster": "vtbt",
    "Brioso Pro Subhead": "vphz",
    "Brix Slab": "qwdx",
    "Brix Slab Condensed": "ghjq",
    "Broadsheet": "sdyc",
    "Bronson Gothic JF": "npph",
    "Brothers ": "zsxr",
    "Brush Script Std": "hgrg",
    "Buena Park JF": "fxkz",
    "Bungee": "lydn",
    "Burnaby Stencil": "gjsz",
    "Cabazon": "rdpv",
    "Caflisch Script Pro": "jjvs",
    "Caliban Std": "qnhl",
    "Calluna": "vybr",
    "Calluna Sans": "wgzc",
    "CamingoDos Web": "nyvb",
    "Cantarell": "kydd",
    "Cantiga": "crzb",
    "Cantiga Condensed": "dkcl",
    "Capitol": "brwn",
    "Capitolina": "zhzf",
    "Capitolium 2": "zhqq",
    "Capitolium News 2": "hzzk",
    "Carbon": "vsqh",
    "Carbon Fence": "zkns",
    "Carbon Phyber": "qkzx",
    "CarbonType": "ksng",
    "Cardea": "dshm",
    "Cardea Lining": "kbvq",
    "Cardigan": "skrz",
    "Cardo": "cnlb",
    "Carta Marina": "cyvn",
    "Casablanca URW": "phvw",
    "Catnip": "lthk",
    "Catseye": "jlbd",
    "Catseye Narrow": "mvcv",
    "Catwing": "vxbz",
    "Century Old Style Std": "vchr",
    "Chainprinter": "ysdr",
    "Chalfont": "sgqs",
    "Chalky": "nsmx",
    "Chaloops": "cztv",
    "Chandler 42 ": "byvt",
    "Changeling Neo": "dmwg",
    "Changeling Neo Inline ": "tmbb",
    "Changeling Neo Stencil": "gncv",
    "Chantal": "mhtp",
    "Chaparral Pro": "hrpf",
    "Chaparral Pro Caption": "vxdv",
    "Chaparral Pro Display": "gwkj",
    "Chaparral Pro Subhead": "gbbm",
    "Charbroiled": "pzjx",
    "Charlemagne Std": "sstt",
    "Chauncy Pro": "qxnj",
    "Cheap Pine": "mpgq",
    "Cheap Pine Sans": "rwbt",
    "Cheap Pine Shadow": "lsgp",
    "Chemist": "zqbs",
    "Chemist Rough": "ssfx",
    "Chennai": "rqgy",
    "Chennai Slab": "rjvq",
    "Chinchilla": "rxvl",
    "Chinese Rocks": "pfcv",
    "Chippewa Falls": "wyrn",
    "Cholla Sans ": "ymsq",
    "Cholla Slab ": "fftv",
    "Cholla Unicase": "lfhv",
    "Cholla Wide": "zgyk",
    "Chuck": "xmtx",
    "Chunder": "lbcx",
    "Chunk": "klcb",
    "Citizen ": "qgws",
    "Clarendon Text Pro": "kctd",
    "Clarendon URW": "rsxs",
    "Clarendon URW Extra Narrow": "ndnc",
    "Clarendon URW Extra Wide": "zzyy",
    "Clarendon Wide": "drqz",
    "Clarendon Wide Stencil": "kpbj",
    "Classic Comic": "kvty",
    "Classico URW": "mtnv",
    "Clavo": "xjbl",
    "Click Clack": "ctyb",
    "Clone Rounded Latin": "clby",
    "Co Headline": "xfwx",
    "Co Text": "hflt",
    "Colaborate": "khwj",
    "Collector Comic": "wsly",
    "Colosseum": "ggth",
    "Colt": "prsy",
    "Colt Soft": "csnn",
    "Comenia Sans Web": "cyhy",
    "Comic Serif Pro": "mkml",
    "Concave Tuscan": "tdtj",
    "Conceal": "sfdy",
    "Continuo": "fscr",
    "Coolvetica": "mhvx",
    "Cooper Black Std": "pbzd",
    "Copacabana": "stgg",
    "Copal Std Decorated": "mtpx",
    "Copal Std Outline": "dpqp",
    "Copal Std Solid": "jbtg",
    "Copperplate": "dtvx",
    "Copperplate Condensed": "qgrw",
    "Coquette": "drjf",
    "Cora": "cklb",
    "Coranto 2": "ktbv",
    "Coranto 2 Headline": "dpvc",
    "Cordale": "thcw",
    "Corn Dog": "vkcq",
    "Corner Store JF": "vvmv",
    "Coronette": "xpjz",
    "Corporate A": "hzzx",
    "Corporate E": "ckyb",
    "Corporate S": "vzyp",
    "Corpulent Web": "rgky",
    "Cosmopolitan": "rdnz",
    "Costa Std": "khmq",
    "Cotton": "rlcc",
    "Cottonwood Std": "pkzg",
    "Council": "cwdw",
    "Courier Prime": "xscx",
    "Courier Std": "jxcp",
    "Cowboyslang": "pkff",
    "Cowboyslang Condensed ": "ccdn",
    "Cowboyslang Expanded": "fdyh",
    "Craw Modern URW": "lwkx",
    "Crete": "hwlb",
    "Crete Rounded": "nngn",
    "Crimson": "gtgg",
    "Cronos Pro": "jqgg",
    "Cronos Pro Caption": "btfg",
    "Cronos Pro Display": "ndrt",
    "Cronos Pro Subhead": "wxwc",
    "Cubano": "wljs",
    "Cubano Sharp": "jmbn",
    "Dalliance Roman": "xcdf",
    "Dalliance Script": "hrqh",
    "Dalliance Script Display": "hfgn",
    "Daniel": "pcvr",
    "Dapifer": "cjdr",
    "DDT": "ndxp",
    "De Walpergen's Pica": "xgfd",
    "De Walpergen's Pica Small Caps": "rbmz",
    "Dead History": "cjhr",
    "Dederon Sans Web": "xtkx",
    "Dederon Serif Web": "khmh",
    "Default Gothic": "jbqf",
    "DejaRip": "mfjw",
    "DeLittle Chromatic": "vhsn",
    "DeLittle Chromatic Inlay": "xmkq",
    "DeLittle Chromatic Outline": "rvpy",
    "Delve Hand": "ctbh",
    "Democratica": "pwhq",
    "Depot New Condensed Web": "czrb",
    "Depot New Web": "hrrw",
    "Deva Ideal": "dmnv",
    "Diavlo": "lgsh",
    "Didoni URW": "cnsv",
    "Dienstag": "sfst",
    "DIN Condensed Web": "gkhs",
    "Dirtstorm": "ybyg",
    "Dirty Bakers Dozen": "gjtg",
    "Dirty Bakers Dozen Scorch": "mvnl",
    "Dirty Bakers Dozen Spraypaint": "nthj",
    "Discourse Middle ": "wtyl",
    "Discourse Middle Fill": "hxxb",
    "Discourse Middle Outline": "zyyn",
    "Discourse Middle Shadow": "vnym",
    "Discourse Narrow": "ybhl",
    "Discourse Narrow Fill": "zstf",
    "Discourse Narrow Outline": "jvtn",
    "Discourse Narrow Shadow": "khmt",
    "Discourse Wide": "xzjg",
    "Discourse Wide Fill": "kzzq",
    "Discourse Wide Outline": "kjfc",
    "Discourse Wide Shadow": "gwzr",
    "District Pro": "bxww",
    "Divulge": "hwks",
    "Dogma": "qmtr",
    "Dogma Extra Outline": "vtrg",
    "Dogma Outline": "lyfj",
    "Dogma Script": "ycnr",
    "Domyouji": "lbnp",
    "Double Pica": "ftkg",
    "Double Pica Small Caps": "stkc",
    "Droid Sans": "gkmg",
    "Droid Sans Mono": "vqgt",
    "Droid Serif": "pcpv",
    "Drunk Cowboy": "zlhj",
    "Dry Cowboy": "dpnz",
    "Duality": "pvyk",
    "Duality Sand": "xkcn",
    "Duality Steel": "lcgx",
    "Dublin": "mgtk",
    "Dustismo": "lbpc",
    "Ebony": "czys",
    "Edding 780": "gjzc",
    "Edita": "gdvw",
    "Edita Small": "ttzz",
    "Edo": "bbfy",
    "Effra": "kldz",
    "Egizio URW": "sxjs",
    "Egizio URW Condensed": "vtmt",
    "Eidetic Neo": "rflw",
    "Eidetic Neo Omni": "zytv",
    "Eigerdals": "gckq",
    "Elektrix ": "fwdf",
    "Elina Web": "kxrh",
    "Elina Web Decor": "qvgz",
    "Elliotts Blue EyeShadow": "mnrx",
    "Elliotts Jigsaw Dropshadow": "yvqt",
    "Elliotts Typhoid Mary 3D Dark": "yrgj",
    "Elliotts Typhoid Mary 3D Light": "yblq",
    "Elliotts Venus D Outlined": "xtbm",
    "Elliotts Venus Dioxide": "zdfx",
    "Eloquent JF Pro": "csdf",
    "Eloquent JF Small Caps Pro": "gwfy",
    "Embryo": "plpq",
    "Embryo Open": "wsfq",
    "Emily Austin": "kbyr",
    "English": "kwsg",
    "English Grotesque": "kwsl",
    "English Small Caps": "btzs",
    "Escoffier Capitaux": "jgwj",
    "Eskapade": "ykbv",
    "Eskapade Fraktur": "gqyb",
    "Eskorte Latin": "tdcs",
    "Essay Text": "mdxv",
    "Essonnes Display": "hfyv",
    "Essonnes Headline": "mrrj",
    "Essonnes Text": "qcck",
    "Estilo": "ywzt",
    "Estilo Pro": "yzhh",
    "Estilo Script": "kqtj",
    "Ethnocentric": "khgt",
    "Europa": "myvg",
    "Eurostile": "dvtb",
    "Eurostile Condensed": "pnyq",
    "Eurostile Extended": "tjpc",
    "Exocet ": "nzyp",
    "Expo Sans Pro": "yfxq",
    "Expo Sans Pro Condensed": "xqnp",
    "Expo Serif Pro": "lclf",
    "Expressway": "fjbr",
    "Factoria": "dklr",
    "Fairplex Narrow ": "jxdf",
    "Fairplex Wide ": "vhvx",
    "Fairway": "mqxb",
    "Fairy Tale JF": "tqhd",
    "Falcon Script": "jtpr",
    "Fanwood": "fsmy",
    "Faricy New Web": "ytjc",
    "Fatboy": "xyqp",
    "FatFrank": "klld",
    "Federico Web": "brnf",
    "Felt Tip Roman": "krvz",
    "Felt Tip Senior": "bcpv",
    "Felt Tip Woman": "xpwg",
    "Fenway Park JF": "wdpc",
    "Fenwick ": "nwpm",
    "Fenwick Outline": "tmqm",
    "Fertigo Pro": "pzyv",
    "Fertigo Pro Script": "twbx",
    "FF Amman Sans Web": "dgkf",
    "FF Amman Serif Web": "lqbw",
    "FF Angie Web Pro": "ngqj",
    "FF Avance Web Pro": "rqjk",
    "FF Basic Gothic SC Web Pro": "vndz",
    "FF Basic Gothic Web Pro": "snqb",
    "FF Brokenscript Web": "sxzw",
    "FF Brokenscript Web Condensed": "gwsq",
    "FF Chambers Sans Web": "zkww",
    "FF Cocon Web Pro": "gzwk",
    "FF Dagny Pro": "rlxq",
    "FF Dax Compact Web Pro": "ffht",
    "FF Dax Web Pro": "dbqg",
    "FF Dax Web Pro Condensed": "xjff",
    "FF Dax Wide Web Pro": "lhlb",
    "FF Duper Pro": "chyy",
    "FF Enzo ": "rwbq",
    "FF Ernestine Web Pro": "lvzh",
    "FF Folk Rough Web": "mbhp",
    "FF Folk Web": "rnjs",
    "FF Ginger Web Pro": "fvmr",
    "FF Good Headline Pro Condensed": "rczt",
    "FF Karbid Slab Web Pro": "qkfw",
    "FF Karbid Text Web Pro": "kqbz",
    "FF Karbid Web Pro": "gqch",
    "FF Kava Pro": "ypyb",
    "FF Mach Web Pro": "zgjf",
    "FF Mach Web Pro Condensed": "ywgw",
    "FF Mach Wide Web Pro": "xxss",
    "FF Market": "fytf",
    "FF Meta SC Web Pro": "wvmz",
    "FF Meta Serif SC Web Pro": "hwxc",
    "FF Meta Serif Web Pro": "rrtc",
    "FF Meta Web Pro": "brwr",
    "FF Meta Web Pro Condensed": "yzqx",
    "FF More Pro": "chdm",
    "FF More Pro Condensed": "qqwp",
    "FF More Pro Wide": "rpsd",
    "FF Netto Web": "rgzb",
    "FF Nuvo SC Web Pro": "fthp",
    "FF Nuvo Web Pro": "njjs",
    "FF Prater Block Web": "sbsp",
    "FF Prater Sans Web": "pjnv",
    "FF Prater Script Web": "thcp",
    "FF Prater Serif Web": "clds",
    "FF Providence Sans Web Pro": "jhyn",
    "FF Providence SC Web Pro": "jgdn",
    "FF Providence Web Pro": "txsc",
    "FF Speak Web": "vgxf",
    "FF Spinoza Pro": "cmfb",
    "FF Tisa Pro": "xwmz",
    "FF Tisa Sans Pro": "lgpw",
    "FF Typestar Web ": "hrsz",
    "FF Utility Web Pro": "glmn",
    "FF Zwo Corr Web Pro": "jpkn",
    "Filosofia ": "lyll",
    "Filosofia All Small Caps": "sbpt",
    "Filosofia Basic Small Caps": "xxwn",
    "Filosofia Grand ": "pltr",
    "Filosofia Grand All Small Caps": "qvtd",
    "Filosofia Grand Basic Small Caps": "gykh",
    "Filosofia Lining": "jgjk",
    "Filosofia Unicase ": "vbgf",
    "Filson Pro": "vdml",
    "Filson Soft": "dynx",
    "Fira Mono": "jcjz",
    "Fira Sans": "cqwn",
    "Fira Sans 2": "wglq",
    "Flood Std": "khwz",
    "Flower Power": "qcdv",
    "Flyswim": "jnfl",
    "Foco": "gvpz",
    "Forgotten Futurist Shadow": "mtpz",
    "FP Dancer Pro": "wnsg",
    "FP Head Pro": "ncmr",
    "Fragile Bombers": "gxwh",
    "Fragile Bombers Attack": "nthz",
    "Fragile Bombers Down": "zbcg",
    "Franklin Gothic URW": "fbft",
    "Franklin Gothic URW Compressed": "knmp",
    "Franklin Gothic URW Condensed": "pthz",
    "Franklin Gothic URW Condensed SC": "tlqm",
    "Franklin Gothic URW Extra Compressed": "kxxt",
    "Freight Big Pro": "kqdn",
    "Freight Display Pro": "hsff",
    "Freight Macro Pro": "gddm",
    "Freight Micro Pro": "bzqy",
    "Freight Neo Pro": "bjpg",
    "Freight Sans Compressed Pro": "pprf",
    "Freight Sans Condensed Pro": "pcqk",
    "Freight Sans Pro": "bgnv",
    "Freight Text Pro": "lstb",
    "French Canon": "myym",
    "French Canon Small Caps": "bcym",
    "French Clarendon Ornamented": "lwgj",
    "French Octagon": "rmzf",
    "French Roast": "fryd",
    "Fresno Black": "rpmb",
    "Fresno Inline": "ycqt",
    "Funkydori": "cpnc",
    "Fusaka Std": "ltcz",
    "Futura PT": "ftnk",
    "Futura PT Condensed": "jxkf",
    "Galette": "vmnk",
    "Garamond Premier Pro": "lfzn",
    "Garamond Premier Pro Caption": "wwvn",
    "Garamond Premier Pro Display": "msmg",
    "Garamond Premier Pro Subhead": "gclg",
    "Garogier": "jwdn",
    "Garvis Pro": "tgbw",
    "Gesta": "bcnl",
    "Gibson": "dvkf",
    "Giddyup Std": "gkpx",
    "Gin": "ktpd",
    "Gioviale": "yrgx",
    "Givry": "nfvx",
    "Gnuolane": "kddp",
    "Goldenbook": "qjwy",
    "Good Bad Man": "yrxy",
    "Good Kitty": "rgmk",
    "Good Times": "ctzl",
    "Good Times Bad Times": "hjzq",
    "GoodDog New": "fmpj",
    "Gothic Open Shaded": "gpdz",
    "Goudy Bookletter 1911": "mpmx",
    "Goudy Old Style": "cczb",
    "Grad": "cpmg",
    "Grad SC OSF": "hhdk",
    "Grafolita Script": "frss",
    "Grandma": "zwzx",
    "Graphite Std": "ggfm",
    "Graphite Std Narrow": "cdps",
    "Graphite Std Wide": "qkbb",
    "Graveblade": "vwhs",
    "Great Primer": "kctm",
    "Great Primer Small Caps": "djsq",
    "Grecian Light Face": "tqrs",
    "Grueber": "zxgr",
    "Gunplay": "gzdg",
    "Gunplay Damage": "pwsj",
    "Gunplay Spraypaint": "pkzf",
    "Gurkner-Jump": "pgmb",
    "Gyparody": "gqbk",
    "Hack": "clgv",
    "Halogen": "rfyp",
    "Handel Gothic": "wyrv",
    "Harfang Pro": "hstn",
    "Harvester": "sspf",
    "Hayate": "hkvl",
    "Headlight": "fpgz",
    "Heavy Data": "mdps",
    "Hedley New Web": "mnbw",
    "Hellenic Wide JF": "bjbs",
    "Helsinki": "vbwb",
    "Hilde Sharp": "zqwt",
    "Hill House": "qrhv",
    "Hit": "prhv",
    "Hobo Std": "ybkv",
    "Hooligan JF": "gzck",
    "Hoosier Daddy": "wzhp",
    "Hotel Open": "smzx",
    "Hotel Solid": "mjpz",
    "Hoverunit": "ncvs",
    "Hucklebuck JF": "zpfq",
    "Hummingbird": "vnsc",
    "HWT American Chromatic": "fmzh",
    "HWT American Inset": "pkpf",
    "HWT American Outline": "zwqp",
    "HWT American Shopworn": "svmj",
    "HWT American Solid": "kyzh",
    "HWT American Stars": "frpj",
    "HWT American Stars Bottom": "vmbb",
    "HWT American Stars Top": "zssy",
    "HWT Antique Tuscan 9": "lfqn",
    "HWT Arabesque": "prfh",
    "HWT Artz": "spvt",
    "HWT Bon Air": "wvts",
    "HWT Bulletin": "sjpr",
    "HWT Geometric": "mskt",
    "HWT Geometric Condensed": "fccw",
    "HWT Geometric Shopworn": "rhfj",
    "HWT Geometric Shopworn Inked": "whfx",
    "HWT Gothic Round": "fmqw",
    "HWT Republic Gothic Outline": "hfsp",
    "HWT Republic Gothic Solid": "stwh",
    "HWT Roman Extended Fat Face": "dwhf",
    "HWT Roman Extended Light Face": "hmyd",
    "HWT Slab Antique": "tjmn",
    "HWT Slab Columbian": "ncbg",
    "HWT Tuscan Extended": "mxbx",
    "HWT Unit Gothic 716": "sybv",
    "HWT Unit Gothic 717": "zvsb",
    "HWT Unit Gothic 718": "cyxw",
    "HWT Unit Gothic 719": "kwfx",
    "HWT Unit gothic 720": "vpck",
    "HWT Unit Gothic 721": "yqhd",
    "HWT Unit Gothic 722": "xnhl",
    "HWT Van Lanen": "gybz",
    "HWT Van Lanen Streamer": "gfzk",
    "Hydrophilia Iced": "bxgy",
    "Hydrophilia Liquid": "bwvb",
    "Hypatia Sans Pro": "xstc",
    "Immi Five O Five": "thfz",
    "Imperial URW": "ypyw",
    "Inconsolata": "gmvz",
    "Industry": "kgqj",
    "Industry Inc 3D": "wwrs",
    "Industry Inc Base": "yqyn",
    "Industry Inc Bevel": "zkgf",
    "Industry Inc Bevel Fill": "vjrz",
    "Industry Inc In-N-Out": "jmxr",
    "Industry Inc Inline": "nhfd",
    "Industry Inc Inline Stroke": "qglh",
    "Industry Inc Outline": "qhrk",
    "Industry Inc Stencil": "dfbf",
    "Informa Pro": "dqxh",
    "Informa Pro Condensed": "vrns",
    "Ingra": "rmqw",
    "Ingra 2": "sltz",
    "Ingra Condensed": "zrjd",
    "Ingra Condensed 2": "tpsk",
    "Ingra Wide": "fmfn",
    "Ingra Wide 2": "yfst",
    "Instant": "hgyb",
    "InterFace": "vbpf",
    "Intruder Alert": "bsnk",
    "Ironwood Std": "zfns",
    "Iskra": "bxgc",
    "Isonorm": "jvsw",
    "JAF Bernina Sans": "pljs",
    "JAF Bernina Sans Compressed": "qmkq",
    "JAF Bernina Sans Condensed": "pqtd",
    "JAF Bernina Sans Narrow": "xtmc",
    "JAF Bernino Sans": "rftw",
    "JAF Bernino Sans Compressed": "ssws",
    "JAF Bernino Sans Condensed": "zccv",
    "JAF Bernino Sans Narrow": "ljvn",
    "JAF Domus Titling": "jwbb",
    "JAF Facit": "ttyp",
    "JAF Herb": "gnbj",
    "JAF Herb Condensed": "lmgn",
    "JAF Lapture": "rvnd",
    "JAF Lapture Caption": "wyzn",
    "JAF Lapture Display": "wtgg",
    "JAF Lapture Subhead": "phtx",
    "JAF Mashine": "vyjt",
    "JAF Mashine Rounded": "mhpd",
    "JAF Peacock": "sfpl",
    "JAF Peacock Alternate": "mfhp",
    "JAF Peacock Deep": "hrwv",
    "JAF Peacock Loop": "nrlg",
    "JAF Peacock Short": "psyw",
    "JAF Peacock Swash": "zcjl",
    "JAF Zalamander": "rvhs",
    "JAF Zalamander Caps": "lpgt",
    "JanaThork-Pro": "xwyz",
    "Jay Gothic URW": "zzvd",
    "Jeanne Moderno": "tkym",
    "Jeanne Moderno Geometrique": "vsnr",
    "Jeanne Moderno Titling": "kkbv",
    "Jeanne Moderno Ultra": "rbkz",
    "Jesaya ": "slrd",
    "Jinky": "svth",
    "John Doe": "qkzf",
    "Josefin": "vjys",
    "Journal ": "nggl",
    "Journal Ultra": "hpfh",
    "Jubilat": "cwfk",
    "Junction": "lnlc",
    "Junegull": "whhj",
    "Junegull Beach": "brrp",
    "Juniper Std": "vvkr",
    "Justus Pro": "xmfs",
    "Kaffeesatz": "jgfl",
    "Kandal": "zfhn",
    "Kari Display Pro": "jlsc",
    "Kari Pro": "nqnd",
    "Kari Pro Wide": "njhs",
    "Karmina": "hmpz",
    "Karmina Sans": "brjr",
    "Katarine Web": "jdwz",
    "Keedy Sans": "drhj",
    "Kegger": "zknw",
    "Kegger Collegiate": "rkyr",
    "Kelvingrove": "gbmp",
    "Kepler Std": "ymjx",
    "Kepler Std Caption": "mhkk",
    "Kepler Std Condensed Display": "nxdj",
    "Kepler Std Condensed Subhead": "wltw",
    "Kepler Std Display": "cdgy",
    "Kepler Std Extended": "mqwh",
    "Kepler Std Extended Caption": "ggdn",
    "Kepler Std Extended Display": "qdrh",
    "Kepler Std Extended Subhead": "hpbq",
    "Kepler Std Semicondensed": "jhbv",
    "Kepler Std Semicondensed Caption": "rysz",
    "Kepler Std Semicondensed Display": "hztf",
    "Kepler Std Semicondensed Subhead": "bgrk",
    "Kepler Std Subhead": "ztvt",
    "Kestrel Script": "hhdp",
    "Kinescope": "cjms",
    "Kinesis Pro 3": "qzql",
    "King's Caslon Display": "gljv",
    "Know Your Product": "rzkj",
    "Komu A": "mbkv",
    "Komu B": "bfxt",
    "Kon Tiki Aloha JF": "mndh",
    "Kon Tiki Lounge JF": "fnvs",
    "Korolev": "rtzs",
    "Korolev Compressed": "bhhr",
    "Korolev Condensed": "ngsd",
    "Korolev Military Stencil": "mcpk",
    "Kremlin Pro Web": "ydmk",
    "Kremlin Pro Web Expanded": "qcqb",
    "Kremlin Pro Web Semi Expanded": "cgdb",
    "Krete": "xmhq",
    "Kulturista Web": "kbrb",
    "Kyrial Display Pro": "ckpf",
    "Kyrial Sans Condensed Pro": "fpvt",
    "Kyrial Sans Pro": "fxdh",
    "Lakeside": "ztzd",
    "Lamar Pen": "kvwm",
    "Larabiefont": "mlyr",
    "Latienne Pro": "jttz",
    "Latino URW": "jxkl",
    "Lato": "jxfv",
    "Le Havre ": "nwxv",
    "Le Havre Rounded": "mcxm",
    "Le Monde Courrier Std": "tnhw",
    "Le Monde Courrier Std 2": "cvjj",
    "Le Monde Journal Std": "mvgb",
    "Le Monde Journal Std 2": "dvrn",
    "Le Monde Livre Classic Std": "wxzn",
    "Le Monde Livre Classic Std SC": "ydky",
    "Le Monde Livre Classic Std Swash": "rwxr",
    "Le Monde Livre Std": "shhb",
    "Le Monde Sans Std": "rshz",
    "Le Monde Sans Std 2": "lcdz",
    "League Gothic": "kmpm",
    "League Gothic Condensed": "wvpq",
    "League Script No. 1": "qbgv",
    "Leander Script Pro": "snrq",
    "Learning Curve": "twry",
    "Learning Curve Dashed ": "qsqs",
    "Legendum": "ztvq",
    "Legitima": "wklw",
    "Leitura News": "zbrg",
    "Letter Gothic Std": "fdxw",
    "Lexia": "jmhq",
    "Lexia Advertising": "zsgt",
    "LFT Etica": "stqs",
    "LFT Etica Compressed": "lwgm",
    "LFT Etica Condensed": "hdhx",
    "LFT Etica Display": "vyvm",
    "Liberation Sans": "zsyz",
    "Liberation Serif": "lcny",
    "Ligurino": "ftfj",
    "Ligurino Condensed": "fngw",
    "Lilac Malaria ": "vrtl",
    "Linden Hill": "wpgv",
    "Lint McCree": "bkzg",
    "Lipa Agate High": "gxvw",
    "Lipa Agate High Condensed": "mkcz",
    "Lipa Agate High Narrow": "snhl",
    "Lipa Agate Low": "ywqj",
    "Lipa Agate Low Condensed": "mmyk",
    "Lipa Agate Low Narrow": "czmz",
    "Liquorstore": "fhrm",
    "Liquorstore 3D": "bkdx",
    "Liquorstore Jazz": "gcsq",
    "Litania": "ydgm",
    "Lithos Pro": "ykxr",
    "Livory": "hdtl",
    "Lobster": "zsbz",
    "LoRes 12 ": "yphd",
    "LoRes 12 Bold Alt Oakland": "hcdt",
    "LoRes 12 Narrow": "zxxw",
    "LoRes 15 ": "srxj",
    "LoRes 15 Bold Alt Oakland": "cgpp",
    "LoRes 15 Narrow": "fldl",
    "LoRes 21 Serif": "gbhd",
    "LoRes 22 Bold Oakland": "ygjb",
    "LoRes 22 Narrow": "jscd",
    "LoRes 22 Serif": "ycbh",
    "LoRes 28 ": "zwfc",
    "LoRes 28 Narrow": "zckx",
    "LoRes 9 Minus Narrow": "wqss",
    "LoRes 9 Minus Wide": "zcll",
    "LoRes 9 Narrow": "cyty",
    "LoRes 9 Plus Narrow": "wllr",
    "LoRes 9 Plus Wide": "gmtl",
    "LoRes 9 Plus Wide Bold Alt": "hfrf",
    "LoRes 9 Wide": "swss",
    "LoRes 9 Wide Bold Alt Oakland": "rgsp",
    "Los Feliz": "xwby",
    "Lourdes": "qjtn",
    "LTC Bodoni 175": "mrnw",
    "LTC Broadway": "tjlh",
    "LTC Broadway Engraved": "xhsc",
    "LTC Globe Gothic": "xnjh",
    "LTC Goudy Ornate": "qhjd",
    "LTC Hess Monoblack": "lwzs",
    "LTC Squareface": "dczc",
    "LTC Squareface Small Caps": "jgsh",
    "Luminance": "pzyp",
    "Luminance SC": "dtyw",
    "Lunatix ": "yygt",
    "Lush Script": "hjnb",
    "Lust": "blcg",
    "Lust Didone": "bbbl",
    "Lust Display": "qypz",
    "Lust Display Didone": "gdvq",
    "Lust Script": "tcqg",
    "Lust Script Display": "mmlh",
    "Luxi Sans": "spyf",
    "Luxi Serif": "ssny",
    "M+ 1c": "qnch",
    "M+ 1m ": "gmnw",
    "Macha": "jyts",
    "Macho": "nsyn",
    "Madawaska": "yqyl",
    "Madre Script": "fzgf",
    "Madrone Std": "lfdr",
    "Magion Web": "wtdk",
    "Magistral Web": "hmpn",
    "Magistral Web Compressed": "xxyj",
    "Magistral Web Condensed": "bjnq",
    "Magneta": "kybj",
    "Magpie": "wkwc",
    "Mahalia": "bvln",
    "Maiola": "fhks",
    "Malaga": "ckcz",
    "Malaga Narrow": "jgzt",
    "Martini at Joe's": "drkh",
    "Maryam Alternate": "qxhg",
    "Maryam Regular": "jkrp",
    "Marydale": "kvdq",
    "Mason Sans": "pshy",
    "Mason Serif": "clqv",
    "Matrix II ": "yqyx",
    "Matrix II Display Hilite Extra Bold": "ylfz",
    "Matrix II Display Hilite Italic": "thrx",
    "Matrix II Display Hilite Script": "swfg",
    "Matrix II Display Inline Extra Bold": "jqxd",
    "Matrix II Display Inline Italic": "bcdy",
    "Matrix II Display Inline Script": "kzbs",
    "Matrix II Ext Semi Narrow": "wtlx",
    "Matrix II Ext Semi Wide": "wdhz",
    "Matrix II Ext Wide": "zcyh",
    "Matrix II Extra Narrow": "jtzd",
    "Matrix II Script ": "snty",
    "Matrix II Tall ": "jsjj",
    "Matrix II Tall Semi": "xdfz",
    "Matt B": "hnhv",
    "Mauritius": "ybqd",
    "Mauritius Condensed": "cyhv",
    "Mayence Premium": "wtxn",
    "Meatball": "pzdd",
    "Meloche": "shjv",
    "Memoriam Headline Pro": "ggqt",
    "Memoriam Inline Pro": "qrlz",
    "Memoriam Outline Pro": "mkcf",
    "Memoriam Pro": "zpxz",
    "Mentone": "lrph",
    "Merriweather": "sqwg",
    "Mesquite Std": "yyxy",
    "Metalista Web": "hxwt",
    "Metallophile Sp8": "sdcj",
    "Metronic Slab": "gxyg",
    "Metronic Slab Narrow": "yvhw",
    "Mic 32 New Rounded Web": "kzcb",
    "Mic 32 New Web": "qjtc",
    "Milibus": "fdly",
    "Millesime": "jhtl",
    "Minerva Modern": "rrrg",
    "Mingler": "sgww",
    "Minion Pro": "nljb",
    "Minion Pro Caption": "pwvm",
    "Minion Pro Condensed": "bkmb",
    "Minion Pro Condensed Caption": "mnjs",
    "Minion Pro Condensed Display": "clyh",
    "Minion Pro Condensed Subhead": "hzyk",
    "Minion Pro Display": "sjrl",
    "Minion Pro Subhead": "gfww",
    "Minion Std Black": "rclj",
    "Ministry": "bvkd",
    "Mislab Std": "zswc",
    "Mislab Std Compact": "jtzm",
    "Mislab Std Narrow": "zqhl",
    "Missionary": "hydd",
    "Mitigate": "fqpt",
    "Mittwoch": "jlnh",
    "Moby": "vswr",
    "Moby Monospaced": "lcgn",
    "Modesto Condensed": "xmgm",
    "Modesto Expanded": "jjrz",
    "Modesto Initials": "rbtt",
    "Modesto Initials Inline": "ynyf",
    "Modesto Open Caps": "tprl",
    "Modesto Open Fat Outline": "bcwq",
    "Modesto Open Inline Fill": "jbrb",
    "Modesto Open Outline": "xvgm",
    "Modesto Open Primary": "ftpc",
    "Modesto Open Shadow": "dfwt",
    "Modesto Poster": "gdxd",
    "Modesto Text": "vhpy",
    "ModestoLite": "zlfx",
    "ModestoLite Expanded": "plwh",
    "Modula Round Outlined": "pwnp",
    "Modula Round Ribbed": "jrpk",
    "Modula Round Sans": "qnxz",
    "Modula Round Serif": "llbq",
    "Modula Sans": "dsys",
    "Modula Serif": "sqlj",
    "Modula Tall": "ydry",
    "Molengo": "jqzh",
    "Monarcha": "jckl",
    "Mono45 Headline": "mngr",
    "Montag": "wdyd",
    "Mostra Nuova": "dktt",
    "Mostra Nuova Alt A": "qmbs",
    "Mostra Nuova Alt B": "nwjl",
    "Mostra Nuova Alt C": "nlnb",
    "Mostra Nuova Alt D": "mpbv",
    "Motion": "rdgd",
    "Motor": "kckf",
    "Motor Stencil": "fzlg",
    "Mr Eaves Modern": "cvvh",
    "Mr Eaves Sans": "mkvk",
    "Mr Eaves XL Modern": "sgfs",
    "Mr Eaves XL Modern Narrow ": "mfbs",
    "Mr Eaves XL Sans": "ptfx",
    "Mr Eaves XL Sans Narrow ": "qvry",
    "Mrs Eaves ": "wdqb",
    "Mrs Eaves XL Serif ": "spst",
    "Mrs Eaves XL Serif Narrow": "fgkw",
    "Mufferaw": "kktq",
    "Muscle Narrow": "blhz",
    "Muscle Wide": "rgxv",
    "Museo": "htrh",
    "Museo Sans": "ycvr",
    "Museo Sans Condensed": "gkws",
    "Museo Sans Display": "vcwp",
    "Museo Sans Rounded": "dtgx",
    "Museo Slab": "llxb",
    "Myriad Pro": "cbym",
    "Myriad Pro Condensed": "vdpz",
    "Myriad Pro Semi Condensed": "ylwn",
    "Myriad Pro SemiExtended": "jhzb",
    "Myriad Std Sketch": "gbbb",
    "Myriad Std Tilt": "nbfh",
    "Mythos Std": "jlqm",
    "Nagomi": "smxk",
    "Narly ": "bbwv",
    "Narly Inline": "mjsw",
    "Narly Outline": "kxjy",
    "Nasalization": "jyzd",
    "Natalya": "vzvw",
    "Natalya Alternate One": "wzgr",
    "Natalya Alternate Two": "rfjn",
    "Nautica": "mlcd",
    "Neuropol Nova": "hldj",
    "Neuropol X ": "ndvj",
    "Neuzeit Grotesk": "ldzs",
    "Neuzeit Grotesk Condensed": "cdqy",
    "Neuzeit Grotesk Extra Condensed": "wkxn",
    "Neuzon": "nqth",
    "New Cicle": "vsdw",
    "Newcomen": "fgrc",
    "News Gothic Std": "hytk",
    "Nimbus Roman": "zjrv",
    "Nimbus Sans": "jyxm",
    "Nimbus Sans Condensed": "cbsf",
    "Nimbus Sans Extended": "wkbr",
    "Niveau Grotesk": "srkh",
    "Niveau Grotesk Small Caps": "hdlf",
    "Nobile": "smsp",
    "NotCaslon One": "xplq",
    "NotCaslon Two": "xhzg",
    "Nouvelle Vague": "qrmf",
    "Nudista Web": "jvbv",
    "Nueva Std": "rwrc",
    "Nueva Std Condensed": "clsw",
    "Nueva Std Extended": "nfyf",
    "Obliqua": "nzvz",
    "Oblong ": "krpk",
    "OCR-A Std": "lxjw",
    "OCR-B Std": "fnzm",
    "Octin College": "wxch",
    "Octin Prison": "ryfc",
    "Octin Sports": "tgkh",
    "Octin Spraypaint": "tzky",
    "Octin Stencil": "gndv",
    "Octin Vintage": "sbtf",
    "Octynaz": "bvmm",
    "Old Man Eloquent": "ssjb",
    "Old Standard": "hhcn",
    "Olidia": "scnw",
    "Omnes Pro": "mpmb",
    "Open Sans": "jtcj",
    "Open Sans Condensed": "kchh",
    "Orator Std": "xlsx",
    "Orbitron": "rfss",
    "Orgovan Rounded Web": "dmfb",
    "Origins": "vczy",
    "Orpheus Pro": "qtnq",
    "Oscine": "fpql",
    "Ottomat": "twzp",
    "Outwest Dark": "bdfw",
    "Outwest Half Empty": "zszm",
    "Outwest Half Full": "rtdx",
    "Outwest Light": "pvxx",
    "Oxtail": "ltxb",
    "P22 FLLW Eaglefeather": "fqdt",
    "P22 FLLW Eaglefeather Informal": "hkvw",
    "P22 FLLW Eaglefeather Small Caps": "qpch",
    "P22 Franklin Caslon": "vkns",
    "P22 Underground": "xjhh",
    "P22 Underground Petite Caps": "zjlx",
    "P22 Underground Small Caps": "nfvg",
    "Paganini": "gfkp",
    "Paganini Open": "dccv",
    "Pakenham": "bdyv",
    "Paralucent": "bmpq",
    "Paralucent Condensed": "vczc",
    "Paralucent Stencil": "qhzb",
    "Paralucent Text": "ndvp",
    "Parisine Office Std": "dbsd",
    "Parisine Plus Std": "gcyw",
    "Parisine Plus Std Clair": "ysqf",
    "Parisine Plus Std Gris": "ggdq",
    "Parisine Plus Std Sombre": "ffkd",
    "Parisine Std": "yymm",
    "Parisine Std Clair": "nyvz",
    "Parisine Std Gris": "xklx",
    "Parisine Std Sombre": "fwwl",
    "Parkway Hotel": "xdzr",
    "Parkway Motel": "qpvq",
    "Pauline": "zvgp",
    "Peachy Keen JF": "ncwm",
    "Penna": "gxfz",
    "Penna Connected": "lmfs",
    "Penna Connected Swashes": "xchj",
    "Penna Swashes": "dpld",
    "Pepperwood Std": "tpsr",
    "Pepperwood Std Fill": "tswh",
    "Pepperwood Std Outline": "cxvc",
    "Peregroy JF": "lqlk",
    "Petala Pro": "mcfg",
    "Petersburg Web": "pvnc",
    "Phoreus Cherokee": "kztt",
    "Pill Gothic 300mg": "hcdx",
    "Pill Gothic 600mg": "sdgb",
    "Pill Gothic 900mg": "zwjh",
    "Pinot Grigio Modern": "mhkp",
    "Pirulen": "rmdm",
    "Platelet": "stkz",
    "Plume": "nfmz",
    "Plume Advertising": "cxfn",
    "Poetica Std": "vmhs",
    "Poleno": "lsbt",
    "Pollen": "lhjv",
    "Ponderosa Std": "mvzx",
    "Poplar Std": "fsrs",
    "Poster Clean": "qpkn",
    "Postino Std": "wkmr",
    "Pragmatica Web": "cmzp",
    "Pragmatica Web Condensed": "nddy",
    "Prenton": "snfg",
    "Prenton Condensed": "ljkd",
    "Prenton Display": "hdwk",
    "Prenton Ultra Condensed": "gfll",
    "Presicav": "hvcm",
    "Prestige Elite Std": "lzbb",
    "Printf": "hhgr",
    "Priori Acute Serif ": "sjyq",
    "Priori Sans": "bqvr",
    "Priori Serif": "vyvs",
    "Private Sans Web": "qtcz",
    "Prociono": "tpnn",
    "Professor Minty": "yqpt",
    "Program ": "nqmd",
    "Program Narrow": "spkv",
    "Prohibition": "dshv",
    "Prometo": "mhst",
    "Proxima Nova": "vcsm",
    "Proxima Nova Alt": "gcgw",
    "Proxima Nova Alt Condensed": "rnlm",
    "Proxima Nova Alt Extra Condensed": "twjk",
    "Proxima Nova Condensed": "mtyl",
    "Proxima Nova Extra Condensed": "wxrb",
    "Proxima Nova SC OSF": "bnsy",
    "Proxima Nova SC OSF Condensed": "vdqp",
    "Proxima Nova SC OSF Extra Condensed": "rmtj",
    "Proxima Nova Soft": "hlkx",
    "PT Sans": "lllr",
    "PT Sans Caption": "dydp",
    "PT Sans Narrow": "rmcr",
    "PT Serif": "xcqq",
    "PT Serif Caption": "wnnk",
    "Pupcat": "crvc",
    "Purista Web": "rjbz",
    "Puritan": "ccqc",
    "Quagmire": "cvcs",
    "Quagmire Extended": "zvzn",
    "Quake Std": "vxzg",
    "Quara": "qfcs",
    "Quatro": "hptl",
    "Quatro Slab": "dxzd",
    "Quimby Gubernatorial": "mhfk",
    "Quimby Mayoral": "zlxv",
    "Raleway": "nqdy",
    "Ratio": "yqrc",
    "Ratio Display": "lwyp",
    "Ratio Modern": "mnts",
    "Ratio Modern SC": "twzz",
    "Reagan": "fqbp",
    "Recherche": "yrgk",
    "Reenie Beanie": "fbtr",
    "Refrigerator Deluxe": "snjm",
    "Reklame Script": "ghpm",
    "Remedy": "mjbh",
    "Report": "qwvc",
    "Report School": "wkdn",
    "RePublic Web": "wkdp",
    "RePublic Web Condensed": "fflc",
    "Restore": "xngk",
    "Retiro Std 16pt": "kjcd",
    "Retiro Std 24pt": "zbmb",
    "Retiro Std 36pt": "vsfm",
    "Retiro Std 48pt": "btcn",
    "Retiro Std 96pt": "scdc",
    "Rexlia": "mqkk",
    "Rieven Uncial": "fzzs",
    "Rinse": "fyfp",
    "Roboto": "dwgd",
    "Roboto Condensed": "flqd",
    "Roboto Mono": "tcyz",
    "Roboto Slab": "xnwr",
    "Rogue Sans": "bdvm",
    "Rogue Sans Condensed": "bjlp",
    "Rogue Sans Extended": "fqjk",
    "Rogue Serif": "pdrp",
    "Ronnia": "rtgb",
    "Ronnia Condensed": "hzlv",
    "Rooney Sans Web": "mtpj",
    "Rooney Web": "thfh",
    "Rosario": "dvxw",
    "Rosewood Std": "gkhy",
    "Rosewood Std Fill": "rcrp",
    "Rowdy": "msgp",
    "Roycroft": "nrkw",
    "RTF Alexander Quill": "ngqw",
    "RTF Stern Pro": "rkcc",
    "Rucksack": "cjbj",
    "Rukou": "qqfy",
    "Runda": "xnyr",
    "Sabbath Black": "zcvb",
    "Sail": "vdwc",
    "Salsbury": "wzyl",
    "Sanvito Pro": "lbxf",
    "Sanvito Pro Caption": "xpjb",
    "Sanvito Pro Display": "rhtz",
    "Sanvito Pro Subhead": "xssy",
    "Sarina": "phnf",
    "Saucy Millionaire": "qvwh",
    "saxMono": "fjsz",
    "Scheme": "fdys",
    "SchoolBook Web": "jvcb",
    "SchoolBook Web Condensed": "hncd",
    "Scriptorama Markdown JF": "kbzw",
    "Scriptorama Tradeshow JF": "jyjz",
    "Scrivano": "drdl",
    "Semplicita Pro": "bdtx",
    "Senator ": "qxml",
    "Senator Tall": "ftkp",
    "September": "wyrm",
    "Serenity": "mxcg",
    "Serifa": "vzyz",
    "Serifa Condensed": "rjbq",
    "Servus Slab": "bsyh",
    "Sewn": "rmhl",
    "Share OSF": "jzbt",
    "Share Regular": "vnrl",
    "Share Tech": "tszf",
    "Share TechMono": "ypjx",
    "Sharik Sans": "fdvv",
    "Sharktooth": "vnjx",
    "Shelby": "hrfr",
    "Shlop": "qcsv",
    "Shlop Shloppy": "ttzn",
    "Shrub": "dldb",
    "Shuriken Std": "vvgc",
    "Signo": "mynw",
    "Silicone ": "kjwl",
    "Silkscreen": "wsxd",
    "Simply Mono": "hkfm",
    "Sirba": "tgbb",
    "Sister Frisky": "wqdz",
    "Sketchnote Square": "krjn",
    "Sketchnote Text": "wmzm",
    "Skippy Sharp": "pynt",
    "Skolar Latin": "wktd",
    "Skolar Sans Latin": "wrzk",
    "Skolar Sans Latin Compressed": "bwkd",
    "Skolar Sans Latin Condensed": "wqkf",
    "Skolar Sans Latin Extended": "zpsy",
    "Sneakers Pro": "wxlh",
    "Sneakers Script": "kpdg",
    "Sneakers Script Narrow": "ykmb",
    "Sneakers Script Ultra Wide": "ktgn",
    "Sneakers Script Wide": "kyln",
    "Snicker": "mkrf",
    "Sniglet": "pfsq",
    "Soap": "hjxr",
    "Soda Script ": "tqwv",
    "Sofachrome": "cntf",
    "Sofia Pro": "bbkk",
    "Sofia Pro Condensed": "hkkn",
    "Sofia Pro Soft": "cght",
    "Soleil": "phxy",
    "Soleto": "dlvr",
    "Solex ": "slhw",
    "Sommet": "gyyc",
    "Sommet Rounded": "gqfn",
    "Sommet Slab": "qlvb",
    "Sommet Slab Titling Caps": "kwmd",
    "Sophisto": "nnzs",
    "Sophisto SC": "xhsp",
    "Sorts Mill Goudy": "yrwy",
    "Source Code Pro": "dkxf",
    "Source Sans Pro": "bhyf",
    "Source Serif Pro": "xlqg",
    "Sovba": "djhf",
    "Spartacus": "qygh",
    "Spartacus Condensed": "whvj",
    "Spumante": "hrwh",
    "Spumante Shadow": "hvxc",
    "Steinzeit": "pxyp",
    "Steinzeit Fill In": "dqqv",
    "Stencil Std": "xjpx",
    "Stenciletta": "zzkp",
    "Stenciletta Left": "bjhz",
    "Stenciletta Right": "nymb",
    "Stenciletta Solid": "rbgh",
    "Stevie Sans": "lcps",
    "Strenuous": "hwfj",
    "Strenuous 3D": "ljdq",
    "Strenuous Cast": "srfm",
    "Stroudley": "vjrb",
    "Strumpf Std Contour": "njgn",
    "Strumpf Std Open": "rpkg",
    "Stud": "qfxd",
    "Stymie": "jxcz",
    "Stymie Condensed": "wrfb",
    "Stymie Drop Caps": "rtbv",
    "Stymie SC": "fkqz",
    "Suburban ": "fdgz",
    "Subway Berlin SC": "cgzm",
    "Subway Berlin STD": "sfdf",
    "Subway New York SC": "dwkp",
    "Subway New York STD": "cxvn",
    "Subway Paris SC": "fkxh",
    "Subway Paris STD": "zrgx",
    "Sui Generis": "ctts",
    "Sunflower": "whtb",
    "Sunshine": "ldbl",
    "Superclarendon ": "ywrj",
    "Supria Sans": "xqvl",
    "Supria Sans Condensed": "hydr",
    "Sutro ": "bhhm",
    "Sutro Black Initials": "qkjh",
    "Sutro Bold Expanded": "cqck",
    "Sutro Deluxe Fill": "vzsn",
    "Sutro Deluxe Inline": "bdfj",
    "Sutro Deluxe Inline Fill": "jxgl",
    "Sutro Deluxe Inline Shaded": "ywpv",
    "Sutro Deluxe Primary": "ywvw",
    "Sutro Open Fill": "dfgk",
    "Sutro Open Initials": "dwdm",
    "Sutro Shaded Fill ": "plpk",
    "Sutro Shaded Gradient": "ywzz",
    "Sutro Shaded Hatching": "gwqq",
    "Sutro Shaded HiLite": "gtfv",
    "Sutro Shaded Primary": "xmbr",
    "Sutro Shaded Rules": "tjxk",
    "Sutturah": "dxbc",
    "Sweater School": "rfcm",
    "Swingdancer": "gmjz",
    "Swister": "mdrb",
    "Synthemesc": "kyyj",
    "T.26 Carbon": "qqmf",
    "Tablet Gothic": "qxcw",
    "Tablet Gothic Compressed": "lgmp",
    "Tablet Gothic Condensed": "flgm",
    "Tablet Gothic Narrow": "ggqq",
    "Tablet Gothic Semi Condensed": "fsmk",
    "Tablet Gothic Wide": "fgpc",
    "Tachyon": "wkby",
    "Tacitus Pro": "pwwk",
    "Tamarillo JF": "cxcx",
    "Tandelle ": "qywd",
    "Tangerine": "dwdh",
    "Tarzana Narrow": "wsdl",
    "Tarzana Wide ": "cgvf",
    "Teeshirt": "bxhq",
    "Teimer Web": "svlp",
    "Tekton Pro": "fkjd",
    "Tekton Pro Condensed": "bsjh",
    "Tekton Pro Extended": "fxtn",
    "Template Gothic": "mbjk",
    "Tenby Eight ": "qvsv",
    "Tenby Five": "pxcb",
    "Tenby Four": "xxhj",
    "Tenby Seven": "tcxj",
    "Tenby Six": "kzrf",
    "Tenso": "xxpy",
    "Terfens": "yhln",
    "TewentyFourNinetyOne": "qbct",
    "Texas Hero": "vvpx",
    "TextBook New Web": "dxlb",
    "Tight": "yqln",
    "Tilden Sans Light": "nkpr",
    "Tinos": "plns",
    "Tondo": "hlmz",
    "Tondo Signage": "pbbh",
    "Tornac": "lkhx",
    "Totally Glyphic ": "rjwx",
    "Totally Gothic": "lwnh",
    "Totally Gothic Wide Caps": "rvdw",
    "Trajan Pro 3": "xwct",
    "Trajan Sans Pro": "zlnd",
    "Transmute": "nchn",
    "Tribute": "cqjj",
    "Triplex Cond Sans ": "vhgm",
    "Triplex Cond Serif ": "ysbn",
    "Triplex Sans ": "cpnb",
    "Triplex Serif ": "hcxf",
    "Trump Gothic Pro": "cckd",
    "Trump Soft Pro": "kzpc",
    "Tussilago": "sxxr",
    "Ubuntu": "jhhw",
    "Ubuntu Condensed": "kflc",
    "Ubuntu Mono": "vwkk",
    "Univia Pro": "hpyn",
    "Uniwars ": "sbpb",
    "Uppercut Angle": "qpgh",
    "Urbana": "txkp",
    "URW Antiqua": "fqzp",
    "Usual": "zprm",
    "Usurp": "qdmw",
    "Utopia Std": "qpzx",
    "Utopia Std Caption": "dwvv",
    "Utopia Std Display": "ngmz",
    "Utopia Std Headline": "krcv",
    "Utopia Std Subhead": "vlql",
    "VAG Rundschrift D": "lphf",
    "Variex ": "cdrw",
    "Vatican": "lcfv",
    "Velino Poster": "tvvb",
    "Vendetta": "rlxz",
    "Vera Sans": "lvrl",
    "Verveine": "dtrt",
    "Vidange Pro": "mdgg",
    "Vinyl": "zgct",
    "Vista Sans": "jghj",
    "Vista Sans Narrow": "clnm",
    "Vista Slab": "gfxd",
    "Viva Std": "gbnd",
    "Viva Std Condensed": "qmzx",
    "Viva Std Extra Extended": "xsww",
    "VM74": "zlhl",
    "Vollkorn": "pdhm",
    "Voltage": "wbxf",
    "Voluta Script Pro": "tyqy",
    "Vortice": "fbtq",
    "Vox": "lhgy",
    "Vox Round": "cmtl",
    "Walnut": "qptp",
    "Warnock Pro": "znjr",
    "Warnock Pro Caption": "xtcp",
    "Warnock Pro Display": "ywcd",
    "Westsac": "nyyg",
    "Wigwag Bold": "tlyc",
    "Wigwag Deluxe": "frzs",
    "Willow Std": "rnxx",
    "Wordy Diva": "rvnv",
    "Xenara": "mspk",
    "Youngblood": "rnxf",
    "Yrsa": "kdmd",
    "Zalderdash": "ybkj",
    "Zebrawood Std": "hqpx",
    "Zebrawood Std Fill": "frcg",
    "Zekton": "pdcq",
    "ZsaZsa Galore": "vjpz",
    "Zubilo Web Black": "phcq",
    "Zubilo Web Inline": "qdql",
    "Zubilo Web Lined": "mcwh",
    "Zubilo Web Shadow": "cjqd"
  };

}).call(this);
