import { Monaco, monacoTypes } from '@grafana/ui';
import React from 'react';
import { SQLCompletionItemProvider } from '../types';
interface LanguageDefinition extends monacoTypes.languages.ILanguageExtensionPoint {
    loadLanguage?: (module: any) => Promise<{
        language: monacoTypes.languages.IMonarchLanguage;
        conf: monacoTypes.languages.LanguageConfiguration;
    }>;
    completionProvider?: (m: Monaco) => SQLCompletionItemProvider;
    formatter?: (q: string) => string;
}
interface SQLEditorProps {
    query: string;
    /**
     * Use for inspecting the query as it changes. I.e. for validation.
     */
    onChange?: (q: string, processQuery: boolean) => void;
    language?: LanguageDefinition;
    children?: (props: {
        formatQuery: () => void;
    }) => React.ReactNode;
    width?: number;
    height?: number;
}
export declare const SQLEditor: React.FC<SQLEditorProps>;
export declare const registerLanguageAndSuggestions: (monaco: Monaco, l: LanguageDefinition, lid: string) => Promise<void>;
export {};
