import { Registry } from '@grafana/data';
import { FunctionsRegistryItem, MacrosRegistryItem, OperatorsRegistryItem, SuggestionsRegistyItem } from './types';
/**
 * This registry glues particular SuggestionKind with an async function that provides completion items for it.
 * To add a new suggestion kind, SQLEditor should be configured with a provider that implements customSuggestionKinds.
 */
export declare const initStandardSuggestions: (functions: Registry<FunctionsRegistryItem>, operators: Registry<OperatorsRegistryItem>, macros: Registry<MacrosRegistryItem>) => () => SuggestionsRegistyItem[];
export declare const initFunctionsRegistry: () => FunctionsRegistryItem[];
export declare const initMacrosRegistry: () => MacrosRegistryItem[];
export declare const initOperatorsRegistry: () => OperatorsRegistryItem[];
