Object.defineProperty(exports, '__esModule', { value: true });

var data = require('@grafana/data');
var ui = require('@grafana/ui');
var React = require('react');
var lodash = require('lodash');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

var TEST_IDS = {
    helpBox: 'Configuration help box',
    dropZone: 'Configuration drop zone',
    pasteArea: 'Configuration text area',
    pasteJwtButton: 'Paste JWT button',
    resetJwtButton: 'Reset JWT button',
    jwtForm: 'JWT form',
    authTypeButtonJWT: 'JWT button',
    authTypeButtonGCE: 'GCE button',
};

var configKeys = ['private_key', 'token_uri', 'client_email', 'project_id'];
var INVALID_JWT_TOKEN_ERROR = 'Invalid JWT token';
var JWTConfigEditor = function (_a) {
    var onChange = _a.onChange;
    var _b = __read(React.useState(), 2), error = _b[0], setError = _b[1];
    var _c = __read(React.useState(null), 2), isPasting = _c[0], setIsPasting = _c[1];
    var theme = ui.useTheme2();
    var onPasteClick = React.useCallback(function (e) {
        setError(null);
        setIsPasting(true);
    }, [setIsPasting]);
    var onUploadClick = React.useCallback(function (e) {
        setIsPasting(null);
        setError(null);
    }, [setIsPasting]);
    var readAndValidateJWT = React.useCallback(function (value) {
        if (value.trim() !== '') {
            var jwt = void 0;
            try {
                jwt = JSON.parse(value);
            }
            catch (e) {
                setError(INVALID_JWT_TOKEN_ERROR);
            }
            var validation = validateJWT(jwt);
            if (validation.isValid) {
                onChange({
                    privateKey: jwt.private_key,
                    tokenUri: jwt.token_uri,
                    clientEmail: jwt.client_email,
                    projectId: jwt.project_id,
                });
            }
            else {
                setError(validation.error);
            }
        }
    }, [setError, onChange]);
    return (React__default["default"].createElement(React__default["default"].Fragment, null,
        React__default["default"].createElement(ui.Field, { label: "JWT token", invalid: Boolean(error), description: isPasting ? 'Paste JWT token below' : 'Upload or paste Google JWT token', error: error },
            React__default["default"].createElement(React__default["default"].Fragment, null,
                isPasting !== true && (React__default["default"].createElement("div", { "data-testid": TEST_IDS.dropZone },
                    React__default["default"].createElement(ui.FileDropzone, { options: { multiple: false, accept: 'application/json' }, readAs: "readAsText", onLoad: function (result) {
                            readAndValidateJWT(result);
                            setIsPasting(false);
                        } },
                        React__default["default"].createElement("p", { style: { margin: 0, fontSize: "" + theme.typography.h4.fontSize, textAlign: 'center' } },
                            "Drop the Google JWT file here",
                            React__default["default"].createElement("br", null),
                            React__default["default"].createElement("br", null),
                            React__default["default"].createElement(ui.LinkButton, { fill: "outline" }, "Click to browse files"))))),
                isPasting && (
                // @ts-ignore
                React__default["default"].createElement(ui.TextArea, { "data-testid": TEST_IDS.pasteArea, autoFocus: true, invalid: Boolean(error), placeholder: "Paste Google JWT token here", onBlur: function (e) { return readAndValidateJWT(e.currentTarget.value); }, rows: 12 })))),
        !isPasting && (React__default["default"].createElement(ui.Field, null,
            React__default["default"].createElement(ui.Button, { "data-testid": TEST_IDS.pasteJwtButton, type: "button", fill: "outline", style: { color: "" + theme.colors.primary.text }, onClick: onPasteClick }, "Paste JWT Token"))),
        isPasting && error && (React__default["default"].createElement(ui.Field, null,
            React__default["default"].createElement(ui.Button, { type: "button", fill: "outline", style: { color: "" + theme.colors.primary.text }, onClick: onUploadClick }, "Upload JWT Token")))));
};
var validateJWT = function (json) {
    if (!lodash.isObject(json)) {
        return { isValid: false, error: 'Invalid JWT token' };
    }
    var missingKeys = configKeys.filter(function (key) { return !json[key]; });
    if (missingKeys.length > 0) {
        return { isValid: false, error: "Missing keys: " + missingKeys.join(', ') };
    }
    return { isValid: true };
};

var JWTForm = function (_a) {
    var options = _a.options, onReset = _a.onReset, onChange = _a.onChange;
    var onResetPress = function () { return onReset(null); };
    return (React__default["default"].createElement("div", { "data-testid": TEST_IDS.jwtForm },
        React__default["default"].createElement(ui.Field, { label: "Project ID" },
            React__default["default"].createElement(ui.Input, { id: "defaultProject", width: 60, value: options.defaultProject || '', onChange: onChange('defaultProject') })),
        React__default["default"].createElement(ui.Field, { label: "Client email" },
            React__default["default"].createElement(ui.Input, { width: 60, id: "clientEmail", value: options.clientEmail || '', onChange: onChange('clientEmail') })),
        React__default["default"].createElement(ui.Field, { label: "Token URI" },
            React__default["default"].createElement(ui.Input, { width: 60, id: "tokenUri", value: options.tokenUri || '', onChange: onChange('tokenUri') })),
        React__default["default"].createElement(ui.Field, { label: "Private key", disabled: true },
            React__default["default"].createElement(ui.Input, { width: 60, id: "privateKey", readOnly: true, placeholder: "Private key configured", addonAfter: React__default["default"].createElement(ui.Tooltip, { content: "Click to clear the uploaded JWT token and upload a new one" },
                    React__default["default"].createElement(ui.Button, { "data-testid": TEST_IDS.resetJwtButton, icon: "sync", size: "xs", onClick: onResetPress, fill: "outline" }, "Reset token")) }))));
};

exports.GoogleAuthType = void 0;
(function (GoogleAuthType) {
    GoogleAuthType["JWT"] = "jwt";
    GoogleAuthType["GCE"] = "gce";
})(exports.GoogleAuthType || (exports.GoogleAuthType = {}));

var GOOGLE_AUTH_TYPE_OPTIONS = [
    { label: 'Google JWT File', value: exports.GoogleAuthType.JWT, ariaLabel: TEST_IDS.authTypeButtonJWT },
    { label: 'GCE Default Service Account', value: exports.GoogleAuthType.GCE, ariaLabel: TEST_IDS.authTypeButtonGCE },
];

var ConnectionConfig = function (props) {
    var options = props.options, onOptionsChange = props.onOptionsChange;
    var jsonData = options.jsonData, secureJsonFields = options.secureJsonFields, secureJsonData = options.secureJsonData;
    if (!jsonData.authenticationType) {
        jsonData.authenticationType = exports.GoogleAuthType.JWT;
    }
    var isJWT = jsonData.authenticationType === exports.GoogleAuthType.JWT || jsonData.authenticationType === undefined;
    var onAuthTypeChange = function (authenticationType) {
        onOptionsChange(__assign(__assign({}, options), { jsonData: __assign(__assign({}, options.jsonData), { authenticationType: authenticationType }) }));
    };
    var hasJWTConfigured = Boolean(secureJsonFields &&
        secureJsonFields.privateKey &&
        jsonData.clientEmail &&
        jsonData.defaultProject &&
        jsonData.tokenUri);
    var onResetApiKey = function (jsonData) {
        var nextSecureJsonData = __assign({}, secureJsonData);
        var nextJsonData = !jsonData ? __assign({}, options.jsonData) : __assign(__assign({}, options.jsonData), jsonData);
        delete nextJsonData.clientEmail;
        delete nextJsonData.defaultProject;
        delete nextJsonData.tokenUri;
        delete nextSecureJsonData.privateKey;
        onOptionsChange(__assign(__assign({}, options), { secureJsonData: nextSecureJsonData, jsonData: nextJsonData }));
    };
    var onJWTFormChange = function (key) { return data.onUpdateDatasourceJsonDataOption(props, key); };
    return (React__default["default"].createElement(React__default["default"].Fragment, null,
        React__default["default"].createElement(ui.FieldSet, { label: "Authentication" },
            React__default["default"].createElement(ui.Field, { label: "Authentication type" },
                React__default["default"].createElement(ui.RadioButtonGroup, { options: GOOGLE_AUTH_TYPE_OPTIONS, value: jsonData.authenticationType || exports.GoogleAuthType.JWT, onChange: onAuthTypeChange }))),
        isJWT && (React__default["default"].createElement(ui.FieldSet, { label: "JWT Key Details" },
            hasJWTConfigured ? (React__default["default"].createElement(JWTForm, { options: options.jsonData, onReset: onResetApiKey, onChange: onJWTFormChange })) : (React__default["default"].createElement(JWTConfigEditor, { onChange: function (jwt) {
                    onOptionsChange(__assign(__assign({}, options), { secureJsonFields: __assign(__assign({}, secureJsonFields), { privateKey: true }), secureJsonData: __assign(__assign({}, secureJsonData), { privateKey: jwt.privateKey }), jsonData: __assign(__assign({}, jsonData), { clientEmail: jwt.clientEmail, defaultProject: jwt.projectId, tokenUri: jwt.tokenUri }) }));
                } })),
            ' ')),
        React__default["default"].createElement("div", { className: "grafana-info-box", style: { marginTop: '16px' }, "data-testid": TEST_IDS.helpBox },
            React__default["default"].createElement("p", null,
                "Don\u2019t know how to get a service account key file or create a service account? Read more",
                ' ',
                React__default["default"].createElement("a", { className: "external-link", target: "_blank", rel: "noopener noreferrer", href: "https://grafana.com/docs/grafana/latest/datasources/google-cloud-monitoring/google-authentication/" }, "in the documentation."))),
        !isJWT && (React__default["default"].createElement(ui.Alert, { title: "", severity: "info" }, "Verify GCE default service account by clicking Save & Test"))));
};

exports.ConnectionConfig = ConnectionConfig;
//# sourceMappingURL=index.development.js.map
