/*
 * Assistant APIs for VMEM and relative modules
 *
 * Author:
 *	Naixuan Guan	<guannaixuan@linux.alibaba.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 */

#ifndef _ASM_X86_VMEM_ASSIST_H
#define _ASM_X86_VMEM_ASSIST_H

#ifdef CONFIG_NEAR_METAL

extern bool vmem_assist_is_cmd_reserved_pfn(unsigned long pfn);
extern bool vmem_assist_is_reserved_pfn(unsigned long pfn);
#else

static inline bool vmem_assist_is_cmd_reserved_pfn(unsigned long pfn)
{
	return false;
}

static inline bool vmem_assist_is_reserved_pfn(unsigned long pfn)
{
	return false;
}
#endif

#endif
