// SPDX-License-Identifier: GPL-2.0
#ifndef __RNG_H
#define __RNG_H

#include <stdint.h>

struct rng_ctx;
typedef void (*rng_completion_t)(struct rng_ctx *ctx, int err);
struct rng_ctx {
	uint32_t flags;

	struct rng_alg *alg;
	void *data;
	rng_completion_t complete;

	unsigned char *result;
	uint32_t len;
	void *__ctx[];
};

struct rng_alg {
	const char *name;

	int (*generate)(struct rng_ctx *ctx);
	int (*seed)(struct rng_ctx *ctx, const uint8_t *seed, unsigned int slen);
	int (*init)(struct rng_ctx *ctx);
	void (*exit)(struct rng_ctx *ctx);

	uint32_t seedsize;
	uint32_t ctxsize;
};

struct rng_alg_entry {
	struct rng_alg *alg;
	struct rng_alg_entry *next;
};

struct rng_ctx *rng_alloc_ctx(const char *alg_name, uint32_t flag);
void rng_free_ctx(struct rng_ctx *ctx);
int rng_generate(struct rng_ctx *ctx, const uint8_t *src, uint32_t slen,
		 uint8_t *dst, uint32_t dlen);
int rng_seed(struct rng_ctx *ctx, const uint8_t *seed, unsigned int slen);
uint32_t rng_seedsize(struct rng_ctx *ctx);
void rng_register_algs(void);
void rng_unregister_algs(void);

#endif
