// SPDX-License-Identifier: GPL-2.0
#ifndef __YCC_UIO_H
#define __YCC_UIO_H

#include <sys/queue.h>
#include <pthread.h>
#include <unistd.h>

#include "ycc_ring.h"

#define YCC_UIO_NAME_LEN	16
#define YCC_UIO_MAP_NAME_LEN	64

struct ycc_uio_map {
	int ufd;
	char uio_name[YCC_UIO_NAME_LEN];
	char name[YCC_UIO_MAP_NAME_LEN];

	unsigned long addr;
	unsigned long offset;
	unsigned long size;
};

#define YCC_LIST_ENTRY(type)		LIST_ENTRY(type)
#define YCC_LIST_HEAD(type, name)	LIST_HEAD(type, name)
#define YCC_LIST_ADD(elem, head)	LIST_INSERT_HEAD(head, elem, list)
#define YCC_LIST_FOREACH(elem, head)	LIST_FOREACH(elem, head, list)

#define LIST_FOREACH_SAFE(var, head, field, tvar)	\
	for ((var) = ((head)->lh_first);	\
		(var) && ((tvar) = LIST_NEXT((var), field), 1);	\
		(var) = (tvar))

#define YCC_LIST_FOREACH_SAFE(elem, tmp, head)	\
	LIST_FOREACH_SAFE(elem, head, list, tmp)
#define YCC_LIST_REMOVE(elem)		LIST_REMOVE(elem, list)
#define YCC_LIST_INIT(head)		LIST_INIT(head)

struct ycc_list {
	struct ycc_uio_map umap;
	struct ycc_ring *ring;

	YCC_LIST_ENTRY(ycc_list) list;
};

YCC_LIST_HEAD(ycc_list_head, ycc_list);

int ycc_set_polling_affinity(cpu_set_t *cpuset);
int ycc_get_polling_affinity(cpu_set_t *cpuset);
int ycc_set_polling_interval(unsigned int usec);
unsigned int ycc_get_polling_interval(void);
int ycc_drv_init(int count);
void ycc_drv_exit(void);

#endif
