// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2020-2022 Alibaba Corporation. All rights reserved.
 * Author: Zelin Deng <zelin.deng@linux.alibaba.com>
 * Author: Guanjun <guanjun@linux.alibaba.com>
 * Author: Jiayu Ni <jiayu.ni@linux.alibaba.com>
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "ycc_uio.h"
#include "utils.h"
#include "rng.h"

static bool inited;

/*
 * Destructor: It is must if driver initialize successfully.
 */
static void __attribute__((destructor)) drv_exit(void)
{
	if (inited)
		ycc_drv_exit();
}

int main(int argc, char *argv[])
{
	struct rng_ctx *cipher;
	uint8_t dst[32];
	int ret;

	ret = ycc_drv_init(1);
	if (ret < 0)
		return ret;

	cipher = rng_alloc_ctx("trng", 0);
	if (!cipher)
		return -1;

	ret = rng_generate(cipher, NULL, 0, dst, 32);
	if (ret >= 0)
		hex_dump("Random:", dst, 32);

	rng_free_ctx(cipher);
	return ret >= 0 ? 0 : ret;
}
