/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client;

import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.client.JDAPAVA;
import netscape.ldap.client.JDAPFilterAnd;
import netscape.ldap.client.JDAPFilterApproxMatch;
import netscape.ldap.client.JDAPFilterEqualityMatch;
import netscape.ldap.client.JDAPFilterExtensible;
import netscape.ldap.client.JDAPFilterGreaterOrEqual;
import netscape.ldap.client.JDAPFilterLessOrEqual;
import netscape.ldap.client.JDAPFilterNot;
import netscape.ldap.client.JDAPFilterOr;
import netscape.ldap.client.JDAPFilterPresent;
import netscape.ldap.client.JDAPFilterSubString;

public abstract class JDAPFilter {
    public static JDAPFilter getFilter(String filter) {
        String f = new String(filter);
        f.trim();
        if (f.startsWith("(") && f.endsWith(")")) {
            return JDAPFilter.getFilterComp(f.substring(1, f.length() - 1));
        }
        return JDAPFilter.getFilterComp(filter);
    }

    public static JDAPFilter getFilterComp(String f) {
        f.trim();
        if (f.startsWith("&")) {
            JDAPFilter[] filters = JDAPFilter.getFilterList(f.substring(1, f.length()));
            if (filters == null) {
                throw new IllegalArgumentException("Bad search filter");
            }
            JDAPFilterAnd and = new JDAPFilterAnd();
            for (int i = 0; i < filters.length; ++i) {
                and.addElement(filters[i]);
            }
            return and;
        }
        if (f.startsWith("|")) {
            JDAPFilter[] filters = JDAPFilter.getFilterList(f.substring(1, f.length()));
            if (filters == null) {
                throw new IllegalArgumentException("Bad search filter");
            }
            JDAPFilterOr or = new JDAPFilterOr();
            for (int i = 0; i < filters.length; ++i) {
                or.addElement(filters[i]);
            }
            return or;
        }
        if (f.startsWith("!")) {
            JDAPFilter filter = JDAPFilter.getFilter(f.substring(1, f.length()));
            if (filter == null) {
                throw new IllegalArgumentException("Bad search filter");
            }
            return new JDAPFilterNot(filter);
        }
        return JDAPFilter.getFilterItem(f.substring(0, f.length()));
    }

    public static JDAPFilter[] getFilterList(String list) {
        list.trim();
        int level = 0;
        int start = 0;
        int end = 0;
        Vector<JDAPFilter> v = new Vector<JDAPFilter>();
        for (int i = 0; i < list.length(); ++i) {
            if (list.charAt(i) == '(') {
                if (level == 0) {
                    start = i;
                }
                ++level;
            }
            if (list.charAt(i) != ')' || --level != 0) continue;
            end = i;
            v.addElement(JDAPFilter.getFilter(list.substring(start, end + 1)));
        }
        if (v.size() == 0) {
            return null;
        }
        JDAPFilter[] f = new JDAPFilter[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            f[i] = (JDAPFilter)v.elementAt(i);
        }
        return f;
    }

    public static JDAPFilter getFilterItem(String item) {
        item.trim();
        int idx = item.indexOf(61);
        if (idx == -1) {
            return null;
        }
        String type = item.substring(0, idx).trim();
        String value = item.substring(idx + 1).trim();
        if (type.indexOf(92) >= 0) {
            throw new IllegalArgumentException("Bad search filter");
        }
        type.trim();
        if (type.endsWith("~")) {
            JDAPAVA ava = new JDAPAVA(type.substring(0, type.length() - 1), value);
            return new JDAPFilterApproxMatch(ava);
        }
        if (type.endsWith(">")) {
            JDAPAVA ava = new JDAPAVA(type.substring(0, type.length() - 1), value);
            return new JDAPFilterGreaterOrEqual(ava);
        }
        if (type.endsWith("<")) {
            JDAPAVA ava = new JDAPAVA(type.substring(0, type.length() - 1), value);
            return new JDAPFilterLessOrEqual(ava);
        }
        if (type.endsWith(":")) {
            return new JDAPFilterExtensible(type.substring(0, type.length() - 1), value);
        }
        if (value.startsWith("*") && value.length() == 1) {
            return new JDAPFilterPresent(type);
        }
        if (value.indexOf(42) == -1) {
            JDAPAVA ava = new JDAPAVA(type, value);
            return new JDAPFilterEqualityMatch(ava);
        }
        StringTokenizer st = new StringTokenizer(value, "*");
        JDAPFilterSubString sub = new JDAPFilterSubString(type);
        String initial = null;
        if (!value.startsWith("*")) {
            initial = st.nextToken();
            initial.trim();
        }
        sub.addInitial(initial);
        while (st.hasMoreTokens()) {
            String any = st.nextToken();
            any.trim();
            if (st.hasMoreTokens()) {
                sub.addAny(any);
                continue;
            }
            if (value.endsWith("*")) {
                sub.addAny(any);
                sub.addFinal(null);
                continue;
            }
            sub.addFinal(any);
        }
        return sub;
    }

    public abstract BERElement getBERElement();

    public abstract String toString();
}

