#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#
# This file incorporates work covered by the following license notice:
#
#   Licensed to the Apache Software Foundation (ASF) under one or more
#   contributor license agreements. See the NOTICE file distributed
#   with this work for additional information regarding copyright
#   ownership. The ASF licenses this file to you under the Apache
#   License, Version 2.0 (the "License"); you may not use this file
#   except in compliance with the License. You may obtain a copy of
#   the License at http://www.apache.org/licenses/LICENSE-2.0 .
#
from .LetterWizardDialogConst import LetterWizardDialogConst, HIDMAIN, HID
from .LetterWizardDialogResources import LetterWizardDialogResources
from ..common.HelpIds import HelpIds
from ..ui.WizardDialog import WizardDialog, uno, PropertyNames

from com.sun.star.awt.FontUnderline import SINGLE

class LetterWizardDialog(WizardDialog):

    def __init__(self, xmsf):
        super(LetterWizardDialog, self).__init__(xmsf, HIDMAIN )

        #Load Resources
        self.resources = LetterWizardDialogResources(self.oWizardResource)
        
        #set dialog properties...        
        self.setDialogProperties(True, 210, True, 104, 52, 1, 1, 
            self.resources.resLetterWizardDialog_title, 350)
                
        self.fontDescriptor5 = \
            uno.createUnoStruct('com.sun.star.awt.FontDescriptor')
        self.fontDescriptor6 = \
            uno.createUnoStruct('com.sun.star.awt.FontDescriptor')
        self.fontDescriptor5.Weight = 100
        self.fontDescriptor6.Weight = 150

    def buildStep1(self):
        self.optBusinessLetter = self.insertRadioButton(
            "optBusinessLetter", 
            LetterWizardDialogConst.OPTBUSINESSLETTER_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 1),
                self.resources.resoptBusinessLetter_value,
                "optBusinessLetter", 97, 28, 1, 1, 184), self)
        self.optPrivOfficialLetter = self.insertRadioButton(
            "optPrivOfficialLetter",
            LetterWizardDialogConst.OPTPRIVOFFICIALLETTER_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 2),
                self.resources.resoptPrivOfficialLetter_value,
                "optPrivOfficialLetter", 97, 74, 1, 2, 184), self)
        self.optPrivateLetter = self.insertRadioButton(
            "optPrivateLetter",
            LetterWizardDialogConst.OPTPRIVATELETTER_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 3),
                self.resources.resoptPrivateLetter_value,
                "optPrivateLetter", 97, 106, 1, 3, 184), self)
        self.lstBusinessStyle = self.insertListBox(
            "lstBusinessStyle",
            LetterWizardDialogConst.LSTBUSINESSSTYLE_ACTION_PERFORMED,
            LetterWizardDialogConst.LSTBUSINESSSTYLE_ITEM_CHANGED,
            ("Dropdown",
                PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (True, 12, HelpIds.getHelpIdString(HID + 4),
                "lstBusinessStyle",
                180, 40, 1, 4, 74), self)
        self.chkBusinessPaper = self.insertCheckBox(
            "chkBusinessPaper",
            LetterWizardDialogConst.CHKBUSINESSPAPER_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 5),
                self.resources.reschkBusinessPaper_value,
                "chkBusinessPaper", 110, 56, 0, 1, 5, 168), self)
        self.lstPrivOfficialStyle = self.insertListBox(
            "lstPrivOfficialStyle",
            LetterWizardDialogConst.LSTPRIVOFFICIALSTYLE_ACTION_PERFORMED,
            LetterWizardDialogConst.LSTPRIVOFFICIALSTYLE_ITEM_CHANGED,
            ("Dropdown",
                PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (True, 12, HelpIds.getHelpIdString(HID + 6),
                "lstPrivOfficialStyle", 180, 86, 1, 6, 74), self)
        self.lstPrivateStyle = self.insertListBox(
            "lstPrivateStyle",
            LetterWizardDialogConst.LSTPRIVATESTYLE_ACTION_PERFORMED,
            LetterWizardDialogConst.LSTPRIVATESTYLE_ITEM_CHANGED,
            ("Dropdown",
                PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (True, 12, HelpIds.getHelpIdString(HID + 7),
                "lstPrivateStyle", 180, 118, 1, 7, 74), self)
        self.insertLabel("lblBusinessStyle",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblBusinessStyle_value,
                "lblBusinessStyle", 110, 42, 1, 48, 60))
        self.insertLabel("lblPrivOfficialStyle",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblPrivOfficialStyle_value,
                "lblPrivOfficialStyle", 110, 88, 1, 49, 60))
        self.insertLabel("lblTitle1",
            ("FontDescriptor",
                PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (self.fontDescriptor6, 16,
                self.resources.reslblTitle1_value, True,
                "lblTitle1", 91, 8, 1, 55, 212))
        self.insertLabel("lblPrivateStyle",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblPrivateStyle_value,
                "lblPrivateStyle", 110, 120, 1, 74, 60))
        self.insertLabel("lblIntroduction",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (39, self.resources.reslblIntroduction_value,
                True,
                "lblIntroduction", 104, 145, 1, 80, 199))
        self.ImageControl3 = self.insertInfoImage(92, 145, 1)

    def buildStep2(self):
        self.chkPaperCompanyLogo = self.insertCheckBox(
            "chkPaperCompanyLogo",
            LetterWizardDialogConst.CHKPAPERCOMPANYLOGO_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 8),
                self.resources.reschkPaperCompanyLogo_value,
                "chkPaperCompanyLogo", 97, 28, 0, 2, 8, 68), self)
        self.numLogoHeight = self.insertNumericField(
            "numLogoHeight",
            LetterWizardDialogConst.NUMLOGOHEIGHT_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                "Spin",
                PropertyNames.PROPERTY_STEP,
                "StrictFormat",
                PropertyNames.PROPERTY_TABINDEX,
                "Value",
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 9),
                "numLogoHeight", 138, 40, True, 2, True, 9, 3, 50), self)
        self.numLogoX = self.insertNumericField(
            "numLogoX",
            LetterWizardDialogConst.NUMLOGOX_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                "Spin",
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                "Value",
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 10),
            "numLogoX", 286, 40, True, 2, 10, 0, 50), self)
        self.numLogoWidth = self.insertNumericField(
            "numLogoWidth",
            LetterWizardDialogConst.NUMLOGOWIDTH_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                "Spin",
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                "Value",
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 11),
                "numLogoWidth", 138, 56, True, 2, 11, 3.8, 50), self)
        self.numLogoY = self.insertNumericField(
            "numLogoY",
            LetterWizardDialogConst.NUMLOGOY_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                "Spin",
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                "Value",
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 12),
                "numLogoY", 286, 56, True, 2, 12, -3.4, 50), self)
        self.chkPaperCompanyAddress = self.insertCheckBox(
            "chkPaperCompanyAddress",
            LetterWizardDialogConst.CHKPAPERCOMPANYADDRESS_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 13),
                self.resources.reschkPaperCompanyAddress_value,
                "chkPaperCompanyAddress", 98, 84, 0, 2, 13, 68), self)
        self.numAddressHeight = self.insertNumericField(
                "numAddressHeight",
                LetterWizardDialogConst.NUMADDRESSHEIGHT_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                "Spin",
                PropertyNames.PROPERTY_STEP,
                "StrictFormat",
                PropertyNames.PROPERTY_TABINDEX,
                "Value",
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 14),
                "numAddressHeight", 138, 96, True, 2, True, 14, 3, 50), self)
        self.numAddressX = self.insertNumericField(
                "numAddressX",
                LetterWizardDialogConst.NUMADDRESSX_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                "Spin",
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                "Value",
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 15),
                "numAddressX", 286, 96, True, 2, 15, 3.8, 50), self)
        self.numAddressWidth = self.insertNumericField(
                "numAddressWidth",
                LetterWizardDialogConst.NUMADDRESSWIDTH_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                "Spin",
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                "Value",
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 16),
                "numAddressWidth", 138, 112, True, 2, 16, 13.8, 50), self)
        self.numAddressY = self.insertNumericField(
                "numAddressY",
                LetterWizardDialogConst.NUMADDRESSY_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                "Spin",
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                "Value",
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 17),
                "numAddressY", 286, 112, True, 2, 17, -3.4, 50), self)
        self.chkCompanyReceiver = self.insertCheckBox(
            "chkCompanyReceiver",
            LetterWizardDialogConst.CHKCOMPANYRECEIVER_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 18),
                self.resources.reschkCompanyReceiver_value,
                "chkCompanyReceiver", 103, 131, 0, 2, 18, 185), self)
        self.chkPaperFooter = self.insertCheckBox(
            "chkPaperFooter",
            LetterWizardDialogConst.CHKPAPERFOOTER_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 19),
                self.resources.reschkPaperFooter_value,
                "chkPaperFooter", 97, 158, 0, 2, 19, 68), self)
        self.numFooterHeight = self.insertNumericField(
            "numFooterHeight",
            LetterWizardDialogConst.NUMFOOTERHEIGHT_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                "Spin",
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                "Value",
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 20),
                "numFooterHeight", 236, 156, True, 2, 20, 5, 50), self)
        self.insertLabel("lblLogoHeight",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblLogoHeight_value,
                "lblLogoHeight", 103, 42, 2, 68, 32))
        self.insertLabel("lblLogoWidth",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblLogoWidth_value,
                "lblLogoWidth", 103, 58, 2, 69, 32))
        self.insertFixedLine(
            "FixedLine5",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (2,
                "FixedLine5", 90, 78, 2, 70, 255))
        self.insertFixedLine(
            "FixedLine6",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (2,
                "FixedLine6", 90, 150, 2, 71, 255))
        self.insertLabel("lblFooterHeight",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblFooterHeight_value,
                "lblFooterHeight", 200, 158, 2, 72, 32))
        self.insertLabel("lblLogoX",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblLogoX_value,
                "lblLogoX", 190, 42, 2, 84, 94))
        self.insertLabel("lblLogoY",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblLogoY_value,
                "lblLogoY", 190, 58, 2, 85, 94))
        self.insertLabel("lblAddressHeight",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblAddressHeight_value,
                "lblAddressHeight", 103, 98, 2, 86, 32))
        self.insertLabel("lblAddressWidth",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblAddressWidth_value,
                "lblAddressWidth", 103, 114, 2, 87, 32))
        self.insertLabel("lblAddressX",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblAddressX_value,
                "lblAddressX", 190, 98, 2, 88, 94))
        self.insertLabel("lblAddressY",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblAddressY_value,
                "lblAddressY", 190, 114, 2, 89, 94))
        self.insertLabel("lblTitle2",
            ("FontDescriptor",
                PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (self.fontDescriptor6, 16,
                self.resources.reslblTitle2_value, True,
                "lblTitle2", 91, 8, 2, 91, 212))

    def buildStep3(self):
        self.chkUseLogo = self.insertCheckBox(
            "chkUseLogo",
            LetterWizardDialogConst.CHKUSELOGO_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 22),
                self.resources.reschkUseLogo_value,
                "chkUseLogo", 97, 34, 0, 3, 22, 212), self)
        self.chkUseAddressReceiver = self.insertCheckBox(
            "chkUseAddressReceiver",
            LetterWizardDialogConst.CHKUSEADDRESSRECEIVER_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 23),
                self.resources.reschkUseAddressReceiver_value,
                "chkUseAddressReceiver", 97, 49, 0, 3, 23, 212), self)
        self.chkUseSigns = self.insertCheckBox(
            "chkUseSigns",
            LetterWizardDialogConst.CHKUSESIGNS_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 24),
                self.resources.reschkUseSigns_value,
                "chkUseSigns", 97, 62, 0, 3, 24, 212), self)
        self.chkUseSubject = self.insertCheckBox(
            "chkUseSubject",
            LetterWizardDialogConst.CHKUSESUBJECT_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 25),
                self.resources.reschkUseSubject_value,
                "chkUseSubject", 97, 78, 0, 3, 25, 212), self)
        self.chkUseSalutation = self.insertCheckBox(
            "chkUseSalutation",
            LetterWizardDialogConst.CHKUSESALUTATION_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 26),
                self.resources.reschkUseSalutation_value,
                "chkUseSalutation", 97, 93, 0, 3, 26, 66), self)
        self.lstSalutation = self.insertComboBox(
            "lstSalutation",
            LetterWizardDialogConst.LSTSALUTATION_ACTION_PERFORMED,
            LetterWizardDialogConst.LSTSALUTATION_ITEM_CHANGED,
            LetterWizardDialogConst.LSTSALUTATION_TEXT_CHANGED,
            ("Dropdown",
                PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (True, 12, HelpIds.getHelpIdString(HID + 27),
                "lstSalutation", 210, 90, 3, 27, 74), self)
        self.chkUseBendMarks = self.insertCheckBox(
            "chkUseBendMarks",
            LetterWizardDialogConst.CHKUSEBENDMARKS_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 28),
                self.resources.reschkUseBendMarks_value,
                "chkUseBendMarks", 97, 107, 0, 3, 28, 212), self)
        self.chkUseGreeting = self.insertCheckBox(
            "chkUseGreeting",
            LetterWizardDialogConst.CHKUSEGREETING_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 29),
                self.resources.reschkUseGreeting_value,
                "chkUseGreeting", 97, 122, 0, 3, 29, 66), self)
        self.lstGreeting = self.insertComboBox(
            "lstGreeting",
            LetterWizardDialogConst.LSTGREETING_ACTION_PERFORMED,
            LetterWizardDialogConst.LSTGREETING_ITEM_CHANGED,
            LetterWizardDialogConst.LSTGREETING_TEXT_CHANGED,
            ("Dropdown",
                PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (True, 12, HelpIds.getHelpIdString(HID + 30),
                "lstGreeting", 210, 121, 3, 30, 74), self)
        self.chkUseFooter = self.insertCheckBox(
            "chkUseFooter",
            LetterWizardDialogConst.CHKUSEFOOTER_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 31),
                self.resources.reschkUseFooter_value,
                "chkUseFooter", 97, 138, 0, 3, 31, 212), self)
        self.insertLabel("lblTitle3",
            (
            "FontDescriptor", PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (self.fontDescriptor6, 16,
                self.resources.reslblTitle3_value, True,
                "lblTitle3", 91, 8, 3, 90, 212))

    def buildStep4(self):
        self.optSenderPlaceholder = self.insertRadioButton(
            "optSenderPlaceholder",
            LetterWizardDialogConst.OPTSENDERPLACEHOLDER_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 32),
                self.resources.resoptSenderPlaceholder_value,
                "optSenderPlaceholder", 104, 42, 4, 32, 149), self)
        self.optSenderDefine = self.insertRadioButton(
            "optSenderDefine",
            LetterWizardDialogConst.OPTSENDERDEFINE_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 33),
                self.resources.resoptSenderDefine_value,
                "optSenderDefine", 104, 54, 4, 33, 149), self)
        self.txtSenderName = self.insertTextField(
            "txtSenderName",
            LetterWizardDialogConst.TXTSENDERNAME_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 34),
                "txtSenderName", 182, 67, 4, 34, 119), self)
        self.txtSenderStreet = self.insertTextField(
            "txtSenderStreet",
            LetterWizardDialogConst.TXTSENDERSTREET_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 35),
                "txtSenderStreet", 182, 81, 4, 35, 119), self)
        self.txtSenderPostCode = self.insertTextField(
            "txtSenderPostCode",
            LetterWizardDialogConst.TXTSENDERPOSTCODE_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 36),
                "txtSenderPostCode", 182, 95, 4, 36, 25), self)
        self.txtSenderState = self.insertTextField(
            "txtSenderState",
            LetterWizardDialogConst.TXTSENDERSTATE_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 37),
                "txtSenderState", 211, 95, 4, 37, 21), self)
        self.txtSenderCity = self.insertTextField(
            "txtSenderCity",
            LetterWizardDialogConst.TXTSENDERCITY_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 38),
                "txtSenderCity", 236, 95, 4, 38, 65), self)
        self.optReceiverPlaceholder = self.insertRadioButton(
            "optReceiverPlaceholder",
            LetterWizardDialogConst.OPTRECEIVERPLACEHOLDER_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 39),
                self.resources.resoptReceiverPlaceholder_value,
                "optReceiverPlaceholder", 104, 145, 4, 39, 200), self)
        self.optReceiverDatabase = self.insertRadioButton(
            "optReceiverDatabase",
            LetterWizardDialogConst.OPTRECEIVERDATABASE_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 40),
                self.resources.resoptReceiverDatabase_value,
                "optReceiverDatabase", 104, 157, 4, 40, 200), self)
        self.insertLabel("lblSenderAddress",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblSenderAddress_value,
                "lblSenderAddress", 97, 28, 4, 64, 136))
        self.insertFixedLine("FixedLine2",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (5,
                "FixedLine2", 90, 126, 4, 75, 212))
        self.insertLabel("lblReceiverAddress",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblReceiverAddress_value,
                "lblReceiverAddress", 97, 134, 4, 76, 136))
        self.insertLabel("lblSenderName",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblSenderName_value,
                "lblSenderName", 113, 69, 4, 77, 68))
        self.insertLabel("lblSenderStreet",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblSenderStreet_value,
                "lblSenderStreet", 113, 82, 4, 78, 68))
        self.insertLabel("lblPostCodeCity",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblPostCodeCity_value,
                "lblPostCodeCity", 113, 97, 4, 79, 68))
        self.insertLabel("lblTitle4",
            ("FontDescriptor", PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (self.fontDescriptor6, 16,
                self.resources.reslblTitle4_value, True,
                "lblTitle4", 91, 8, 4, 92, 212))

    def buildStep5(self):
        self.txtFooter = self.insertTextField(
            "txtFooter",
            LetterWizardDialogConst.TXTFOOTER_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (47, HelpIds.getHelpIdString(HID + 41), True,
                "txtFooter", 97, 40, 5, 41, 203), self)
        self.chkFooterNextPages = self.insertCheckBox(
            "chkFooterNextPages",
            LetterWizardDialogConst.CHKFOOTERNEXTPAGES_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 42),
                self.resources.reschkFooterNextPages_value,
                "chkFooterNextPages", 97, 92, 0, 5, 42, 202), self)
        self.chkFooterPageNumbers = self.insertCheckBox(
            "chkFooterPageNumbers",
            LetterWizardDialogConst.CHKFOOTERPAGENUMBERS_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STATE,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 43),
                self.resources.reschkFooterPageNumbers_value,
                "chkFooterPageNumbers", 97, 106, 0, 5, 43, 201), self)
        self.insertLabel("lblFooter",
            ("FontDescriptor", PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (self.fontDescriptor5, 8, self.resources.reslblFooter_value,
                "lblFooter", 97, 28, 5, 52, 116))
        self.insertLabel("lblTitle5",
            ("FontDescriptor", PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (self.fontDescriptor6, 16,
                self.resources.reslblTitle5_value, True,
                "lblTitle5", 91, 8, 5, 93, 212))

    def buildStep6(self):
        self.txtTemplateName = self.insertTextField(
            "txtTemplateName",
            LetterWizardDialogConst.TXTTEMPLATENAME_TEXT_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                "Text",
                PropertyNames.PROPERTY_WIDTH),
            (12, HelpIds.getHelpIdString(HID + 44),
                "txtTemplateName", 202, 56, 6, 44,
                self.resources.restxtTemplateName_value, 100), self)
        self.optCreateLetter = self.insertRadioButton(
            "optCreateLetter",
            LetterWizardDialogConst.OPTCREATELETTER_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 45),
                self.resources.resoptCreateLetter_value,
                "optCreateLetter", 104, 111, 6, 50, 198), self)
        self.optMakeChanges = self.insertRadioButton(
            "optMakeChanges",
            LetterWizardDialogConst.OPTMAKECHANGES_ITEM_CHANGED,
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_HELPURL,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, HelpIds.getHelpIdString(HID + 46),
                self.resources.resoptMakeChanges_value,
                "optMakeChanges", 104, 123, 6, 51, 198), self)
        self.insertLabel("lblFinalExplanation1",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (26, self.resources.reslblFinalExplanation1_value, True,
                "lblFinalExplanation1", 97, 28, 6, 52, 205))
        self.insertLabel("lblProceed",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblProceed_value,
                "lblProceed", 97, 100, 6, 53, 204))
        self.insertLabel("lblFinalExplanation2",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (33, self.resources.reslblFinalExplanation2_value, True,
                "lblFinalExplanation2", 104, 145, 6, 54, 199))
        self.insertImage(
            "ImageControl2",
            ("Border", PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_IMAGEURL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                "ScaleImage",
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (0, 10,
                "private:resource/dbu/image/19205",
                "ImageControl2", 92, 145,  False, 6, 66, 10))
        self.insertLabel("lblTemplateName",
            (PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (8, self.resources.reslblTemplateName_value,
                "lblTemplateName", 97, 58, 6, 82, 101))
        self.insertLabel("lblTitle6",
            ("FontDescriptor", PropertyNames.PROPERTY_HEIGHT,
                PropertyNames.PROPERTY_LABEL,
                PropertyNames.PROPERTY_MULTILINE,
                PropertyNames.PROPERTY_NAME,
                PropertyNames.PROPERTY_POSITION_X,
                PropertyNames.PROPERTY_POSITION_Y,
                PropertyNames.PROPERTY_STEP,
                PropertyNames.PROPERTY_TABINDEX,
                PropertyNames.PROPERTY_WIDTH),
            (self.fontDescriptor6, 16,
                self.resources.reslblTitle6_value, True,
                "lblTitle6", 91, 8, 6, 94, 212))
