; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+c -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=NOSFB %s
; RUN: llc -mtriple=riscv64 -mcpu=sifive-u74 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=SFB %s

; The sifive-7-series can predicate a mv.

define signext i32 @test1(i32 signext %x, i32 signext %y, i32 signext %z) {
; NOSFB-LABEL: test1:
; NOSFB:       # %bb.0:
; NOSFB-NEXT:    beqz a2, .LBB0_2
; NOSFB-NEXT:  # %bb.1:
; NOSFB-NEXT:    mv a0, a1
; NOSFB-NEXT:  .LBB0_2:
; NOSFB-NEXT:    ret
;
; SFB-LABEL: test1:
; SFB:       # %bb.0:
; SFB-NEXT:    beqz a2, .LBB0_2
; SFB-NEXT:  # %bb.1:
; SFB-NEXT:    mv a0, a1
; SFB-NEXT:  .LBB0_2:
; SFB-NEXT:    ret
  %c = icmp eq i32 %z, 0
  %b = select i1 %c, i32 %x, i32 %y
  ret i32 %b
}

; Same as above with select operands swapped.
define signext i32 @test2(i32 signext %x, i32 signext %y, i32 signext %z) {
; NOSFB-LABEL: test2:
; NOSFB:       # %bb.0:
; NOSFB-NEXT:    beqz a2, .LBB1_2
; NOSFB-NEXT:  # %bb.1:
; NOSFB-NEXT:    mv a1, a0
; NOSFB-NEXT:  .LBB1_2:
; NOSFB-NEXT:    mv a0, a1
; NOSFB-NEXT:    ret
;
; SFB-LABEL: test2:
; SFB:       # %bb.0:
; SFB-NEXT:    bnez a2, .LBB1_2
; SFB-NEXT:  # %bb.1:
; SFB-NEXT:    mv a0, a1
; SFB-NEXT:  .LBB1_2:
; SFB-NEXT:    ret
  %c = icmp eq i32 %z, 0
  %b = select i1 %c, i32 %y, i32 %x
  ret i32 %b
}

; Make sure we don't share the same basic block for two selects with the same
; condition this would break the predication.
define signext i32 @test3(i32 signext %v, i32 signext %w, i32 signext %x, i32 signext %y, i32 signext %z) {
; NOSFB-LABEL: test3:
; NOSFB:       # %bb.0:
; NOSFB-NEXT:    beqz a4, .LBB2_2
; NOSFB-NEXT:  # %bb.1:
; NOSFB-NEXT:    mv a1, a0
; NOSFB-NEXT:    mv a2, a3
; NOSFB-NEXT:  .LBB2_2:
; NOSFB-NEXT:    addw a0, a1, a2
; NOSFB-NEXT:    ret
;
; SFB-LABEL: test3:
; SFB:       # %bb.0:
; SFB-NEXT:    bnez a4, .LBB2_2
; SFB-NEXT:  # %bb.1:
; SFB-NEXT:    mv a0, a1
; SFB-NEXT:  .LBB2_2:
; SFB-NEXT:    beqz a4, .LBB2_4
; SFB-NEXT:  # %bb.3:
; SFB-NEXT:    mv a2, a3
; SFB-NEXT:  .LBB2_4:
; SFB-NEXT:    addw a0, a0, a2
; SFB-NEXT:    ret
  %c = icmp eq i32 %z, 0
  %a = select i1 %c, i32 %w, i32 %v
  %b = select i1 %c, i32 %x, i32 %y
  %d = add i32 %a, %b
  ret i32 %d
}

; Test with false value 0.
define signext i32 @test4(i32 signext %x, i32 signext %z) {
; NOSFB-LABEL: test4:
; NOSFB:       # %bb.0:
; NOSFB-NEXT:    snez a1, a1
; NOSFB-NEXT:    addi a1, a1, -1
; NOSFB-NEXT:    and a0, a0, a1
; NOSFB-NEXT:    ret
;
; SFB-LABEL: test4:
; SFB:       # %bb.0:
; SFB-NEXT:    beqz a1, .LBB3_2
; SFB-NEXT:  # %bb.1:
; SFB-NEXT:    li a0, 0
; SFB-NEXT:  .LBB3_2:
; SFB-NEXT:    ret
  %c = icmp eq i32 %z, 0
  %b = select i1 %c, i32 %x, i32 0
  ret i32 %b
}

; Same as above with select operands swapped.
define signext i32 @test5(i32 signext %x, i32 signext %z) {
; NOSFB-LABEL: test5:
; NOSFB:       # %bb.0:
; NOSFB-NEXT:    seqz a1, a1
; NOSFB-NEXT:    addi a1, a1, -1
; NOSFB-NEXT:    and a0, a0, a1
; NOSFB-NEXT:    ret
;
; SFB-LABEL: test5:
; SFB:       # %bb.0:
; SFB-NEXT:    bnez a1, .LBB4_2
; SFB-NEXT:  # %bb.1:
; SFB-NEXT:    li a0, 0
; SFB-NEXT:  .LBB4_2:
; SFB-NEXT:    ret
  %c = icmp eq i32 %z, 0
  %b = select i1 %c, i32 0, i32 %x
  ret i32 %b
}

; Test with false value -1.
define signext i32 @test6(i32 signext %x, i32 signext %z) {
; NOSFB-LABEL: test6:
; NOSFB:       # %bb.0:
; NOSFB-NEXT:    seqz a1, a1
; NOSFB-NEXT:    addi a1, a1, -1
; NOSFB-NEXT:    or a0, a0, a1
; NOSFB-NEXT:    ret
;
; SFB-LABEL: test6:
; SFB:       # %bb.0:
; SFB-NEXT:    li a2, -1
; SFB-NEXT:    beqz a1, .LBB5_2
; SFB-NEXT:  # %bb.1:
; SFB-NEXT:    mv a0, a2
; SFB-NEXT:  .LBB5_2:
; SFB-NEXT:    ret
  %c = icmp eq i32 %z, 0
  %b = select i1 %c, i32 %x, i32 -1
  ret i32 %b
}

; Same as above with select operands swapped.
define signext i32 @test7(i32 signext %x, i32 signext %z) {
; NOSFB-LABEL: test7:
; NOSFB:       # %bb.0:
; NOSFB-NEXT:    snez a1, a1
; NOSFB-NEXT:    addi a1, a1, -1
; NOSFB-NEXT:    or a0, a0, a1
; NOSFB-NEXT:    ret
;
; SFB-LABEL: test7:
; SFB:       # %bb.0:
; SFB-NEXT:    li a2, -1
; SFB-NEXT:    bnez a1, .LBB6_2
; SFB-NEXT:  # %bb.1:
; SFB-NEXT:    mv a0, a2
; SFB-NEXT:  .LBB6_2:
; SFB-NEXT:    ret
  %c = icmp eq i32 %z, 0
  %b = select i1 %c, i32 -1, i32 %x
  ret i32 %b
}

define i16 @select_xor_1(i16 %A, i8 %cond) {
; NOSFB-LABEL: select_xor_1:
; NOSFB:       # %bb.0: # %entry
; NOSFB-NEXT:    slli a1, a1, 63
; NOSFB-NEXT:    srai a1, a1, 63
; NOSFB-NEXT:    andi a1, a1, 43
; NOSFB-NEXT:    xor a0, a0, a1
; NOSFB-NEXT:    ret
;
; SFB-LABEL: select_xor_1:
; SFB:       # %bb.0: # %entry
; SFB-NEXT:    andi a1, a1, 1
; SFB-NEXT:    xori a2, a0, 43
; SFB-NEXT:    beqz a1, .LBB7_2
; SFB-NEXT:  # %bb.1: # %entry
; SFB-NEXT:    mv a0, a2
; SFB-NEXT:  .LBB7_2: # %entry
; SFB-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = xor i16 %A, 43
 %1 = select i1 %cmp10, i16 %A, i16 %0
 ret i16 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i16 @select_xor_1b(i16 %A, i8 %cond) {
; NOSFB-LABEL: select_xor_1b:
; NOSFB:       # %bb.0: # %entry
; NOSFB-NEXT:    slli a1, a1, 63
; NOSFB-NEXT:    srai a1, a1, 63
; NOSFB-NEXT:    andi a1, a1, 43
; NOSFB-NEXT:    xor a0, a0, a1
; NOSFB-NEXT:    ret
;
; SFB-LABEL: select_xor_1b:
; SFB:       # %bb.0: # %entry
; SFB-NEXT:    andi a1, a1, 1
; SFB-NEXT:    xori a2, a0, 43
; SFB-NEXT:    beqz a1, .LBB8_2
; SFB-NEXT:  # %bb.1: # %entry
; SFB-NEXT:    mv a0, a2
; SFB-NEXT:  .LBB8_2: # %entry
; SFB-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = xor i16 %A, 43
 %1 = select i1 %cmp10, i16 %A, i16 %0
 ret i16 %1
}

define i32 @select_xor_2(i32 %A, i32 %B, i8 %cond) {
; NOSFB-LABEL: select_xor_2:
; NOSFB:       # %bb.0: # %entry
; NOSFB-NEXT:    slli a2, a2, 63
; NOSFB-NEXT:    srai a2, a2, 63
; NOSFB-NEXT:    and a1, a1, a2
; NOSFB-NEXT:    xor a0, a0, a1
; NOSFB-NEXT:    ret
;
; SFB-LABEL: select_xor_2:
; SFB:       # %bb.0: # %entry
; SFB-NEXT:    andi a2, a2, 1
; SFB-NEXT:    beqz a2, .LBB9_2
; SFB-NEXT:  # %bb.1: # %entry
; SFB-NEXT:    xor a0, a0, a1
; SFB-NEXT:  .LBB9_2: # %entry
; SFB-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = xor i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_xor_2b(i32 %A, i32 %B, i8 %cond) {
; NOSFB-LABEL: select_xor_2b:
; NOSFB:       # %bb.0: # %entry
; NOSFB-NEXT:    slli a2, a2, 63
; NOSFB-NEXT:    srai a2, a2, 63
; NOSFB-NEXT:    and a1, a1, a2
; NOSFB-NEXT:    xor a0, a0, a1
; NOSFB-NEXT:    ret
;
; SFB-LABEL: select_xor_2b:
; SFB:       # %bb.0: # %entry
; SFB-NEXT:    andi a2, a2, 1
; SFB-NEXT:    beqz a2, .LBB10_2
; SFB-NEXT:  # %bb.1: # %entry
; SFB-NEXT:    xor a0, a0, a1
; SFB-NEXT:  .LBB10_2: # %entry
; SFB-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = xor i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

define i32 @select_or(i32 %A, i32 %B, i8 %cond) {
; NOSFB-LABEL: select_or:
; NOSFB:       # %bb.0: # %entry
; NOSFB-NEXT:    slli a2, a2, 63
; NOSFB-NEXT:    srai a2, a2, 63
; NOSFB-NEXT:    and a1, a1, a2
; NOSFB-NEXT:    or a0, a0, a1
; NOSFB-NEXT:    ret
;
; SFB-LABEL: select_or:
; SFB:       # %bb.0: # %entry
; SFB-NEXT:    andi a2, a2, 1
; SFB-NEXT:    beqz a2, .LBB11_2
; SFB-NEXT:  # %bb.1: # %entry
; SFB-NEXT:    or a0, a0, a1
; SFB-NEXT:  .LBB11_2: # %entry
; SFB-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_or_b(i32 %A, i32 %B, i8 %cond) {
; NOSFB-LABEL: select_or_b:
; NOSFB:       # %bb.0: # %entry
; NOSFB-NEXT:    slli a2, a2, 63
; NOSFB-NEXT:    srai a2, a2, 63
; NOSFB-NEXT:    and a1, a1, a2
; NOSFB-NEXT:    or a0, a0, a1
; NOSFB-NEXT:    ret
;
; SFB-LABEL: select_or_b:
; SFB:       # %bb.0: # %entry
; SFB-NEXT:    andi a2, a2, 1
; SFB-NEXT:    beqz a2, .LBB12_2
; SFB-NEXT:  # %bb.1: # %entry
; SFB-NEXT:    or a0, a0, a1
; SFB-NEXT:  .LBB12_2: # %entry
; SFB-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

define i32 @select_or_1(i32 %A, i32 %B, i32 %cond) {
; NOSFB-LABEL: select_or_1:
; NOSFB:       # %bb.0: # %entry
; NOSFB-NEXT:    slli a2, a2, 63
; NOSFB-NEXT:    srai a2, a2, 63
; NOSFB-NEXT:    and a1, a1, a2
; NOSFB-NEXT:    or a0, a0, a1
; NOSFB-NEXT:    ret
;
; SFB-LABEL: select_or_1:
; SFB:       # %bb.0: # %entry
; SFB-NEXT:    andi a2, a2, 1
; SFB-NEXT:    beqz a2, .LBB13_2
; SFB-NEXT:  # %bb.1: # %entry
; SFB-NEXT:    or a0, a0, a1
; SFB-NEXT:  .LBB13_2: # %entry
; SFB-NEXT:    ret
entry:
 %and = and i32 %cond, 1
 %cmp10 = icmp eq i32 %and, 0
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_or_1b(i32 %A, i32 %B, i32 %cond) {
; NOSFB-LABEL: select_or_1b:
; NOSFB:       # %bb.0: # %entry
; NOSFB-NEXT:    slli a2, a2, 63
; NOSFB-NEXT:    srai a2, a2, 63
; NOSFB-NEXT:    and a1, a1, a2
; NOSFB-NEXT:    or a0, a0, a1
; NOSFB-NEXT:    ret
;
; SFB-LABEL: select_or_1b:
; SFB:       # %bb.0: # %entry
; SFB-NEXT:    andi a2, a2, 1
; SFB-NEXT:    beqz a2, .LBB14_2
; SFB-NEXT:  # %bb.1: # %entry
; SFB-NEXT:    or a0, a0, a1
; SFB-NEXT:  .LBB14_2: # %entry
; SFB-NEXT:    ret
entry:
 %and = and i32 %cond, 1
 %cmp10 = icmp ne i32 %and, 1
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

define void @sextw_removal_ccor(i1 %c, i32 signext %arg, i32 signext %arg1, i32 signext %arg2) nounwind {
; NOSFB-LABEL: sextw_removal_ccor:
; NOSFB:       # %bb.0: # %bb
; NOSFB-NEXT:    addi sp, sp, -32
; NOSFB-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; NOSFB-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; NOSFB-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; NOSFB-NEXT:    mv s0, a2
; NOSFB-NEXT:    slli a0, a0, 63
; NOSFB-NEXT:    srai a0, a0, 63
; NOSFB-NEXT:    and a0, a0, a1
; NOSFB-NEXT:    or s1, a0, a3
; NOSFB-NEXT:  .LBB15_1: # %bb2
; NOSFB-NEXT:    # =>This Inner Loop Header: Depth=1
; NOSFB-NEXT:    mv a0, s1
; NOSFB-NEXT:    call bar@plt
; NOSFB-NEXT:    sllw s1, s1, s0
; NOSFB-NEXT:    bnez a0, .LBB15_1
; NOSFB-NEXT:  # %bb.2: # %bb7
; NOSFB-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; NOSFB-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; NOSFB-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; NOSFB-NEXT:    addi sp, sp, 32
; NOSFB-NEXT:    ret
;
; SFB-LABEL: sextw_removal_ccor:
; SFB:       # %bb.0: # %bb
; SFB-NEXT:    addi sp, sp, -32
; SFB-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; SFB-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; SFB-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; SFB-NEXT:    mv s0, a3
; SFB-NEXT:    andi a0, a0, 1
; SFB-NEXT:    mv s1, a2
; SFB-NEXT:    beqz a0, .LBB15_4
; SFB-NEXT:  # %bb.3: # %bb
; SFB-NEXT:    or s0, a3, a1
; SFB-NEXT:  .LBB15_4: # %bb
; SFB-NEXT:  .LBB15_1: # %bb2
; SFB-NEXT:    # =>This Inner Loop Header: Depth=1
; SFB-NEXT:    mv a0, s0
; SFB-NEXT:    call bar@plt
; SFB-NEXT:    sllw s0, s0, s1
; SFB-NEXT:    bnez a0, .LBB15_1
; SFB-NEXT:  # %bb.2: # %bb7
; SFB-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; SFB-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; SFB-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; SFB-NEXT:    addi sp, sp, 32
; SFB-NEXT:    ret
bb:
  %sel = select i1 %c, i32 %arg, i32 0
  %or = or i32 %sel, %arg2
  br label %bb2

bb2:                                              ; preds = %bb2, %bb
  %i3 = phi i32 [ %or, %bb ], [ %i5, %bb2 ]
  %i4 = tail call signext i32 @bar(i32 signext %i3)
  %i5 = shl i32 %i3, %arg1
  %i6 = icmp eq i32 %i4, 0
  br i1 %i6, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  ret void
}
declare signext i32 @bar(i32 signext)

define void @sextw_removal_ccaddw(i1 %c, i32 signext %arg, i32 signext %arg1, i32 %arg2) nounwind {
; NOSFB-LABEL: sextw_removal_ccaddw:
; NOSFB:       # %bb.0: # %bb
; NOSFB-NEXT:    addi sp, sp, -32
; NOSFB-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; NOSFB-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; NOSFB-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; NOSFB-NEXT:    mv s0, a2
; NOSFB-NEXT:    slli a0, a0, 63
; NOSFB-NEXT:    srai a0, a0, 63
; NOSFB-NEXT:    and a0, a0, a3
; NOSFB-NEXT:    addw s1, a0, a1
; NOSFB-NEXT:  .LBB16_1: # %bb2
; NOSFB-NEXT:    # =>This Inner Loop Header: Depth=1
; NOSFB-NEXT:    mv a0, s1
; NOSFB-NEXT:    call bar@plt
; NOSFB-NEXT:    sllw s1, s1, s0
; NOSFB-NEXT:    bnez a0, .LBB16_1
; NOSFB-NEXT:  # %bb.2: # %bb7
; NOSFB-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; NOSFB-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; NOSFB-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; NOSFB-NEXT:    addi sp, sp, 32
; NOSFB-NEXT:    ret
;
; SFB-LABEL: sextw_removal_ccaddw:
; SFB:       # %bb.0: # %bb
; SFB-NEXT:    addi sp, sp, -32
; SFB-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; SFB-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; SFB-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; SFB-NEXT:    mv s0, a1
; SFB-NEXT:    andi a0, a0, 1
; SFB-NEXT:    mv s1, a2
; SFB-NEXT:    beqz a0, .LBB16_4
; SFB-NEXT:  # %bb.3: # %bb
; SFB-NEXT:    addw s0, a1, a3
; SFB-NEXT:  .LBB16_4: # %bb
; SFB-NEXT:  .LBB16_1: # %bb2
; SFB-NEXT:    # =>This Inner Loop Header: Depth=1
; SFB-NEXT:    mv a0, s0
; SFB-NEXT:    call bar@plt
; SFB-NEXT:    sllw s0, s0, s1
; SFB-NEXT:    bnez a0, .LBB16_1
; SFB-NEXT:  # %bb.2: # %bb7
; SFB-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; SFB-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; SFB-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; SFB-NEXT:    addi sp, sp, 32
; SFB-NEXT:    ret
bb:
  %sel = select i1 %c, i32 %arg2, i32 0
  %or = add i32 %sel, %arg
  br label %bb2

bb2:                                              ; preds = %bb2, %bb
  %i3 = phi i32 [ %or, %bb ], [ %i5, %bb2 ]
  %i4 = tail call signext i32 @bar(i32 signext %i3)
  %i5 = shl i32 %i3, %arg1
  %i6 = icmp eq i32 %i4, 0
  br i1 %i6, label %bb7, label %bb2

bb7:                                              ; preds = %bb2
  ret void
}
