; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+m,+v \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+m,+v \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK,RV64

define <vscale x 3 x i1> @icmp_eq_vv_nxv3i8(<vscale x 3 x i8> %va, <vscale x 3 x i8> %vb) {
; CHECK-LABEL: icmp_eq_vv_nxv3i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmseq.vv v0, v8, v9
; CHECK-NEXT:    ret
  %vc = icmp eq <vscale x 3 x i8> %va, %vb
  ret <vscale x 3 x i1> %vc
}

define <vscale x 3 x i1> @icmp_eq_vx_nxv3i8(<vscale x 3 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_eq_vx_nxv3i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 3 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 3 x i8> %head, <vscale x 3 x i8> poison, <vscale x 3 x i32> zeroinitializer
  %vc = icmp eq <vscale x 3 x i8> %va, %splat
  ret <vscale x 3 x i1> %vc
}

define <vscale x 3 x i1> @icmp_eq_xv_nxv3i8(<vscale x 3 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_eq_xv_nxv3i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 3 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 3 x i8> %head, <vscale x 3 x i8> poison, <vscale x 3 x i32> zeroinitializer
  %vc = icmp eq <vscale x 3 x i8> %splat, %va
  ret <vscale x 3 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: icmp_eq_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vv v0, v8, v9
; CHECK-NEXT:    ret
  %vc = icmp eq <vscale x 8 x i8> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_eq_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_xv_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_eq_xv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vi_nxv8i8_0(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_eq_vi_nxv8i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 0, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vi_nxv8i8_1(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_eq_vi_nxv8i8_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 5, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_iv_nxv8i8_1(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_eq_iv_nxv8i8_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 5, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: icmp_ne_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsne.vv v0, v8, v9
; CHECK-NEXT:    ret
  %vc = icmp ne <vscale x 8 x i8> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_ne_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsne.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ne <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_xv_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_ne_xv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsne.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ne <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_vi_nxv8i8_0(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_ne_vi_nxv8i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 5, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ne <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: icmp_ugt_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v9, v8
; CHECK-NEXT:    ret
  %vc = icmp ugt <vscale x 8 x i8> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_ugt_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ugt <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_xv_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_ugt_xv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ugt <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_vi_nxv8i8_0(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_ugt_vi_nxv8i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 5, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ugt <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: icmp_uge_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v9, v8
; CHECK-NEXT:    ret
  %vc = icmp uge <vscale x 8 x i8> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_uge_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vmsleu.vv v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_xv_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_uge_xv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i8_0(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v9, -16
; CHECK-NEXT:    vmsleu.vv v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 -16, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i8_1(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i8_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 14
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 15, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_iv_nxv8i8_1(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_uge_iv_nxv8i8_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 15, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i8_2(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i8_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmset.m v0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 0, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i8_3(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i8_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 1, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i8_4(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i8_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 -15, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i8_5(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i8_5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 16, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

; Test that we don't optimize uge x, 0 -> ugt x, -1
define <vscale x 8 x i1> @icmp_uge_vi_nxv8i8_6(<vscale x 8 x i8> %va, iXLen %vl) {
; CHECK-LABEL: icmp_uge_vi_nxv8i8_6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v9, v8
; CHECK-NEXT:    ret
  %splat = call <vscale x 8 x i8> @llvm.riscv.vmv.v.x.nxv8i8.iXLen(<vscale x 8 x i8> undef, i8 0, iXLen %vl)
  %vc = icmp uge <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: icmp_ult_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v8, v9
; CHECK-NEXT:    ret
  %vc = icmp ult <vscale x 8 x i8> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_ult_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_xv_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_ult_xv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i8_0(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, -16
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 -16, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i8_1(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i8_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 -15, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_iv_nxv8i8_1(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_ult_iv_nxv8i8_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, -15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 -15, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i8_2(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i8_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmclr.m v0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 0, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i8_3(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i8_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 1, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i8_4(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i8_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 16, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

declare <vscale x 8 x i8> @llvm.riscv.vmv.v.x.nxv8i8.iXLen(<vscale x 8 x i8>, i8, iXLen);

; Test that we don't optimize ult x, 0 -> ule x, -1
define <vscale x 8 x i1> @icmp_ult_vi_nxv8i8_5(<vscale x 8 x i8> %va, iXLen %vl) {
; CHECK-LABEL: icmp_ult_vi_nxv8i8_5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, zero
; CHECK-NEXT:    ret
  %splat = call <vscale x 8 x i8> @llvm.riscv.vmv.v.x.nxv8i8.iXLen(<vscale x 8 x i8> undef, i8 0, iXLen %vl)
  %vc = icmp ult <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: icmp_ule_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v8, v9
; CHECK-NEXT:    ret
  %vc = icmp ule <vscale x 8 x i8> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_ule_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ule <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_xv_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_ule_xv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vmsleu.vv v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ule <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_vi_nxv8i8_0(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_ule_vi_nxv8i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 5, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ule <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: icmp_sgt_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v9, v8
; CHECK-NEXT:    ret
  %vc = icmp sgt <vscale x 8 x i8> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_sgt_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sgt <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_xv_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_sgt_xv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sgt <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_vi_nxv8i8_0(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_sgt_vi_nxv8i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 5, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sgt <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: icmp_sge_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    ret
  %vc = icmp sge <vscale x 8 x i8> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_sge_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_xv_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_sge_xv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i8_0(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v9, -16
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 -16, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i8_1(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i8_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 -15, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_iv_nxv8i8_1(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_sge_iv_nxv8i8_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, -15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 -15, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i8_2(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i8_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -1
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 0, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i8_3(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i8_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 16, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: icmp_slt_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v8, v9
; CHECK-NEXT:    ret
  %vc = icmp slt <vscale x 8 x i8> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_slt_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_xv_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_slt_xv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i8_0(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, -16
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 -16, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i8_1(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i8_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 -15, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_iv_nxv8i8_1(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_slt_iv_nxv8i8_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 -15, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i8_2(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i8_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, -1
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 0, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i8_3(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i8_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 16, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: icmp_sle_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v8, v9
; CHECK-NEXT:    ret
  %vc = icmp sle <vscale x 8 x i8> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_sle_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sle <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_xv_nxv8i8(<vscale x 8 x i8> %va, i8 %b) {
; CHECK-LABEL: icmp_sle_xv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sle <vscale x 8 x i8> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_vi_nxv8i8_0(<vscale x 8 x i8> %va) {
; CHECK-LABEL: icmp_sle_vi_nxv8i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 5, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sle <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vv_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: icmp_eq_vv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmseq.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = icmp eq <vscale x 8 x i16> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vx_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_eq_vx_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_xv_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_eq_xv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vi_nxv8i16_0(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_eq_vi_nxv8i16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 0, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vi_nxv8i16_1(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_eq_vi_nxv8i16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 5, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_iv_nxv8i16_1(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_eq_iv_nxv8i16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 5, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_vv_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: icmp_ne_vv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsne.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = icmp ne <vscale x 8 x i16> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_vx_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_ne_vx_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsne.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ne <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_xv_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_ne_xv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsne.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ne <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_vi_nxv8i16_0(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_ne_vi_nxv8i16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 5, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ne <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_vv_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: icmp_ugt_vv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v10, v8
; CHECK-NEXT:    ret
  %vc = icmp ugt <vscale x 8 x i16> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_vx_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_ugt_vx_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgtu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ugt <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_xv_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_ugt_xv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ugt <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_vi_nxv8i16_0(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_ugt_vi_nxv8i16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 5, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ugt <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vv_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: icmp_uge_vv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v10, v8
; CHECK-NEXT:    ret
  %vc = icmp uge <vscale x 8 x i16> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vx_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_uge_vx_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v10, a0
; CHECK-NEXT:    vmsleu.vv v0, v10, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_xv_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_uge_xv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsleu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i16_0(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v10, -16
; CHECK-NEXT:    vmsleu.vv v0, v10, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 -16, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i16_1(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 14
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 15, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_iv_nxv8i16_1(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_uge_iv_nxv8i16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 15, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i16_2(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmset.m v0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 0, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i16_3(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i16_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 1, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i16_4(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i16_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 -15, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i16_5(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i16_5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 16, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vv_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: icmp_ult_vv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = icmp ult <vscale x 8 x i16> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vx_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_ult_vx_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_xv_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_ult_xv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgtu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i16_0(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, -16
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 -16, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i16_1(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 -15, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_iv_nxv8i16_1(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_ult_iv_nxv8i16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, -15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 -15, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i16_2(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmclr.m v0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 0, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i16_3(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i16_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 1, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i16_4(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i16_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 16, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_vv_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: icmp_ule_vv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = icmp ule <vscale x 8 x i16> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_vx_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_ule_vx_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsleu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ule <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_xv_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_ule_xv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v10, a0
; CHECK-NEXT:    vmsleu.vv v0, v10, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ule <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_vi_nxv8i16_0(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_ule_vi_nxv8i16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 5, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ule <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_vv_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: icmp_sgt_vv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v10, v8
; CHECK-NEXT:    ret
  %vc = icmp sgt <vscale x 8 x i16> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_vx_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_sgt_vx_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sgt <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_xv_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_sgt_xv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sgt <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_vi_nxv8i16_0(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_sgt_vi_nxv8i16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 5, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sgt <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vv_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: icmp_sge_vv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v10, v8
; CHECK-NEXT:    ret
  %vc = icmp sge <vscale x 8 x i16> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vx_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_sge_vx_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v10, a0
; CHECK-NEXT:    vmsle.vv v0, v10, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_xv_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_sge_xv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsle.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i16_0(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v10, -16
; CHECK-NEXT:    vmsle.vv v0, v10, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 -16, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i16_1(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 -15, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_iv_nxv8i16_1(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_sge_iv_nxv8i16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, -15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 -15, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i16_2(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -1
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 0, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i16_3(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i16_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 16, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vv_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: icmp_slt_vv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = icmp slt <vscale x 8 x i16> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vx_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_slt_vx_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_xv_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_slt_xv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i16_0(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, -16
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 -16, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i16_1(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 -15, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_iv_nxv8i16_1(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_slt_iv_nxv8i16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 -15, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i16_2(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, -1
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 0, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i16_3(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i16_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 16, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_vv_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: icmp_sle_vv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = icmp sle <vscale x 8 x i16> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_vx_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_sle_vx_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsle.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sle <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_xv_nxv8i16(<vscale x 8 x i16> %va, i16 %b) {
; CHECK-LABEL: icmp_sle_xv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v10, a0
; CHECK-NEXT:    vmsle.vv v0, v10, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sle <vscale x 8 x i16> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_vi_nxv8i16_0(<vscale x 8 x i16> %va) {
; CHECK-LABEL: icmp_sle_vi_nxv8i16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 5, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sle <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: icmp_eq_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmseq.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = icmp eq <vscale x 8 x i32> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_eq_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_xv_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_eq_xv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vi_nxv8i32_0(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_eq_vi_nxv8i32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 0, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vi_nxv8i32_1(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_eq_vi_nxv8i32_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 5, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_iv_nxv8i32_1(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_eq_iv_nxv8i32_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 5, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: icmp_ne_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsne.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = icmp ne <vscale x 8 x i32> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_ne_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsne.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ne <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_xv_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_ne_xv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsne.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ne <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_vi_nxv8i32_0(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_ne_vi_nxv8i32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 5, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ne <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: icmp_ugt_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = icmp ugt <vscale x 8 x i32> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_ugt_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgtu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ugt <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_xv_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_ugt_xv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ugt <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_vi_nxv8i32_0(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_ugt_vi_nxv8i32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 5, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ugt <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: icmp_uge_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = icmp uge <vscale x 8 x i32> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_uge_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vmsleu.vv v0, v12, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_xv_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_uge_xv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsleu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i32_0(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v12, -16
; CHECK-NEXT:    vmsleu.vv v0, v12, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 -16, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i32_1(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i32_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 14
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 15, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_iv_nxv8i32_1(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_uge_iv_nxv8i32_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 15, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i32_2(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i32_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmset.m v0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 0, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i32_3(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i32_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 1, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i32_4(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i32_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 -15, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i32_5(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i32_5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 16, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: icmp_ult_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = icmp ult <vscale x 8 x i32> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_ult_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_xv_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_ult_xv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgtu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i32_0(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, -16
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 -16, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i32_1(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i32_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 -15, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_iv_nxv8i32_1(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_ult_iv_nxv8i32_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, -15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 -15, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i32_2(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i32_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmclr.m v0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 0, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i32_3(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i32_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 1, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i32_4(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i32_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 16, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: icmp_ule_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = icmp ule <vscale x 8 x i32> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_ule_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsleu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ule <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_xv_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_ule_xv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vmsleu.vv v0, v12, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ule <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_vi_nxv8i32_0(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_ule_vi_nxv8i32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 5, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ule <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: icmp_sgt_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = icmp sgt <vscale x 8 x i32> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_sgt_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sgt <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_xv_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_sgt_xv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sgt <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_vi_nxv8i32_0(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_sgt_vi_nxv8i32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 5, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sgt <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: icmp_sge_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = icmp sge <vscale x 8 x i32> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_sge_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vmsle.vv v0, v12, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_xv_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_sge_xv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i32_0(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v12, -16
; CHECK-NEXT:    vmsle.vv v0, v12, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 -16, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i32_1(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i32_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 -15, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_iv_nxv8i32_1(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_sge_iv_nxv8i32_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, -15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 -15, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i32_2(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i32_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -1
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 0, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i32_3(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i32_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 16, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: icmp_slt_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = icmp slt <vscale x 8 x i32> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_slt_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_xv_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_slt_xv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i32_0(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, -16
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 -16, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i32_1(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i32_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 -15, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_iv_nxv8i32_1(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_slt_iv_nxv8i32_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 -15, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i32_2(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i32_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, -1
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 0, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i32_3(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i32_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 16, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: icmp_sle_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = icmp sle <vscale x 8 x i32> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_sle_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sle <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_xv_nxv8i32(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: icmp_sle_xv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vmsle.vv v0, v12, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sle <vscale x 8 x i32> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_vi_nxv8i32_0(<vscale x 8 x i32> %va) {
; CHECK-LABEL: icmp_sle_vi_nxv8i32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 5, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sle <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb) {
; CHECK-LABEL: icmp_eq_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmseq.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = icmp eq <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_eq_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmseq.vv v0, v8, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_eq_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmseq.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_xv_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_eq_xv_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmseq.vv v0, v16, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_eq_xv_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmseq.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vi_nxv8i64_0(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_eq_vi_nxv8i64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 0, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_vi_nxv8i64_1(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_eq_vi_nxv8i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 5, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_eq_iv_nxv8i64_1(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_eq_iv_nxv8i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 5, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb) {
; CHECK-LABEL: icmp_ne_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsne.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = icmp ne <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_ne_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmsne.vv v0, v8, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ne_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmsne.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ne <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_xv_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_ne_xv_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmsne.vv v0, v16, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ne_xv_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmsne.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ne <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ne_vi_nxv8i64_0(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_ne_vi_nxv8i64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 5, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ne <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb) {
; CHECK-LABEL: icmp_ugt_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = icmp ugt <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_ugt_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmsltu.vv v0, v16, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ugt_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmsgtu.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ugt <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_xv_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_ugt_xv_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmsltu.vv v0, v8, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ugt_xv_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmsltu.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ugt <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ugt_vi_nxv8i64_0(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_ugt_vi_nxv8i64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 5, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ugt <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb) {
; CHECK-LABEL: icmp_uge_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = icmp uge <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_uge_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmsleu.vv v0, v16, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_uge_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmv.v.x v16, a0
; RV64-NEXT:    vmsleu.vv v0, v16, v8
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_xv_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_uge_xv_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmsleu.vv v0, v8, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_uge_xv_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmsleu.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i64_0(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmv.v.i v16, -16
; CHECK-NEXT:    vmsleu.vv v0, v16, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 -16, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i64_1(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 14
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 15, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_iv_nxv8i64_1(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_uge_iv_nxv8i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 15, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i64_2(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmset.m v0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 0, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i64_3(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i64_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 1, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i64_4(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i64_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 -15, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i64_5(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_uge_vi_nxv8i64_5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 16, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp uge <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb) {
; CHECK-LABEL: icmp_ult_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = icmp ult <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_ult_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmsltu.vv v0, v8, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ult_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmsltu.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_xv_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_ult_xv_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmsltu.vv v0, v16, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ult_xv_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmsgtu.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i64_0(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, -16
; CHECK-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 -16, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i64_1(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 -15, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_iv_nxv8i64_1(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_ult_iv_nxv8i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, -15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 -15, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i64_2(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmclr.m v0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 0, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i64_3(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i64_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 1, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i64_4(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_ult_vi_nxv8i64_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 16, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ult <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb) {
; CHECK-LABEL: icmp_ule_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = icmp ule <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_ule_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmsleu.vv v0, v8, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ule_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmsleu.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ule <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_xv_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_ule_xv_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmsleu.vv v0, v16, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ule_xv_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmv.v.x v16, a0
; RV64-NEXT:    vmsleu.vv v0, v16, v8
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ule <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_ule_vi_nxv8i64_0(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_ule_vi_nxv8i64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 5, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp ule <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb) {
; CHECK-LABEL: icmp_sgt_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = icmp sgt <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_sgt_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmslt.vv v0, v16, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sgt_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmsgt.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sgt <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_xv_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_sgt_xv_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmslt.vv v0, v8, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sgt_xv_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmslt.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sgt <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sgt_vi_nxv8i64_0(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_sgt_vi_nxv8i64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 5, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sgt <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb) {
; CHECK-LABEL: icmp_sge_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = icmp sge <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_sge_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmsle.vv v0, v16, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sge_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmv.v.x v16, a0
; RV64-NEXT:    vmsle.vv v0, v16, v8
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_xv_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_sge_xv_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmsle.vv v0, v8, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sge_xv_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmsle.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i64_0(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmv.v.i v16, -16
; CHECK-NEXT:    vmsle.vv v0, v16, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 -16, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i64_1(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 -15, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_iv_nxv8i64_1(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_sge_iv_nxv8i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, -15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 -15, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i64_2(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -1
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 0, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i64_3(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_sge_vi_nxv8i64_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 16, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sge <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb) {
; CHECK-LABEL: icmp_slt_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = icmp slt <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_slt_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmslt.vv v0, v8, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_slt_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmslt.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_xv_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_slt_xv_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmslt.vv v0, v16, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_slt_xv_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmsgt.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i64_0(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, -16
; CHECK-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 -16, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i64_1(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, -16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 -15, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_iv_nxv8i64_1(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_slt_iv_nxv8i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 -15, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i64_2(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, -1
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 0, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i64_3(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_slt_vi_nxv8i64_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 16, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp slt <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb) {
; CHECK-LABEL: icmp_sle_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = icmp sle <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_sle_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmsle.vv v0, v8, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sle_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmsle.vx v0, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sle <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_xv_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: icmp_sle_xv_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmsle.vv v0, v16, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sle_xv_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmv.v.x v16, a0
; RV64-NEXT:    vmsle.vv v0, v16, v8
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sle <vscale x 8 x i64> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @icmp_sle_vi_nxv8i64_0(<vscale x 8 x i64> %va) {
; CHECK-LABEL: icmp_sle_vi_nxv8i64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 5, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp sle <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i1> %vc
}

; Check a setcc with two constant splats, which would previously get stuck in
; an infinite loop. DAGCombine isn't clever enough to constant-fold
; splat_vectors but could continuously swap the operands, trying to put the
; splat on the RHS.
define <vscale x 8 x i1> @icmp_eq_ii_nxv8i8() {
; CHECK-LABEL: icmp_eq_ii_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmclr.m v0
; CHECK-NEXT:    ret
  %heada = insertelement <vscale x 8 x i8> poison, i8 5, i32 0
  %splata = shufflevector <vscale x 8 x i8> %heada, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %headb = insertelement <vscale x 8 x i8> poison, i8 2, i32 0
  %splatb = shufflevector <vscale x 8 x i8> %headb, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = icmp eq <vscale x 8 x i8> %splata, %splatb
  ret <vscale x 8 x i1> %vc
}

; This icmp/setcc is split and so we find a scalable-vector mask CONCAT_VECTOR
; node. Ensure we correctly (custom) lower this.
define <vscale x 16 x i1> @icmp_eq_vi_nx16i64(<vscale x 16 x i64> %va) {
; CHECK-LABEL: icmp_eq_vi_nx16i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    add a1, a0, a0
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmseq.vi v24, v16, 0
; CHECK-NEXT:    vmseq.vi v0, v8, 0
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, tu, ma
; CHECK-NEXT:    vslideup.vx v0, v24, a0
; CHECK-NEXT:    ret
  %vc = icmp eq <vscale x 16 x i64> %va, zeroinitializer
  ret <vscale x 16 x i1> %vc
}
