// RUN: llvm-mc -arch=amdgcn -mcpu=gfx1150 -show-encoding %s | FileCheck --check-prefixes=GFX1150 %s

s_cvt_f32_i32 s5, s1
// GFX1150: encoding: [0x01,0x64,0x85,0xbe]

s_cvt_f32_i32 s105, s1
// GFX1150: encoding: [0x01,0x64,0xe9,0xbe]

s_cvt_f32_i32 s5, s105
// GFX1150: encoding: [0x69,0x64,0x85,0xbe]

s_cvt_f32_i32 s5, s103
// GFX1150: encoding: [0x67,0x64,0x85,0xbe]

s_cvt_f32_i32 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x64,0x85,0xbe]

s_cvt_f32_i32 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x64,0x85,0xbe]

s_cvt_f32_i32 s5, ttmp11
// GFX1150: encoding: [0x77,0x64,0x85,0xbe]

s_cvt_f32_i32 s5, m0
// GFX1150: encoding: [0x7d,0x64,0x85,0xbe]

s_cvt_f32_i32 s5, exec_lo
// GFX1150: encoding: [0x7e,0x64,0x85,0xbe]

s_cvt_f32_i32 s5, exec_hi
// GFX1150: encoding: [0x7f,0x64,0x85,0xbe]

s_cvt_f32_i32 s5, 0
// GFX1150: encoding: [0x80,0x64,0x85,0xbe]

s_cvt_f32_i32 s5, -1
// GFX1150: encoding: [0xc1,0x64,0x85,0xbe]

s_cvt_f32_i32 s5, 0.5
// GFX1150: encoding: [0xf0,0x64,0x85,0xbe]

s_cvt_f32_i32 s5, -4.0
// GFX1150: encoding: [0xf7,0x64,0x85,0xbe]

s_cvt_f32_i32 s5, 0xaf123456
// GFX1150: encoding: [0xff,0x64,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_cvt_f32_i32 s5, 0x3f717273
// GFX1150: encoding: [0xff,0x64,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_cvt_f32_u32 s5, s1
// GFX1150: encoding: [0x01,0x65,0x85,0xbe]

s_cvt_f32_u32 s105, s1
// GFX1150: encoding: [0x01,0x65,0xe9,0xbe]

s_cvt_f32_u32 s5, s105
// GFX1150: encoding: [0x69,0x65,0x85,0xbe]

s_cvt_f32_u32 s5, s103
// GFX1150: encoding: [0x67,0x65,0x85,0xbe]

s_cvt_f32_u32 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x65,0x85,0xbe]

s_cvt_f32_u32 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x65,0x85,0xbe]

s_cvt_f32_u32 s5, ttmp11
// GFX1150: encoding: [0x77,0x65,0x85,0xbe]

s_cvt_f32_u32 s5, m0
// GFX1150: encoding: [0x7d,0x65,0x85,0xbe]

s_cvt_f32_u32 s5, exec_lo
// GFX1150: encoding: [0x7e,0x65,0x85,0xbe]

s_cvt_f32_u32 s5, exec_hi
// GFX1150: encoding: [0x7f,0x65,0x85,0xbe]

s_cvt_f32_u32 s5, 0
// GFX1150: encoding: [0x80,0x65,0x85,0xbe]

s_cvt_f32_u32 s5, -1
// GFX1150: encoding: [0xc1,0x65,0x85,0xbe]

s_cvt_f32_u32 s5, 0.5
// GFX1150: encoding: [0xf0,0x65,0x85,0xbe]

s_cvt_f32_u32 s5, -4.0
// GFX1150: encoding: [0xf7,0x65,0x85,0xbe]

s_cvt_f32_u32 s5, 0xaf123456
// GFX1150: encoding: [0xff,0x65,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_cvt_f32_u32 s5, 0x3f717273
// GFX1150: encoding: [0xff,0x65,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_cvt_u32_f32 s5, s1
// GFX1150: encoding: [0x01,0x67,0x85,0xbe]

s_cvt_u32_f32 s105, s1
// GFX1150: encoding: [0x01,0x67,0xe9,0xbe]

s_cvt_u32_f32 s5, s105
// GFX1150: encoding: [0x69,0x67,0x85,0xbe]

s_cvt_u32_f32 s5, s103
// GFX1150: encoding: [0x67,0x67,0x85,0xbe]

s_cvt_u32_f32 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x67,0x85,0xbe]

s_cvt_u32_f32 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x67,0x85,0xbe]

s_cvt_u32_f32 s5, ttmp11
// GFX1150: encoding: [0x77,0x67,0x85,0xbe]

s_cvt_u32_f32 s5, m0
// GFX1150: encoding: [0x7d,0x67,0x85,0xbe]

s_cvt_u32_f32 s5, exec_lo
// GFX1150: encoding: [0x7e,0x67,0x85,0xbe]

s_cvt_u32_f32 s5, exec_hi
// GFX1150: encoding: [0x7f,0x67,0x85,0xbe]

s_cvt_u32_f32 s5, 0
// GFX1150: encoding: [0x80,0x67,0x85,0xbe]

s_cvt_u32_f32 s5, -1
// GFX1150: encoding: [0xc1,0x67,0x85,0xbe]

s_cvt_u32_f32 s5, 0.5
// GFX1150: encoding: [0xf0,0x67,0x85,0xbe]

s_cvt_u32_f32 s5, -4.0
// GFX1150: encoding: [0xf7,0x67,0x85,0xbe]

s_cvt_u32_f32 s5, 0xaf123456
// GFX1150: encoding: [0xff,0x67,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_cvt_u32_f32 s5, 0x3f717273
// GFX1150: encoding: [0xff,0x67,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_cvt_i32_f32 s5, s1
// GFX1150: encoding: [0x01,0x66,0x85,0xbe]

s_cvt_i32_f32 s105, s1
// GFX1150: encoding: [0x01,0x66,0xe9,0xbe]

s_cvt_i32_f32 s5, s105
// GFX1150: encoding: [0x69,0x66,0x85,0xbe]

s_cvt_i32_f32 s5, s103
// GFX1150: encoding: [0x67,0x66,0x85,0xbe]

s_cvt_i32_f32 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x66,0x85,0xbe]

s_cvt_i32_f32 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x66,0x85,0xbe]

s_cvt_i32_f32 s5, ttmp11
// GFX1150: encoding: [0x77,0x66,0x85,0xbe]

s_cvt_i32_f32 s5, m0
// GFX1150: encoding: [0x7d,0x66,0x85,0xbe]

s_cvt_i32_f32 s5, exec_lo
// GFX1150: encoding: [0x7e,0x66,0x85,0xbe]

s_cvt_i32_f32 s5, exec_hi
// GFX1150: encoding: [0x7f,0x66,0x85,0xbe]

s_cvt_i32_f32 s5, 0
// GFX1150: encoding: [0x80,0x66,0x85,0xbe]

s_cvt_i32_f32 s5, -1
// GFX1150: encoding: [0xc1,0x66,0x85,0xbe]

s_cvt_i32_f32 s5, 0.5
// GFX1150: encoding: [0xf0,0x66,0x85,0xbe]

s_cvt_i32_f32 s5, -4.0
// GFX1150: encoding: [0xf7,0x66,0x85,0xbe]

s_cvt_i32_f32 s5, 0xaf123456
// GFX1150: encoding: [0xff,0x66,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_cvt_i32_f32 s5, 0x3f717273
// GFX1150: encoding: [0xff,0x66,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_cvt_f16_f32 s5, s1
// GFX1150: encoding: [0x01,0x68,0x85,0xbe]

s_cvt_f16_f32 s105, s1
// GFX1150: encoding: [0x01,0x68,0xe9,0xbe]

s_cvt_f16_f32 s5, s105
// GFX1150: encoding: [0x69,0x68,0x85,0xbe]

s_cvt_f16_f32 s5, s103
// GFX1150: encoding: [0x67,0x68,0x85,0xbe]

s_cvt_f16_f32 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x68,0x85,0xbe]

s_cvt_f16_f32 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x68,0x85,0xbe]

s_cvt_f16_f32 s5, ttmp11
// GFX1150: encoding: [0x77,0x68,0x85,0xbe]

s_cvt_f16_f32 s5, m0
// GFX1150: encoding: [0x7d,0x68,0x85,0xbe]

s_cvt_f16_f32 s5, exec_lo
// GFX1150: encoding: [0x7e,0x68,0x85,0xbe]

s_cvt_f16_f32 s5, exec_hi
// GFX1150: encoding: [0x7f,0x68,0x85,0xbe]

s_cvt_f16_f32 s5, 0
// GFX1150: encoding: [0x80,0x68,0x85,0xbe]

s_cvt_f16_f32 s5, -1
// GFX1150: encoding: [0xc1,0x68,0x85,0xbe]

s_cvt_f16_f32 s5, 0.5
// GFX1150: encoding: [0xf0,0x68,0x85,0xbe]

s_cvt_f16_f32 s5, -4.0
// GFX1150: encoding: [0xf7,0x68,0x85,0xbe]

s_cvt_f16_f32 s5, 0xaf123456
// GFX1150: encoding: [0xff,0x68,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_cvt_f16_f32 s5, 0x3f717273
// GFX1150: encoding: [0xff,0x68,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_cvt_f32_f16 s5, s1
// GFX1150: encoding: [0x01,0x69,0x85,0xbe]

s_cvt_f32_f16 s105, s1
// GFX1150: encoding: [0x01,0x69,0xe9,0xbe]

s_cvt_f32_f16 s5, s105
// GFX1150: encoding: [0x69,0x69,0x85,0xbe]

s_cvt_f32_f16 s5, s103
// GFX1150: encoding: [0x67,0x69,0x85,0xbe]

s_cvt_f32_f16 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x69,0x85,0xbe]

s_cvt_f32_f16 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x69,0x85,0xbe]

s_cvt_f32_f16 s5, ttmp11
// GFX1150: encoding: [0x77,0x69,0x85,0xbe]

s_cvt_f32_f16 s5, m0
// GFX1150: encoding: [0x7d,0x69,0x85,0xbe]

s_cvt_f32_f16 s5, exec_lo
// GFX1150: encoding: [0x7e,0x69,0x85,0xbe]

s_cvt_f32_f16 s5, exec_hi
// GFX1150: encoding: [0x7f,0x69,0x85,0xbe]

s_cvt_f32_f16 s5, 0
// GFX1150: encoding: [0x80,0x69,0x85,0xbe]

s_cvt_f32_f16 s5, -1
// GFX1150: encoding: [0xc1,0x69,0x85,0xbe]

s_cvt_hi_f32_f16 s5, s1
// GFX1150: encoding: [0x01,0x6a,0x85,0xbe]

s_cvt_hi_f32_f16 s105, s1
// GFX1150: encoding: [0x01,0x6a,0xe9,0xbe]

s_cvt_hi_f32_f16 s5, s105
// GFX1150: encoding: [0x69,0x6a,0x85,0xbe]

s_cvt_hi_f32_f16 s5, s103
// GFX1150: encoding: [0x67,0x6a,0x85,0xbe]

s_cvt_hi_f32_f16 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x6a,0x85,0xbe]

s_cvt_hi_f32_f16 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x6a,0x85,0xbe]

s_cvt_hi_f32_f16 s5, ttmp11
// GFX1150: encoding: [0x77,0x6a,0x85,0xbe]

s_cvt_hi_f32_f16 s5, m0
// GFX1150: encoding: [0x7d,0x6a,0x85,0xbe]

s_cvt_hi_f32_f16 s5, exec_lo
// GFX1150: encoding: [0x7e,0x6a,0x85,0xbe]

s_cvt_hi_f32_f16 s5, exec_hi
// GFX1150: encoding: [0x7f,0x6a,0x85,0xbe]

s_cvt_hi_f32_f16 s5, 0
// GFX1150: encoding: [0x80,0x6a,0x85,0xbe]

s_cvt_hi_f32_f16 s5, -1
// GFX1150: encoding: [0xc1,0x6a,0x85,0xbe]

s_trunc_f32 s5, s1
// GFX1150: encoding: [0x01,0x62,0x85,0xbe]

s_trunc_f32 s105, s1
// GFX1150: encoding: [0x01,0x62,0xe9,0xbe]

s_trunc_f32 s5, s105
// GFX1150: encoding: [0x69,0x62,0x85,0xbe]

s_trunc_f32 s5, s103
// GFX1150: encoding: [0x67,0x62,0x85,0xbe]

s_trunc_f32 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x62,0x85,0xbe]

s_trunc_f32 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x62,0x85,0xbe]

s_trunc_f32 s5, ttmp11
// GFX1150: encoding: [0x77,0x62,0x85,0xbe]

s_trunc_f32 s5, m0
// GFX1150: encoding: [0x7d,0x62,0x85,0xbe]

s_trunc_f32 s5, exec_lo
// GFX1150: encoding: [0x7e,0x62,0x85,0xbe]

s_trunc_f32 s5, exec_hi
// GFX1150: encoding: [0x7f,0x62,0x85,0xbe]

s_trunc_f32 s5, 0
// GFX1150: encoding: [0x80,0x62,0x85,0xbe]

s_trunc_f32 s5, -1
// GFX1150: encoding: [0xc1,0x62,0x85,0xbe]

s_trunc_f32 s5, 0.5
// GFX1150: encoding: [0xf0,0x62,0x85,0xbe]

s_trunc_f32 s5, -4.0
// GFX1150: encoding: [0xf7,0x62,0x85,0xbe]

s_trunc_f32 s5, 0xaf123456
// GFX1150: encoding: [0xff,0x62,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_trunc_f32 s5, 0x3f717273
// GFX1150: encoding: [0xff,0x62,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_ceil_f32 s5, s1
// GFX1150: encoding: [0x01,0x60,0x85,0xbe]

s_ceil_f32 s105, s1
// GFX1150: encoding: [0x01,0x60,0xe9,0xbe]

s_ceil_f32 s5, s105
// GFX1150: encoding: [0x69,0x60,0x85,0xbe]

s_ceil_f32 s5, s103
// GFX1150: encoding: [0x67,0x60,0x85,0xbe]

s_ceil_f32 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x60,0x85,0xbe]

s_ceil_f32 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x60,0x85,0xbe]

s_ceil_f32 s5, ttmp11
// GFX1150: encoding: [0x77,0x60,0x85,0xbe]

s_ceil_f32 s5, m0
// GFX1150: encoding: [0x7d,0x60,0x85,0xbe]

s_ceil_f32 s5, exec_lo
// GFX1150: encoding: [0x7e,0x60,0x85,0xbe]

s_ceil_f32 s5, exec_hi
// GFX1150: encoding: [0x7f,0x60,0x85,0xbe]

s_ceil_f32 s5, 0
// GFX1150: encoding: [0x80,0x60,0x85,0xbe]

s_ceil_f32 s5, -1
// GFX1150: encoding: [0xc1,0x60,0x85,0xbe]

s_ceil_f32 s5, 0.5
// GFX1150: encoding: [0xf0,0x60,0x85,0xbe]

s_ceil_f32 s5, -4.0
// GFX1150: encoding: [0xf7,0x60,0x85,0xbe]

s_ceil_f32 s5, 0xaf123456
// GFX1150: encoding: [0xff,0x60,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_ceil_f32 s5, 0x3f717273
// GFX1150: encoding: [0xff,0x60,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_rndne_f32 s5, s1
// GFX1150: encoding: [0x01,0x63,0x85,0xbe]

s_rndne_f32 s105, s1
// GFX1150: encoding: [0x01,0x63,0xe9,0xbe]

s_rndne_f32 s5, s105
// GFX1150: encoding: [0x69,0x63,0x85,0xbe]

s_rndne_f32 s5, s103
// GFX1150: encoding: [0x67,0x63,0x85,0xbe]

s_rndne_f32 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x63,0x85,0xbe]

s_rndne_f32 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x63,0x85,0xbe]

s_rndne_f32 s5, ttmp11
// GFX1150: encoding: [0x77,0x63,0x85,0xbe]

s_rndne_f32 s5, m0
// GFX1150: encoding: [0x7d,0x63,0x85,0xbe]

s_rndne_f32 s5, exec_lo
// GFX1150: encoding: [0x7e,0x63,0x85,0xbe]

s_rndne_f32 s5, exec_hi
// GFX1150: encoding: [0x7f,0x63,0x85,0xbe]

s_rndne_f32 s5, 0
// GFX1150: encoding: [0x80,0x63,0x85,0xbe]

s_rndne_f32 s5, -1
// GFX1150: encoding: [0xc1,0x63,0x85,0xbe]

s_rndne_f32 s5, 0.5
// GFX1150: encoding: [0xf0,0x63,0x85,0xbe]

s_rndne_f32 s5, -4.0
// GFX1150: encoding: [0xf7,0x63,0x85,0xbe]

s_rndne_f32 s5, 0xaf123456
// GFX1150: encoding: [0xff,0x63,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_rndne_f32 s5, 0x3f717273
// GFX1150: encoding: [0xff,0x63,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_floor_f32 s5, s1
// GFX1150: encoding: [0x01,0x61,0x85,0xbe]

s_floor_f32 s105, s1
// GFX1150: encoding: [0x01,0x61,0xe9,0xbe]

s_floor_f32 s5, s105
// GFX1150: encoding: [0x69,0x61,0x85,0xbe]

s_floor_f32 s5, s103
// GFX1150: encoding: [0x67,0x61,0x85,0xbe]

s_floor_f32 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x61,0x85,0xbe]

s_floor_f32 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x61,0x85,0xbe]

s_floor_f32 s5, ttmp11
// GFX1150: encoding: [0x77,0x61,0x85,0xbe]

s_floor_f32 s5, m0
// GFX1150: encoding: [0x7d,0x61,0x85,0xbe]

s_floor_f32 s5, exec_lo
// GFX1150: encoding: [0x7e,0x61,0x85,0xbe]

s_floor_f32 s5, exec_hi
// GFX1150: encoding: [0x7f,0x61,0x85,0xbe]

s_floor_f32 s5, 0
// GFX1150: encoding: [0x80,0x61,0x85,0xbe]

s_floor_f32 s5, -1
// GFX1150: encoding: [0xc1,0x61,0x85,0xbe]

s_floor_f32 s5, 0.5
// GFX1150: encoding: [0xf0,0x61,0x85,0xbe]

s_floor_f32 s5, -4.0
// GFX1150: encoding: [0xf7,0x61,0x85,0xbe]

s_floor_f32 s5, 0xaf123456
// GFX1150: encoding: [0xff,0x61,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_floor_f32 s5, 0x3f717273
// GFX1150: encoding: [0xff,0x61,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_floor_f16 s5, s1
// GFX1150: encoding: [0x01,0x6c,0x85,0xbe]

s_floor_f16 s105, s1
// GFX1150: encoding: [0x01,0x6c,0xe9,0xbe]

s_floor_f16 s5, s105
// GFX1150: encoding: [0x69,0x6c,0x85,0xbe]

s_floor_f16 s5, s101
// GFX1150: encoding: [0x65,0x6c,0x85,0xbe]

s_floor_f16 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x6c,0x85,0xbe]

s_floor_f16 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x6c,0x85,0xbe]

s_floor_f16 s5, m0
// GFX1150: encoding: [0x7d,0x6c,0x85,0xbe]

s_floor_f16 s5, exec_lo
// GFX1150: encoding: [0x7e,0x6c,0x85,0xbe]

s_floor_f16 s5, exec_hi
// GFX1150: encoding: [0x7f,0x6c,0x85,0xbe]

s_floor_f16 s5, 0
// GFX1150: encoding: [0x80,0x6c,0x85,0xbe]

s_floor_f16 s5, -1
// GFX1150: encoding: [0xc1,0x6c,0x85,0xbe]

s_floor_f16 s5, 0.5
// GFX1150: encoding: [0xf0,0x6c,0x85,0xbe]

s_floor_f16 s5, -4.0
// GFX1150: encoding: [0xf7,0x6c,0x85,0xbe]

s_floor_f16 s5, 0xfe0b
// GFX1150: encoding: [0xff,0x6c,0x85,0xbe,0x0b,0xfe,0x00,0x00]

s_floor_f16 s5, 0x3456
// GFX1150: encoding: [0xff,0x6c,0x85,0xbe,0x56,0x34,0x00,0x00]

s_ceil_f16 s5, s1
// GFX1150: encoding: [0x01,0x6b,0x85,0xbe]

s_ceil_f16 s105, s1
// GFX1150: encoding: [0x01,0x6b,0xe9,0xbe]

s_ceil_f16 s5, s105
// GFX1150: encoding: [0x69,0x6b,0x85,0xbe]

s_ceil_f16 s5, s101
// GFX1150: encoding: [0x65,0x6b,0x85,0xbe]

s_ceil_f16 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x6b,0x85,0xbe]

s_ceil_f16 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x6b,0x85,0xbe]

s_ceil_f16 s5, m0
// GFX1150: encoding: [0x7d,0x6b,0x85,0xbe]

s_ceil_f16 s5, exec_lo
// GFX1150: encoding: [0x7e,0x6b,0x85,0xbe]

s_ceil_f16 s5, exec_hi
// GFX1150: encoding: [0x7f,0x6b,0x85,0xbe]

s_ceil_f16 s5, 0
// GFX1150: encoding: [0x80,0x6b,0x85,0xbe]

s_ceil_f16 s5, -1
// GFX1150: encoding: [0xc1,0x6b,0x85,0xbe]

s_ceil_f16 s5, 0.5
// GFX1150: encoding: [0xf0,0x6b,0x85,0xbe]

s_ceil_f16 s5, -4.0
// GFX1150: encoding: [0xf7,0x6b,0x85,0xbe]

s_ceil_f16 s5, 0xfe0b
// GFX1150: encoding: [0xff,0x6b,0x85,0xbe,0x0b,0xfe,0x00,0x00]

s_ceil_f16 s5, 0x3456
// GFX1150: encoding: [0xff,0x6b,0x85,0xbe,0x56,0x34,0x00,0x00]

s_trunc_f16 s5, s1
// GFX1150: encoding: [0x01,0x6d,0x85,0xbe]

s_trunc_f16 s105, s1
// GFX1150: encoding: [0x01,0x6d,0xe9,0xbe]

s_trunc_f16 s5, s105
// GFX1150: encoding: [0x69,0x6d,0x85,0xbe]

s_trunc_f16 s5, s101
// GFX1150: encoding: [0x65,0x6d,0x85,0xbe]

s_trunc_f16 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x6d,0x85,0xbe]

s_trunc_f16 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x6d,0x85,0xbe]

s_trunc_f16 s5, m0
// GFX1150: encoding: [0x7d,0x6d,0x85,0xbe]

s_trunc_f16 s5, exec_lo
// GFX1150: encoding: [0x7e,0x6d,0x85,0xbe]

s_trunc_f16 s5, exec_hi
// GFX1150: encoding: [0x7f,0x6d,0x85,0xbe]

s_trunc_f16 s5, 0
// GFX1150: encoding: [0x80,0x6d,0x85,0xbe]

s_trunc_f16 s5, -1
// GFX1150: encoding: [0xc1,0x6d,0x85,0xbe]

s_trunc_f16 s5, 0.5
// GFX1150: encoding: [0xf0,0x6d,0x85,0xbe]

s_trunc_f16 s5, -4.0
// GFX1150: encoding: [0xf7,0x6d,0x85,0xbe]

s_trunc_f16 s5, 0xfe0b
// GFX1150: encoding: [0xff,0x6d,0x85,0xbe,0x0b,0xfe,0x00,0x00]

s_trunc_f16 s5, 0x3456
// GFX1150: encoding: [0xff,0x6d,0x85,0xbe,0x56,0x34,0x00,0x00]

s_rndne_f16 s5, s1
// GFX1150: encoding: [0x01,0x6e,0x85,0xbe]

s_rndne_f16 s105, s1
// GFX1150: encoding: [0x01,0x6e,0xe9,0xbe]

s_rndne_f16 s5, s105
// GFX1150: encoding: [0x69,0x6e,0x85,0xbe]

s_rndne_f16 s5, s101
// GFX1150: encoding: [0x65,0x6e,0x85,0xbe]

s_rndne_f16 s5, vcc_lo
// GFX1150: encoding: [0x6a,0x6e,0x85,0xbe]

s_rndne_f16 s5, vcc_hi
// GFX1150: encoding: [0x6b,0x6e,0x85,0xbe]

s_rndne_f16 s5, m0
// GFX1150: encoding: [0x7d,0x6e,0x85,0xbe]

s_rndne_f16 s5, exec_lo
// GFX1150: encoding: [0x7e,0x6e,0x85,0xbe]

s_rndne_f16 s5, exec_hi
// GFX1150: encoding: [0x7f,0x6e,0x85,0xbe]

s_rndne_f16 s5, 0
// GFX1150: encoding: [0x80,0x6e,0x85,0xbe]

s_rndne_f16 s5, -1
// GFX1150: encoding: [0xc1,0x6e,0x85,0xbe]

s_rndne_f16 s5, 0.5
// GFX1150: encoding: [0xf0,0x6e,0x85,0xbe]

s_rndne_f16 s5, -4.0
// GFX1150: encoding: [0xf7,0x6e,0x85,0xbe]

s_rndne_f16 s5, 0xfe0b
// GFX1150: encoding: [0xff,0x6e,0x85,0xbe,0x0b,0xfe,0x00,0x00]

s_rndne_f16 s5, 0x3456
// GFX1150: encoding: [0xff,0x6e,0x85,0xbe,0x56,0x34,0x00,0x00]

s_add_f32 s5, s1, s2
// GFX1150: encoding: [0x01,0x02,0x05,0xa0]

s_add_f32 s105, s1, s2
// GFX1150: encoding: [0x01,0x02,0x69,0xa0]

s_add_f32 s5, s105, s2
// GFX1150: encoding: [0x69,0x02,0x05,0xa0]

s_add_f32 s5, s101, s2
// GFX1150: encoding: [0x65,0x02,0x05,0xa0]

s_add_f32 s5, vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x05,0xa0]

s_add_f32 s5, vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x05,0xa0]

s_add_f32 s5, m0, s2
// GFX1150: encoding: [0x7d,0x02,0x05,0xa0]

s_add_f32 s5, exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x05,0xa0]

s_add_f32 s5, exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x05,0xa0]

s_add_f32 s5, 0, s2
// GFX1150: encoding: [0x80,0x02,0x05,0xa0]

s_add_f32 s5, -1, s2
// GFX1150: encoding: [0xc1,0x02,0x05,0xa0]

s_add_f32 s5, 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x05,0xa0]

s_add_f32 s5, -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x05,0xa0]

s_add_f32 s5, 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x05,0xa0,0x56,0x34,0x12,0xaf]

s_add_f32 s5, 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x05,0xa0,0x73,0x72,0x71,0x3f]

s_add_f32 s5, s1, s105
// GFX1150: encoding: [0x01,0x69,0x05,0xa0]

s_sub_f32 s5, s1, s2
// GFX1150: encoding: [0x01,0x02,0x85,0xa0]

s_sub_f32 s105, s1, s2
// GFX1150: encoding: [0x01,0x02,0xe9,0xa0]

s_sub_f32 s5, s105, s2
// GFX1150: encoding: [0x69,0x02,0x85,0xa0]

s_sub_f32 s5, s101, s2
// GFX1150: encoding: [0x65,0x02,0x85,0xa0]

s_sub_f32 s5, vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x85,0xa0]

s_sub_f32 s5, vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x85,0xa0]

s_sub_f32 s5, m0, s2
// GFX1150: encoding: [0x7d,0x02,0x85,0xa0]

s_sub_f32 s5, exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x85,0xa0]

s_sub_f32 s5, exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x85,0xa0]

s_sub_f32 s5, 0, s2
// GFX1150: encoding: [0x80,0x02,0x85,0xa0]

s_sub_f32 s5, -1, s2
// GFX1150: encoding: [0xc1,0x02,0x85,0xa0]

s_sub_f32 s5, 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x85,0xa0]

s_sub_f32 s5, -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x85,0xa0]

s_sub_f32 s5, 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x85,0xa0,0x56,0x34,0x12,0xaf]

s_sub_f32 s5, 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x85,0xa0,0x73,0x72,0x71,0x3f]

s_sub_f32 s5, s1, s105
// GFX1150: encoding: [0x01,0x69,0x85,0xa0]

s_mul_f32 s5, s1, s2
// GFX1150: encoding: [0x01,0x02,0x05,0xa2]

s_mul_f32 s105, s1, s2
// GFX1150: encoding: [0x01,0x02,0x69,0xa2]

s_mul_f32 s5, s105, s2
// GFX1150: encoding: [0x69,0x02,0x05,0xa2]

s_mul_f32 s5, s103, s2
// GFX1150: encoding: [0x67,0x02,0x05,0xa2]

s_mul_f32 s5, vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x05,0xa2]

s_mul_f32 s5, vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x05,0xa2]

s_mul_f32 s5, ttmp11, s2
// GFX1150: encoding: [0x77,0x02,0x05,0xa2]

s_mul_f32 s5, m0, s2
// GFX1150: encoding: [0x7d,0x02,0x05,0xa2]

s_mul_f32 s5, exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x05,0xa2]

s_mul_f32 s5, exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x05,0xa2]

s_mul_f32 s5, 0, s2
// GFX1150: encoding: [0x80,0x02,0x05,0xa2]

s_mul_f32 s5, -1, s2
// GFX1150: encoding: [0xc1,0x02,0x05,0xa2]

s_mul_f32 s5, 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x05,0xa2]

s_mul_f32 s5, -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x05,0xa2]

s_mul_f32 s5, 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x05,0xa2,0x56,0x34,0x12,0xaf]

s_mul_f32 s5, 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x05,0xa2,0x73,0x72,0x71,0x3f]

s_mul_f32 s5, s1, s105
// GFX1150: encoding: [0x01,0x69,0x05,0xa2]

s_min_f32 s5, s1, s2
// GFX1150: encoding: [0x01,0x02,0x05,0xa1]

s_min_f32 s105, s1, s2
// GFX1150: encoding: [0x01,0x02,0x69,0xa1]

s_min_f32 s5, s105, s2
// GFX1150: encoding: [0x69,0x02,0x05,0xa1]

s_min_f32 s5, s103, s2
// GFX1150: encoding: [0x67,0x02,0x05,0xa1]

s_min_f32 s5, vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x05,0xa1]

s_min_f32 s5, vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x05,0xa1]

s_min_f32 s5, ttmp11, s2
// GFX1150: encoding: [0x77,0x02,0x05,0xa1]

s_min_f32 s5, m0, s2
// GFX1150: encoding: [0x7d,0x02,0x05,0xa1]

s_min_f32 s5, exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x05,0xa1]

s_min_f32 s5, exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x05,0xa1]

s_min_f32 s5, 0, s2
// GFX1150: encoding: [0x80,0x02,0x05,0xa1]

s_min_f32 s5, -1, s2
// GFX1150: encoding: [0xc1,0x02,0x05,0xa1]

s_min_f32 s5, 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x05,0xa1]

s_min_f32 s5, -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x05,0xa1]

s_min_f32 s5, 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x05,0xa1,0x56,0x34,0x12,0xaf]

s_min_f32 s5, 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x05,0xa1,0x73,0x72,0x71,0x3f]

s_min_f32 s5, s1, s105
// GFX1150: encoding: [0x01,0x69,0x05,0xa1]

s_max_f32 s5, s1, s2
// GFX1150: encoding: [0x01,0x02,0x85,0xa1]

s_max_f32 s105, s1, s2
// GFX1150: encoding: [0x01,0x02,0xe9,0xa1]

s_max_f32 s5, s105, s2
// GFX1150: encoding: [0x69,0x02,0x85,0xa1]

s_max_f32 s5, s103, s2
// GFX1150: encoding: [0x67,0x02,0x85,0xa1]

s_max_f32 s5, vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x85,0xa1]

s_max_f32 s5, vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x85,0xa1]

s_max_f32 s5, ttmp11, s2
// GFX1150: encoding: [0x77,0x02,0x85,0xa1]

s_max_f32 s5, m0, s2
// GFX1150: encoding: [0x7d,0x02,0x85,0xa1]

s_max_f32 s5, exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x85,0xa1]

s_max_f32 s5, exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x85,0xa1]

s_max_f32 s5, 0, s2
// GFX1150: encoding: [0x80,0x02,0x85,0xa1]

s_max_f32 s5, -1, s2
// GFX1150: encoding: [0xc1,0x02,0x85,0xa1]

s_max_f32 s5, 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x85,0xa1]

s_max_f32 s5, -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x85,0xa1]

s_max_f32 s5, 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x85,0xa1,0x56,0x34,0x12,0xaf]

s_max_f32 s5, 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x85,0xa1,0x73,0x72,0x71,0x3f]

s_max_f32 s5, s1, s105
// GFX1150: encoding: [0x01,0x69,0x85,0xa1]

s_fmac_f32 s5, s1, s2
// GFX1150: encoding: [0x01,0x02,0x85,0xa3]

s_fmac_f32 s105, s1, s2
// GFX1150: encoding: [0x01,0x02,0xe9,0xa3]

s_fmac_f32 s5, s105, s2
// GFX1150: encoding: [0x69,0x02,0x85,0xa3]

s_fmac_f32 s5, s103, s2
// GFX1150: encoding: [0x67,0x02,0x85,0xa3]

s_fmac_f32 s5, vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x85,0xa3]

s_fmac_f32 s5, vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x85,0xa3]

s_fmac_f32 s5, ttmp11, s2
// GFX1150: encoding: [0x77,0x02,0x85,0xa3]

s_fmac_f32 s5, m0, s2
// GFX1150: encoding: [0x7d,0x02,0x85,0xa3]

s_fmac_f32 s5, exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x85,0xa3]

s_fmac_f32 s5, exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x85,0xa3]

s_fmac_f32 s5, 0, s2
// GFX1150: encoding: [0x80,0x02,0x85,0xa3]

s_fmac_f32 s5, -1, s2
// GFX1150: encoding: [0xc1,0x02,0x85,0xa3]

s_fmac_f32 s5, 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x85,0xa3]

s_fmac_f32 s5, -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x85,0xa3]

s_fmac_f32 s5, 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x85,0xa3,0x56,0x34,0x12,0xaf]

s_fmac_f32 s5, 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x85,0xa3,0x73,0x72,0x71,0x3f]

s_fmac_f32 s5, s1, s105
// GFX1150: encoding: [0x01,0x69,0x85,0xa3]

s_fmamk_f32 s5, s1, 0x11213141, s3
// GFX1150: encoding: [0x01,0x03,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s105, s1, 0x11213141, s3
// GFX1150: encoding: [0x01,0x03,0x69,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, s105, 0x11213141, s3
// GFX1150: encoding: [0x69,0x03,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, 0, 0x11213141, s3
// GFX1150: encoding: [0x80,0x03,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, -1, 0x11213141, s3
// GFX1150: encoding: [0xc1,0x03,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, 0.5, 0x11213141, s3
// GFX1150: encoding: [0xf0,0x03,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, -4.0, 0x11213141, s3
// GFX1150: encoding: [0xf7,0x03,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, s1, 0xa1b1c1d1, s3
// GFX1150: encoding: [0x01,0x03,0x05,0xa3,0xd1,0xc1,0xb1,0xa1]

s_fmamk_f32 s5, s1, 0x11213141, s105
// GFX1150: encoding: [0x01,0x69,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, 0x11213141, 0x11213141, s105
// GFX1150 encoding: [0xff,0x69,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, s105, 0x11213141, 0x11213141
// GFX1150 encoding: [0x69,0xff,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, s1, s2, 0x11213141
// GFX1150: encoding: [0x01,0x02,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s105, s1, s2, 0x11213141
// GFX1150: encoding: [0x01,0x02,0xe9,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, s105, s2, 0x11213141
// GFX1150: encoding: [0x69,0x02,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, 0, s2, 0x11213141
// GFX1150: encoding: [0x80,0x02,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, -1, s2, 0x11213141
// GFX1150: encoding: [0xc1,0x02,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, 0.5, s2, 0x11213141
// GFX1150: encoding: [0xf0,0x02,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, -4.0, s2, 0x11213141
// GFX1150: encoding: [0xf7,0x02,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, s1, s105, 0x11213141
// GFX1150: encoding: [0x01,0x69,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, s1, s2, 0xa1b1c1d1
// GFX1150: encoding: [0x01,0x02,0x85,0xa2,0xd1,0xc1,0xb1,0xa1]

s_fmaak_f32 s5, 0x11213141, s2, 0x11213141
// GFX1150: encoding: [0xff,0x02,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, s105, 0x11213141, 0x11213141
// GFX1150: encoding: [0x69,0xff,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, 0x11213141, 0x11213141, 0x11213141
// GFX1150: encoding: [0xff,0xff,0x85,0xa2,0x41,0x31,0x21,0x11]

s_cvt_pk_rtz_f16_f32 s5, s1, s2
// GFX1150: encoding: [0x01,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s105, s1, s2
// GFX1150: encoding: [0x01,0x02,0x69,0xa4]

s_cvt_pk_rtz_f16_f32 s5, s105, s2
// GFX1150: encoding: [0x69,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, s103, s2
// GFX1150: encoding: [0x67,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, ttmp11, s2
// GFX1150: encoding: [0x77,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, m0, s2
// GFX1150: encoding: [0x7d,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, 0, s2
// GFX1150: encoding: [0x80,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, -1, s2
// GFX1150: encoding: [0xc1,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x05,0xa4,0x56,0x34,0x12,0xaf]

s_cvt_pk_rtz_f16_f32 s5, 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x05,0xa4,0x73,0x72,0x71,0x3f]

s_cvt_pk_rtz_f16_f32 s5, s1, s105
// GFX1150: encoding: [0x01,0x69,0x05,0xa4]

s_add_f16 s5, s1, s2
// GFX1150: encoding: [0x01,0x02,0x85,0xa4]

s_add_f16 s105, s1, s2
// GFX1150: encoding: [0x01,0x02,0xe9,0xa4]

s_add_f16 s5, s105, s2
// GFX1150: encoding: [0x69,0x02,0x85,0xa4]

s_add_f16 s5, s101, s2
// GFX1150: encoding: [0x65,0x02,0x85,0xa4]

s_add_f16 s5, vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x85,0xa4]

s_add_f16 s5, vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x85,0xa4]

s_add_f16 s5, m0, s2
// GFX1150: encoding: [0x7d,0x02,0x85,0xa4]

s_add_f16 s5, exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x85,0xa4]

s_add_f16 s5, exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x85,0xa4]

s_add_f16 s5, 0, s2
// GFX1150: encoding: [0x80,0x02,0x85,0xa4]

s_add_f16 s5, -1, s2
// GFX1150: encoding: [0xc1,0x02,0x85,0xa4]

s_add_f16 s5, 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x85,0xa4]

s_add_f16 s5, -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x85,0xa4]

s_add_f16 s5, 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x85,0xa4,0x0b,0xfe,0x00,0x00]

s_add_f16 s5, 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x85,0xa4,0x56,0x34,0x00,0x00]

s_add_f16 s5, s1, s105
// GFX1150: encoding: [0x01,0x69,0x85,0xa4]

s_sub_f16 s5, s1, s2
// GFX1150: encoding: [0x01,0x02,0x05,0xa5]

s_sub_f16 s105, s1, s2
// GFX1150: encoding: [0x01,0x02,0x69,0xa5]

s_sub_f16 s5, s105, s2
// GFX1150: encoding: [0x69,0x02,0x05,0xa5]

s_sub_f16 s5, s101, s2
// GFX1150: encoding: [0x65,0x02,0x05,0xa5]

s_sub_f16 s5, vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x05,0xa5]

s_sub_f16 s5, vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x05,0xa5]

s_sub_f16 s5, m0, s2
// GFX1150: encoding: [0x7d,0x02,0x05,0xa5]

s_sub_f16 s5, exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x05,0xa5]

s_sub_f16 s5, exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x05,0xa5]

s_sub_f16 s5, 0, s2
// GFX1150: encoding: [0x80,0x02,0x05,0xa5]

s_sub_f16 s5, -1, s2
// GFX1150: encoding: [0xc1,0x02,0x05,0xa5]

s_sub_f16 s5, 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x05,0xa5]

s_sub_f16 s5, -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x05,0xa5]

s_sub_f16 s5, 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x05,0xa5,0x0b,0xfe,0x00,0x00]

s_sub_f16 s5, 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x05,0xa5,0x56,0x34,0x00,0x00]

s_sub_f16 s5, s1, s105
// GFX1150: encoding: [0x01,0x69,0x05,0xa5]

s_mul_f16 s5, s1, s2
// GFX1150: encoding: [0x01,0x02,0x85,0xa6]

s_mul_f16 s105, s1, s2
// GFX1150: encoding: [0x01,0x02,0xe9,0xa6]

s_mul_f16 s5, s105, s2
// GFX1150: encoding: [0x69,0x02,0x85,0xa6]

s_mul_f16 s5, s101, s2
// GFX1150: encoding: [0x65,0x02,0x85,0xa6]

s_mul_f16 s5, vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x85,0xa6]

s_mul_f16 s5, vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x85,0xa6]

s_mul_f16 s5, m0, s2
// GFX1150: encoding: [0x7d,0x02,0x85,0xa6]

s_mul_f16 s5, exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x85,0xa6]

s_mul_f16 s5, exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x85,0xa6]

s_mul_f16 s5, 0, s2
// GFX1150: encoding: [0x80,0x02,0x85,0xa6]

s_mul_f16 s5, -1, s2
// GFX1150: encoding: [0xc1,0x02,0x85,0xa6]

s_mul_f16 s5, 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x85,0xa6]

s_mul_f16 s5, -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x85,0xa6]

s_mul_f16 s5, 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x85,0xa6,0x0b,0xfe,0x00,0x00]

s_mul_f16 s5, 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x85,0xa6,0x56,0x34,0x00,0x00]

s_mul_f16 s5, s1, s105
// GFX1150: encoding: [0x01,0x69,0x85,0xa6]

s_fmac_f16 s5, s1, s2
// GFX1150: encoding: [0x01,0x02,0x05,0xa7]

s_fmac_f16 s105, s1, s2
// GFX1150: encoding: [0x01,0x02,0x69,0xa7]

s_fmac_f16 s5, s105, s2
// GFX1150: encoding: [0x69,0x02,0x05,0xa7]

s_fmac_f16 s5, s103, s2
// GFX1150: encoding: [0x67,0x02,0x05,0xa7]

s_fmac_f16 s5, vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x05,0xa7]

s_fmac_f16 s5, vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x05,0xa7]

s_fmac_f16 s5, ttmp11, s2
// GFX1150: encoding: [0x77,0x02,0x05,0xa7]

s_fmac_f16 s5, m0, s2
// GFX1150: encoding: [0x7d,0x02,0x05,0xa7]

s_fmac_f16 s5, exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x05,0xa7]

s_fmac_f16 s5, exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x05,0xa7]

s_fmac_f16 s5, 0, s2
// GFX1150: encoding: [0x80,0x02,0x05,0xa7]

s_fmac_f16 s5, -1, s2
// GFX1150: encoding: [0xc1,0x02,0x05,0xa7]

s_fmac_f16 s5, 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x05,0xa7]

s_fmac_f16 s5, -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x05,0xa7]

s_fmac_f16 s5, 0x1234, s2
// GFX1150: encoding: [0xff,0x02,0x05,0xa7,0x34,0x12,0x00,0x00]

s_fmac_f16 s5, s1, s105
// GFX1150: encoding: [0x01,0x69,0x05,0xa7]

s_max_f16 s5, s1, s2
// GFX1150: encoding: [0x01,0x02,0x05,0xa6]

s_max_f16 s105, s1, s2
// GFX1150: encoding: [0x01,0x02,0x69,0xa6]

s_max_f16 s5, s105, s2
// GFX1150: encoding: [0x69,0x02,0x05,0xa6]

s_max_f16 s5, s101, s2
// GFX1150: encoding: [0x65,0x02,0x05,0xa6]

s_max_f16 s5, vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x05,0xa6]

s_max_f16 s5, vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x05,0xa6]

s_max_f16 s5, m0, s2
// GFX1150: encoding: [0x7d,0x02,0x05,0xa6]

s_max_f16 s5, exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x05,0xa6]

s_max_f16 s5, exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x05,0xa6]

s_max_f16 s5, 0, s2
// GFX1150: encoding: [0x80,0x02,0x05,0xa6]

s_max_f16 s5, -1, s2
// GFX1150: encoding: [0xc1,0x02,0x05,0xa6]

s_max_f16 s5, 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x05,0xa6]

s_max_f16 s5, -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x05,0xa6]

s_max_f16 s5, 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x05,0xa6,0x0b,0xfe,0x00,0x00]

s_max_f16 s5, 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x05,0xa6,0x56,0x34,0x00,0x00]

s_max_f16 s5, s1, s105
// GFX1150: encoding: [0x01,0x69,0x05,0xa6]

s_min_f16 s5, s1, s2
// GFX1150: encoding: [0x01,0x02,0x85,0xa5]

s_min_f16 s105, s1, s2
// GFX1150: encoding: [0x01,0x02,0xe9,0xa5]

s_min_f16 s5, s105, s2
// GFX1150: encoding: [0x69,0x02,0x85,0xa5]

s_min_f16 s5, s101, s2
// GFX1150: encoding: [0x65,0x02,0x85,0xa5]

s_min_f16 s5, vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x85,0xa5]

s_min_f16 s5, vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x85,0xa5]

s_min_f16 s5, m0, s2
// GFX1150: encoding: [0x7d,0x02,0x85,0xa5]

s_min_f16 s5, exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x85,0xa5]

s_min_f16 s5, exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x85,0xa5]

s_min_f16 s5, 0, s2
// GFX1150: encoding: [0x80,0x02,0x85,0xa5]

s_min_f16 s5, -1, s2
// GFX1150: encoding: [0xc1,0x02,0x85,0xa5]

s_min_f16 s5, 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x85,0xa5]

s_min_f16 s5, -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x85,0xa5]

s_min_f16 s5, 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x85,0xa5,0x0b,0xfe,0x00,0x00]

s_min_f16 s5, 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x85,0xa5,0x56,0x34,0x00,0x00]

s_min_f16 s5, s1, s105
// GFX1150: encoding: [0x01,0x69,0x85,0xa5]

s_cmp_lt_f32 s1, s2
// GFX1150: encoding: [0x01,0x02,0x41,0xbf]

s_cmp_lt_f32 s105, s2
// GFX1150: encoding: [0x69,0x02,0x41,0xbf]

s_cmp_lt_f32 s101, s2
// GFX1150: encoding: [0x65,0x02,0x41,0xbf]

s_cmp_lt_f32 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x41,0xbf]

s_cmp_lt_f32 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x41,0xbf]

s_cmp_lt_f32 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x41,0xbf]

s_cmp_lt_f32 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x41,0xbf]

s_cmp_lt_f32 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x41,0xbf]

s_cmp_lt_f32 0, s2
// GFX1150: encoding: [0x80,0x02,0x41,0xbf]

s_cmp_lt_f32 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x41,0xbf]

s_cmp_lt_f32 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x41,0xbf]

s_cmp_lt_f32 -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x41,0xbf]

s_cmp_lt_f32 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x41,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_f32 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x41,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_f32 s1, s105
// GFX1150: encoding: [0x01,0x69,0x41,0xbf]

s_cmp_eq_f32 s1, s2
// GFX1150: encoding: [0x01,0x02,0x42,0xbf]

s_cmp_eq_f32 s105, s2
// GFX1150: encoding: [0x69,0x02,0x42,0xbf]

s_cmp_eq_f32 s101, s2
// GFX1150: encoding: [0x65,0x02,0x42,0xbf]

s_cmp_eq_f32 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x42,0xbf]

s_cmp_eq_f32 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x42,0xbf]

s_cmp_eq_f32 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x42,0xbf]

s_cmp_eq_f32 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x42,0xbf]

s_cmp_eq_f32 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x42,0xbf]

s_cmp_eq_f32 0, s2
// GFX1150: encoding: [0x80,0x02,0x42,0xbf]

s_cmp_eq_f32 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x42,0xbf]

s_cmp_eq_f32 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x42,0xbf]

s_cmp_eq_f32 -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x42,0xbf]

s_cmp_eq_f32 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x42,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_f32 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x42,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_f32 s1, s105
// GFX1150: encoding: [0x01,0x69,0x42,0xbf]

s_cmp_le_f32 s1, s2
// GFX1150: encoding: [0x01,0x02,0x43,0xbf]

s_cmp_le_f32 s105, s2
// GFX1150: encoding: [0x69,0x02,0x43,0xbf]

s_cmp_le_f32 s101, s2
// GFX1150: encoding: [0x65,0x02,0x43,0xbf]

s_cmp_le_f32 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x43,0xbf]

s_cmp_le_f32 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x43,0xbf]

s_cmp_le_f32 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x43,0xbf]

s_cmp_le_f32 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x43,0xbf]

s_cmp_le_f32 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x43,0xbf]

s_cmp_le_f32 0, s2
// GFX1150: encoding: [0x80,0x02,0x43,0xbf]

s_cmp_le_f32 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x43,0xbf]

s_cmp_le_f32 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x43,0xbf]

s_cmp_le_f32 -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x43,0xbf]

s_cmp_le_f32 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x43,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_f32 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x43,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_f32 s1, s105
// GFX1150: encoding: [0x01,0x69,0x43,0xbf]

s_cmp_gt_f32 s1, s2
// GFX1150: encoding: [0x01,0x02,0x44,0xbf]

s_cmp_gt_f32 s105, s2
// GFX1150: encoding: [0x69,0x02,0x44,0xbf]

s_cmp_gt_f32 s101, s2
// GFX1150: encoding: [0x65,0x02,0x44,0xbf]

s_cmp_gt_f32 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x44,0xbf]

s_cmp_gt_f32 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x44,0xbf]

s_cmp_gt_f32 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x44,0xbf]

s_cmp_gt_f32 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x44,0xbf]

s_cmp_gt_f32 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x44,0xbf]

s_cmp_gt_f32 0, s2
// GFX1150: encoding: [0x80,0x02,0x44,0xbf]

s_cmp_gt_f32 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x44,0xbf]

s_cmp_gt_f32 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x44,0xbf]

s_cmp_gt_f32 -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x44,0xbf]

s_cmp_gt_f32 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x44,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_f32 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x44,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_f32 s1, s105
// GFX1150: encoding: [0x01,0x69,0x44,0xbf]

s_cmp_lg_f32 s1, s2
// GFX1150: encoding: [0x01,0x02,0x45,0xbf]

s_cmp_lg_f32 s105, s2
// GFX1150: encoding: [0x69,0x02,0x45,0xbf]

s_cmp_lg_f32 s101, s2
// GFX1150: encoding: [0x65,0x02,0x45,0xbf]

s_cmp_lg_f32 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x45,0xbf]

s_cmp_lg_f32 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x45,0xbf]

s_cmp_lg_f32 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x45,0xbf]

s_cmp_lg_f32 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x45,0xbf]

s_cmp_lg_f32 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x45,0xbf]

s_cmp_lg_f32 0, s2
// GFX1150: encoding: [0x80,0x02,0x45,0xbf]

s_cmp_lg_f32 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x45,0xbf]

s_cmp_lg_f32 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x45,0xbf]

s_cmp_lg_f32 -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x45,0xbf]

s_cmp_lg_f32 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x45,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_f32 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x45,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_f32 s1, s105
// GFX1150: encoding: [0x01,0x69,0x45,0xbf]

s_cmp_ge_f32 s1, s2
// GFX1150: encoding: [0x01,0x02,0x46,0xbf]

s_cmp_ge_f32 s105, s2
// GFX1150: encoding: [0x69,0x02,0x46,0xbf]

s_cmp_ge_f32 s101, s2
// GFX1150: encoding: [0x65,0x02,0x46,0xbf]

s_cmp_ge_f32 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x46,0xbf]

s_cmp_ge_f32 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x46,0xbf]

s_cmp_ge_f32 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x46,0xbf]

s_cmp_ge_f32 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x46,0xbf]

s_cmp_ge_f32 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x46,0xbf]

s_cmp_ge_f32 0, s2
// GFX1150: encoding: [0x80,0x02,0x46,0xbf]

s_cmp_ge_f32 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x46,0xbf]

s_cmp_ge_f32 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x46,0xbf]

s_cmp_ge_f32 -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x46,0xbf]

s_cmp_ge_f32 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x46,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_f32 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x46,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_f32 s1, s105
// GFX1150: encoding: [0x01,0x69,0x46,0xbf]

s_cmp_o_f32 s1, s2
// GFX1150: encoding: [0x01,0x02,0x47,0xbf]

s_cmp_o_f32 s105, s2
// GFX1150: encoding: [0x69,0x02,0x47,0xbf]

s_cmp_o_f32 s101, s2
// GFX1150: encoding: [0x65,0x02,0x47,0xbf]

s_cmp_o_f32 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x47,0xbf]

s_cmp_o_f32 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x47,0xbf]

s_cmp_o_f32 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x47,0xbf]

s_cmp_o_f32 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x47,0xbf]

s_cmp_o_f32 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x47,0xbf]

s_cmp_o_f32 0, s2
// GFX1150: encoding: [0x80,0x02,0x47,0xbf]

s_cmp_o_f32 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x47,0xbf]

s_cmp_o_f32 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x47,0xbf]

s_cmp_o_f32 -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x47,0xbf]

s_cmp_o_f32 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x47,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_o_f32 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x47,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_o_f32 s1, s105
// GFX1150: encoding: [0x01,0x69,0x47,0xbf]

s_cmp_u_f32 s1, s2
// GFX1150: encoding: [0x01,0x02,0x48,0xbf]

s_cmp_u_f32 s105, s2
// GFX1150: encoding: [0x69,0x02,0x48,0xbf]

s_cmp_u_f32 s101, s2
// GFX1150: encoding: [0x65,0x02,0x48,0xbf]

s_cmp_u_f32 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x48,0xbf]

s_cmp_u_f32 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x48,0xbf]

s_cmp_u_f32 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x48,0xbf]

s_cmp_u_f32 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x48,0xbf]

s_cmp_u_f32 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x48,0xbf]

s_cmp_u_f32 0, s2
// GFX1150: encoding: [0x80,0x02,0x48,0xbf]

s_cmp_u_f32 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x48,0xbf]

s_cmp_u_f32 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x48,0xbf]

s_cmp_u_f32 -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x48,0xbf]

s_cmp_u_f32 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x48,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_u_f32 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x48,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_u_f32 s1, s105
// GFX1150: encoding: [0x01,0x69,0x48,0xbf]

s_cmp_nge_f32 s1, s2
// GFX1150: encoding: [0x01,0x02,0x49,0xbf]

s_cmp_nge_f32 s105, s2
// GFX1150: encoding: [0x69,0x02,0x49,0xbf]

s_cmp_nge_f32 s101, s2
// GFX1150: encoding: [0x65,0x02,0x49,0xbf]

s_cmp_nge_f32 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x49,0xbf]

s_cmp_nge_f32 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x49,0xbf]

s_cmp_nge_f32 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x49,0xbf]

s_cmp_nge_f32 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x49,0xbf]

s_cmp_nge_f32 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x49,0xbf]

s_cmp_nge_f32 0, s2
// GFX1150: encoding: [0x80,0x02,0x49,0xbf]

s_cmp_nge_f32 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x49,0xbf]

s_cmp_nge_f32 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x49,0xbf]

s_cmp_nge_f32 -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x49,0xbf]

s_cmp_nge_f32 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x49,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_nge_f32 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x49,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_nge_f32 s1, s105
// GFX1150: encoding: [0x01,0x69,0x49,0xbf]

s_cmp_nlg_f32 s1, s2
// GFX1150: encoding: [0x01,0x02,0x4a,0xbf]

s_cmp_nlg_f32 s105, s2
// GFX1150: encoding: [0x69,0x02,0x4a,0xbf]

s_cmp_nlg_f32 s101, s2
// GFX1150: encoding: [0x65,0x02,0x4a,0xbf]

s_cmp_nlg_f32 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x4a,0xbf]

s_cmp_nlg_f32 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x4a,0xbf]

s_cmp_nlg_f32 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x4a,0xbf]

s_cmp_nlg_f32 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x4a,0xbf]

s_cmp_nlg_f32 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x4a,0xbf]

s_cmp_nlg_f32 0, s2
// GFX1150: encoding: [0x80,0x02,0x4a,0xbf]

s_cmp_nlg_f32 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x4a,0xbf]

s_cmp_nlg_f32 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x4a,0xbf]

s_cmp_nlg_f32 -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x4a,0xbf]

s_cmp_nlg_f32 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x4a,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_nlg_f32 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x4a,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_nlg_f32 s1, s105
// GFX1150: encoding: [0x01,0x69,0x4a,0xbf]

s_cmp_ngt_f32 s1, s2
// GFX1150: encoding: [0x01,0x02,0x4b,0xbf]

s_cmp_ngt_f32 s105, s2
// GFX1150: encoding: [0x69,0x02,0x4b,0xbf]

s_cmp_ngt_f32 s101, s2
// GFX1150: encoding: [0x65,0x02,0x4b,0xbf]

s_cmp_ngt_f32 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x4b,0xbf]

s_cmp_ngt_f32 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x4b,0xbf]

s_cmp_ngt_f32 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x4b,0xbf]

s_cmp_ngt_f32 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x4b,0xbf]

s_cmp_ngt_f32 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x4b,0xbf]

s_cmp_ngt_f32 0, s2
// GFX1150: encoding: [0x80,0x02,0x4b,0xbf]

s_cmp_ngt_f32 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x4b,0xbf]

s_cmp_ngt_f32 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x4b,0xbf]

s_cmp_ngt_f32 -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x4b,0xbf]

s_cmp_ngt_f32 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x4b,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ngt_f32 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x4b,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ngt_f32 s1, s105
// GFX1150: encoding: [0x01,0x69,0x4b,0xbf]

s_cmp_nle_f32 s1, s2
// GFX1150: encoding: [0x01,0x02,0x4c,0xbf]

s_cmp_nle_f32 s105, s2
// GFX1150: encoding: [0x69,0x02,0x4c,0xbf]

s_cmp_nle_f32 s101, s2
// GFX1150: encoding: [0x65,0x02,0x4c,0xbf]

s_cmp_nle_f32 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x4c,0xbf]

s_cmp_nle_f32 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x4c,0xbf]

s_cmp_nle_f32 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x4c,0xbf]

s_cmp_nle_f32 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x4c,0xbf]

s_cmp_nle_f32 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x4c,0xbf]

s_cmp_nle_f32 0, s2
// GFX1150: encoding: [0x80,0x02,0x4c,0xbf]

s_cmp_nle_f32 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x4c,0xbf]

s_cmp_nle_f32 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x4c,0xbf]

s_cmp_nle_f32 -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x4c,0xbf]

s_cmp_nle_f32 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x4c,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_nle_f32 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x4c,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_nle_f32 s1, s105
// GFX1150: encoding: [0x01,0x69,0x4c,0xbf]

s_cmp_neq_f32 s1, s2
// GFX1150: encoding: [0x01,0x02,0x4d,0xbf]

s_cmp_neq_f32 s105, s2
// GFX1150: encoding: [0x69,0x02,0x4d,0xbf]

s_cmp_neq_f32 s101, s2
// GFX1150: encoding: [0x65,0x02,0x4d,0xbf]

s_cmp_neq_f32 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x4d,0xbf]

s_cmp_neq_f32 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x4d,0xbf]

s_cmp_neq_f32 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x4d,0xbf]

s_cmp_neq_f32 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x4d,0xbf]

s_cmp_neq_f32 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x4d,0xbf]

s_cmp_neq_f32 0, s2
// GFX1150: encoding: [0x80,0x02,0x4d,0xbf]

s_cmp_neq_f32 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x4d,0xbf]

s_cmp_neq_f32 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x4d,0xbf]

s_cmp_neq_f32 -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x4d,0xbf]

s_cmp_neq_f32 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x4d,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_neq_f32 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x4d,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_neq_f32 s1, s105
// GFX1150: encoding: [0x01,0x69,0x4d,0xbf]

s_cmp_nlt_f32 s1, s2
// GFX1150: encoding: [0x01,0x02,0x4e,0xbf]

s_cmp_nlt_f32 s105, s2
// GFX1150: encoding: [0x69,0x02,0x4e,0xbf]

s_cmp_nlt_f32 s101, s2
// GFX1150: encoding: [0x65,0x02,0x4e,0xbf]

s_cmp_nlt_f32 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x4e,0xbf]

s_cmp_nlt_f32 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x4e,0xbf]

s_cmp_nlt_f32 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x4e,0xbf]

s_cmp_nlt_f32 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x4e,0xbf]

s_cmp_nlt_f32 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x4e,0xbf]

s_cmp_nlt_f32 0, s2
// GFX1150: encoding: [0x80,0x02,0x4e,0xbf]

s_cmp_nlt_f32 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x4e,0xbf]

s_cmp_nlt_f32 0.5, s2
// GFX1150: encoding: [0xf0,0x02,0x4e,0xbf]

s_cmp_nlt_f32 -4.0, s2
// GFX1150: encoding: [0xf7,0x02,0x4e,0xbf]

s_cmp_nlt_f32 0xaf123456, s2
// GFX1150: encoding: [0xff,0x02,0x4e,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_nlt_f32 0x3f717273, s2
// GFX1150: encoding: [0xff,0x02,0x4e,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_nlt_f32 s1, s105
// GFX1150: encoding: [0x01,0x69,0x4e,0xbf]

s_cmp_lt_f16 s1, s2
// GFX1150: encoding: [0x01,0x02,0x51,0xbf]

s_cmp_lt_f16 s101, s2
// GFX1150: encoding: [0x65,0x02,0x51,0xbf]

s_cmp_lt_f16 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x51,0xbf]

s_cmp_lt_f16 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x51,0xbf]

s_cmp_lt_f16 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x51,0xbf]

s_cmp_lt_f16 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x51,0xbf]

s_cmp_lt_f16 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x51,0xbf]

s_cmp_lt_f16 0, s2
// GFX1150: encoding: [0x80,0x02,0x51,0xbf]

s_cmp_lt_f16 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x51,0xbf]

s_cmp_lt_f16 0x3800, s2
// GFX1150: encoding: [0xff,0x02,0x51,0xbf,0x00,0x38,0x00,0x00]

s_cmp_lt_f16 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x51,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_lt_f16 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x51,0xbf,0x56,0x34,0x00,0x00]

s_cmp_eq_f16 s1, s2
// GFX1150: encoding: [0x01,0x02,0x52,0xbf]

s_cmp_eq_f16 s101, s2
// GFX1150: encoding: [0x65,0x02,0x52,0xbf]

s_cmp_eq_f16 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x52,0xbf]

s_cmp_eq_f16 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x52,0xbf]

s_cmp_eq_f16 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x52,0xbf]

s_cmp_eq_f16 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x52,0xbf]

s_cmp_eq_f16 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x52,0xbf]

s_cmp_eq_f16 0, s2
// GFX1150: encoding: [0x80,0x02,0x52,0xbf]

s_cmp_eq_f16 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x52,0xbf]

s_cmp_eq_f16 0x3800, s2
// GFX1150: encoding: [0xff,0x02,0x52,0xbf,0x00,0x38,0x00,0x00]

s_cmp_eq_f16 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x52,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_eq_f16 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x52,0xbf,0x56,0x34,0x00,0x00]

s_cmp_le_f16 s1, s2
// GFX1150: encoding: [0x01,0x02,0x53,0xbf]

s_cmp_le_f16 s101, s2
// GFX1150: encoding: [0x65,0x02,0x53,0xbf]

s_cmp_le_f16 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x53,0xbf]

s_cmp_le_f16 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x53,0xbf]

s_cmp_le_f16 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x53,0xbf]

s_cmp_le_f16 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x53,0xbf]

s_cmp_le_f16 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x53,0xbf]

s_cmp_le_f16 0, s2
// GFX1150: encoding: [0x80,0x02,0x53,0xbf]

s_cmp_le_f16 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x53,0xbf]

s_cmp_le_f16 0x3800, s2
// GFX1150: encoding: [0xff,0x02,0x53,0xbf,0x00,0x38,0x00,0x00]

s_cmp_le_f16 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x53,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_le_f16 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x53,0xbf,0x56,0x34,0x00,0x00]

s_cmp_gt_f16 s1, s2
// GFX1150: encoding: [0x01,0x02,0x54,0xbf]

s_cmp_gt_f16 s101, s2
// GFX1150: encoding: [0x65,0x02,0x54,0xbf]

s_cmp_gt_f16 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x54,0xbf]

s_cmp_gt_f16 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x54,0xbf]

s_cmp_gt_f16 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x54,0xbf]

s_cmp_gt_f16 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x54,0xbf]

s_cmp_gt_f16 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x54,0xbf]

s_cmp_gt_f16 0, s2
// GFX1150: encoding: [0x80,0x02,0x54,0xbf]

s_cmp_gt_f16 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x54,0xbf]

s_cmp_gt_f16 0x3800, s2
// GFX1150: encoding: [0xff,0x02,0x54,0xbf,0x00,0x38,0x00,0x00]

s_cmp_gt_f16 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x54,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_gt_f16 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x54,0xbf,0x56,0x34,0x00,0x00]

s_cmp_lg_f16 s1, s2
// GFX1150: encoding: [0x01,0x02,0x55,0xbf]

s_cmp_lg_f16 s101, s2
// GFX1150: encoding: [0x65,0x02,0x55,0xbf]

s_cmp_lg_f16 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x55,0xbf]

s_cmp_lg_f16 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x55,0xbf]

s_cmp_lg_f16 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x55,0xbf]

s_cmp_lg_f16 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x55,0xbf]

s_cmp_lg_f16 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x55,0xbf]

s_cmp_lg_f16 0, s2
// GFX1150: encoding: [0x80,0x02,0x55,0xbf]

s_cmp_lg_f16 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x55,0xbf]

s_cmp_lg_f16 0x3800, s2
// GFX1150: encoding: [0xff,0x02,0x55,0xbf,0x00,0x38,0x00,0x00]

s_cmp_lg_f16 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x55,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_lg_f16 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x55,0xbf,0x56,0x34,0x00,0x00]

s_cmp_ge_f16 s1, s2
// GFX1150: encoding: [0x01,0x02,0x56,0xbf]

s_cmp_ge_f16 s101, s2
// GFX1150: encoding: [0x65,0x02,0x56,0xbf]

s_cmp_ge_f16 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x56,0xbf]

s_cmp_ge_f16 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x56,0xbf]

s_cmp_ge_f16 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x56,0xbf]

s_cmp_ge_f16 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x56,0xbf]

s_cmp_ge_f16 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x56,0xbf]

s_cmp_ge_f16 0, s2
// GFX1150: encoding: [0x80,0x02,0x56,0xbf]

s_cmp_ge_f16 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x56,0xbf]

s_cmp_ge_f16 0x3800, s2
// GFX1150: encoding: [0xff,0x02,0x56,0xbf,0x00,0x38,0x00,0x00]

s_cmp_ge_f16 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x56,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_ge_f16 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x56,0xbf,0x56,0x34,0x00,0x00]

s_cmp_o_f16 s1, s2
// GFX1150: encoding: [0x01,0x02,0x57,0xbf]

s_cmp_o_f16 s101, s2
// GFX1150: encoding: [0x65,0x02,0x57,0xbf]

s_cmp_o_f16 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x57,0xbf]

s_cmp_o_f16 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x57,0xbf]

s_cmp_o_f16 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x57,0xbf]

s_cmp_o_f16 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x57,0xbf]

s_cmp_o_f16 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x57,0xbf]

s_cmp_o_f16 0, s2
// GFX1150: encoding: [0x80,0x02,0x57,0xbf]

s_cmp_o_f16 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x57,0xbf]

s_cmp_o_f16 0x3800, s2
// GFX1150: encoding: [0xff,0x02,0x57,0xbf,0x00,0x38,0x00,0x00]

s_cmp_o_f16 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x57,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_o_f16 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x57,0xbf,0x56,0x34,0x00,0x00]

s_cmp_u_f16 s1, s2
// GFX1150: encoding: [0x01,0x02,0x58,0xbf]

s_cmp_u_f16 s101, s2
// GFX1150: encoding: [0x65,0x02,0x58,0xbf]

s_cmp_u_f16 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x58,0xbf]

s_cmp_u_f16 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x58,0xbf]

s_cmp_u_f16 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x58,0xbf]

s_cmp_u_f16 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x58,0xbf]

s_cmp_u_f16 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x58,0xbf]

s_cmp_u_f16 0, s2
// GFX1150: encoding: [0x80,0x02,0x58,0xbf]

s_cmp_u_f16 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x58,0xbf]

s_cmp_u_f16 0x3800, s2
// GFX1150: encoding: [0xff,0x02,0x58,0xbf,0x00,0x38,0x00,0x00]

s_cmp_u_f16 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x58,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_u_f16 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x58,0xbf,0x56,0x34,0x00,0x00]

s_cmp_nge_f16 s1, s2
// GFX1150: encoding: [0x01,0x02,0x59,0xbf]

s_cmp_nge_f16 s101, s2
// GFX1150: encoding: [0x65,0x02,0x59,0xbf]

s_cmp_nge_f16 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x59,0xbf]

s_cmp_nge_f16 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x59,0xbf]

s_cmp_nge_f16 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x59,0xbf]

s_cmp_nge_f16 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x59,0xbf]

s_cmp_nge_f16 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x59,0xbf]

s_cmp_nge_f16 0, s2
// GFX1150: encoding: [0x80,0x02,0x59,0xbf]

s_cmp_nge_f16 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x59,0xbf]

s_cmp_nge_f16 0x3800, s2
// GFX1150: encoding: [0xff,0x02,0x59,0xbf,0x00,0x38,0x00,0x00]

s_cmp_nge_f16 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x59,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_nge_f16 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x59,0xbf,0x56,0x34,0x00,0x00]

s_cmp_nlg_f16 s1, s2
// GFX1150: encoding: [0x01,0x02,0x5a,0xbf]

s_cmp_nlg_f16 s101, s2
// GFX1150: encoding: [0x65,0x02,0x5a,0xbf]

s_cmp_nlg_f16 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x5a,0xbf]

s_cmp_nlg_f16 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x5a,0xbf]

s_cmp_nlg_f16 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x5a,0xbf]

s_cmp_nlg_f16 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x5a,0xbf]

s_cmp_nlg_f16 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x5a,0xbf]

s_cmp_nlg_f16 0, s2
// GFX1150: encoding: [0x80,0x02,0x5a,0xbf]

s_cmp_nlg_f16 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x5a,0xbf]

s_cmp_nlg_f16 0x3800, s2
// GFX1150: encoding: [0xff,0x02,0x5a,0xbf,0x00,0x38,0x00,0x00]

s_cmp_nlg_f16 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x5a,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_nlg_f16 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x5a,0xbf,0x56,0x34,0x00,0x00]

s_cmp_ngt_f16 s1, s2
// GFX1150: encoding: [0x01,0x02,0x5b,0xbf]

s_cmp_ngt_f16 s101, s2
// GFX1150: encoding: [0x65,0x02,0x5b,0xbf]

s_cmp_ngt_f16 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x5b,0xbf]

s_cmp_ngt_f16 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x5b,0xbf]

s_cmp_ngt_f16 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x5b,0xbf]

s_cmp_ngt_f16 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x5b,0xbf]

s_cmp_ngt_f16 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x5b,0xbf]

s_cmp_ngt_f16 0, s2
// GFX1150: encoding: [0x80,0x02,0x5b,0xbf]

s_cmp_ngt_f16 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x5b,0xbf]

s_cmp_ngt_f16 0x3800, s2
// GFX1150: encoding: [0xff,0x02,0x5b,0xbf,0x00,0x38,0x00,0x00]

s_cmp_ngt_f16 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x5b,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_ngt_f16 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x5b,0xbf,0x56,0x34,0x00,0x00]

s_cmp_nle_f16 s1, s2
// GFX1150: encoding: [0x01,0x02,0x5c,0xbf]

s_cmp_nle_f16 s101, s2
// GFX1150: encoding: [0x65,0x02,0x5c,0xbf]

s_cmp_nle_f16 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x5c,0xbf]

s_cmp_nle_f16 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x5c,0xbf]

s_cmp_nle_f16 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x5c,0xbf]

s_cmp_nle_f16 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x5c,0xbf]

s_cmp_nle_f16 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x5c,0xbf]

s_cmp_nle_f16 0, s2
// GFX1150: encoding: [0x80,0x02,0x5c,0xbf]

s_cmp_nle_f16 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x5c,0xbf]

s_cmp_nle_f16 0x3800, s2
// GFX1150: encoding: [0xff,0x02,0x5c,0xbf,0x00,0x38,0x00,0x00]

s_cmp_nle_f16 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x5c,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_nle_f16 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x5c,0xbf,0x56,0x34,0x00,0x00]

s_cmp_neq_f16 s1, s2
// GFX1150: encoding: [0x01,0x02,0x5d,0xbf]

s_cmp_neq_f16 s101, s2
// GFX1150: encoding: [0x65,0x02,0x5d,0xbf]

s_cmp_neq_f16 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x5d,0xbf]

s_cmp_neq_f16 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x5d,0xbf]

s_cmp_neq_f16 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x5d,0xbf]

s_cmp_neq_f16 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x5d,0xbf]

s_cmp_neq_f16 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x5d,0xbf]

s_cmp_neq_f16 0, s2
// GFX1150: encoding: [0x80,0x02,0x5d,0xbf]

s_cmp_neq_f16 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x5d,0xbf]

s_cmp_neq_f16 0x3800, s2
// GFX1150: encoding: [0xff,0x02,0x5d,0xbf,0x00,0x38,0x00,0x00]

s_cmp_neq_f16 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x5d,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_neq_f16 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x5d,0xbf,0x56,0x34,0x00,0x00]

s_cmp_nlt_f16 s1, s2
// GFX1150: encoding: [0x01,0x02,0x5e,0xbf]

s_cmp_nlt_f16 s101, s2
// GFX1150: encoding: [0x65,0x02,0x5e,0xbf]

s_cmp_nlt_f16 vcc_lo, s2
// GFX1150: encoding: [0x6a,0x02,0x5e,0xbf]

s_cmp_nlt_f16 vcc_hi, s2
// GFX1150: encoding: [0x6b,0x02,0x5e,0xbf]

s_cmp_nlt_f16 m0, s2
// GFX1150: encoding: [0x7d,0x02,0x5e,0xbf]

s_cmp_nlt_f16 exec_lo, s2
// GFX1150: encoding: [0x7e,0x02,0x5e,0xbf]

s_cmp_nlt_f16 exec_hi, s2
// GFX1150: encoding: [0x7f,0x02,0x5e,0xbf]

s_cmp_nlt_f16 0, s2
// GFX1150: encoding: [0x80,0x02,0x5e,0xbf]

s_cmp_nlt_f16 -1, s2
// GFX1150: encoding: [0xc1,0x02,0x5e,0xbf]

s_cmp_nlt_f16 0x3800, s2
// GFX1150: encoding: [0xff,0x02,0x5e,0xbf,0x00,0x38,0x00,0x00]

s_cmp_nlt_f16 0xfe0b, s2
// GFX1150: encoding: [0xff,0x02,0x5e,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_nlt_f16 0x3456, s2
// GFX1150: encoding: [0xff,0x02,0x5e,0xbf,0x56,0x34,0x00,0x00]
