/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifndef OCEANBASE_SHARE_SYSTEM_VARIABLE_OB_SYS_VAR_CLASS_TYPE_
#define OCEANBASE_SHARE_SYSTEM_VARIABLE_OB_SYS_VAR_CLASS_TYPE_
#include <stdint.h>

namespace oceanbase
{
namespace share
{
enum ObSysVarClassType
{
  SYS_VAR_INVALID = -1,
  SYS_VAR_AUTO_INCREMENT_INCREMENT = 0,
  SYS_VAR_AUTO_INCREMENT_OFFSET = 1,
  SYS_VAR_AUTOCOMMIT = 2,
  SYS_VAR_CHARACTER_SET_CLIENT = 3,
  SYS_VAR_CHARACTER_SET_CONNECTION = 4,
  SYS_VAR_CHARACTER_SET_DATABASE = 5,
  SYS_VAR_CHARACTER_SET_RESULTS = 6,
  SYS_VAR_CHARACTER_SET_SERVER = 7,
  SYS_VAR_CHARACTER_SET_SYSTEM = 8,
  SYS_VAR_COLLATION_CONNECTION = 9,
  SYS_VAR_COLLATION_DATABASE = 10,
  SYS_VAR_COLLATION_SERVER = 11,
  SYS_VAR_INTERACTIVE_TIMEOUT = 12,
  SYS_VAR_LAST_INSERT_ID = 13,
  SYS_VAR_MAX_ALLOWED_PACKET = 14,
  SYS_VAR_SQL_MODE = 15,
  SYS_VAR_TIME_ZONE = 16,
  SYS_VAR_TX_ISOLATION = 17,
  SYS_VAR_VERSION_COMMENT = 18,
  SYS_VAR_WAIT_TIMEOUT = 19,
  SYS_VAR_BINLOG_ROW_IMAGE = 20,
  SYS_VAR_CHARACTER_SET_FILESYSTEM = 21,
  SYS_VAR_CONNECT_TIMEOUT = 22,
  SYS_VAR_DATADIR = 23,
  SYS_VAR_DEBUG_SYNC = 24,
  SYS_VAR_DIV_PRECISION_INCREMENT = 25,
  SYS_VAR_EXPLICIT_DEFAULTS_FOR_TIMESTAMP = 26,
  SYS_VAR_GROUP_CONCAT_MAX_LEN = 27,
  SYS_VAR_IDENTITY = 28,
  SYS_VAR_LOWER_CASE_TABLE_NAMES = 29,
  SYS_VAR_NET_READ_TIMEOUT = 30,
  SYS_VAR_NET_WRITE_TIMEOUT = 31,
  SYS_VAR_READ_ONLY = 32,
  SYS_VAR_SQL_AUTO_IS_NULL = 33,
  SYS_VAR_SQL_SELECT_LIMIT = 34,
  SYS_VAR_TIMESTAMP = 35,
  SYS_VAR_TX_READ_ONLY = 36,
  SYS_VAR_VERSION = 37,
  SYS_VAR_SQL_WARNINGS = 38,
  SYS_VAR_MAX_USER_CONNECTIONS = 39,
  SYS_VAR_INIT_CONNECT = 40,
  SYS_VAR_LICENSE = 41,
  SYS_VAR_NET_BUFFER_LENGTH = 42,
  SYS_VAR_SYSTEM_TIME_ZONE = 43,
  SYS_VAR_QUERY_CACHE_SIZE = 44,
  SYS_VAR_QUERY_CACHE_TYPE = 45,
  SYS_VAR_SQL_QUOTE_SHOW_CREATE = 46,
  SYS_VAR_MAX_SP_RECURSION_DEPTH = 47,
  SYS_VAR_SQL_SAFE_UPDATES = 48,
  SYS_VAR_CONCURRENT_INSERT = 49,
  SYS_VAR_DEFAULT_AUTHENTICATION_PLUGIN = 50,
  SYS_VAR_DISABLED_STORAGE_ENGINES = 51,
  SYS_VAR_ERROR_COUNT = 52,
  SYS_VAR_GENERAL_LOG = 53,
  SYS_VAR_HAVE_OPENSSL = 54,
  SYS_VAR_HAVE_PROFILING = 55,
  SYS_VAR_HAVE_SSL = 56,
  SYS_VAR_HOSTNAME = 57,
  SYS_VAR_LC_MESSAGES = 58,
  SYS_VAR_LOCAL_INFILE = 59,
  SYS_VAR_LOCK_WAIT_TIMEOUT = 60,
  SYS_VAR_LONG_QUERY_TIME = 61,
  SYS_VAR_MAX_CONNECTIONS = 62,
  SYS_VAR_MAX_EXECUTION_TIME = 63,
  SYS_VAR_PROTOCOL_VERSION = 64,
  SYS_VAR_SERVER_ID = 65,
  SYS_VAR_SSL_CA = 66,
  SYS_VAR_SSL_CAPATH = 67,
  SYS_VAR_SSL_CERT = 68,
  SYS_VAR_SSL_CIPHER = 69,
  SYS_VAR_SSL_CRL = 70,
  SYS_VAR_SSL_CRLPATH = 71,
  SYS_VAR_SSL_KEY = 72,
  SYS_VAR_TIME_FORMAT = 73,
  SYS_VAR_TLS_VERSION = 74,
  SYS_VAR_TMP_TABLE_SIZE = 75,
  SYS_VAR_TMPDIR = 76,
  SYS_VAR_UNIQUE_CHECKS = 77,
  SYS_VAR_VERSION_COMPILE_MACHINE = 78,
  SYS_VAR_VERSION_COMPILE_OS = 79,
  SYS_VAR_WARNING_COUNT = 80,
  SYS_VAR_SESSION_TRACK_SCHEMA = 81,
  SYS_VAR_SESSION_TRACK_SYSTEM_VARIABLES = 82,
  SYS_VAR_SESSION_TRACK_STATE_CHANGE = 83,
  SYS_VAR_HAVE_QUERY_CACHE = 84,
  SYS_VAR_QUERY_CACHE_LIMIT = 85,
  SYS_VAR_QUERY_CACHE_MIN_RES_UNIT = 86,
  SYS_VAR_QUERY_CACHE_WLOCK_INVALIDATE = 87,
  SYS_VAR_BINLOG_FORMAT = 88,
  SYS_VAR_BINLOG_CHECKSUM = 89,
  SYS_VAR_BINLOG_ROWS_QUERY_LOG_EVENTS = 90,
  SYS_VAR_LOG_BIN = 91,
  SYS_VAR_SERVER_UUID = 92,
  SYS_VAR_DEFAULT_STORAGE_ENGINE = 93,
  SYS_VAR_CTE_MAX_RECURSION_DEPTH = 94,
  SYS_VAR_REGEXP_STACK_LIMIT = 95,
  SYS_VAR_REGEXP_TIME_LIMIT = 96,
  SYS_VAR_PROFILING = 97,
  SYS_VAR_PROFILING_HISTORY_SIZE = 98,
  SYS_VAR_OB_INTERM_RESULT_MEM_LIMIT = 10001,
  SYS_VAR_OB_PROXY_PARTITION_HIT = 10002,
  SYS_VAR_OB_LOG_LEVEL = 10003,
  SYS_VAR_OB_QUERY_TIMEOUT = 10005,
  SYS_VAR_OB_READ_CONSISTENCY = 10006,
  SYS_VAR_OB_ENABLE_TRANSFORMATION = 10007,
  SYS_VAR_OB_TRX_TIMEOUT = 10008,
  SYS_VAR_OB_ENABLE_PLAN_CACHE = 10009,
  SYS_VAR_OB_ENABLE_INDEX_DIRECT_SELECT = 10010,
  SYS_VAR_OB_PROXY_SET_TRX_EXECUTED = 10011,
  SYS_VAR_OB_ENABLE_AGGREGATION_PUSHDOWN = 10012,
  SYS_VAR_OB_LAST_SCHEMA_VERSION = 10013,
  SYS_VAR_OB_GLOBAL_DEBUG_SYNC = 10014,
  SYS_VAR_OB_PROXY_GLOBAL_VARIABLES_VERSION = 10015,
  SYS_VAR_OB_ENABLE_SHOW_TRACE = 10016,
  SYS_VAR_OB_BNL_JOIN_CACHE_SIZE = 10019,
  SYS_VAR_OB_PROXY_USER_PRIVILEGE = 10020,
  SYS_VAR_OB_ORG_CLUSTER_ID = 10021,
  SYS_VAR_OB_PLAN_CACHE_PERCENTAGE = 10022,
  SYS_VAR_OB_PLAN_CACHE_EVICT_HIGH_PERCENTAGE = 10023,
  SYS_VAR_OB_PLAN_CACHE_EVICT_LOW_PERCENTAGE = 10024,
  SYS_VAR_RECYCLEBIN = 10025,
  SYS_VAR_OB_CAPABILITY_FLAG = 10026,
  SYS_VAR_IS_RESULT_ACCURATE = 10028,
  SYS_VAR_ERROR_ON_OVERLAP_TIME = 10029,
  SYS_VAR_OB_COMPATIBILITY_MODE = 10030,
  SYS_VAR_OB_SQL_WORK_AREA_PERCENTAGE = 10032,
  SYS_VAR_OB_SAFE_WEAK_READ_SNAPSHOT = 10033,
  SYS_VAR_OB_ROUTE_POLICY = 10034,
  SYS_VAR_OB_ENABLE_TRANSMISSION_CHECKSUM = 10035,
  SYS_VAR_FOREIGN_KEY_CHECKS = 10036,
  SYS_VAR_OB_STATEMENT_TRACE_ID = 10037,
  SYS_VAR_OB_ENABLE_TRUNCATE_FLASHBACK = 10038,
  SYS_VAR_OB_TCP_INVITED_NODES = 10039,
  SYS_VAR_SQL_THROTTLE_CURRENT_PRIORITY = 10040,
  SYS_VAR_SQL_THROTTLE_PRIORITY = 10041,
  SYS_VAR_SQL_THROTTLE_RT = 10042,
  SYS_VAR_SQL_THROTTLE_CPU = 10043,
  SYS_VAR_SQL_THROTTLE_IO = 10044,
  SYS_VAR_SQL_THROTTLE_NETWORK = 10045,
  SYS_VAR_SQL_THROTTLE_LOGICAL_READS = 10046,
  SYS_VAR_AUTO_INCREMENT_CACHE_SIZE = 10047,
  SYS_VAR_OB_ENABLE_JIT = 10048,
  SYS_VAR_OB_TEMP_TABLESPACE_SIZE_PERCENTAGE = 10049,
  SYS_VAR_PLUGIN_DIR = 10052,
  SYS_VAR_OB_SQL_AUDIT_PERCENTAGE = 10055,
  SYS_VAR_OB_ENABLE_SQL_AUDIT = 10056,
  SYS_VAR_OPTIMIZER_USE_SQL_PLAN_BASELINES = 10057,
  SYS_VAR_OPTIMIZER_CAPTURE_SQL_PLAN_BASELINES = 10058,
  SYS_VAR_PARALLEL_SERVERS_TARGET = 10060,
  SYS_VAR_OB_EARLY_LOCK_RELEASE = 10061,
  SYS_VAR_OB_TRX_IDLE_TIMEOUT = 10062,
  SYS_VAR_BLOCK_ENCRYPTION_MODE = 10063,
  SYS_VAR_NLS_DATE_FORMAT = 10064,
  SYS_VAR_NLS_TIMESTAMP_FORMAT = 10065,
  SYS_VAR_NLS_TIMESTAMP_TZ_FORMAT = 10066,
  SYS_VAR_OB_RESERVED_META_MEMORY_PERCENTAGE = 10067,
  SYS_VAR_OB_CHECK_SYS_VARIABLE = 10068,
  SYS_VAR_NLS_LANGUAGE = 10069,
  SYS_VAR_NLS_TERRITORY = 10070,
  SYS_VAR_NLS_SORT = 10071,
  SYS_VAR_NLS_COMP = 10072,
  SYS_VAR_NLS_CHARACTERSET = 10073,
  SYS_VAR_NLS_NCHAR_CHARACTERSET = 10074,
  SYS_VAR_NLS_DATE_LANGUAGE = 10075,
  SYS_VAR_NLS_LENGTH_SEMANTICS = 10076,
  SYS_VAR_NLS_NCHAR_CONV_EXCP = 10077,
  SYS_VAR_NLS_CALENDAR = 10078,
  SYS_VAR_NLS_NUMERIC_CHARACTERS = 10079,
  SYS_VAR__NLJ_BATCHING_ENABLED = 10080,
  SYS_VAR_TRACEFILE_IDENTIFIER = 10081,
  SYS_VAR__GROUPBY_NOPUSHDOWN_CUT_RATIO = 10082,
  SYS_VAR__PX_BROADCAST_FUDGE_FACTOR = 10083,
  SYS_VAR_TRANSACTION_ISOLATION = 10085,
  SYS_VAR_OB_TRX_LOCK_TIMEOUT = 10086,
  SYS_VAR_VALIDATE_PASSWORD_CHECK_USER_NAME = 10087,
  SYS_VAR_VALIDATE_PASSWORD_LENGTH = 10088,
  SYS_VAR_VALIDATE_PASSWORD_MIXED_CASE_COUNT = 10089,
  SYS_VAR_VALIDATE_PASSWORD_NUMBER_COUNT = 10090,
  SYS_VAR_VALIDATE_PASSWORD_POLICY = 10091,
  SYS_VAR_VALIDATE_PASSWORD_SPECIAL_CHAR_COUNT = 10092,
  SYS_VAR_DEFAULT_PASSWORD_LIFETIME = 10093,
  SYS_VAR__OB_OLS_POLICY_SESSION_LABELS = 10094,
  SYS_VAR_OB_TRACE_INFO = 10095,
  SYS_VAR__PX_PARTITION_SCAN_THRESHOLD = 10097,
  SYS_VAR__OB_PX_BCAST_OPTIMIZATION = 10098,
  SYS_VAR__OB_PX_SLAVE_MAPPING_THRESHOLD = 10099,
  SYS_VAR__ENABLE_PARALLEL_DML = 10100,
  SYS_VAR__PX_MIN_GRANULES_PER_SLAVE = 10101,
  SYS_VAR_SECURE_FILE_PRIV = 10102,
  SYS_VAR_PLSQL_WARNINGS = 10103,
  SYS_VAR__ENABLE_PARALLEL_QUERY = 10104,
  SYS_VAR__FORCE_PARALLEL_QUERY_DOP = 10105,
  SYS_VAR__FORCE_PARALLEL_DML_DOP = 10106,
  SYS_VAR_OB_PL_BLOCK_TIMEOUT = 10107,
  SYS_VAR_TRANSACTION_READ_ONLY = 10108,
  SYS_VAR_RESOURCE_MANAGER_PLAN = 10109,
  SYS_VAR_PERFORMANCE_SCHEMA = 10110,
  SYS_VAR_NLS_CURRENCY = 10111,
  SYS_VAR_NLS_ISO_CURRENCY = 10112,
  SYS_VAR_NLS_DUAL_CURRENCY = 10113,
  SYS_VAR_PLSQL_CCFLAGS = 10115,
  SYS_VAR__OB_PROXY_SESSION_TEMPORARY_TABLE_USED = 10116,
  SYS_VAR__ENABLE_PARALLEL_DDL = 10117,
  SYS_VAR__FORCE_PARALLEL_DDL_DOP = 10118,
  SYS_VAR_CURSOR_SHARING = 10119,
  SYS_VAR__OPTIMIZER_NULL_AWARE_ANTIJOIN = 10120,
  SYS_VAR__PX_PARTIAL_ROLLUP_PUSHDOWN = 10121,
  SYS_VAR__PX_DIST_AGG_PARTIAL_ROLLUP_PUSHDOWN = 10122,
  SYS_VAR__CREATE_AUDIT_PURGE_JOB = 10123,
  SYS_VAR__DROP_AUDIT_PURGE_JOB = 10124,
  SYS_VAR__SET_PURGE_JOB_INTERVAL = 10125,
  SYS_VAR__SET_PURGE_JOB_STATUS = 10126,
  SYS_VAR__SET_LAST_ARCHIVE_TIMESTAMP = 10127,
  SYS_VAR__CLEAR_LAST_ARCHIVE_TIMESTAMP = 10128,
  SYS_VAR__AGGREGATION_OPTIMIZATION_SETTINGS = 10129,
  SYS_VAR__PX_SHARED_HASH_JOIN = 10130,
  SYS_VAR_SQL_NOTES = 10131,
  SYS_VAR_INNODB_STRICT_MODE = 10132,
  SYS_VAR__WINDOWFUNC_OPTIMIZATION_SETTINGS = 10133,
  SYS_VAR_OB_ENABLE_RICH_ERROR_MSG = 10134,
  SYS_VAR_LOG_ROW_VALUE_OPTIONS = 10136,
  SYS_VAR_OB_MAX_READ_STALE_TIME = 10137,
  SYS_VAR__OPTIMIZER_GATHER_STATS_ON_LOAD = 10138,
  SYS_VAR__SET_REVERSE_DBLINK_INFOS = 10139,
  SYS_VAR__FORCE_ORDER_PRESERVE_SET = 10140,
  SYS_VAR__SHOW_DDL_IN_COMPAT_MODE = 10141,
  SYS_VAR_PARALLEL_DEGREE_POLICY = 10142,
  SYS_VAR_PARALLEL_DEGREE_LIMIT = 10143,
  SYS_VAR_PARALLEL_MIN_SCAN_TIME_THRESHOLD = 10144,
  SYS_VAR_OPTIMIZER_DYNAMIC_SAMPLING = 10145,
  SYS_VAR_RUNTIME_FILTER_TYPE = 10146,
  SYS_VAR_RUNTIME_FILTER_WAIT_TIME_MS = 10147,
  SYS_VAR_RUNTIME_FILTER_MAX_IN_NUM = 10148,
  SYS_VAR_RUNTIME_BLOOM_FILTER_MAX_SIZE = 10149,
  SYS_VAR_OPTIMIZER_FEATURES_ENABLE = 10150,
  SYS_VAR__OB_PROXY_WEAKREAD_FEEDBACK = 10151,
  SYS_VAR_NCHARACTER_SET_CONNECTION = 10152,
  SYS_VAR_AUTOMATIC_SP_PRIVILEGES = 10153,
  SYS_VAR_PRIVILEGE_FEATURES_ENABLE = 10154,
  SYS_VAR__PRIV_CONTROL = 10155,
  SYS_VAR__ENABLE_MYSQL_PL_PRIV_CHECK = 10156,
  SYS_VAR_OB_ENABLE_PL_CACHE = 10157,
  SYS_VAR_OB_DEFAULT_LOB_INROW_THRESHOLD = 10158,
  SYS_VAR__ENABLE_STORAGE_CARDINALITY_ESTIMATION = 10159,
  SYS_VAR_LC_TIME_NAMES = 10160,
  SYS_VAR_ACTIVATE_ALL_ROLES_ON_LOGIN = 10161,
  SYS_VAR__ENABLE_RICH_VECTOR_FORMAT = 10162,
  SYS_VAR_INNODB_STATS_PERSISTENT = 10163,
  SYS_VAR_DEBUG = 10164,
  SYS_VAR_INNODB_CHANGE_BUFFERING_DEBUG = 10165,
  SYS_VAR_INNODB_COMPRESS_DEBUG = 10166,
  SYS_VAR_INNODB_DISABLE_RESIZE_BUFFER_POOL_DEBUG = 10167,
  SYS_VAR_INNODB_FIL_MAKE_PAGE_DIRTY_DEBUG = 10168,
  SYS_VAR_INNODB_LIMIT_OPTIMISTIC_INSERT_DEBUG = 10169,
  SYS_VAR_INNODB_MERGE_THRESHOLD_SET_ALL_DEBUG = 10170,
  SYS_VAR_INNODB_SAVED_PAGE_NUMBER_DEBUG = 10171,
  SYS_VAR_INNODB_TRX_PURGE_VIEW_UPDATE_ONLY_DEBUG = 10172,
  SYS_VAR_INNODB_TRX_RSEG_N_SLOTS_DEBUG = 10173,
  SYS_VAR_STORED_PROGRAM_CACHE = 10174,
  SYS_VAR_OB_COMPATIBILITY_CONTROL = 10175,
  SYS_VAR_OB_COMPATIBILITY_VERSION = 10176,
  SYS_VAR_OB_SECURITY_VERSION = 10177,
  SYS_VAR_CARDINALITY_ESTIMATION_MODEL = 10178,
  SYS_VAR_QUERY_REWRITE_ENABLED = 10179,
  SYS_VAR_QUERY_REWRITE_INTEGRITY = 10180,
  SYS_VAR_FLUSH = 10181,
  SYS_VAR_FLUSH_TIME = 10182,
  SYS_VAR_INNODB_ADAPTIVE_FLUSHING = 10183,
  SYS_VAR_INNODB_ADAPTIVE_FLUSHING_LWM = 10184,
  SYS_VAR_INNODB_ADAPTIVE_HASH_INDEX = 10185,
  SYS_VAR_INNODB_ADAPTIVE_HASH_INDEX_PARTS = 10186,
  SYS_VAR_INNODB_ADAPTIVE_MAX_SLEEP_DELAY = 10187,
  SYS_VAR_INNODB_AUTOEXTEND_INCREMENT = 10188,
  SYS_VAR_INNODB_BACKGROUND_DROP_LIST_EMPTY = 10189,
  SYS_VAR_INNODB_BUFFER_POOL_DUMP_AT_SHUTDOWN = 10190,
  SYS_VAR_INNODB_BUFFER_POOL_DUMP_NOW = 10191,
  SYS_VAR_INNODB_BUFFER_POOL_DUMP_PCT = 10192,
  SYS_VAR_INNODB_BUFFER_POOL_FILENAME = 10193,
  SYS_VAR_INNODB_BUFFER_POOL_LOAD_ABORT = 10194,
  SYS_VAR_INNODB_BUFFER_POOL_LOAD_NOW = 10195,
  SYS_VAR_INNODB_BUFFER_POOL_SIZE = 10196,
  SYS_VAR_INNODB_CHANGE_BUFFER_MAX_SIZE = 10197,
  SYS_VAR_INNODB_CHANGE_BUFFERING = 10198,
  SYS_VAR_INNODB_CHECKSUM_ALGORITHM = 10199,
  SYS_VAR_INNODB_CMP_PER_INDEX_ENABLED = 10200,
  SYS_VAR_INNODB_COMMIT_CONCURRENCY = 10201,
  SYS_VAR_INNODB_COMPRESSION_FAILURE_THRESHOLD_PCT = 10202,
  SYS_VAR_INNODB_COMPRESSION_LEVEL = 10203,
  SYS_VAR_INNODB_COMPRESSION_PAD_PCT_MAX = 10204,
  SYS_VAR_INNODB_CONCURRENCY_TICKETS = 10205,
  SYS_VAR_INNODB_DEFAULT_ROW_FORMAT = 10206,
  SYS_VAR_INNODB_DISABLE_SORT_FILE_CACHE = 10207,
  SYS_VAR_INNODB_FILE_FORMAT = 10208,
  SYS_VAR_INNODB_FILE_FORMAT_MAX = 10209,
  SYS_VAR_INNODB_FILE_PER_TABLE = 10210,
  SYS_VAR_INNODB_FILL_FACTOR = 10211,
  SYS_VAR_INNODB_FLUSH_NEIGHBORS = 10212,
  SYS_VAR_INNODB_FLUSH_SYNC = 10213,
  SYS_VAR_INNODB_FLUSHING_AVG_LOOPS = 10214,
  SYS_VAR_INNODB_LRU_SCAN_DEPTH = 10215,
  SYS_VAR_INNODB_MAX_DIRTY_PAGES_PCT = 10216,
  SYS_VAR_INNODB_MAX_DIRTY_PAGES_PCT_LWM = 10217,
  SYS_VAR_INNODB_MAX_PURGE_LAG = 10218,
  SYS_VAR_INNODB_MAX_PURGE_LAG_DELAY = 10219,
  SYS_VAR_HAVE_SYMLINK = 10220,
  SYS_VAR_IGNORE_BUILTIN_INNODB = 10221,
  SYS_VAR_INNODB_BUFFER_POOL_CHUNK_SIZE = 10222,
  SYS_VAR_INNODB_BUFFER_POOL_INSTANCES = 10223,
  SYS_VAR_INNODB_BUFFER_POOL_LOAD_AT_STARTUP = 10224,
  SYS_VAR_INNODB_CHECKSUMS = 10225,
  SYS_VAR_INNODB_DOUBLEWRITE = 10226,
  SYS_VAR_INNODB_FILE_FORMAT_CHECK = 10227,
  SYS_VAR_INNODB_FLUSH_METHOD = 10228,
  SYS_VAR_INNODB_FORCE_LOAD_CORRUPTED = 10229,
  SYS_VAR_INNODB_PAGE_SIZE = 10230,
  SYS_VAR_INNODB_VERSION = 10231,
  SYS_VAR_MYISAM_MMAP_SIZE = 10232,
  SYS_VAR_TABLE_OPEN_CACHE_INSTANCES = 10233,
  SYS_VAR_GTID_EXECUTED = 10234,
  SYS_VAR_GTID_OWNED = 10235,
  SYS_VAR_INNODB_ROLLBACK_ON_TIMEOUT = 10236,
  SYS_VAR_COMPLETION_TYPE = 10237,
  SYS_VAR_ENFORCE_GTID_CONSISTENCY = 10238,
  SYS_VAR_GTID_EXECUTED_COMPRESSION_PERIOD = 10239,
  SYS_VAR_GTID_MODE = 10240,
  SYS_VAR_GTID_NEXT = 10241,
  SYS_VAR_GTID_PURGED = 10242,
  SYS_VAR_INNODB_API_BK_COMMIT_INTERVAL = 10243,
  SYS_VAR_INNODB_API_TRX_LEVEL = 10244,
  SYS_VAR_INNODB_SUPPORT_XA = 10245,
  SYS_VAR_SESSION_TRACK_GTIDS = 10246,
  SYS_VAR_SESSION_TRACK_TRANSACTION_INFO = 10247,
  SYS_VAR_TRANSACTION_ALLOC_BLOCK_SIZE = 10248,
  SYS_VAR_TRANSACTION_ALLOW_BATCHING = 10249,
  SYS_VAR_TRANSACTION_PREALLOC_SIZE = 10250,
  SYS_VAR_TRANSACTION_WRITE_SET_EXTRACTION = 10251,
  SYS_VAR_INFORMATION_SCHEMA_STATS_EXPIRY = 10252,
  SYS_VAR__ORACLE_SQL_SELECT_LIMIT = 10253,
  SYS_VAR_GROUP_REPLICATION_ALLOW_LOCAL_DISJOINT_GTIDS_JOIN = 10254,
  SYS_VAR_GROUP_REPLICATION_ALLOW_LOCAL_LOWER_VERSION_JOIN = 10255,
  SYS_VAR_GROUP_REPLICATION_AUTO_INCREMENT_INCREMENT = 10256,
  SYS_VAR_GROUP_REPLICATION_BOOTSTRAP_GROUP = 10257,
  SYS_VAR_GROUP_REPLICATION_COMPONENTS_STOP_TIMEOUT = 10258,
  SYS_VAR_GROUP_REPLICATION_COMPRESSION_THRESHOLD = 10259,
  SYS_VAR_GROUP_REPLICATION_ENFORCE_UPDATE_EVERYWHERE_CHECKS = 10260,
  SYS_VAR_GROUP_REPLICATION_EXIT_STATE_ACTION = 10261,
  SYS_VAR_GROUP_REPLICATION_FLOW_CONTROL_APPLIER_THRESHOLD = 10262,
  SYS_VAR_GROUP_REPLICATION_FLOW_CONTROL_CERTIFIER_THRESHOLD = 10263,
  SYS_VAR_GROUP_REPLICATION_FLOW_CONTROL_MODE = 10264,
  SYS_VAR_GROUP_REPLICATION_FORCE_MEMBERS = 10265,
  SYS_VAR_GROUP_REPLICATION_GROUP_NAME = 10266,
  SYS_VAR_GROUP_REPLICATION_GTID_ASSIGNMENT_BLOCK_SIZE = 10267,
  SYS_VAR_GROUP_REPLICATION_IP_WHITELIST = 10268,
  SYS_VAR_GROUP_REPLICATION_LOCAL_ADDRESS = 10269,
  SYS_VAR_GROUP_REPLICATION_MEMBER_WEIGHT = 10270,
  SYS_VAR_GROUP_REPLICATION_POLL_SPIN_LOOPS = 10271,
  SYS_VAR_GROUP_REPLICATION_RECOVERY_COMPLETE_AT = 10272,
  SYS_VAR_GROUP_REPLICATION_RECOVERY_RECONNECT_INTERVAL = 10273,
  SYS_VAR_GROUP_REPLICATION_RECOVERY_RETRY_COUNT = 10274,
  SYS_VAR_GROUP_REPLICATION_RECOVERY_SSL_CA = 10275,
  SYS_VAR_GROUP_REPLICATION_RECOVERY_SSL_CAPATH = 10276,
  SYS_VAR_GROUP_REPLICATION_RECOVERY_SSL_CERT = 10277,
  SYS_VAR_GROUP_REPLICATION_RECOVERY_SSL_CIPHER = 10278,
  SYS_VAR_GROUP_REPLICATION_RECOVERY_SSL_CRL = 10279,
  SYS_VAR_GROUP_REPLICATION_RECOVERY_SSL_CRLPATH = 10280,
  SYS_VAR_GROUP_REPLICATION_RECOVERY_SSL_KEY = 10281,
  SYS_VAR_GROUP_REPLICATION_RECOVERY_SSL_VERIFY_SERVER_CERT = 10282,
  SYS_VAR_GROUP_REPLICATION_RECOVERY_USE_SSL = 10283,
  SYS_VAR_GROUP_REPLICATION_SINGLE_PRIMARY_MODE = 10284,
  SYS_VAR_GROUP_REPLICATION_SSL_MODE = 10285,
  SYS_VAR_GROUP_REPLICATION_START_ON_BOOT = 10286,
  SYS_VAR_GROUP_REPLICATION_TRANSACTION_SIZE_LIMIT = 10287,
  SYS_VAR_GROUP_REPLICATION_UNREACHABLE_MAJORITY_TIMEOUT = 10288,
  SYS_VAR_INNODB_REPLICATION_DELAY = 10289,
  SYS_VAR_MASTER_INFO_REPOSITORY = 10290,
  SYS_VAR_MASTER_VERIFY_CHECKSUM = 10291,
  SYS_VAR_PSEUDO_SLAVE_MODE = 10292,
  SYS_VAR_PSEUDO_THREAD_ID = 10293,
  SYS_VAR_RBR_EXEC_MODE = 10294,
  SYS_VAR_REPLICATION_OPTIMIZE_FOR_STATIC_PLUGIN_CONFIG = 10295,
  SYS_VAR_REPLICATION_SENDER_OBSERVE_COMMIT_ONLY = 10296,
  SYS_VAR_RPL_SEMI_SYNC_MASTER_ENABLED = 10297,
  SYS_VAR_RPL_SEMI_SYNC_MASTER_TIMEOUT = 10298,
  SYS_VAR_RPL_SEMI_SYNC_MASTER_TRACE_LEVEL = 10299,
  SYS_VAR_RPL_SEMI_SYNC_MASTER_WAIT_FOR_SLAVE_COUNT = 10300,
  SYS_VAR_RPL_SEMI_SYNC_MASTER_WAIT_NO_SLAVE = 10301,
  SYS_VAR_RPL_SEMI_SYNC_MASTER_WAIT_POINT = 10302,
  SYS_VAR_RPL_SEMI_SYNC_SLAVE_ENABLED = 10303,
  SYS_VAR_RPL_SEMI_SYNC_SLAVE_TRACE_LEVEL = 10304,
  SYS_VAR_RPL_STOP_SLAVE_TIMEOUT = 10305,
  SYS_VAR_SLAVE_ALLOW_BATCHING = 10306,
  SYS_VAR_SLAVE_CHECKPOINT_GROUP = 10307,
  SYS_VAR_SLAVE_CHECKPOINT_PERIOD = 10308,
  SYS_VAR_SLAVE_COMPRESSED_PROTOCOL = 10309,
  SYS_VAR_SLAVE_EXEC_MODE = 10310,
  SYS_VAR_SLAVE_MAX_ALLOWED_PACKET = 10311,
  SYS_VAR_SLAVE_NET_TIMEOUT = 10312,
  SYS_VAR_SLAVE_PARALLEL_TYPE = 10313,
  SYS_VAR_SLAVE_PARALLEL_WORKERS = 10314,
  SYS_VAR_SLAVE_PENDING_JOBS_SIZE_MAX = 10315,
  SYS_VAR_SLAVE_PRESERVE_COMMIT_ORDER = 10316,
  SYS_VAR_SLAVE_SQL_VERIFY_CHECKSUM = 10317,
  SYS_VAR_SLAVE_TRANSACTION_RETRIES = 10318,
  SYS_VAR_SQL_SLAVE_SKIP_COUNTER = 10319,
  SYS_VAR_INNODB_FORCE_RECOVERY = 10320,
  SYS_VAR_SKIP_SLAVE_START = 10321,
  SYS_VAR_SLAVE_LOAD_TMPDIR = 10322,
  SYS_VAR_SLAVE_SKIP_ERRORS = 10323,
  SYS_VAR_INNODB_SYNC_DEBUG = 10324,
  SYS_VAR_DEFAULT_COLLATION_FOR_UTF8MB4 = 10325,
  SYS_VAR__ENABLE_OLD_CHARSET_AGGREGATION = 10326,
  SYS_VAR_ENABLE_SQL_PLAN_MONITOR = 10327,
  SYS_VAR_INSERT_ID = 10328,
  SYS_VAR_JOIN_BUFFER_SIZE = 10329,
  SYS_VAR_MAX_JOIN_SIZE = 10330,
  SYS_VAR_MAX_LENGTH_FOR_SORT_DATA = 10331,
  SYS_VAR_MAX_PREPARED_STMT_COUNT = 10332,
  SYS_VAR_MAX_SORT_LENGTH = 10333,
  SYS_VAR_MIN_EXAMINED_ROW_LIMIT = 10334,
  SYS_VAR_MULTI_RANGE_COUNT = 10335,
  SYS_VAR_MYSQLX_CONNECT_TIMEOUT = 10336,
  SYS_VAR_MYSQLX_IDLE_WORKER_THREAD_TIMEOUT = 10337,
  SYS_VAR_MYSQLX_MAX_ALLOWED_PACKET = 10338,
  SYS_VAR_MYSQLX_MAX_CONNECTIONS = 10339,
  SYS_VAR_MYSQLX_MIN_WORKER_THREADS = 10340,
  SYS_VAR_PERFORMANCE_SCHEMA_SHOW_PROCESSLIST = 10341,
  SYS_VAR_QUERY_ALLOC_BLOCK_SIZE = 10342,
  SYS_VAR_QUERY_PREALLOC_SIZE = 10343,
  SYS_VAR_SLOW_QUERY_LOG = 10344,
  SYS_VAR_SLOW_QUERY_LOG_FILE = 10345,
  SYS_VAR_SORT_BUFFER_SIZE = 10346,
  SYS_VAR_SQL_BUFFER_RESULT = 10347,
  SYS_VAR_BINLOG_CACHE_SIZE = 10348,
  SYS_VAR_BINLOG_DIRECT_NON_TRANSACTIONAL_UPDATES = 10349,
  SYS_VAR_BINLOG_ERROR_ACTION = 10350,
  SYS_VAR_BINLOG_GROUP_COMMIT_SYNC_DELAY = 10351,
  SYS_VAR_BINLOG_GROUP_COMMIT_SYNC_NO_DELAY_COUNT = 10352,
  SYS_VAR_BINLOG_MAX_FLUSH_QUEUE_TIME = 10353,
  SYS_VAR_BINLOG_ORDER_COMMITS = 10354,
  SYS_VAR_BINLOG_STMT_CACHE_SIZE = 10355,
  SYS_VAR_BINLOG_TRANSACTION_DEPENDENCY_HISTORY_SIZE = 10356,
  SYS_VAR_BINLOG_TRANSACTION_DEPENDENCY_TRACKING = 10357,
  SYS_VAR_EXPIRE_LOGS_DAYS = 10358,
  SYS_VAR_INNODB_FLUSH_LOG_AT_TIMEOUT = 10359,
  SYS_VAR_INNODB_FLUSH_LOG_AT_TRX_COMMIT = 10360,
  SYS_VAR_INNODB_LOG_CHECKPOINT_NOW = 10361,
  SYS_VAR_INNODB_LOG_CHECKSUMS = 10362,
  SYS_VAR_INNODB_LOG_COMPRESSED_PAGES = 10363,
  SYS_VAR_INNODB_LOG_WRITE_AHEAD_SIZE = 10364,
  SYS_VAR_INNODB_MAX_UNDO_LOG_SIZE = 10365,
  SYS_VAR_INNODB_ONLINE_ALTER_LOG_MAX_SIZE = 10366,
  SYS_VAR_INNODB_UNDO_LOG_TRUNCATE = 10367,
  SYS_VAR_INNODB_UNDO_LOGS = 10368,
  SYS_VAR_LOG_BIN_TRUST_FUNCTION_CREATORS = 10369,
  SYS_VAR_LOG_BIN_USE_V1_ROW_EVENTS = 10370,
  SYS_VAR_LOG_BUILTIN_AS_IDENTIFIED_BY_PASSWORD = 10371,
  SYS_VAR_MAX_BINLOG_CACHE_SIZE = 10372,
  SYS_VAR_MAX_BINLOG_SIZE = 10373,
  SYS_VAR_MAX_BINLOG_STMT_CACHE_SIZE = 10374,
  SYS_VAR_MAX_RELAY_LOG_SIZE = 10375,
  SYS_VAR_RELAY_LOG_INFO_REPOSITORY = 10376,
  SYS_VAR_RELAY_LOG_PURGE = 10377,
  SYS_VAR_SYNC_BINLOG = 10378,
  SYS_VAR_SYNC_RELAY_LOG = 10379,
  SYS_VAR_SYNC_RELAY_LOG_INFO = 10380,
  SYS_VAR_INNODB_DEADLOCK_DETECT = 10381,
  SYS_VAR_INNODB_LOCK_WAIT_TIMEOUT = 10382,
  SYS_VAR_INNODB_PRINT_ALL_DEADLOCKS = 10383,
  SYS_VAR_INNODB_TABLE_LOCKS = 10384,
  SYS_VAR_MAX_WRITE_LOCK_COUNT = 10385,
  SYS_VAR__OB_ENABLE_ROLE_IDS = 10386,
  SYS_VAR_INNODB_READ_ONLY = 10387,
  SYS_VAR_INNODB_API_DISABLE_ROWLOCK = 10388,
  SYS_VAR_INNODB_AUTOINC_LOCK_MODE = 10389,
  SYS_VAR_SKIP_EXTERNAL_LOCKING = 10390,
  SYS_VAR_SUPER_READ_ONLY = 10391,
  SYS_VAR_PLSQL_OPTIMIZE_LEVEL = 10393,
  SYS_VAR_LOW_PRIORITY_UPDATES = 10394,
  SYS_VAR_MAX_ERROR_COUNT = 10395,
  SYS_VAR_MAX_INSERT_DELAYED_THREADS = 10396,
  SYS_VAR_FT_STOPWORD_FILE = 10397,
  SYS_VAR_INNODB_FT_CACHE_SIZE = 10398,
  SYS_VAR_INNODB_FT_SORT_PLL_DEGREE = 10399,
  SYS_VAR_INNODB_FT_TOTAL_CACHE_SIZE = 10400,
  SYS_VAR_MECAB_RC_FILE = 10401,
  SYS_VAR_METADATA_LOCKS_CACHE_SIZE = 10402,
  SYS_VAR_METADATA_LOCKS_HASH_INSTANCES = 10403,
  SYS_VAR_INNODB_TEMP_DATA_FILE_PATH = 10404,
  SYS_VAR_INNODB_DATA_FILE_PATH = 10405,
  SYS_VAR_INNODB_DATA_HOME_DIR = 10406,
  SYS_VAR_AVOID_TEMPORAL_UPGRADE = 10407,
  SYS_VAR_DEFAULT_TMP_STORAGE_ENGINE = 10408,
  SYS_VAR_INNODB_FT_ENABLE_DIAG_PRINT = 10409,
  SYS_VAR_INNODB_FT_NUM_WORD_OPTIMIZE = 10410,
  SYS_VAR_INNODB_FT_RESULT_CACHE_LIMIT = 10411,
  SYS_VAR_INNODB_FT_SERVER_STOPWORD_TABLE = 10412,
  SYS_VAR_INNODB_OPTIMIZE_FULLTEXT_ONLY = 10413,
  SYS_VAR_MAX_TMP_TABLES = 10414,
  SYS_VAR_INNODB_TMPDIR = 10415,
  SYS_VAR_GROUP_REPLICATION_GROUP_SEEDS = 10416,
  SYS_VAR_SLAVE_ROWS_SEARCH_ALGORITHMS = 10417,
  SYS_VAR_SLAVE_TYPE_CONVERSIONS = 10418,
  SYS_VAR_OB_HNSW_EF_SEARCH = 10419,
  SYS_VAR_NDB_ALLOW_COPYING_ALTER_TABLE = 10420,
  SYS_VAR_NDB_AUTOINCREMENT_PREFETCH_SZ = 10421,
  SYS_VAR_NDB_BLOB_READ_BATCH_BYTES = 10422,
  SYS_VAR_NDB_BLOB_WRITE_BATCH_BYTES = 10423,
  SYS_VAR_NDB_CACHE_CHECK_TIME = 10424,
  SYS_VAR_NDB_CLEAR_APPLY_STATUS = 10425,
  SYS_VAR_NDB_DATA_NODE_NEIGHBOUR = 10426,
  SYS_VAR_NDB_DEFAULT_COLUMN_FORMAT = 10427,
  SYS_VAR_NDB_DEFERRED_CONSTRAINTS = 10428,
  SYS_VAR_NDB_DISTRIBUTION = 10429,
  SYS_VAR_NDB_EVENTBUFFER_FREE_PERCENT = 10430,
  SYS_VAR_NDB_EVENTBUFFER_MAX_ALLOC = 10431,
  SYS_VAR_NDB_EXTRA_LOGGING = 10432,
  SYS_VAR_NDB_FORCE_SEND = 10433,
  SYS_VAR_NDB_FULLY_REPLICATED = 10434,
  SYS_VAR_NDB_INDEX_STAT_ENABLE = 10435,
  SYS_VAR_NDB_INDEX_STAT_OPTION = 10436,
  SYS_VAR_NDB_JOIN_PUSHDOWN = 10437,
  SYS_VAR_NDB_LOG_BINLOG_INDEX = 10438,
  SYS_VAR_NDB_LOG_EMPTY_EPOCHS = 10439,
  SYS_VAR_NDB_LOG_EMPTY_UPDATE = 10440,
  SYS_VAR_NDB_LOG_EXCLUSIVE_READS = 10441,
  SYS_VAR_NDB_LOG_UPDATE_AS_WRITE = 10442,
  SYS_VAR_NDB_LOG_UPDATE_MINIMAL = 10443,
  SYS_VAR_NDB_LOG_UPDATED_ONLY = 10444,
  SYS_VAR_NDB_OPTIMIZATION_DELAY = 10445,
  SYS_VAR_NDB_READ_BACKUP = 10446,
  SYS_VAR_NDB_RECV_THREAD_ACTIVATION_THRESHOLD = 10447,
  SYS_VAR_NDB_RECV_THREAD_CPU_MASK = 10448,
  SYS_VAR_NDB_REPORT_THRESH_BINLOG_EPOCH_SLIP = 10449,
  SYS_VAR_NDB_REPORT_THRESH_BINLOG_MEM_USAGE = 10450,
  SYS_VAR_NDB_ROW_CHECKSUM = 10451,
  SYS_VAR_NDB_SHOW_FOREIGN_KEY_MOCK_TABLES = 10452,
  SYS_VAR_NDB_SLAVE_CONFLICT_ROLE = 10453,
  SYS_VAR_NDB_TABLE_NO_LOGGING = 10454,
  SYS_VAR_NDB_TABLE_TEMPORARY = 10455,
  SYS_VAR_NDB_USE_EXACT_COUNT = 10456,
  SYS_VAR_NDB_USE_TRANSACTIONS = 10457,
  SYS_VAR_NDBINFO_MAX_BYTES = 10458,
  SYS_VAR_NDBINFO_MAX_ROWS = 10459,
  SYS_VAR_NDBINFO_OFFLINE = 10460,
  SYS_VAR_NDBINFO_SHOW_HIDDEN = 10461,
  SYS_VAR_MYISAM_DATA_POINTER_SIZE = 10462,
  SYS_VAR_MYISAM_MAX_SORT_FILE_SIZE = 10463,
  SYS_VAR_MYISAM_REPAIR_THREADS = 10464,
  SYS_VAR_MYISAM_SORT_BUFFER_SIZE = 10465,
  SYS_VAR_MYISAM_STATS_METHOD = 10466,
  SYS_VAR_MYISAM_USE_MMAP = 10467,
  SYS_VAR_PRELOAD_BUFFER_SIZE = 10468,
  SYS_VAR_READ_BUFFER_SIZE = 10469,
  SYS_VAR_READ_RND_BUFFER_SIZE = 10470,
  SYS_VAR_SYNC_FRM = 10471,
  SYS_VAR_SYNC_MASTER_INFO = 10472,
  SYS_VAR_TABLE_OPEN_CACHE = 10473,
  SYS_VAR_INNODB_MONITOR_DISABLE = 10474,
  SYS_VAR_INNODB_MONITOR_ENABLE = 10475,
  SYS_VAR_INNODB_MONITOR_RESET = 10476,
  SYS_VAR_INNODB_MONITOR_RESET_ALL = 10477,
  SYS_VAR_INNODB_OLD_BLOCKS_PCT = 10478,
  SYS_VAR_INNODB_OLD_BLOCKS_TIME = 10479,
  SYS_VAR_INNODB_PURGE_BATCH_SIZE = 10480,
  SYS_VAR_INNODB_PURGE_RSEG_TRUNCATE_FREQUENCY = 10481,
  SYS_VAR_INNODB_RANDOM_READ_AHEAD = 10482,
  SYS_VAR_INNODB_READ_AHEAD_THRESHOLD = 10483,
  SYS_VAR_INNODB_ROLLBACK_SEGMENTS = 10484,
  SYS_VAR_INNODB_SPIN_WAIT_DELAY = 10485,
  SYS_VAR_INNODB_STATUS_OUTPUT = 10486,
  SYS_VAR_INNODB_STATUS_OUTPUT_LOCKS = 10487,
  SYS_VAR_INNODB_SYNC_SPIN_LOOPS = 10488,
  SYS_VAR_INTERNAL_TMP_DISK_STORAGE_ENGINE = 10489,
  SYS_VAR_KEEP_FILES_ON_CREATE = 10490,
  SYS_VAR_MAX_HEAP_TABLE_SIZE = 10491,
  SYS_VAR_BULK_INSERT_BUFFER_SIZE = 10492,
  SYS_VAR_HOST_CACHE_SIZE = 10493,
  SYS_VAR_INIT_SLAVE = 10494,
  SYS_VAR_INNODB_FAST_SHUTDOWN = 10495,
  SYS_VAR_INNODB_IO_CAPACITY = 10496,
  SYS_VAR_INNODB_IO_CAPACITY_MAX = 10497,
  SYS_VAR_INNODB_THREAD_CONCURRENCY = 10498,
  SYS_VAR_INNODB_THREAD_SLEEP_DELAY = 10499,
  SYS_VAR_LOG_ERROR_VERBOSITY = 10500,
  SYS_VAR_LOG_OUTPUT = 10501,
  SYS_VAR_LOG_QUERIES_NOT_USING_INDEXES = 10502,
  SYS_VAR_LOG_SLOW_ADMIN_STATEMENTS = 10503,
  SYS_VAR_LOG_SLOW_SLAVE_STATEMENTS = 10504,
  SYS_VAR_LOG_STATEMENTS_UNSAFE_FOR_BINLOG = 10505,
  SYS_VAR_LOG_SYSLOG = 10506,
  SYS_VAR_LOG_SYSLOG_FACILITY = 10507,
  SYS_VAR_LOG_SYSLOG_INCLUDE_PID = 10508,
  SYS_VAR_LOG_SYSLOG_TAG = 10509,
  SYS_VAR_LOG_THROTTLE_QUERIES_NOT_USING_INDEXES = 10510,
  SYS_VAR_LOG_TIMESTAMPS = 10511,
  SYS_VAR_LOG_WARNINGS = 10512,
  SYS_VAR_MAX_DELAYED_THREADS = 10513,
  SYS_VAR_OFFLINE_MODE = 10514,
  SYS_VAR_REQUIRE_SECURE_TRANSPORT = 10515,
  SYS_VAR_SLOW_LAUNCH_TIME = 10516,
  SYS_VAR_SQL_LOG_OFF = 10517,
  SYS_VAR_THREAD_CACHE_SIZE = 10518,
  SYS_VAR_THREAD_POOL_HIGH_PRIORITY_CONNECTION = 10519,
  SYS_VAR_THREAD_POOL_MAX_UNUSED_THREADS = 10520,
  SYS_VAR_THREAD_POOL_PRIO_KICKUP_TIMER = 10521,
  SYS_VAR_THREAD_POOL_STALL_LIMIT = 10522,
  SYS_VAR_HAVE_STATEMENT_TIMEOUT = 10523,
  SYS_VAR_MYSQLX_BIND_ADDRESS = 10524,
  SYS_VAR_MYSQLX_PORT = 10525,
  SYS_VAR_MYSQLX_PORT_OPEN_TIMEOUT = 10526,
  SYS_VAR_MYSQLX_SOCKET = 10527,
  SYS_VAR_MYSQLX_SSL_CA = 10528,
  SYS_VAR_MYSQLX_SSL_CAPATH = 10529,
  SYS_VAR_MYSQLX_SSL_CERT = 10530,
  SYS_VAR_MYSQLX_SSL_CIPHER = 10531,
  SYS_VAR_MYSQLX_SSL_CRL = 10532,
  SYS_VAR_MYSQLX_SSL_CRLPATH = 10533,
  SYS_VAR_MYSQLX_SSL_KEY = 10534,
  SYS_VAR_OLD = 10535,
  SYS_VAR_PERFORMANCE_SCHEMA_ACCOUNTS_SIZE = 10536,
  SYS_VAR_PERFORMANCE_SCHEMA_DIGESTS_SIZE = 10537,
  SYS_VAR_PERFORMANCE_SCHEMA_EVENTS_STAGES_HISTORY_LONG_SIZE = 10538,
  SYS_VAR_PERFORMANCE_SCHEMA_EVENTS_STAGES_HISTORY_SIZE = 10539,
  SYS_VAR_PERFORMANCE_SCHEMA_EVENTS_STATEMENTS_HISTORY_LONG_SIZE = 10540,
  SYS_VAR_PERFORMANCE_SCHEMA_EVENTS_STATEMENTS_HISTORY_SIZE = 10541,
  SYS_VAR_PERFORMANCE_SCHEMA_EVENTS_TRANSACTIONS_HISTORY_LONG_SIZE = 10542,
  SYS_VAR_PERFORMANCE_SCHEMA_EVENTS_TRANSACTIONS_HISTORY_SIZE = 10543,
  SYS_VAR_PERFORMANCE_SCHEMA_EVENTS_WAITS_HISTORY_LONG_SIZE = 10544,
  SYS_VAR_PERFORMANCE_SCHEMA_EVENTS_WAITS_HISTORY_SIZE = 10545,
  SYS_VAR_PERFORMANCE_SCHEMA_HOSTS_SIZE = 10546,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_COND_CLASSES = 10547,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_COND_INSTANCES = 10548,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_DIGEST_LENGTH = 10549,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_FILE_CLASSES = 10550,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_FILE_HANDLES = 10551,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_FILE_INSTANCES = 10552,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_INDEX_STAT = 10553,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_MEMORY_CLASSES = 10554,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_METADATA_LOCKS = 10555,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_MUTEX_CLASSES = 10556,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_MUTEX_INSTANCES = 10557,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_PREPARED_STATEMENTS_INSTANCES = 10558,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_PROGRAM_INSTANCES = 10559,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_RWLOCK_CLASSES = 10560,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_RWLOCK_INSTANCES = 10561,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_SOCKET_CLASSES = 10562,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_SOCKET_INSTANCES = 10563,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_SQL_TEXT_LENGTH = 10564,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_STAGE_CLASSES = 10565,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_STATEMENT_CLASSES = 10566,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_STATEMENT_STACK = 10567,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_TABLE_HANDLES = 10568,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_TABLE_INSTANCES = 10569,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_TABLE_LOCK_STAT = 10570,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_THREAD_CLASSES = 10571,
  SYS_VAR_PERFORMANCE_SCHEMA_MAX_THREAD_INSTANCES = 10572,
  SYS_VAR_PERFORMANCE_SCHEMA_SESSION_CONNECT_ATTRS_SIZE = 10573,
  SYS_VAR_PERFORMANCE_SCHEMA_SETUP_ACTORS_SIZE = 10574,
  SYS_VAR_PERFORMANCE_SCHEMA_SETUP_OBJECTS_SIZE = 10575,
  SYS_VAR_PERFORMANCE_SCHEMA_USERS_SIZE = 10576,
  SYS_VAR_VERSION_TOKENS_SESSION_NUMBER = 10577,
  SYS_VAR_BACK_LOG = 10578,
  SYS_VAR_BASEDIR = 10579,
  SYS_VAR_BIND_ADDRESS = 10580,
  SYS_VAR_CORE_FILE = 10581,
  SYS_VAR_HAVE_COMPRESS = 10582,
  SYS_VAR_IGNORE_DB_DIRS = 10583,
  SYS_VAR_INIT_FILE = 10584,
  SYS_VAR_INNODB_NUMA_INTERLEAVE = 10585,
  SYS_VAR_INNODB_OPEN_FILES = 10586,
  SYS_VAR_INNODB_PAGE_CLEANERS = 10587,
  SYS_VAR_INNODB_PURGE_THREADS = 10588,
  SYS_VAR_INNODB_READ_IO_THREADS = 10589,
  SYS_VAR_INNODB_SYNC_ARRAY_SIZE = 10590,
  SYS_VAR_INNODB_USE_NATIVE_AIO = 10591,
  SYS_VAR_INNODB_WRITE_IO_THREADS = 10592,
  SYS_VAR_LARGE_FILES_SUPPORT = 10593,
  SYS_VAR_LARGE_PAGES = 10594,
  SYS_VAR_LARGE_PAGE_SIZE = 10595,
  SYS_VAR_LOCKED_IN_MEMORY = 10596,
  SYS_VAR_LOG_ERROR = 10597,
  SYS_VAR_NAMED_PIPE = 10598,
  SYS_VAR_NAMED_PIPE_FULL_ACCESS_GROUP = 10599,
  SYS_VAR_OPEN_FILES_LIMIT = 10600,
  SYS_VAR_REPORT_HOST = 10601,
  SYS_VAR_REPORT_PASSWORD = 10602,
  SYS_VAR_REPORT_PORT = 10603,
  SYS_VAR_REPORT_USER = 10604,
  SYS_VAR_SERVER_ID_BITS = 10605,
  SYS_VAR_SHARED_MEMORY = 10606,
  SYS_VAR_SHARED_MEMORY_BASE_NAME = 10607,
  SYS_VAR_SKIP_NAME_RESOLVE = 10608,
  SYS_VAR_SKIP_NETWORKING = 10609,
  SYS_VAR_THREAD_HANDLING = 10610,
  SYS_VAR_THREAD_POOL_ALGORITHM = 10611,
  SYS_VAR_THREAD_POOL_SIZE = 10612,
  SYS_VAR_THREAD_STACK = 10613,
  SYS_VAR_BINLOG_GTID_SIMPLE_RECOVERY = 10614,
  SYS_VAR_INNODB_API_ENABLE_BINLOG = 10615,
  SYS_VAR_INNODB_LOCKS_UNSAFE_FOR_BINLOG = 10616,
  SYS_VAR_INNODB_LOG_BUFFER_SIZE = 10617,
  SYS_VAR_INNODB_LOG_FILES_IN_GROUP = 10618,
  SYS_VAR_INNODB_LOG_FILE_SIZE = 10619,
  SYS_VAR_INNODB_LOG_GROUP_HOME_DIR = 10620,
  SYS_VAR_INNODB_UNDO_DIRECTORY = 10621,
  SYS_VAR_INNODB_UNDO_TABLESPACES = 10622,
  SYS_VAR_LOG_BIN_BASENAME = 10623,
  SYS_VAR_LOG_BIN_INDEX = 10624,
  SYS_VAR_LOG_SLAVE_UPDATES = 10625,
  SYS_VAR_RELAY_LOG = 10626,
  SYS_VAR_RELAY_LOG_BASENAME = 10627,
  SYS_VAR_RELAY_LOG_INDEX = 10628,
  SYS_VAR_RELAY_LOG_INFO_FILE = 10629,
  SYS_VAR_RELAY_LOG_RECOVERY = 10630,
  SYS_VAR_RELAY_LOG_SPACE_LIMIT = 10631,
  SYS_VAR_DELAY_KEY_WRITE = 10632,
  SYS_VAR_INNODB_LARGE_PREFIX = 10633,
  SYS_VAR_KEY_BUFFER_SIZE = 10634,
  SYS_VAR_KEY_CACHE_AGE_THRESHOLD = 10635,
  SYS_VAR_KEY_CACHE_DIVISION_LIMIT = 10636,
  SYS_VAR_MAX_SEEKS_FOR_KEY = 10637,
  SYS_VAR_OLD_ALTER_TABLE = 10638,
  SYS_VAR_TABLE_DEFINITION_CACHE = 10639,
  SYS_VAR_INNODB_SORT_BUFFER_SIZE = 10640,
  SYS_VAR_KEY_CACHE_BLOCK_SIZE = 10641,
  SYS_VAR_OB_KV_MODE = 10642,
  SYS_VAR___OB_CLIENT_CAPABILITY_FLAG = 10643,
  SYS_VAR_OB_ENABLE_PARAMETER_ANONYMOUS_BLOCK = 10644,
  SYS_VAR_CHARACTER_SETS_DIR = 10645,
  SYS_VAR_DATE_FORMAT = 10646,
  SYS_VAR_DATETIME_FORMAT = 10647,
  SYS_VAR_DISCONNECT_ON_EXPIRED_PASSWORD = 10648,
  SYS_VAR_EXTERNAL_USER = 10649,
  SYS_VAR_HAVE_CRYPT = 10650,
  SYS_VAR_HAVE_DYNAMIC_LOADING = 10651,
  SYS_VAR_KEYRING_AWS_CONF_FILE = 10652,
  SYS_VAR_KEYRING_AWS_DATA_FILE = 10653,
  SYS_VAR_LANGUAGE = 10654,
  SYS_VAR_LC_MESSAGES_DIR = 10655,
  SYS_VAR_LOWER_CASE_FILE_SYSTEM = 10656,
  SYS_VAR_MAX_DIGEST_LENGTH = 10657,
  SYS_VAR_NDBINFO_DATABASE = 10658,
  SYS_VAR_NDBINFO_TABLE_PREFIX = 10659,
  SYS_VAR_NDBINFO_VERSION = 10660,
  SYS_VAR_NDB_BATCH_SIZE = 10661,
  SYS_VAR_NDB_CLUSTER_CONNECTION_POOL = 10662,
  SYS_VAR_NDB_CLUSTER_CONNECTION_POOL_NODEIDS = 10663,
  SYS_VAR_NDB_LOG_APPLY_STATUS = 10664,
  SYS_VAR_NDB_LOG_BIN = 10665,
  SYS_VAR_NDB_LOG_FAIL_TERMINATE = 10666,
  SYS_VAR_NDB_LOG_ORIG = 10667,
  SYS_VAR_NDB_LOG_TRANSACTION_ID = 10668,
  SYS_VAR_NDB_OPTIMIZED_NODE_SELECTION = 10669,
  SYS_VAR_NDB_SYSTEM_NAME = 10670,
  SYS_VAR_NDB_USE_COPYING_ALTER_TABLE = 10671,
  SYS_VAR_NDB_VERSION_STRING = 10672,
  SYS_VAR_NDB_WAIT_CONNECTED = 10673,
  SYS_VAR_NDB_WAIT_SETUP = 10674,
  SYS_VAR_PROXY_USER = 10675,
  SYS_VAR_SHA256_PASSWORD_AUTO_GENERATE_RSA_KEYS = 10676,
  SYS_VAR_SHA256_PASSWORD_PRIVATE_KEY_PATH = 10677,
  SYS_VAR_SHA256_PASSWORD_PUBLIC_KEY_PATH = 10678,
  SYS_VAR_SKIP_SHOW_DATABASE = 10679,
  SYS_VAR_PLUGIN_LOAD = 10680,
  SYS_VAR_PLUGIN_LOAD_ADD = 10681,
  SYS_VAR_BIG_TABLES = 10682,
  SYS_VAR_CHECK_PROXY_USERS = 10683,
  SYS_VAR_CONNECTION_CONTROL_FAILED_CONNECTIONS_THRESHOLD = 10684,
  SYS_VAR_CONNECTION_CONTROL_MAX_CONNECTION_DELAY = 10685,
  SYS_VAR_CONNECTION_CONTROL_MIN_CONNECTION_DELAY = 10686,
  SYS_VAR_DEFAULT_WEEK_FORMAT = 10687,
  SYS_VAR_DELAYED_INSERT_TIMEOUT = 10688,
  SYS_VAR_DELAYED_QUEUE_SIZE = 10689,
  SYS_VAR_EQ_RANGE_INDEX_DIVE_LIMIT = 10690,
  SYS_VAR_INNODB_STATS_AUTO_RECALC = 10691,
  SYS_VAR_INNODB_STATS_INCLUDE_DELETE_MARKED = 10692,
  SYS_VAR_INNODB_STATS_METHOD = 10693,
  SYS_VAR_INNODB_STATS_ON_METADATA = 10694,
  SYS_VAR_VERSION_TOKENS_SESSION = 10695,
  SYS_VAR_INNODB_STATS_PERSISTENT_SAMPLE_PAGES = 10696,
  SYS_VAR_INNODB_STATS_SAMPLE_PAGES = 10697,
  SYS_VAR_INNODB_STATS_TRANSIENT_SAMPLE_PAGES = 10698,
  SYS_VAR_KEYRING_AWS_CMK_ID = 10699,
  SYS_VAR_KEYRING_AWS_REGION = 10700,
  SYS_VAR_KEYRING_ENCRYPTED_FILE_DATA = 10701,
  SYS_VAR_KEYRING_ENCRYPTED_FILE_PASSWORD = 10702,
  SYS_VAR_KEYRING_FILE_DATA = 10703,
  SYS_VAR_KEYRING_OKV_CONF_DIR = 10704,
  SYS_VAR_KEYRING_OPERATIONS = 10705,
  SYS_VAR_OPTIMIZER_SWITCH = 10706,
  SYS_VAR_MAX_CONNECT_ERRORS = 10707,
  SYS_VAR_MYSQL_FIREWALL_MODE = 10708,
  SYS_VAR_MYSQL_FIREWALL_TRACE = 10709,
  SYS_VAR_MYSQL_NATIVE_PASSWORD_PROXY_USERS = 10710,
  SYS_VAR_NET_RETRY_COUNT = 10711,
  SYS_VAR_NEW = 10712,
  SYS_VAR_OLD_PASSWORDS = 10713,
  SYS_VAR_OPTIMIZER_PRUNE_LEVEL = 10714,
  SYS_VAR_OPTIMIZER_SEARCH_DEPTH = 10715,
  SYS_VAR_OPTIMIZER_TRACE = 10716,
  SYS_VAR_OPTIMIZER_TRACE_FEATURES = 10717,
  SYS_VAR_OPTIMIZER_TRACE_LIMIT = 10718,
  SYS_VAR_OPTIMIZER_TRACE_MAX_MEM_SIZE = 10719,
  SYS_VAR_OPTIMIZER_TRACE_OFFSET = 10720,
  SYS_VAR_PARSER_MAX_MEM_SIZE = 10721,
  SYS_VAR_RAND_SEED1 = 10722,
  SYS_VAR_RAND_SEED2 = 10723,
  SYS_VAR_RANGE_ALLOC_BLOCK_SIZE = 10724,
  SYS_VAR_RANGE_OPTIMIZER_MAX_MEM_SIZE = 10725,
  SYS_VAR_REWRITER_ENABLED = 10726,
  SYS_VAR_REWRITER_VERBOSE = 10727,
  SYS_VAR_SECURE_AUTH = 10728,
  SYS_VAR_SHA256_PASSWORD_PROXY_USERS = 10729,
  SYS_VAR_SHOW_COMPATIBILITY_56 = 10730,
  SYS_VAR_SHOW_CREATE_TABLE_VERBOSITY = 10731,
  SYS_VAR_SHOW_OLD_TEMPORALS = 10732,
  SYS_VAR_SQL_BIG_SELECTS = 10733,
  SYS_VAR_UPDATABLE_VIEWS_WITH_LIMIT = 10734,
  SYS_VAR_VALIDATE_PASSWORD_DICTIONARY_FILE = 10735,
  SYS_VAR_DELAYED_INSERT_LIMIT = 10736,
  SYS_VAR_NDB_VERSION = 10737,
  SYS_VAR_AUTO_GENERATE_CERTS = 10738,
  SYS_VAR__OPTIMIZER_COST_BASED_TRANSFORMATION = 10739,
  SYS_VAR_RANGE_INDEX_DIVE_LIMIT = 10740,
  SYS_VAR_PARTITION_INDEX_DIVE_LIMIT = 10741,
  SYS_VAR_OB_TABLE_ACCESS_POLICY = 10742,
  SYS_VAR_PID_FILE = 10743,
  SYS_VAR_PORT = 10744,
  SYS_VAR_SOCKET = 10745,
  SYS_VAR_MVIEW_REFRESH_DOP = 10746,
  SYS_VAR_ENABLE_OPTIMIZER_ROWGOAL = 10747,
  SYS_VAR_OB_IVF_NPROBES = 10748,
};

}
}
#endif //OCEANBASE_SHARE_SYSTEM_VARIABLE_OB_SYS_VAR_CLASS_TYPE_