//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcompute

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type APIEntityReference.
func (a APIEntityReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIEntityReference.
func (a *APIEntityReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIError.
func (a APIError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", a.Code)
	populate(objectMap, "details", a.Details)
	populate(objectMap, "innererror", a.Innererror)
	populate(objectMap, "message", a.Message)
	populate(objectMap, "target", a.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIError.
func (a *APIError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &a.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &a.Details)
			delete(rawMsg, key)
		case "innererror":
			err = unpopulate(val, "Innererror", &a.Innererror)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &a.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIErrorBase.
func (a APIErrorBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", a.Code)
	populate(objectMap, "message", a.Message)
	populate(objectMap, "target", a.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIErrorBase.
func (a *APIErrorBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &a.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &a.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessURI.
func (a AccessURI) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessSAS", a.AccessSAS)
	populate(objectMap, "securityDataAccessSAS", a.SecurityDataAccessSAS)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessURI.
func (a *AccessURI) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessSAS":
			err = unpopulate(val, "AccessSAS", &a.AccessSAS)
			delete(rawMsg, key)
		case "securityDataAccessSAS":
			err = unpopulate(val, "SecurityDataAccessSAS", &a.SecurityDataAccessSAS)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdditionalCapabilities.
func (a AdditionalCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hibernationEnabled", a.HibernationEnabled)
	populate(objectMap, "ultraSSDEnabled", a.UltraSSDEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdditionalCapabilities.
func (a *AdditionalCapabilities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hibernationEnabled":
			err = unpopulate(val, "HibernationEnabled", &a.HibernationEnabled)
			delete(rawMsg, key)
		case "ultraSSDEnabled":
			err = unpopulate(val, "UltraSSDEnabled", &a.UltraSSDEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdditionalUnattendContent.
func (a AdditionalUnattendContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["componentName"] = "Microsoft-Windows-Shell-Setup"
	populate(objectMap, "content", a.Content)
	objectMap["passName"] = "OobeSystem"
	populate(objectMap, "settingName", a.SettingName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdditionalUnattendContent.
func (a *AdditionalUnattendContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentName":
			err = unpopulate(val, "ComponentName", &a.ComponentName)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &a.Content)
			delete(rawMsg, key)
		case "passName":
			err = unpopulate(val, "PassName", &a.PassName)
			delete(rawMsg, key)
		case "settingName":
			err = unpopulate(val, "SettingName", &a.SettingName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlternativeOption.
func (a AlternativeOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlternativeOption.
func (a *AlternativeOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationProfile.
func (a ApplicationProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "galleryApplications", a.GalleryApplications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationProfile.
func (a *ApplicationProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "galleryApplications":
			err = unpopulate(val, "GalleryApplications", &a.GalleryApplications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AttachDetachDataDisksRequest.
func (a AttachDetachDataDisksRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDisksToAttach", a.DataDisksToAttach)
	populate(objectMap, "dataDisksToDetach", a.DataDisksToDetach)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AttachDetachDataDisksRequest.
func (a *AttachDetachDataDisksRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDisksToAttach":
			err = unpopulate(val, "DataDisksToAttach", &a.DataDisksToAttach)
			delete(rawMsg, key)
		case "dataDisksToDetach":
			err = unpopulate(val, "DataDisksToDetach", &a.DataDisksToDetach)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomaticOSUpgradePolicy.
func (a AutomaticOSUpgradePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disableAutomaticRollback", a.DisableAutomaticRollback)
	populate(objectMap, "enableAutomaticOSUpgrade", a.EnableAutomaticOSUpgrade)
	populate(objectMap, "osRollingUpgradeDeferral", a.OSRollingUpgradeDeferral)
	populate(objectMap, "useRollingUpgradePolicy", a.UseRollingUpgradePolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomaticOSUpgradePolicy.
func (a *AutomaticOSUpgradePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableAutomaticRollback":
			err = unpopulate(val, "DisableAutomaticRollback", &a.DisableAutomaticRollback)
			delete(rawMsg, key)
		case "enableAutomaticOSUpgrade":
			err = unpopulate(val, "EnableAutomaticOSUpgrade", &a.EnableAutomaticOSUpgrade)
			delete(rawMsg, key)
		case "osRollingUpgradeDeferral":
			err = unpopulate(val, "OSRollingUpgradeDeferral", &a.OSRollingUpgradeDeferral)
			delete(rawMsg, key)
		case "useRollingUpgradePolicy":
			err = unpopulate(val, "UseRollingUpgradePolicy", &a.UseRollingUpgradePolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomaticOSUpgradeProperties.
func (a AutomaticOSUpgradeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "automaticOSUpgradeSupported", a.AutomaticOSUpgradeSupported)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomaticOSUpgradeProperties.
func (a *AutomaticOSUpgradeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "automaticOSUpgradeSupported":
			err = unpopulate(val, "AutomaticOSUpgradeSupported", &a.AutomaticOSUpgradeSupported)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomaticRepairsPolicy.
func (a AutomaticRepairsPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "gracePeriod", a.GracePeriod)
	populate(objectMap, "repairAction", a.RepairAction)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomaticRepairsPolicy.
func (a *AutomaticRepairsPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "gracePeriod":
			err = unpopulate(val, "GracePeriod", &a.GracePeriod)
			delete(rawMsg, key)
		case "repairAction":
			err = unpopulate(val, "RepairAction", &a.RepairAction)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySet.
func (a AvailabilitySet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilitySet.
func (a *AvailabilitySet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySetListResult.
func (a AvailabilitySetListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilitySetListResult.
func (a *AvailabilitySetListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySetProperties.
func (a AvailabilitySetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "platformFaultDomainCount", a.PlatformFaultDomainCount)
	populate(objectMap, "platformUpdateDomainCount", a.PlatformUpdateDomainCount)
	populate(objectMap, "proximityPlacementGroup", a.ProximityPlacementGroup)
	populate(objectMap, "statuses", a.Statuses)
	populate(objectMap, "virtualMachines", a.VirtualMachines)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilitySetProperties.
func (a *AvailabilitySetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "platformFaultDomainCount":
			err = unpopulate(val, "PlatformFaultDomainCount", &a.PlatformFaultDomainCount)
			delete(rawMsg, key)
		case "platformUpdateDomainCount":
			err = unpopulate(val, "PlatformUpdateDomainCount", &a.PlatformUpdateDomainCount)
			delete(rawMsg, key)
		case "proximityPlacementGroup":
			err = unpopulate(val, "ProximityPlacementGroup", &a.ProximityPlacementGroup)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &a.Statuses)
			delete(rawMsg, key)
		case "virtualMachines":
			err = unpopulate(val, "VirtualMachines", &a.VirtualMachines)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySetUpdate.
func (a AvailabilitySetUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilitySetUpdate.
func (a *AvailabilitySetUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailablePatchSummary.
func (a AvailablePatchSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assessmentActivityId", a.AssessmentActivityID)
	populate(objectMap, "criticalAndSecurityPatchCount", a.CriticalAndSecurityPatchCount)
	populate(objectMap, "error", a.Error)
	populateDateTimeRFC3339(objectMap, "lastModifiedTime", a.LastModifiedTime)
	populate(objectMap, "otherPatchCount", a.OtherPatchCount)
	populate(objectMap, "rebootPending", a.RebootPending)
	populateDateTimeRFC3339(objectMap, "startTime", a.StartTime)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailablePatchSummary.
func (a *AvailablePatchSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentActivityId":
			err = unpopulate(val, "AssessmentActivityID", &a.AssessmentActivityID)
			delete(rawMsg, key)
		case "criticalAndSecurityPatchCount":
			err = unpopulate(val, "CriticalAndSecurityPatchCount", &a.CriticalAndSecurityPatchCount)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedTime", &a.LastModifiedTime)
			delete(rawMsg, key)
		case "otherPatchCount":
			err = unpopulate(val, "OtherPatchCount", &a.OtherPatchCount)
			delete(rawMsg, key)
		case "rebootPending":
			err = unpopulate(val, "RebootPending", &a.RebootPending)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingProfile.
func (b BillingProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxPrice", b.MaxPrice)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingProfile.
func (b *BillingProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxPrice":
			err = unpopulate(val, "MaxPrice", &b.MaxPrice)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BootDiagnostics.
func (b BootDiagnostics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", b.Enabled)
	populate(objectMap, "storageUri", b.StorageURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BootDiagnostics.
func (b *BootDiagnostics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &b.Enabled)
			delete(rawMsg, key)
		case "storageUri":
			err = unpopulate(val, "StorageURI", &b.StorageURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BootDiagnosticsInstanceView.
func (b BootDiagnosticsInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consoleScreenshotBlobUri", b.ConsoleScreenshotBlobURI)
	populate(objectMap, "serialConsoleLogBlobUri", b.SerialConsoleLogBlobURI)
	populate(objectMap, "status", b.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BootDiagnosticsInstanceView.
func (b *BootDiagnosticsInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consoleScreenshotBlobUri":
			err = unpopulate(val, "ConsoleScreenshotBlobURI", &b.ConsoleScreenshotBlobURI)
			delete(rawMsg, key)
		case "serialConsoleLogBlobUri":
			err = unpopulate(val, "SerialConsoleLogBlobURI", &b.SerialConsoleLogBlobURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &b.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservation.
func (c CapacityReservation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "sku", c.SKU)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "zones", c.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityReservation.
func (c *CapacityReservation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &c.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &c.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationGroup.
func (c CapacityReservationGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "zones", c.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityReservationGroup.
func (c *CapacityReservationGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &c.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationGroupInstanceView.
func (c CapacityReservationGroupInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacityReservations", c.CapacityReservations)
	populate(objectMap, "sharedSubscriptionIds", c.SharedSubscriptionIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityReservationGroupInstanceView.
func (c *CapacityReservationGroupInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityReservations":
			err = unpopulate(val, "CapacityReservations", &c.CapacityReservations)
			delete(rawMsg, key)
		case "sharedSubscriptionIds":
			err = unpopulate(val, "SharedSubscriptionIDs", &c.SharedSubscriptionIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationGroupListResult.
func (c CapacityReservationGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityReservationGroupListResult.
func (c *CapacityReservationGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationGroupProperties.
func (c CapacityReservationGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacityReservations", c.CapacityReservations)
	populate(objectMap, "instanceView", c.InstanceView)
	populate(objectMap, "sharingProfile", c.SharingProfile)
	populate(objectMap, "virtualMachinesAssociated", c.VirtualMachinesAssociated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityReservationGroupProperties.
func (c *CapacityReservationGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityReservations":
			err = unpopulate(val, "CapacityReservations", &c.CapacityReservations)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &c.InstanceView)
			delete(rawMsg, key)
		case "sharingProfile":
			err = unpopulate(val, "SharingProfile", &c.SharingProfile)
			delete(rawMsg, key)
		case "virtualMachinesAssociated":
			err = unpopulate(val, "VirtualMachinesAssociated", &c.VirtualMachinesAssociated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationGroupUpdate.
func (c CapacityReservationGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityReservationGroupUpdate.
func (c *CapacityReservationGroupUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationInstanceView.
func (c CapacityReservationInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "statuses", c.Statuses)
	populate(objectMap, "utilizationInfo", c.UtilizationInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityReservationInstanceView.
func (c *CapacityReservationInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "statuses":
			err = unpopulate(val, "Statuses", &c.Statuses)
			delete(rawMsg, key)
		case "utilizationInfo":
			err = unpopulate(val, "UtilizationInfo", &c.UtilizationInfo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationInstanceViewWithName.
func (c CapacityReservationInstanceViewWithName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "statuses", c.Statuses)
	populate(objectMap, "utilizationInfo", c.UtilizationInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityReservationInstanceViewWithName.
func (c *CapacityReservationInstanceViewWithName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &c.Statuses)
			delete(rawMsg, key)
		case "utilizationInfo":
			err = unpopulate(val, "UtilizationInfo", &c.UtilizationInfo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationListResult.
func (c CapacityReservationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityReservationListResult.
func (c *CapacityReservationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationProfile.
func (c CapacityReservationProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacityReservationGroup", c.CapacityReservationGroup)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityReservationProfile.
func (c *CapacityReservationProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityReservationGroup":
			err = unpopulate(val, "CapacityReservationGroup", &c.CapacityReservationGroup)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationProperties.
func (c CapacityReservationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceView", c.InstanceView)
	populate(objectMap, "platformFaultDomainCount", c.PlatformFaultDomainCount)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populateDateTimeRFC3339(objectMap, "provisioningTime", c.ProvisioningTime)
	populate(objectMap, "reservationId", c.ReservationID)
	populateDateTimeRFC3339(objectMap, "timeCreated", c.TimeCreated)
	populate(objectMap, "virtualMachinesAssociated", c.VirtualMachinesAssociated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityReservationProperties.
func (c *CapacityReservationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceView":
			err = unpopulate(val, "InstanceView", &c.InstanceView)
			delete(rawMsg, key)
		case "platformFaultDomainCount":
			err = unpopulate(val, "PlatformFaultDomainCount", &c.PlatformFaultDomainCount)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "provisioningTime":
			err = unpopulateDateTimeRFC3339(val, "ProvisioningTime", &c.ProvisioningTime)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &c.ReservationID)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateDateTimeRFC3339(val, "TimeCreated", &c.TimeCreated)
			delete(rawMsg, key)
		case "virtualMachinesAssociated":
			err = unpopulate(val, "VirtualMachinesAssociated", &c.VirtualMachinesAssociated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationUpdate.
func (c CapacityReservationUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "sku", c.SKU)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityReservationUpdate.
func (c *CapacityReservationUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &c.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityReservationUtilization.
func (c CapacityReservationUtilization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentCapacity", c.CurrentCapacity)
	populate(objectMap, "virtualMachinesAllocated", c.VirtualMachinesAllocated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityReservationUtilization.
func (c *CapacityReservationUtilization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentCapacity":
			err = unpopulate(val, "CurrentCapacity", &c.CurrentCapacity)
			delete(rawMsg, key)
		case "virtualMachinesAllocated":
			err = unpopulate(val, "VirtualMachinesAllocated", &c.VirtualMachinesAllocated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudService.
func (c CloudService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "zones", c.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudService.
func (c *CloudService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &c.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceExtensionProfile.
func (c CloudServiceExtensionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extensions", c.Extensions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceExtensionProfile.
func (c *CloudServiceExtensionProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extensions":
			err = unpopulate(val, "Extensions", &c.Extensions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceExtensionProperties.
func (c CloudServiceExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoUpgradeMinorVersion", c.AutoUpgradeMinorVersion)
	populate(objectMap, "forceUpdateTag", c.ForceUpdateTag)
	populateAny(objectMap, "protectedSettings", c.ProtectedSettings)
	populate(objectMap, "protectedSettingsFromKeyVault", c.ProtectedSettingsFromKeyVault)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "publisher", c.Publisher)
	populate(objectMap, "rolesAppliedTo", c.RolesAppliedTo)
	populateAny(objectMap, "settings", c.Settings)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "typeHandlerVersion", c.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceExtensionProperties.
func (c *CloudServiceExtensionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoUpgradeMinorVersion":
			err = unpopulate(val, "AutoUpgradeMinorVersion", &c.AutoUpgradeMinorVersion)
			delete(rawMsg, key)
		case "forceUpdateTag":
			err = unpopulate(val, "ForceUpdateTag", &c.ForceUpdateTag)
			delete(rawMsg, key)
		case "protectedSettings":
			err = unpopulate(val, "ProtectedSettings", &c.ProtectedSettings)
			delete(rawMsg, key)
		case "protectedSettingsFromKeyVault":
			err = unpopulate(val, "ProtectedSettingsFromKeyVault", &c.ProtectedSettingsFromKeyVault)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &c.Publisher)
			delete(rawMsg, key)
		case "rolesAppliedTo":
			err = unpopulate(val, "RolesAppliedTo", &c.RolesAppliedTo)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &c.Settings)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &c.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceInstanceView.
func (c CloudServiceInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateIds", c.PrivateIDs)
	populate(objectMap, "roleInstance", c.RoleInstance)
	populate(objectMap, "sdkVersion", c.SdkVersion)
	populate(objectMap, "statuses", c.Statuses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceInstanceView.
func (c *CloudServiceInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateIds":
			err = unpopulate(val, "PrivateIDs", &c.PrivateIDs)
			delete(rawMsg, key)
		case "roleInstance":
			err = unpopulate(val, "RoleInstance", &c.RoleInstance)
			delete(rawMsg, key)
		case "sdkVersion":
			err = unpopulate(val, "SdkVersion", &c.SdkVersion)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &c.Statuses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceListResult.
func (c CloudServiceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceListResult.
func (c *CloudServiceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceNetworkProfile.
func (c CloudServiceNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "loadBalancerConfigurations", c.LoadBalancerConfigurations)
	populate(objectMap, "slotType", c.SlotType)
	populate(objectMap, "swappableCloudService", c.SwappableCloudService)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceNetworkProfile.
func (c *CloudServiceNetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "loadBalancerConfigurations":
			err = unpopulate(val, "LoadBalancerConfigurations", &c.LoadBalancerConfigurations)
			delete(rawMsg, key)
		case "slotType":
			err = unpopulate(val, "SlotType", &c.SlotType)
			delete(rawMsg, key)
		case "swappableCloudService":
			err = unpopulate(val, "SwappableCloudService", &c.SwappableCloudService)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceOsProfile.
func (c CloudServiceOsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secrets", c.Secrets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceOsProfile.
func (c *CloudServiceOsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secrets":
			err = unpopulate(val, "Secrets", &c.Secrets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceProperties.
func (c CloudServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowModelOverride", c.AllowModelOverride)
	populate(objectMap, "configuration", c.Configuration)
	populate(objectMap, "configurationUrl", c.ConfigurationURL)
	populate(objectMap, "extensionProfile", c.ExtensionProfile)
	populate(objectMap, "networkProfile", c.NetworkProfile)
	populate(objectMap, "osProfile", c.OSProfile)
	populate(objectMap, "packageUrl", c.PackageURL)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "roleProfile", c.RoleProfile)
	populate(objectMap, "startCloudService", c.StartCloudService)
	populate(objectMap, "uniqueId", c.UniqueID)
	populate(objectMap, "upgradeMode", c.UpgradeMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceProperties.
func (c *CloudServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowModelOverride":
			err = unpopulate(val, "AllowModelOverride", &c.AllowModelOverride)
			delete(rawMsg, key)
		case "configuration":
			err = unpopulate(val, "Configuration", &c.Configuration)
			delete(rawMsg, key)
		case "configurationUrl":
			err = unpopulate(val, "ConfigurationURL", &c.ConfigurationURL)
			delete(rawMsg, key)
		case "extensionProfile":
			err = unpopulate(val, "ExtensionProfile", &c.ExtensionProfile)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &c.NetworkProfile)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &c.OSProfile)
			delete(rawMsg, key)
		case "packageUrl":
			err = unpopulate(val, "PackageURL", &c.PackageURL)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "roleProfile":
			err = unpopulate(val, "RoleProfile", &c.RoleProfile)
			delete(rawMsg, key)
		case "startCloudService":
			err = unpopulate(val, "StartCloudService", &c.StartCloudService)
			delete(rawMsg, key)
		case "uniqueId":
			err = unpopulate(val, "UniqueID", &c.UniqueID)
			delete(rawMsg, key)
		case "upgradeMode":
			err = unpopulate(val, "UpgradeMode", &c.UpgradeMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceRole.
func (c CloudServiceRole) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "sku", c.SKU)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceRole.
func (c *CloudServiceRole) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &c.SKU)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceRoleListResult.
func (c CloudServiceRoleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceRoleListResult.
func (c *CloudServiceRoleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceRoleProfile.
func (c CloudServiceRoleProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "roles", c.Roles)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceRoleProfile.
func (c *CloudServiceRoleProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "roles":
			err = unpopulate(val, "Roles", &c.Roles)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceRoleProfileProperties.
func (c CloudServiceRoleProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "sku", c.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceRoleProfileProperties.
func (c *CloudServiceRoleProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &c.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceRoleProperties.
func (c CloudServiceRoleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "uniqueId", c.UniqueID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceRoleProperties.
func (c *CloudServiceRoleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "uniqueId":
			err = unpopulate(val, "UniqueID", &c.UniqueID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceRoleSKU.
func (c CloudServiceRoleSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", c.Capacity)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "tier", c.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceRoleSKU.
func (c *CloudServiceRoleSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &c.Capacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &c.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceUpdate.
func (c CloudServiceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceUpdate.
func (c *CloudServiceUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceVaultAndSecretReference.
func (c CloudServiceVaultAndSecretReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secretUrl", c.SecretURL)
	populate(objectMap, "sourceVault", c.SourceVault)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceVaultAndSecretReference.
func (c *CloudServiceVaultAndSecretReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretUrl":
			err = unpopulate(val, "SecretURL", &c.SecretURL)
			delete(rawMsg, key)
		case "sourceVault":
			err = unpopulate(val, "SourceVault", &c.SourceVault)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceVaultCertificate.
func (c CloudServiceVaultCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateUrl", c.CertificateURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceVaultCertificate.
func (c *CloudServiceVaultCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateUrl":
			err = unpopulate(val, "CertificateURL", &c.CertificateURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServiceVaultSecretGroup.
func (c CloudServiceVaultSecretGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sourceVault", c.SourceVault)
	populate(objectMap, "vaultCertificates", c.VaultCertificates)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServiceVaultSecretGroup.
func (c *CloudServiceVaultSecretGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceVault":
			err = unpopulate(val, "SourceVault", &c.SourceVault)
			delete(rawMsg, key)
		case "vaultCertificates":
			err = unpopulate(val, "VaultCertificates", &c.VaultCertificates)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommunityGallery.
func (c CommunityGallery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identifier", c.Identifier)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunityGallery.
func (c *CommunityGallery) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identifier":
			err = unpopulate(val, "Identifier", &c.Identifier)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommunityGalleryIdentifier.
func (c CommunityGalleryIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "uniqueId", c.UniqueID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunityGalleryIdentifier.
func (c *CommunityGalleryIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "uniqueId":
			err = unpopulate(val, "UniqueID", &c.UniqueID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommunityGalleryImage.
func (c CommunityGalleryImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identifier", c.Identifier)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunityGalleryImage.
func (c *CommunityGalleryImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identifier":
			err = unpopulate(val, "Identifier", &c.Identifier)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommunityGalleryImageIdentifier.
func (c CommunityGalleryImageIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "offer", c.Offer)
	populate(objectMap, "publisher", c.Publisher)
	populate(objectMap, "sku", c.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunityGalleryImageIdentifier.
func (c *CommunityGalleryImageIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "offer":
			err = unpopulate(val, "Offer", &c.Offer)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &c.Publisher)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &c.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommunityGalleryImageList.
func (c CommunityGalleryImageList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunityGalleryImageList.
func (c *CommunityGalleryImageList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommunityGalleryImageProperties.
func (c CommunityGalleryImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "architecture", c.Architecture)
	populate(objectMap, "artifactTags", c.ArtifactTags)
	populate(objectMap, "disallowed", c.Disallowed)
	populate(objectMap, "disclaimer", c.Disclaimer)
	populateDateTimeRFC3339(objectMap, "endOfLifeDate", c.EndOfLifeDate)
	populate(objectMap, "eula", c.Eula)
	populate(objectMap, "features", c.Features)
	populate(objectMap, "hyperVGeneration", c.HyperVGeneration)
	populate(objectMap, "identifier", c.Identifier)
	populate(objectMap, "osState", c.OSState)
	populate(objectMap, "osType", c.OSType)
	populate(objectMap, "privacyStatementUri", c.PrivacyStatementURI)
	populate(objectMap, "purchasePlan", c.PurchasePlan)
	populate(objectMap, "recommended", c.Recommended)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunityGalleryImageProperties.
func (c *CommunityGalleryImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "architecture":
			err = unpopulate(val, "Architecture", &c.Architecture)
			delete(rawMsg, key)
		case "artifactTags":
			err = unpopulate(val, "ArtifactTags", &c.ArtifactTags)
			delete(rawMsg, key)
		case "disallowed":
			err = unpopulate(val, "Disallowed", &c.Disallowed)
			delete(rawMsg, key)
		case "disclaimer":
			err = unpopulate(val, "Disclaimer", &c.Disclaimer)
			delete(rawMsg, key)
		case "endOfLifeDate":
			err = unpopulateDateTimeRFC3339(val, "EndOfLifeDate", &c.EndOfLifeDate)
			delete(rawMsg, key)
		case "eula":
			err = unpopulate(val, "Eula", &c.Eula)
			delete(rawMsg, key)
		case "features":
			err = unpopulate(val, "Features", &c.Features)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &c.HyperVGeneration)
			delete(rawMsg, key)
		case "identifier":
			err = unpopulate(val, "Identifier", &c.Identifier)
			delete(rawMsg, key)
		case "osState":
			err = unpopulate(val, "OSState", &c.OSState)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &c.OSType)
			delete(rawMsg, key)
		case "privacyStatementUri":
			err = unpopulate(val, "PrivacyStatementURI", &c.PrivacyStatementURI)
			delete(rawMsg, key)
		case "purchasePlan":
			err = unpopulate(val, "PurchasePlan", &c.PurchasePlan)
			delete(rawMsg, key)
		case "recommended":
			err = unpopulate(val, "Recommended", &c.Recommended)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommunityGalleryImageVersion.
func (c CommunityGalleryImageVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identifier", c.Identifier)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunityGalleryImageVersion.
func (c *CommunityGalleryImageVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identifier":
			err = unpopulate(val, "Identifier", &c.Identifier)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommunityGalleryImageVersionList.
func (c CommunityGalleryImageVersionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunityGalleryImageVersionList.
func (c *CommunityGalleryImageVersionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommunityGalleryImageVersionProperties.
func (c CommunityGalleryImageVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactTags", c.ArtifactTags)
	populate(objectMap, "disclaimer", c.Disclaimer)
	populateDateTimeRFC3339(objectMap, "endOfLifeDate", c.EndOfLifeDate)
	populate(objectMap, "excludeFromLatest", c.ExcludeFromLatest)
	populateDateTimeRFC3339(objectMap, "publishedDate", c.PublishedDate)
	populate(objectMap, "storageProfile", c.StorageProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunityGalleryImageVersionProperties.
func (c *CommunityGalleryImageVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactTags":
			err = unpopulate(val, "ArtifactTags", &c.ArtifactTags)
			delete(rawMsg, key)
		case "disclaimer":
			err = unpopulate(val, "Disclaimer", &c.Disclaimer)
			delete(rawMsg, key)
		case "endOfLifeDate":
			err = unpopulateDateTimeRFC3339(val, "EndOfLifeDate", &c.EndOfLifeDate)
			delete(rawMsg, key)
		case "excludeFromLatest":
			err = unpopulate(val, "ExcludeFromLatest", &c.ExcludeFromLatest)
			delete(rawMsg, key)
		case "publishedDate":
			err = unpopulateDateTimeRFC3339(val, "PublishedDate", &c.PublishedDate)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &c.StorageProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommunityGalleryInfo.
func (c CommunityGalleryInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "communityGalleryEnabled", c.CommunityGalleryEnabled)
	populate(objectMap, "eula", c.Eula)
	populate(objectMap, "publicNamePrefix", c.PublicNamePrefix)
	populate(objectMap, "publicNames", c.PublicNames)
	populate(objectMap, "publisherContact", c.PublisherContact)
	populate(objectMap, "publisherUri", c.PublisherURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunityGalleryInfo.
func (c *CommunityGalleryInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "communityGalleryEnabled":
			err = unpopulate(val, "CommunityGalleryEnabled", &c.CommunityGalleryEnabled)
			delete(rawMsg, key)
		case "eula":
			err = unpopulate(val, "Eula", &c.Eula)
			delete(rawMsg, key)
		case "publicNamePrefix":
			err = unpopulate(val, "PublicNamePrefix", &c.PublicNamePrefix)
			delete(rawMsg, key)
		case "publicNames":
			err = unpopulate(val, "PublicNames", &c.PublicNames)
			delete(rawMsg, key)
		case "publisherContact":
			err = unpopulate(val, "PublisherContact", &c.PublisherContact)
			delete(rawMsg, key)
		case "publisherUri":
			err = unpopulate(val, "PublisherURI", &c.PublisherURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommunityGalleryMetadata.
func (c CommunityGalleryMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eula", c.Eula)
	populate(objectMap, "privacyStatementUri", c.PrivacyStatementURI)
	populate(objectMap, "publicNames", c.PublicNames)
	populate(objectMap, "publisherContact", c.PublisherContact)
	populate(objectMap, "publisherUri", c.PublisherURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunityGalleryMetadata.
func (c *CommunityGalleryMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eula":
			err = unpopulate(val, "Eula", &c.Eula)
			delete(rawMsg, key)
		case "privacyStatementUri":
			err = unpopulate(val, "PrivacyStatementURI", &c.PrivacyStatementURI)
			delete(rawMsg, key)
		case "publicNames":
			err = unpopulate(val, "PublicNames", &c.PublicNames)
			delete(rawMsg, key)
		case "publisherContact":
			err = unpopulate(val, "PublisherContact", &c.PublisherContact)
			delete(rawMsg, key)
		case "publisherUri":
			err = unpopulate(val, "PublisherURI", &c.PublisherURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommunityGalleryProperties.
func (c CommunityGalleryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactTags", c.ArtifactTags)
	populate(objectMap, "communityMetadata", c.CommunityMetadata)
	populate(objectMap, "disclaimer", c.Disclaimer)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunityGalleryProperties.
func (c *CommunityGalleryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactTags":
			err = unpopulate(val, "ArtifactTags", &c.ArtifactTags)
			delete(rawMsg, key)
		case "communityMetadata":
			err = unpopulate(val, "CommunityMetadata", &c.CommunityMetadata)
			delete(rawMsg, key)
		case "disclaimer":
			err = unpopulate(val, "Disclaimer", &c.Disclaimer)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CopyCompletionError.
func (c CopyCompletionError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorCode", c.ErrorCode)
	populate(objectMap, "errorMessage", c.ErrorMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CopyCompletionError.
func (c *CopyCompletionError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &c.ErrorCode)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &c.ErrorMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreationData.
func (c CreationData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "createOption", c.CreateOption)
	populate(objectMap, "elasticSanResourceId", c.ElasticSanResourceID)
	populate(objectMap, "galleryImageReference", c.GalleryImageReference)
	populate(objectMap, "imageReference", c.ImageReference)
	populate(objectMap, "logicalSectorSize", c.LogicalSectorSize)
	populate(objectMap, "performancePlus", c.PerformancePlus)
	populate(objectMap, "provisionedBandwidthCopySpeed", c.ProvisionedBandwidthCopySpeed)
	populate(objectMap, "securityDataUri", c.SecurityDataURI)
	populate(objectMap, "sourceResourceId", c.SourceResourceID)
	populate(objectMap, "sourceUri", c.SourceURI)
	populate(objectMap, "sourceUniqueId", c.SourceUniqueID)
	populate(objectMap, "storageAccountId", c.StorageAccountID)
	populate(objectMap, "uploadSizeBytes", c.UploadSizeBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreationData.
func (c *CreationData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createOption":
			err = unpopulate(val, "CreateOption", &c.CreateOption)
			delete(rawMsg, key)
		case "elasticSanResourceId":
			err = unpopulate(val, "ElasticSanResourceID", &c.ElasticSanResourceID)
			delete(rawMsg, key)
		case "galleryImageReference":
			err = unpopulate(val, "GalleryImageReference", &c.GalleryImageReference)
			delete(rawMsg, key)
		case "imageReference":
			err = unpopulate(val, "ImageReference", &c.ImageReference)
			delete(rawMsg, key)
		case "logicalSectorSize":
			err = unpopulate(val, "LogicalSectorSize", &c.LogicalSectorSize)
			delete(rawMsg, key)
		case "performancePlus":
			err = unpopulate(val, "PerformancePlus", &c.PerformancePlus)
			delete(rawMsg, key)
		case "provisionedBandwidthCopySpeed":
			err = unpopulate(val, "ProvisionedBandwidthCopySpeed", &c.ProvisionedBandwidthCopySpeed)
			delete(rawMsg, key)
		case "securityDataUri":
			err = unpopulate(val, "SecurityDataURI", &c.SecurityDataURI)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &c.SourceResourceID)
			delete(rawMsg, key)
		case "sourceUri":
			err = unpopulate(val, "SourceURI", &c.SourceURI)
			delete(rawMsg, key)
		case "sourceUniqueId":
			err = unpopulate(val, "SourceUniqueID", &c.SourceUniqueID)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &c.StorageAccountID)
			delete(rawMsg, key)
		case "uploadSizeBytes":
			err = unpopulate(val, "UploadSizeBytes", &c.UploadSizeBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataDisk.
func (d DataDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caching", d.Caching)
	populate(objectMap, "createOption", d.CreateOption)
	populate(objectMap, "deleteOption", d.DeleteOption)
	populate(objectMap, "detachOption", d.DetachOption)
	populate(objectMap, "diskIOPSReadWrite", d.DiskIOPSReadWrite)
	populate(objectMap, "diskMBpsReadWrite", d.DiskMBpsReadWrite)
	populate(objectMap, "diskSizeGB", d.DiskSizeGB)
	populate(objectMap, "image", d.Image)
	populate(objectMap, "lun", d.Lun)
	populate(objectMap, "managedDisk", d.ManagedDisk)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "toBeDetached", d.ToBeDetached)
	populate(objectMap, "vhd", d.Vhd)
	populate(objectMap, "writeAcceleratorEnabled", d.WriteAcceleratorEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataDisk.
func (d *DataDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caching":
			err = unpopulate(val, "Caching", &d.Caching)
			delete(rawMsg, key)
		case "createOption":
			err = unpopulate(val, "CreateOption", &d.CreateOption)
			delete(rawMsg, key)
		case "deleteOption":
			err = unpopulate(val, "DeleteOption", &d.DeleteOption)
			delete(rawMsg, key)
		case "detachOption":
			err = unpopulate(val, "DetachOption", &d.DetachOption)
			delete(rawMsg, key)
		case "diskIOPSReadWrite":
			err = unpopulate(val, "DiskIOPSReadWrite", &d.DiskIOPSReadWrite)
			delete(rawMsg, key)
		case "diskMBpsReadWrite":
			err = unpopulate(val, "DiskMBpsReadWrite", &d.DiskMBpsReadWrite)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &d.DiskSizeGB)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &d.Image)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &d.Lun)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &d.ManagedDisk)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "toBeDetached":
			err = unpopulate(val, "ToBeDetached", &d.ToBeDetached)
			delete(rawMsg, key)
		case "vhd":
			err = unpopulate(val, "Vhd", &d.Vhd)
			delete(rawMsg, key)
		case "writeAcceleratorEnabled":
			err = unpopulate(val, "WriteAcceleratorEnabled", &d.WriteAcceleratorEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataDiskImage.
func (d DataDiskImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "lun", d.Lun)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataDiskImage.
func (d *DataDiskImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lun":
			err = unpopulate(val, "Lun", &d.Lun)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataDiskImageEncryption.
func (d DataDiskImageEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSetId", d.DiskEncryptionSetID)
	populate(objectMap, "lun", d.Lun)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataDiskImageEncryption.
func (d *DataDiskImageEncryption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &d.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &d.Lun)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataDisksToAttach.
func (d DataDisksToAttach) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskId", d.DiskID)
	populate(objectMap, "lun", d.Lun)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataDisksToAttach.
func (d *DataDisksToAttach) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskId":
			err = unpopulate(val, "DiskID", &d.DiskID)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &d.Lun)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataDisksToDetach.
func (d DataDisksToDetach) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "detachOption", d.DetachOption)
	populate(objectMap, "diskId", d.DiskID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataDisksToDetach.
func (d *DataDisksToDetach) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "detachOption":
			err = unpopulate(val, "DetachOption", &d.DetachOption)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &d.DiskID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHost.
func (d DedicatedHost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHost.
func (d *DedicatedHost) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &d.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostAllocatableVM.
func (d DedicatedHostAllocatableVM) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", d.Count)
	populate(objectMap, "vmSize", d.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostAllocatableVM.
func (d *DedicatedHostAllocatableVM) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &d.Count)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &d.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostAvailableCapacity.
func (d DedicatedHostAvailableCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allocatableVMs", d.AllocatableVMs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostAvailableCapacity.
func (d *DedicatedHostAvailableCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocatableVMs":
			err = unpopulate(val, "AllocatableVMs", &d.AllocatableVMs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroup.
func (d DedicatedHostGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	populate(objectMap, "zones", d.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostGroup.
func (d *DedicatedHostGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &d.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroupInstanceView.
func (d DedicatedHostGroupInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hosts", d.Hosts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostGroupInstanceView.
func (d *DedicatedHostGroupInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hosts":
			err = unpopulate(val, "Hosts", &d.Hosts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroupListResult.
func (d DedicatedHostGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostGroupListResult.
func (d *DedicatedHostGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroupProperties.
func (d DedicatedHostGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalCapabilities", d.AdditionalCapabilities)
	populate(objectMap, "hosts", d.Hosts)
	populate(objectMap, "instanceView", d.InstanceView)
	populate(objectMap, "platformFaultDomainCount", d.PlatformFaultDomainCount)
	populate(objectMap, "supportAutomaticPlacement", d.SupportAutomaticPlacement)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostGroupProperties.
func (d *DedicatedHostGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalCapabilities":
			err = unpopulate(val, "AdditionalCapabilities", &d.AdditionalCapabilities)
			delete(rawMsg, key)
		case "hosts":
			err = unpopulate(val, "Hosts", &d.Hosts)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &d.InstanceView)
			delete(rawMsg, key)
		case "platformFaultDomainCount":
			err = unpopulate(val, "PlatformFaultDomainCount", &d.PlatformFaultDomainCount)
			delete(rawMsg, key)
		case "supportAutomaticPlacement":
			err = unpopulate(val, "SupportAutomaticPlacement", &d.SupportAutomaticPlacement)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroupPropertiesAdditionalCapabilities.
func (d DedicatedHostGroupPropertiesAdditionalCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ultraSSDEnabled", d.UltraSSDEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostGroupPropertiesAdditionalCapabilities.
func (d *DedicatedHostGroupPropertiesAdditionalCapabilities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ultraSSDEnabled":
			err = unpopulate(val, "UltraSSDEnabled", &d.UltraSSDEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostGroupUpdate.
func (d DedicatedHostGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "zones", d.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostGroupUpdate.
func (d *DedicatedHostGroupUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &d.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostInstanceView.
func (d DedicatedHostInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assetId", d.AssetID)
	populate(objectMap, "availableCapacity", d.AvailableCapacity)
	populate(objectMap, "statuses", d.Statuses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostInstanceView.
func (d *DedicatedHostInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assetId":
			err = unpopulate(val, "AssetID", &d.AssetID)
			delete(rawMsg, key)
		case "availableCapacity":
			err = unpopulate(val, "AvailableCapacity", &d.AvailableCapacity)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &d.Statuses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostInstanceViewWithName.
func (d DedicatedHostInstanceViewWithName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assetId", d.AssetID)
	populate(objectMap, "availableCapacity", d.AvailableCapacity)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "statuses", d.Statuses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostInstanceViewWithName.
func (d *DedicatedHostInstanceViewWithName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assetId":
			err = unpopulate(val, "AssetID", &d.AssetID)
			delete(rawMsg, key)
		case "availableCapacity":
			err = unpopulate(val, "AvailableCapacity", &d.AvailableCapacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &d.Statuses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostListResult.
func (d DedicatedHostListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostListResult.
func (d *DedicatedHostListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostProperties.
func (d DedicatedHostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoReplaceOnFailure", d.AutoReplaceOnFailure)
	populate(objectMap, "hostId", d.HostID)
	populate(objectMap, "instanceView", d.InstanceView)
	populate(objectMap, "licenseType", d.LicenseType)
	populate(objectMap, "platformFaultDomain", d.PlatformFaultDomain)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populateDateTimeRFC3339(objectMap, "provisioningTime", d.ProvisioningTime)
	populateDateTimeRFC3339(objectMap, "timeCreated", d.TimeCreated)
	populate(objectMap, "virtualMachines", d.VirtualMachines)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostProperties.
func (d *DedicatedHostProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoReplaceOnFailure":
			err = unpopulate(val, "AutoReplaceOnFailure", &d.AutoReplaceOnFailure)
			delete(rawMsg, key)
		case "hostId":
			err = unpopulate(val, "HostID", &d.HostID)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &d.InstanceView)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &d.LicenseType)
			delete(rawMsg, key)
		case "platformFaultDomain":
			err = unpopulate(val, "PlatformFaultDomain", &d.PlatformFaultDomain)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "provisioningTime":
			err = unpopulateDateTimeRFC3339(val, "ProvisioningTime", &d.ProvisioningTime)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateDateTimeRFC3339(val, "TimeCreated", &d.TimeCreated)
			delete(rawMsg, key)
		case "virtualMachines":
			err = unpopulate(val, "VirtualMachines", &d.VirtualMachines)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostSizeListResult.
func (d DedicatedHostSizeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostSizeListResult.
func (d *DedicatedHostSizeListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DedicatedHostUpdate.
func (d DedicatedHostUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DedicatedHostUpdate.
func (d *DedicatedHostUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &d.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsProfile.
func (d DiagnosticsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bootDiagnostics", d.BootDiagnostics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsProfile.
func (d *DiagnosticsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bootDiagnostics":
			err = unpopulate(val, "BootDiagnostics", &d.BootDiagnostics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiffDiskSettings.
func (d DiffDiskSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "option", d.Option)
	populate(objectMap, "placement", d.Placement)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiffDiskSettings.
func (d *DiffDiskSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "option":
			err = unpopulate(val, "Option", &d.Option)
			delete(rawMsg, key)
		case "placement":
			err = unpopulate(val, "Placement", &d.Placement)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Disallowed.
func (d Disallowed) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskTypes", d.DiskTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Disallowed.
func (d *Disallowed) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskTypes":
			err = unpopulate(val, "DiskTypes", &d.DiskTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DisallowedConfiguration.
func (d DisallowedConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vmDiskType", d.VMDiskType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DisallowedConfiguration.
func (d *DisallowedConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vmDiskType":
			err = unpopulate(val, "VMDiskType", &d.VMDiskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Disk.
func (d Disk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", d.ExtendedLocation)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "managedBy", d.ManagedBy)
	populate(objectMap, "managedByExtended", d.ManagedByExtended)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	populate(objectMap, "zones", d.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Disk.
func (d *Disk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &d.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "managedBy":
			err = unpopulate(val, "ManagedBy", &d.ManagedBy)
			delete(rawMsg, key)
		case "managedByExtended":
			err = unpopulate(val, "ManagedByExtended", &d.ManagedByExtended)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &d.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &d.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskAccess.
func (d DiskAccess) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", d.ExtendedLocation)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskAccess.
func (d *DiskAccess) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &d.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskAccessList.
func (d DiskAccessList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskAccessList.
func (d *DiskAccessList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskAccessProperties.
func (d DiskAccessProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateEndpointConnections", d.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populateDateTimeRFC3339(objectMap, "timeCreated", d.TimeCreated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskAccessProperties.
func (d *DiskAccessProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &d.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateDateTimeRFC3339(val, "TimeCreated", &d.TimeCreated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskAccessUpdate.
func (d DiskAccessUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskAccessUpdate.
func (d *DiskAccessUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSet.
func (d DiskEncryptionSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "identity", d.Identity)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionSet.
func (d *DiskEncryptionSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &d.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSetList.
func (d DiskEncryptionSetList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionSetList.
func (d *DiskEncryptionSetList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSetParameters.
func (d DiskEncryptionSetParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionSetParameters.
func (d *DiskEncryptionSetParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSetUpdate.
func (d DiskEncryptionSetUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", d.Identity)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionSetUpdate.
func (d *DiskEncryptionSetUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &d.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSetUpdateProperties.
func (d DiskEncryptionSetUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeKey", d.ActiveKey)
	populate(objectMap, "encryptionType", d.EncryptionType)
	populate(objectMap, "federatedClientId", d.FederatedClientID)
	populate(objectMap, "rotationToLatestKeyVersionEnabled", d.RotationToLatestKeyVersionEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionSetUpdateProperties.
func (d *DiskEncryptionSetUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeKey":
			err = unpopulate(val, "ActiveKey", &d.ActiveKey)
			delete(rawMsg, key)
		case "encryptionType":
			err = unpopulate(val, "EncryptionType", &d.EncryptionType)
			delete(rawMsg, key)
		case "federatedClientId":
			err = unpopulate(val, "FederatedClientID", &d.FederatedClientID)
			delete(rawMsg, key)
		case "rotationToLatestKeyVersionEnabled":
			err = unpopulate(val, "RotationToLatestKeyVersionEnabled", &d.RotationToLatestKeyVersionEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSettings.
func (d DiskEncryptionSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionKey", d.DiskEncryptionKey)
	populate(objectMap, "enabled", d.Enabled)
	populate(objectMap, "keyEncryptionKey", d.KeyEncryptionKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionSettings.
func (d *DiskEncryptionSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionKey":
			err = unpopulate(val, "DiskEncryptionKey", &d.DiskEncryptionKey)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &d.KeyEncryptionKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskImageEncryption.
func (d DiskImageEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSetId", d.DiskEncryptionSetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskImageEncryption.
func (d *DiskImageEncryption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &d.DiskEncryptionSetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskInstanceView.
func (d DiskInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionSettings", d.EncryptionSettings)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "statuses", d.Statuses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskInstanceView.
func (d *DiskInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionSettings":
			err = unpopulate(val, "EncryptionSettings", &d.EncryptionSettings)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &d.Statuses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskList.
func (d DiskList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskList.
func (d *DiskList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskProperties.
func (d DiskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "burstingEnabled", d.BurstingEnabled)
	populateDateTimeRFC3339(objectMap, "burstingEnabledTime", d.BurstingEnabledTime)
	populate(objectMap, "completionPercent", d.CompletionPercent)
	populate(objectMap, "creationData", d.CreationData)
	populate(objectMap, "dataAccessAuthMode", d.DataAccessAuthMode)
	populate(objectMap, "diskAccessId", d.DiskAccessID)
	populate(objectMap, "diskIOPSReadOnly", d.DiskIOPSReadOnly)
	populate(objectMap, "diskIOPSReadWrite", d.DiskIOPSReadWrite)
	populate(objectMap, "diskMBpsReadOnly", d.DiskMBpsReadOnly)
	populate(objectMap, "diskMBpsReadWrite", d.DiskMBpsReadWrite)
	populate(objectMap, "diskSizeBytes", d.DiskSizeBytes)
	populate(objectMap, "diskSizeGB", d.DiskSizeGB)
	populate(objectMap, "diskState", d.DiskState)
	populate(objectMap, "encryption", d.Encryption)
	populate(objectMap, "encryptionSettingsCollection", d.EncryptionSettingsCollection)
	populate(objectMap, "hyperVGeneration", d.HyperVGeneration)
	populateDateTimeRFC3339(objectMap, "LastOwnershipUpdateTime", d.LastOwnershipUpdateTime)
	populate(objectMap, "maxShares", d.MaxShares)
	populate(objectMap, "networkAccessPolicy", d.NetworkAccessPolicy)
	populate(objectMap, "osType", d.OSType)
	populate(objectMap, "optimizedForFrequentAttach", d.OptimizedForFrequentAttach)
	populate(objectMap, "propertyUpdatesInProgress", d.PropertyUpdatesInProgress)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", d.PublicNetworkAccess)
	populate(objectMap, "purchasePlan", d.PurchasePlan)
	populate(objectMap, "securityProfile", d.SecurityProfile)
	populate(objectMap, "shareInfo", d.ShareInfo)
	populate(objectMap, "supportedCapabilities", d.SupportedCapabilities)
	populate(objectMap, "supportsHibernation", d.SupportsHibernation)
	populate(objectMap, "tier", d.Tier)
	populateDateTimeRFC3339(objectMap, "timeCreated", d.TimeCreated)
	populate(objectMap, "uniqueId", d.UniqueID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskProperties.
func (d *DiskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "burstingEnabled":
			err = unpopulate(val, "BurstingEnabled", &d.BurstingEnabled)
			delete(rawMsg, key)
		case "burstingEnabledTime":
			err = unpopulateDateTimeRFC3339(val, "BurstingEnabledTime", &d.BurstingEnabledTime)
			delete(rawMsg, key)
		case "completionPercent":
			err = unpopulate(val, "CompletionPercent", &d.CompletionPercent)
			delete(rawMsg, key)
		case "creationData":
			err = unpopulate(val, "CreationData", &d.CreationData)
			delete(rawMsg, key)
		case "dataAccessAuthMode":
			err = unpopulate(val, "DataAccessAuthMode", &d.DataAccessAuthMode)
			delete(rawMsg, key)
		case "diskAccessId":
			err = unpopulate(val, "DiskAccessID", &d.DiskAccessID)
			delete(rawMsg, key)
		case "diskIOPSReadOnly":
			err = unpopulate(val, "DiskIOPSReadOnly", &d.DiskIOPSReadOnly)
			delete(rawMsg, key)
		case "diskIOPSReadWrite":
			err = unpopulate(val, "DiskIOPSReadWrite", &d.DiskIOPSReadWrite)
			delete(rawMsg, key)
		case "diskMBpsReadOnly":
			err = unpopulate(val, "DiskMBpsReadOnly", &d.DiskMBpsReadOnly)
			delete(rawMsg, key)
		case "diskMBpsReadWrite":
			err = unpopulate(val, "DiskMBpsReadWrite", &d.DiskMBpsReadWrite)
			delete(rawMsg, key)
		case "diskSizeBytes":
			err = unpopulate(val, "DiskSizeBytes", &d.DiskSizeBytes)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &d.DiskSizeGB)
			delete(rawMsg, key)
		case "diskState":
			err = unpopulate(val, "DiskState", &d.DiskState)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &d.Encryption)
			delete(rawMsg, key)
		case "encryptionSettingsCollection":
			err = unpopulate(val, "EncryptionSettingsCollection", &d.EncryptionSettingsCollection)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &d.HyperVGeneration)
			delete(rawMsg, key)
		case "LastOwnershipUpdateTime":
			err = unpopulateDateTimeRFC3339(val, "LastOwnershipUpdateTime", &d.LastOwnershipUpdateTime)
			delete(rawMsg, key)
		case "maxShares":
			err = unpopulate(val, "MaxShares", &d.MaxShares)
			delete(rawMsg, key)
		case "networkAccessPolicy":
			err = unpopulate(val, "NetworkAccessPolicy", &d.NetworkAccessPolicy)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &d.OSType)
			delete(rawMsg, key)
		case "optimizedForFrequentAttach":
			err = unpopulate(val, "OptimizedForFrequentAttach", &d.OptimizedForFrequentAttach)
			delete(rawMsg, key)
		case "propertyUpdatesInProgress":
			err = unpopulate(val, "PropertyUpdatesInProgress", &d.PropertyUpdatesInProgress)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &d.PublicNetworkAccess)
			delete(rawMsg, key)
		case "purchasePlan":
			err = unpopulate(val, "PurchasePlan", &d.PurchasePlan)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &d.SecurityProfile)
			delete(rawMsg, key)
		case "shareInfo":
			err = unpopulate(val, "ShareInfo", &d.ShareInfo)
			delete(rawMsg, key)
		case "supportedCapabilities":
			err = unpopulate(val, "SupportedCapabilities", &d.SupportedCapabilities)
			delete(rawMsg, key)
		case "supportsHibernation":
			err = unpopulate(val, "SupportsHibernation", &d.SupportsHibernation)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &d.Tier)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateDateTimeRFC3339(val, "TimeCreated", &d.TimeCreated)
			delete(rawMsg, key)
		case "uniqueId":
			err = unpopulate(val, "UniqueID", &d.UniqueID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskPurchasePlan.
func (d DiskPurchasePlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "product", d.Product)
	populate(objectMap, "promotionCode", d.PromotionCode)
	populate(objectMap, "publisher", d.Publisher)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskPurchasePlan.
func (d *DiskPurchasePlan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &d.Product)
			delete(rawMsg, key)
		case "promotionCode":
			err = unpopulate(val, "PromotionCode", &d.PromotionCode)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &d.Publisher)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskRestorePoint.
func (d DiskRestorePoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskRestorePoint.
func (d *DiskRestorePoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskRestorePointAttributes.
func (d DiskRestorePointAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryption", d.Encryption)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "sourceDiskRestorePoint", d.SourceDiskRestorePoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskRestorePointAttributes.
func (d *DiskRestorePointAttributes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryption":
			err = unpopulate(val, "Encryption", &d.Encryption)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "sourceDiskRestorePoint":
			err = unpopulate(val, "SourceDiskRestorePoint", &d.SourceDiskRestorePoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskRestorePointInstanceView.
func (d DiskRestorePointInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "replicationStatus", d.ReplicationStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskRestorePointInstanceView.
func (d *DiskRestorePointInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "replicationStatus":
			err = unpopulate(val, "ReplicationStatus", &d.ReplicationStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskRestorePointList.
func (d DiskRestorePointList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskRestorePointList.
func (d *DiskRestorePointList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskRestorePointProperties.
func (d DiskRestorePointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "completionPercent", d.CompletionPercent)
	populate(objectMap, "diskAccessId", d.DiskAccessID)
	populate(objectMap, "encryption", d.Encryption)
	populate(objectMap, "familyId", d.FamilyID)
	populate(objectMap, "hyperVGeneration", d.HyperVGeneration)
	populate(objectMap, "networkAccessPolicy", d.NetworkAccessPolicy)
	populate(objectMap, "osType", d.OSType)
	populate(objectMap, "publicNetworkAccess", d.PublicNetworkAccess)
	populate(objectMap, "purchasePlan", d.PurchasePlan)
	populate(objectMap, "replicationState", d.ReplicationState)
	populate(objectMap, "securityProfile", d.SecurityProfile)
	populate(objectMap, "sourceResourceId", d.SourceResourceID)
	populate(objectMap, "sourceResourceLocation", d.SourceResourceLocation)
	populate(objectMap, "sourceUniqueId", d.SourceUniqueID)
	populate(objectMap, "supportedCapabilities", d.SupportedCapabilities)
	populate(objectMap, "supportsHibernation", d.SupportsHibernation)
	populateDateTimeRFC3339(objectMap, "timeCreated", d.TimeCreated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskRestorePointProperties.
func (d *DiskRestorePointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completionPercent":
			err = unpopulate(val, "CompletionPercent", &d.CompletionPercent)
			delete(rawMsg, key)
		case "diskAccessId":
			err = unpopulate(val, "DiskAccessID", &d.DiskAccessID)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &d.Encryption)
			delete(rawMsg, key)
		case "familyId":
			err = unpopulate(val, "FamilyID", &d.FamilyID)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &d.HyperVGeneration)
			delete(rawMsg, key)
		case "networkAccessPolicy":
			err = unpopulate(val, "NetworkAccessPolicy", &d.NetworkAccessPolicy)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &d.OSType)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &d.PublicNetworkAccess)
			delete(rawMsg, key)
		case "purchasePlan":
			err = unpopulate(val, "PurchasePlan", &d.PurchasePlan)
			delete(rawMsg, key)
		case "replicationState":
			err = unpopulate(val, "ReplicationState", &d.ReplicationState)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &d.SecurityProfile)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &d.SourceResourceID)
			delete(rawMsg, key)
		case "sourceResourceLocation":
			err = unpopulate(val, "SourceResourceLocation", &d.SourceResourceLocation)
			delete(rawMsg, key)
		case "sourceUniqueId":
			err = unpopulate(val, "SourceUniqueID", &d.SourceUniqueID)
			delete(rawMsg, key)
		case "supportedCapabilities":
			err = unpopulate(val, "SupportedCapabilities", &d.SupportedCapabilities)
			delete(rawMsg, key)
		case "supportsHibernation":
			err = unpopulate(val, "SupportsHibernation", &d.SupportsHibernation)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateDateTimeRFC3339(val, "TimeCreated", &d.TimeCreated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskRestorePointReplicationStatus.
func (d DiskRestorePointReplicationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "completionPercent", d.CompletionPercent)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskRestorePointReplicationStatus.
func (d *DiskRestorePointReplicationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completionPercent":
			err = unpopulate(val, "CompletionPercent", &d.CompletionPercent)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskSKU.
func (d DiskSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "tier", d.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskSKU.
func (d *DiskSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &d.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskSecurityProfile.
func (d DiskSecurityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secureVMDiskEncryptionSetId", d.SecureVMDiskEncryptionSetID)
	populate(objectMap, "securityType", d.SecurityType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskSecurityProfile.
func (d *DiskSecurityProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secureVMDiskEncryptionSetId":
			err = unpopulate(val, "SecureVMDiskEncryptionSetID", &d.SecureVMDiskEncryptionSetID)
			delete(rawMsg, key)
		case "securityType":
			err = unpopulate(val, "SecurityType", &d.SecurityType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskUpdate.
func (d DiskUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskUpdate.
func (d *DiskUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &d.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskUpdateProperties.
func (d DiskUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "burstingEnabled", d.BurstingEnabled)
	populate(objectMap, "dataAccessAuthMode", d.DataAccessAuthMode)
	populate(objectMap, "diskAccessId", d.DiskAccessID)
	populate(objectMap, "diskIOPSReadOnly", d.DiskIOPSReadOnly)
	populate(objectMap, "diskIOPSReadWrite", d.DiskIOPSReadWrite)
	populate(objectMap, "diskMBpsReadOnly", d.DiskMBpsReadOnly)
	populate(objectMap, "diskMBpsReadWrite", d.DiskMBpsReadWrite)
	populate(objectMap, "diskSizeGB", d.DiskSizeGB)
	populate(objectMap, "encryption", d.Encryption)
	populate(objectMap, "encryptionSettingsCollection", d.EncryptionSettingsCollection)
	populate(objectMap, "maxShares", d.MaxShares)
	populate(objectMap, "networkAccessPolicy", d.NetworkAccessPolicy)
	populate(objectMap, "osType", d.OSType)
	populate(objectMap, "optimizedForFrequentAttach", d.OptimizedForFrequentAttach)
	populate(objectMap, "propertyUpdatesInProgress", d.PropertyUpdatesInProgress)
	populate(objectMap, "publicNetworkAccess", d.PublicNetworkAccess)
	populate(objectMap, "purchasePlan", d.PurchasePlan)
	populate(objectMap, "supportedCapabilities", d.SupportedCapabilities)
	populate(objectMap, "supportsHibernation", d.SupportsHibernation)
	populate(objectMap, "tier", d.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskUpdateProperties.
func (d *DiskUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "burstingEnabled":
			err = unpopulate(val, "BurstingEnabled", &d.BurstingEnabled)
			delete(rawMsg, key)
		case "dataAccessAuthMode":
			err = unpopulate(val, "DataAccessAuthMode", &d.DataAccessAuthMode)
			delete(rawMsg, key)
		case "diskAccessId":
			err = unpopulate(val, "DiskAccessID", &d.DiskAccessID)
			delete(rawMsg, key)
		case "diskIOPSReadOnly":
			err = unpopulate(val, "DiskIOPSReadOnly", &d.DiskIOPSReadOnly)
			delete(rawMsg, key)
		case "diskIOPSReadWrite":
			err = unpopulate(val, "DiskIOPSReadWrite", &d.DiskIOPSReadWrite)
			delete(rawMsg, key)
		case "diskMBpsReadOnly":
			err = unpopulate(val, "DiskMBpsReadOnly", &d.DiskMBpsReadOnly)
			delete(rawMsg, key)
		case "diskMBpsReadWrite":
			err = unpopulate(val, "DiskMBpsReadWrite", &d.DiskMBpsReadWrite)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &d.DiskSizeGB)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &d.Encryption)
			delete(rawMsg, key)
		case "encryptionSettingsCollection":
			err = unpopulate(val, "EncryptionSettingsCollection", &d.EncryptionSettingsCollection)
			delete(rawMsg, key)
		case "maxShares":
			err = unpopulate(val, "MaxShares", &d.MaxShares)
			delete(rawMsg, key)
		case "networkAccessPolicy":
			err = unpopulate(val, "NetworkAccessPolicy", &d.NetworkAccessPolicy)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &d.OSType)
			delete(rawMsg, key)
		case "optimizedForFrequentAttach":
			err = unpopulate(val, "OptimizedForFrequentAttach", &d.OptimizedForFrequentAttach)
			delete(rawMsg, key)
		case "propertyUpdatesInProgress":
			err = unpopulate(val, "PropertyUpdatesInProgress", &d.PropertyUpdatesInProgress)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &d.PublicNetworkAccess)
			delete(rawMsg, key)
		case "purchasePlan":
			err = unpopulate(val, "PurchasePlan", &d.PurchasePlan)
			delete(rawMsg, key)
		case "supportedCapabilities":
			err = unpopulate(val, "SupportedCapabilities", &d.SupportedCapabilities)
			delete(rawMsg, key)
		case "supportsHibernation":
			err = unpopulate(val, "SupportsHibernation", &d.SupportsHibernation)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &d.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Encryption.
func (e Encryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSetId", e.DiskEncryptionSetID)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Encryption.
func (e *Encryption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &e.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionIdentity.
func (e EncryptionIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "userAssignedIdentityResourceId", e.UserAssignedIdentityResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionIdentity.
func (e *EncryptionIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "userAssignedIdentityResourceId":
			err = unpopulate(val, "UserAssignedIdentityResourceID", &e.UserAssignedIdentityResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionImages.
func (e EncryptionImages) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDiskImages", e.DataDiskImages)
	populate(objectMap, "osDiskImage", e.OSDiskImage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionImages.
func (e *EncryptionImages) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDiskImages":
			err = unpopulate(val, "DataDiskImages", &e.DataDiskImages)
			delete(rawMsg, key)
		case "osDiskImage":
			err = unpopulate(val, "OSDiskImage", &e.OSDiskImage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionSetIdentity.
func (e EncryptionSetIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", e.PrincipalID)
	populate(objectMap, "tenantId", e.TenantID)
	populate(objectMap, "type", e.Type)
	populate(objectMap, "userAssignedIdentities", e.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionSetIdentity.
func (e *EncryptionSetIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &e.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &e.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &e.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionSetProperties.
func (e EncryptionSetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeKey", e.ActiveKey)
	populate(objectMap, "autoKeyRotationError", e.AutoKeyRotationError)
	populate(objectMap, "encryptionType", e.EncryptionType)
	populate(objectMap, "federatedClientId", e.FederatedClientID)
	populateDateTimeRFC3339(objectMap, "lastKeyRotationTimestamp", e.LastKeyRotationTimestamp)
	populate(objectMap, "previousKeys", e.PreviousKeys)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "rotationToLatestKeyVersionEnabled", e.RotationToLatestKeyVersionEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionSetProperties.
func (e *EncryptionSetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeKey":
			err = unpopulate(val, "ActiveKey", &e.ActiveKey)
			delete(rawMsg, key)
		case "autoKeyRotationError":
			err = unpopulate(val, "AutoKeyRotationError", &e.AutoKeyRotationError)
			delete(rawMsg, key)
		case "encryptionType":
			err = unpopulate(val, "EncryptionType", &e.EncryptionType)
			delete(rawMsg, key)
		case "federatedClientId":
			err = unpopulate(val, "FederatedClientID", &e.FederatedClientID)
			delete(rawMsg, key)
		case "lastKeyRotationTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastKeyRotationTimestamp", &e.LastKeyRotationTimestamp)
			delete(rawMsg, key)
		case "previousKeys":
			err = unpopulate(val, "PreviousKeys", &e.PreviousKeys)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "rotationToLatestKeyVersionEnabled":
			err = unpopulate(val, "RotationToLatestKeyVersionEnabled", &e.RotationToLatestKeyVersionEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionSettingsCollection.
func (e EncryptionSettingsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", e.Enabled)
	populate(objectMap, "encryptionSettings", e.EncryptionSettings)
	populate(objectMap, "encryptionSettingsVersion", e.EncryptionSettingsVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionSettingsCollection.
func (e *EncryptionSettingsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &e.Enabled)
			delete(rawMsg, key)
		case "encryptionSettings":
			err = unpopulate(val, "EncryptionSettings", &e.EncryptionSettings)
			delete(rawMsg, key)
		case "encryptionSettingsVersion":
			err = unpopulate(val, "EncryptionSettingsVersion", &e.EncryptionSettingsVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionSettingsElement.
func (e EncryptionSettingsElement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionKey", e.DiskEncryptionKey)
	populate(objectMap, "keyEncryptionKey", e.KeyEncryptionKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionSettingsElement.
func (e *EncryptionSettingsElement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionKey":
			err = unpopulate(val, "DiskEncryptionKey", &e.DiskEncryptionKey)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &e.KeyEncryptionKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedLocation.
func (e ExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedLocation.
func (e *ExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Extension.
func (e Extension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Extension.
func (e *Extension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gallery.
func (g Gallery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gallery.
func (g *Gallery) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplication.
func (g GalleryApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryApplication.
func (g *GalleryApplication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationCustomAction.
func (g GalleryApplicationCustomAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "parameters", g.Parameters)
	populate(objectMap, "script", g.Script)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryApplicationCustomAction.
func (g *GalleryApplicationCustomAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &g.Parameters)
			delete(rawMsg, key)
		case "script":
			err = unpopulate(val, "Script", &g.Script)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationCustomActionParameter.
func (g GalleryApplicationCustomActionParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultValue", g.DefaultValue)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "required", g.Required)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryApplicationCustomActionParameter.
func (g *GalleryApplicationCustomActionParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultValue":
			err = unpopulate(val, "DefaultValue", &g.DefaultValue)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "required":
			err = unpopulate(val, "Required", &g.Required)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationList.
func (g GalleryApplicationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryApplicationList.
func (g *GalleryApplicationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationProperties.
func (g GalleryApplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customActions", g.CustomActions)
	populate(objectMap, "description", g.Description)
	populateDateTimeRFC3339(objectMap, "endOfLifeDate", g.EndOfLifeDate)
	populate(objectMap, "eula", g.Eula)
	populate(objectMap, "privacyStatementUri", g.PrivacyStatementURI)
	populate(objectMap, "releaseNoteUri", g.ReleaseNoteURI)
	populate(objectMap, "supportedOSType", g.SupportedOSType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryApplicationProperties.
func (g *GalleryApplicationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customActions":
			err = unpopulate(val, "CustomActions", &g.CustomActions)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "endOfLifeDate":
			err = unpopulateDateTimeRFC3339(val, "EndOfLifeDate", &g.EndOfLifeDate)
			delete(rawMsg, key)
		case "eula":
			err = unpopulate(val, "Eula", &g.Eula)
			delete(rawMsg, key)
		case "privacyStatementUri":
			err = unpopulate(val, "PrivacyStatementURI", &g.PrivacyStatementURI)
			delete(rawMsg, key)
		case "releaseNoteUri":
			err = unpopulate(val, "ReleaseNoteURI", &g.ReleaseNoteURI)
			delete(rawMsg, key)
		case "supportedOSType":
			err = unpopulate(val, "SupportedOSType", &g.SupportedOSType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationUpdate.
func (g GalleryApplicationUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryApplicationUpdate.
func (g *GalleryApplicationUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationVersion.
func (g GalleryApplicationVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryApplicationVersion.
func (g *GalleryApplicationVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationVersionList.
func (g GalleryApplicationVersionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryApplicationVersionList.
func (g *GalleryApplicationVersionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationVersionProperties.
func (g GalleryApplicationVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "publishingProfile", g.PublishingProfile)
	populate(objectMap, "replicationStatus", g.ReplicationStatus)
	populate(objectMap, "safetyProfile", g.SafetyProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryApplicationVersionProperties.
func (g *GalleryApplicationVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &g.ProvisioningState)
			delete(rawMsg, key)
		case "publishingProfile":
			err = unpopulate(val, "PublishingProfile", &g.PublishingProfile)
			delete(rawMsg, key)
		case "replicationStatus":
			err = unpopulate(val, "ReplicationStatus", &g.ReplicationStatus)
			delete(rawMsg, key)
		case "safetyProfile":
			err = unpopulate(val, "SafetyProfile", &g.SafetyProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationVersionPublishingProfile.
func (g GalleryApplicationVersionPublishingProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "advancedSettings", g.AdvancedSettings)
	populate(objectMap, "customActions", g.CustomActions)
	populate(objectMap, "enableHealthCheck", g.EnableHealthCheck)
	populateDateTimeRFC3339(objectMap, "endOfLifeDate", g.EndOfLifeDate)
	populate(objectMap, "excludeFromLatest", g.ExcludeFromLatest)
	populate(objectMap, "manageActions", g.ManageActions)
	populateDateTimeRFC3339(objectMap, "publishedDate", g.PublishedDate)
	populate(objectMap, "replicaCount", g.ReplicaCount)
	populate(objectMap, "replicationMode", g.ReplicationMode)
	populate(objectMap, "settings", g.Settings)
	populate(objectMap, "source", g.Source)
	populate(objectMap, "storageAccountType", g.StorageAccountType)
	populate(objectMap, "targetExtendedLocations", g.TargetExtendedLocations)
	populate(objectMap, "targetRegions", g.TargetRegions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryApplicationVersionPublishingProfile.
func (g *GalleryApplicationVersionPublishingProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "advancedSettings":
			err = unpopulate(val, "AdvancedSettings", &g.AdvancedSettings)
			delete(rawMsg, key)
		case "customActions":
			err = unpopulate(val, "CustomActions", &g.CustomActions)
			delete(rawMsg, key)
		case "enableHealthCheck":
			err = unpopulate(val, "EnableHealthCheck", &g.EnableHealthCheck)
			delete(rawMsg, key)
		case "endOfLifeDate":
			err = unpopulateDateTimeRFC3339(val, "EndOfLifeDate", &g.EndOfLifeDate)
			delete(rawMsg, key)
		case "excludeFromLatest":
			err = unpopulate(val, "ExcludeFromLatest", &g.ExcludeFromLatest)
			delete(rawMsg, key)
		case "manageActions":
			err = unpopulate(val, "ManageActions", &g.ManageActions)
			delete(rawMsg, key)
		case "publishedDate":
			err = unpopulateDateTimeRFC3339(val, "PublishedDate", &g.PublishedDate)
			delete(rawMsg, key)
		case "replicaCount":
			err = unpopulate(val, "ReplicaCount", &g.ReplicaCount)
			delete(rawMsg, key)
		case "replicationMode":
			err = unpopulate(val, "ReplicationMode", &g.ReplicationMode)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &g.Settings)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &g.Source)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &g.StorageAccountType)
			delete(rawMsg, key)
		case "targetExtendedLocations":
			err = unpopulate(val, "TargetExtendedLocations", &g.TargetExtendedLocations)
			delete(rawMsg, key)
		case "targetRegions":
			err = unpopulate(val, "TargetRegions", &g.TargetRegions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationVersionSafetyProfile.
func (g GalleryApplicationVersionSafetyProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowDeletionOfReplicatedLocations", g.AllowDeletionOfReplicatedLocations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryApplicationVersionSafetyProfile.
func (g *GalleryApplicationVersionSafetyProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowDeletionOfReplicatedLocations":
			err = unpopulate(val, "AllowDeletionOfReplicatedLocations", &g.AllowDeletionOfReplicatedLocations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryApplicationVersionUpdate.
func (g GalleryApplicationVersionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryApplicationVersionUpdate.
func (g *GalleryApplicationVersionUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryArtifactPublishingProfileBase.
func (g GalleryArtifactPublishingProfileBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endOfLifeDate", g.EndOfLifeDate)
	populate(objectMap, "excludeFromLatest", g.ExcludeFromLatest)
	populateDateTimeRFC3339(objectMap, "publishedDate", g.PublishedDate)
	populate(objectMap, "replicaCount", g.ReplicaCount)
	populate(objectMap, "replicationMode", g.ReplicationMode)
	populate(objectMap, "storageAccountType", g.StorageAccountType)
	populate(objectMap, "targetExtendedLocations", g.TargetExtendedLocations)
	populate(objectMap, "targetRegions", g.TargetRegions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryArtifactPublishingProfileBase.
func (g *GalleryArtifactPublishingProfileBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endOfLifeDate":
			err = unpopulateDateTimeRFC3339(val, "EndOfLifeDate", &g.EndOfLifeDate)
			delete(rawMsg, key)
		case "excludeFromLatest":
			err = unpopulate(val, "ExcludeFromLatest", &g.ExcludeFromLatest)
			delete(rawMsg, key)
		case "publishedDate":
			err = unpopulateDateTimeRFC3339(val, "PublishedDate", &g.PublishedDate)
			delete(rawMsg, key)
		case "replicaCount":
			err = unpopulate(val, "ReplicaCount", &g.ReplicaCount)
			delete(rawMsg, key)
		case "replicationMode":
			err = unpopulate(val, "ReplicationMode", &g.ReplicationMode)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &g.StorageAccountType)
			delete(rawMsg, key)
		case "targetExtendedLocations":
			err = unpopulate(val, "TargetExtendedLocations", &g.TargetExtendedLocations)
			delete(rawMsg, key)
		case "targetRegions":
			err = unpopulate(val, "TargetRegions", &g.TargetRegions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryArtifactSafetyProfileBase.
func (g GalleryArtifactSafetyProfileBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowDeletionOfReplicatedLocations", g.AllowDeletionOfReplicatedLocations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryArtifactSafetyProfileBase.
func (g *GalleryArtifactSafetyProfileBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowDeletionOfReplicatedLocations":
			err = unpopulate(val, "AllowDeletionOfReplicatedLocations", &g.AllowDeletionOfReplicatedLocations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryArtifactSource.
func (g GalleryArtifactSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "managedImage", g.ManagedImage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryArtifactSource.
func (g *GalleryArtifactSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "managedImage":
			err = unpopulate(val, "ManagedImage", &g.ManagedImage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryArtifactVersionFullSource.
func (g GalleryArtifactVersionFullSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "communityGalleryImageId", g.CommunityGalleryImageID)
	populate(objectMap, "id", g.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryArtifactVersionFullSource.
func (g *GalleryArtifactVersionFullSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "communityGalleryImageId":
			err = unpopulate(val, "CommunityGalleryImageID", &g.CommunityGalleryImageID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryArtifactVersionSource.
func (g GalleryArtifactVersionSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryArtifactVersionSource.
func (g *GalleryArtifactVersionSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryDataDiskImage.
func (g GalleryDataDiskImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostCaching", g.HostCaching)
	populate(objectMap, "lun", g.Lun)
	populate(objectMap, "sizeInGB", g.SizeInGB)
	populate(objectMap, "source", g.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryDataDiskImage.
func (g *GalleryDataDiskImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostCaching":
			err = unpopulate(val, "HostCaching", &g.HostCaching)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &g.Lun)
			delete(rawMsg, key)
		case "sizeInGB":
			err = unpopulate(val, "SizeInGB", &g.SizeInGB)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &g.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryDiskImage.
func (g GalleryDiskImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostCaching", g.HostCaching)
	populate(objectMap, "sizeInGB", g.SizeInGB)
	populate(objectMap, "source", g.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryDiskImage.
func (g *GalleryDiskImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostCaching":
			err = unpopulate(val, "HostCaching", &g.HostCaching)
			delete(rawMsg, key)
		case "sizeInGB":
			err = unpopulate(val, "SizeInGB", &g.SizeInGB)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &g.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryDiskImageSource.
func (g GalleryDiskImageSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "storageAccountId", g.StorageAccountID)
	populate(objectMap, "uri", g.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryDiskImageSource.
func (g *GalleryDiskImageSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &g.StorageAccountID)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &g.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryExtendedLocation.
func (g GalleryExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryExtendedLocation.
func (g *GalleryExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryIdentifier.
func (g GalleryIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "uniqueName", g.UniqueName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryIdentifier.
func (g *GalleryIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "uniqueName":
			err = unpopulate(val, "UniqueName", &g.UniqueName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImage.
func (g GalleryImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImage.
func (g *GalleryImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageFeature.
func (g GalleryImageFeature) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageFeature.
func (g *GalleryImageFeature) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageIdentifier.
func (g GalleryImageIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "offer", g.Offer)
	populate(objectMap, "publisher", g.Publisher)
	populate(objectMap, "sku", g.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageIdentifier.
func (g *GalleryImageIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "offer":
			err = unpopulate(val, "Offer", &g.Offer)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &g.Publisher)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &g.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageList.
func (g GalleryImageList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageList.
func (g *GalleryImageList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageProperties.
func (g GalleryImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "architecture", g.Architecture)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "disallowed", g.Disallowed)
	populateDateTimeRFC3339(objectMap, "endOfLifeDate", g.EndOfLifeDate)
	populate(objectMap, "eula", g.Eula)
	populate(objectMap, "features", g.Features)
	populate(objectMap, "hyperVGeneration", g.HyperVGeneration)
	populate(objectMap, "identifier", g.Identifier)
	populate(objectMap, "osState", g.OSState)
	populate(objectMap, "osType", g.OSType)
	populate(objectMap, "privacyStatementUri", g.PrivacyStatementURI)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "purchasePlan", g.PurchasePlan)
	populate(objectMap, "recommended", g.Recommended)
	populate(objectMap, "releaseNoteUri", g.ReleaseNoteURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageProperties.
func (g *GalleryImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "architecture":
			err = unpopulate(val, "Architecture", &g.Architecture)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "disallowed":
			err = unpopulate(val, "Disallowed", &g.Disallowed)
			delete(rawMsg, key)
		case "endOfLifeDate":
			err = unpopulateDateTimeRFC3339(val, "EndOfLifeDate", &g.EndOfLifeDate)
			delete(rawMsg, key)
		case "eula":
			err = unpopulate(val, "Eula", &g.Eula)
			delete(rawMsg, key)
		case "features":
			err = unpopulate(val, "Features", &g.Features)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &g.HyperVGeneration)
			delete(rawMsg, key)
		case "identifier":
			err = unpopulate(val, "Identifier", &g.Identifier)
			delete(rawMsg, key)
		case "osState":
			err = unpopulate(val, "OSState", &g.OSState)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &g.OSType)
			delete(rawMsg, key)
		case "privacyStatementUri":
			err = unpopulate(val, "PrivacyStatementURI", &g.PrivacyStatementURI)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &g.ProvisioningState)
			delete(rawMsg, key)
		case "purchasePlan":
			err = unpopulate(val, "PurchasePlan", &g.PurchasePlan)
			delete(rawMsg, key)
		case "recommended":
			err = unpopulate(val, "Recommended", &g.Recommended)
			delete(rawMsg, key)
		case "releaseNoteUri":
			err = unpopulate(val, "ReleaseNoteURI", &g.ReleaseNoteURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageUpdate.
func (g GalleryImageUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageUpdate.
func (g *GalleryImageUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageVersion.
func (g GalleryImageVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageVersion.
func (g *GalleryImageVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageVersionList.
func (g GalleryImageVersionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageVersionList.
func (g *GalleryImageVersionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageVersionProperties.
func (g GalleryImageVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "publishingProfile", g.PublishingProfile)
	populate(objectMap, "replicationStatus", g.ReplicationStatus)
	populate(objectMap, "safetyProfile", g.SafetyProfile)
	populate(objectMap, "securityProfile", g.SecurityProfile)
	populate(objectMap, "storageProfile", g.StorageProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageVersionProperties.
func (g *GalleryImageVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &g.ProvisioningState)
			delete(rawMsg, key)
		case "publishingProfile":
			err = unpopulate(val, "PublishingProfile", &g.PublishingProfile)
			delete(rawMsg, key)
		case "replicationStatus":
			err = unpopulate(val, "ReplicationStatus", &g.ReplicationStatus)
			delete(rawMsg, key)
		case "safetyProfile":
			err = unpopulate(val, "SafetyProfile", &g.SafetyProfile)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &g.SecurityProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &g.StorageProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageVersionPublishingProfile.
func (g GalleryImageVersionPublishingProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endOfLifeDate", g.EndOfLifeDate)
	populate(objectMap, "excludeFromLatest", g.ExcludeFromLatest)
	populateDateTimeRFC3339(objectMap, "publishedDate", g.PublishedDate)
	populate(objectMap, "replicaCount", g.ReplicaCount)
	populate(objectMap, "replicationMode", g.ReplicationMode)
	populate(objectMap, "storageAccountType", g.StorageAccountType)
	populate(objectMap, "targetExtendedLocations", g.TargetExtendedLocations)
	populate(objectMap, "targetRegions", g.TargetRegions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageVersionPublishingProfile.
func (g *GalleryImageVersionPublishingProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endOfLifeDate":
			err = unpopulateDateTimeRFC3339(val, "EndOfLifeDate", &g.EndOfLifeDate)
			delete(rawMsg, key)
		case "excludeFromLatest":
			err = unpopulate(val, "ExcludeFromLatest", &g.ExcludeFromLatest)
			delete(rawMsg, key)
		case "publishedDate":
			err = unpopulateDateTimeRFC3339(val, "PublishedDate", &g.PublishedDate)
			delete(rawMsg, key)
		case "replicaCount":
			err = unpopulate(val, "ReplicaCount", &g.ReplicaCount)
			delete(rawMsg, key)
		case "replicationMode":
			err = unpopulate(val, "ReplicationMode", &g.ReplicationMode)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &g.StorageAccountType)
			delete(rawMsg, key)
		case "targetExtendedLocations":
			err = unpopulate(val, "TargetExtendedLocations", &g.TargetExtendedLocations)
			delete(rawMsg, key)
		case "targetRegions":
			err = unpopulate(val, "TargetRegions", &g.TargetRegions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageVersionSafetyProfile.
func (g GalleryImageVersionSafetyProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowDeletionOfReplicatedLocations", g.AllowDeletionOfReplicatedLocations)
	populate(objectMap, "policyViolations", g.PolicyViolations)
	populate(objectMap, "reportedForPolicyViolation", g.ReportedForPolicyViolation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageVersionSafetyProfile.
func (g *GalleryImageVersionSafetyProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowDeletionOfReplicatedLocations":
			err = unpopulate(val, "AllowDeletionOfReplicatedLocations", &g.AllowDeletionOfReplicatedLocations)
			delete(rawMsg, key)
		case "policyViolations":
			err = unpopulate(val, "PolicyViolations", &g.PolicyViolations)
			delete(rawMsg, key)
		case "reportedForPolicyViolation":
			err = unpopulate(val, "ReportedForPolicyViolation", &g.ReportedForPolicyViolation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageVersionStorageProfile.
func (g GalleryImageVersionStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDiskImages", g.DataDiskImages)
	populate(objectMap, "osDiskImage", g.OSDiskImage)
	populate(objectMap, "source", g.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageVersionStorageProfile.
func (g *GalleryImageVersionStorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDiskImages":
			err = unpopulate(val, "DataDiskImages", &g.DataDiskImages)
			delete(rawMsg, key)
		case "osDiskImage":
			err = unpopulate(val, "OSDiskImage", &g.OSDiskImage)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &g.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageVersionUefiSettings.
func (g GalleryImageVersionUefiSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalSignatures", g.AdditionalSignatures)
	populate(objectMap, "signatureTemplateNames", g.SignatureTemplateNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageVersionUefiSettings.
func (g *GalleryImageVersionUefiSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalSignatures":
			err = unpopulate(val, "AdditionalSignatures", &g.AdditionalSignatures)
			delete(rawMsg, key)
		case "signatureTemplateNames":
			err = unpopulate(val, "SignatureTemplateNames", &g.SignatureTemplateNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageVersionUpdate.
func (g GalleryImageVersionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageVersionUpdate.
func (g *GalleryImageVersionUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryList.
func (g GalleryList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryList.
func (g *GalleryList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryOSDiskImage.
func (g GalleryOSDiskImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostCaching", g.HostCaching)
	populate(objectMap, "sizeInGB", g.SizeInGB)
	populate(objectMap, "source", g.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryOSDiskImage.
func (g *GalleryOSDiskImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostCaching":
			err = unpopulate(val, "HostCaching", &g.HostCaching)
			delete(rawMsg, key)
		case "sizeInGB":
			err = unpopulate(val, "SizeInGB", &g.SizeInGB)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &g.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryProperties.
func (g GalleryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "identifier", g.Identifier)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "sharingProfile", g.SharingProfile)
	populate(objectMap, "sharingStatus", g.SharingStatus)
	populate(objectMap, "softDeletePolicy", g.SoftDeletePolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryProperties.
func (g *GalleryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "identifier":
			err = unpopulate(val, "Identifier", &g.Identifier)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &g.ProvisioningState)
			delete(rawMsg, key)
		case "sharingProfile":
			err = unpopulate(val, "SharingProfile", &g.SharingProfile)
			delete(rawMsg, key)
		case "sharingStatus":
			err = unpopulate(val, "SharingStatus", &g.SharingStatus)
			delete(rawMsg, key)
		case "softDeletePolicy":
			err = unpopulate(val, "SoftDeletePolicy", &g.SoftDeletePolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryTargetExtendedLocation.
func (g GalleryTargetExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryption", g.Encryption)
	populate(objectMap, "extendedLocation", g.ExtendedLocation)
	populate(objectMap, "extendedLocationReplicaCount", g.ExtendedLocationReplicaCount)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "storageAccountType", g.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryTargetExtendedLocation.
func (g *GalleryTargetExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryption":
			err = unpopulate(val, "Encryption", &g.Encryption)
			delete(rawMsg, key)
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &g.ExtendedLocation)
			delete(rawMsg, key)
		case "extendedLocationReplicaCount":
			err = unpopulate(val, "ExtendedLocationReplicaCount", &g.ExtendedLocationReplicaCount)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &g.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryUpdate.
func (g GalleryUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryUpdate.
func (g *GalleryUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GrantAccessData.
func (g GrantAccessData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "access", g.Access)
	populate(objectMap, "durationInSeconds", g.DurationInSeconds)
	populate(objectMap, "fileFormat", g.FileFormat)
	populate(objectMap, "getSecureVMGuestStateSAS", g.GetSecureVMGuestStateSAS)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GrantAccessData.
func (g *GrantAccessData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "access":
			err = unpopulate(val, "Access", &g.Access)
			delete(rawMsg, key)
		case "durationInSeconds":
			err = unpopulate(val, "DurationInSeconds", &g.DurationInSeconds)
			delete(rawMsg, key)
		case "fileFormat":
			err = unpopulate(val, "FileFormat", &g.FileFormat)
			delete(rawMsg, key)
		case "getSecureVMGuestStateSAS":
			err = unpopulate(val, "GetSecureVMGuestStateSAS", &g.GetSecureVMGuestStateSAS)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HardwareProfile.
func (h HardwareProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vmSize", h.VMSize)
	populate(objectMap, "vmSizeProperties", h.VMSizeProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HardwareProfile.
func (h *HardwareProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vmSize":
			err = unpopulate(val, "VMSize", &h.VMSize)
			delete(rawMsg, key)
		case "vmSizeProperties":
			err = unpopulate(val, "VMSizeProperties", &h.VMSizeProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Image.
func (i Image) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", i.ExtendedLocation)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Image.
func (i *Image) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &i.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageDataDisk.
func (i ImageDataDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobUri", i.BlobURI)
	populate(objectMap, "caching", i.Caching)
	populate(objectMap, "diskEncryptionSet", i.DiskEncryptionSet)
	populate(objectMap, "diskSizeGB", i.DiskSizeGB)
	populate(objectMap, "lun", i.Lun)
	populate(objectMap, "managedDisk", i.ManagedDisk)
	populate(objectMap, "snapshot", i.Snapshot)
	populate(objectMap, "storageAccountType", i.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageDataDisk.
func (i *ImageDataDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobUri":
			err = unpopulate(val, "BlobURI", &i.BlobURI)
			delete(rawMsg, key)
		case "caching":
			err = unpopulate(val, "Caching", &i.Caching)
			delete(rawMsg, key)
		case "diskEncryptionSet":
			err = unpopulate(val, "DiskEncryptionSet", &i.DiskEncryptionSet)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &i.DiskSizeGB)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &i.Lun)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &i.ManagedDisk)
			delete(rawMsg, key)
		case "snapshot":
			err = unpopulate(val, "Snapshot", &i.Snapshot)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &i.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageDeprecationStatus.
func (i ImageDeprecationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alternativeOption", i.AlternativeOption)
	populate(objectMap, "imageState", i.ImageState)
	populateDateTimeRFC3339(objectMap, "scheduledDeprecationTime", i.ScheduledDeprecationTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageDeprecationStatus.
func (i *ImageDeprecationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternativeOption":
			err = unpopulate(val, "AlternativeOption", &i.AlternativeOption)
			delete(rawMsg, key)
		case "imageState":
			err = unpopulate(val, "ImageState", &i.ImageState)
			delete(rawMsg, key)
		case "scheduledDeprecationTime":
			err = unpopulateDateTimeRFC3339(val, "ScheduledDeprecationTime", &i.ScheduledDeprecationTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageDisk.
func (i ImageDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobUri", i.BlobURI)
	populate(objectMap, "caching", i.Caching)
	populate(objectMap, "diskEncryptionSet", i.DiskEncryptionSet)
	populate(objectMap, "diskSizeGB", i.DiskSizeGB)
	populate(objectMap, "managedDisk", i.ManagedDisk)
	populate(objectMap, "snapshot", i.Snapshot)
	populate(objectMap, "storageAccountType", i.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageDisk.
func (i *ImageDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobUri":
			err = unpopulate(val, "BlobURI", &i.BlobURI)
			delete(rawMsg, key)
		case "caching":
			err = unpopulate(val, "Caching", &i.Caching)
			delete(rawMsg, key)
		case "diskEncryptionSet":
			err = unpopulate(val, "DiskEncryptionSet", &i.DiskEncryptionSet)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &i.DiskSizeGB)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &i.ManagedDisk)
			delete(rawMsg, key)
		case "snapshot":
			err = unpopulate(val, "Snapshot", &i.Snapshot)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &i.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageDiskReference.
func (i ImageDiskReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "communityGalleryImageId", i.CommunityGalleryImageID)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "lun", i.Lun)
	populate(objectMap, "sharedGalleryImageId", i.SharedGalleryImageID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageDiskReference.
func (i *ImageDiskReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "communityGalleryImageId":
			err = unpopulate(val, "CommunityGalleryImageID", &i.CommunityGalleryImageID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &i.Lun)
			delete(rawMsg, key)
		case "sharedGalleryImageId":
			err = unpopulate(val, "SharedGalleryImageID", &i.SharedGalleryImageID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageListResult.
func (i ImageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageListResult.
func (i *ImageListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageOSDisk.
func (i ImageOSDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobUri", i.BlobURI)
	populate(objectMap, "caching", i.Caching)
	populate(objectMap, "diskEncryptionSet", i.DiskEncryptionSet)
	populate(objectMap, "diskSizeGB", i.DiskSizeGB)
	populate(objectMap, "managedDisk", i.ManagedDisk)
	populate(objectMap, "osState", i.OSState)
	populate(objectMap, "osType", i.OSType)
	populate(objectMap, "snapshot", i.Snapshot)
	populate(objectMap, "storageAccountType", i.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageOSDisk.
func (i *ImageOSDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobUri":
			err = unpopulate(val, "BlobURI", &i.BlobURI)
			delete(rawMsg, key)
		case "caching":
			err = unpopulate(val, "Caching", &i.Caching)
			delete(rawMsg, key)
		case "diskEncryptionSet":
			err = unpopulate(val, "DiskEncryptionSet", &i.DiskEncryptionSet)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &i.DiskSizeGB)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &i.ManagedDisk)
			delete(rawMsg, key)
		case "osState":
			err = unpopulate(val, "OSState", &i.OSState)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &i.OSType)
			delete(rawMsg, key)
		case "snapshot":
			err = unpopulate(val, "Snapshot", &i.Snapshot)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &i.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageProperties.
func (i ImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hyperVGeneration", i.HyperVGeneration)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "sourceVirtualMachine", i.SourceVirtualMachine)
	populate(objectMap, "storageProfile", i.StorageProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageProperties.
func (i *ImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &i.HyperVGeneration)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "sourceVirtualMachine":
			err = unpopulate(val, "SourceVirtualMachine", &i.SourceVirtualMachine)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &i.StorageProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImagePurchasePlan.
func (i ImagePurchasePlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "product", i.Product)
	populate(objectMap, "publisher", i.Publisher)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImagePurchasePlan.
func (i *ImagePurchasePlan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &i.Product)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &i.Publisher)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageReference.
func (i ImageReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "communityGalleryImageId", i.CommunityGalleryImageID)
	populate(objectMap, "exactVersion", i.ExactVersion)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "offer", i.Offer)
	populate(objectMap, "publisher", i.Publisher)
	populate(objectMap, "sku", i.SKU)
	populate(objectMap, "sharedGalleryImageId", i.SharedGalleryImageID)
	populate(objectMap, "version", i.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageReference.
func (i *ImageReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "communityGalleryImageId":
			err = unpopulate(val, "CommunityGalleryImageID", &i.CommunityGalleryImageID)
			delete(rawMsg, key)
		case "exactVersion":
			err = unpopulate(val, "ExactVersion", &i.ExactVersion)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "offer":
			err = unpopulate(val, "Offer", &i.Offer)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &i.Publisher)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &i.SKU)
			delete(rawMsg, key)
		case "sharedGalleryImageId":
			err = unpopulate(val, "SharedGalleryImageID", &i.SharedGalleryImageID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &i.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageStorageProfile.
func (i ImageStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDisks", i.DataDisks)
	populate(objectMap, "osDisk", i.OSDisk)
	populate(objectMap, "zoneResilient", i.ZoneResilient)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageStorageProfile.
func (i *ImageStorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDisks":
			err = unpopulate(val, "DataDisks", &i.DataDisks)
			delete(rawMsg, key)
		case "osDisk":
			err = unpopulate(val, "OSDisk", &i.OSDisk)
			delete(rawMsg, key)
		case "zoneResilient":
			err = unpopulate(val, "ZoneResilient", &i.ZoneResilient)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageUpdate.
func (i ImageUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageUpdate.
func (i *ImageUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageVersionSecurityProfile.
func (i ImageVersionSecurityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "uefiSettings", i.UefiSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageVersionSecurityProfile.
func (i *ImageVersionSecurityProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "uefiSettings":
			err = unpopulate(val, "UefiSettings", &i.UefiSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InnerError.
func (i InnerError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errordetail", i.Errordetail)
	populate(objectMap, "exceptiontype", i.Exceptiontype)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InnerError.
func (i *InnerError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errordetail":
			err = unpopulate(val, "Errordetail", &i.Errordetail)
			delete(rawMsg, key)
		case "exceptiontype":
			err = unpopulate(val, "Exceptiontype", &i.Exceptiontype)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InstanceSKU.
func (i InstanceSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "tier", i.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InstanceSKU.
func (i *InstanceSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &i.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InstanceViewStatus.
func (i InstanceViewStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", i.Code)
	populate(objectMap, "displayStatus", i.DisplayStatus)
	populate(objectMap, "level", i.Level)
	populate(objectMap, "message", i.Message)
	populateDateTimeRFC3339(objectMap, "time", i.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InstanceViewStatus.
func (i *InstanceViewStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &i.Code)
			delete(rawMsg, key)
		case "displayStatus":
			err = unpopulate(val, "DisplayStatus", &i.DisplayStatus)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &i.Level)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &i.Message)
			delete(rawMsg, key)
		case "time":
			err = unpopulateDateTimeRFC3339(val, "Time", &i.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InstanceViewStatusesSummary.
func (i InstanceViewStatusesSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "statusesSummary", i.StatusesSummary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InstanceViewStatusesSummary.
func (i *InstanceViewStatusesSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "statusesSummary":
			err = unpopulate(val, "StatusesSummary", &i.StatusesSummary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyForDiskEncryptionSet.
func (k KeyForDiskEncryptionSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyUrl", k.KeyURL)
	populate(objectMap, "sourceVault", k.SourceVault)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyForDiskEncryptionSet.
func (k *KeyForDiskEncryptionSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyUrl":
			err = unpopulate(val, "KeyURL", &k.KeyURL)
			delete(rawMsg, key)
		case "sourceVault":
			err = unpopulate(val, "SourceVault", &k.SourceVault)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultAndKeyReference.
func (k KeyVaultAndKeyReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyUrl", k.KeyURL)
	populate(objectMap, "sourceVault", k.SourceVault)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultAndKeyReference.
func (k *KeyVaultAndKeyReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyUrl":
			err = unpopulate(val, "KeyURL", &k.KeyURL)
			delete(rawMsg, key)
		case "sourceVault":
			err = unpopulate(val, "SourceVault", &k.SourceVault)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultAndSecretReference.
func (k KeyVaultAndSecretReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secretUrl", k.SecretURL)
	populate(objectMap, "sourceVault", k.SourceVault)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultAndSecretReference.
func (k *KeyVaultAndSecretReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretUrl":
			err = unpopulate(val, "SecretURL", &k.SecretURL)
			delete(rawMsg, key)
		case "sourceVault":
			err = unpopulate(val, "SourceVault", &k.SourceVault)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultKeyReference.
func (k KeyVaultKeyReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyUrl", k.KeyURL)
	populate(objectMap, "sourceVault", k.SourceVault)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultKeyReference.
func (k *KeyVaultKeyReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyUrl":
			err = unpopulate(val, "KeyURL", &k.KeyURL)
			delete(rawMsg, key)
		case "sourceVault":
			err = unpopulate(val, "SourceVault", &k.SourceVault)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultSecretReference.
func (k KeyVaultSecretReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secretUrl", k.SecretURL)
	populate(objectMap, "sourceVault", k.SourceVault)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultSecretReference.
func (k *KeyVaultSecretReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretUrl":
			err = unpopulate(val, "SecretURL", &k.SecretURL)
			delete(rawMsg, key)
		case "sourceVault":
			err = unpopulate(val, "SourceVault", &k.SourceVault)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LastPatchInstallationSummary.
func (l LastPatchInstallationSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", l.Error)
	populate(objectMap, "excludedPatchCount", l.ExcludedPatchCount)
	populate(objectMap, "failedPatchCount", l.FailedPatchCount)
	populate(objectMap, "installationActivityId", l.InstallationActivityID)
	populate(objectMap, "installedPatchCount", l.InstalledPatchCount)
	populateDateTimeRFC3339(objectMap, "lastModifiedTime", l.LastModifiedTime)
	populate(objectMap, "maintenanceWindowExceeded", l.MaintenanceWindowExceeded)
	populate(objectMap, "notSelectedPatchCount", l.NotSelectedPatchCount)
	populate(objectMap, "pendingPatchCount", l.PendingPatchCount)
	populateDateTimeRFC3339(objectMap, "startTime", l.StartTime)
	populate(objectMap, "status", l.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LastPatchInstallationSummary.
func (l *LastPatchInstallationSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &l.Error)
			delete(rawMsg, key)
		case "excludedPatchCount":
			err = unpopulate(val, "ExcludedPatchCount", &l.ExcludedPatchCount)
			delete(rawMsg, key)
		case "failedPatchCount":
			err = unpopulate(val, "FailedPatchCount", &l.FailedPatchCount)
			delete(rawMsg, key)
		case "installationActivityId":
			err = unpopulate(val, "InstallationActivityID", &l.InstallationActivityID)
			delete(rawMsg, key)
		case "installedPatchCount":
			err = unpopulate(val, "InstalledPatchCount", &l.InstalledPatchCount)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedTime", &l.LastModifiedTime)
			delete(rawMsg, key)
		case "maintenanceWindowExceeded":
			err = unpopulate(val, "MaintenanceWindowExceeded", &l.MaintenanceWindowExceeded)
			delete(rawMsg, key)
		case "notSelectedPatchCount":
			err = unpopulate(val, "NotSelectedPatchCount", &l.NotSelectedPatchCount)
			delete(rawMsg, key)
		case "pendingPatchCount":
			err = unpopulate(val, "PendingPatchCount", &l.PendingPatchCount)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &l.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &l.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LatestGalleryImageVersion.
func (l LatestGalleryImageVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "latestVersionName", l.LatestVersionName)
	populate(objectMap, "location", l.Location)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LatestGalleryImageVersion.
func (l *LatestGalleryImageVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "latestVersionName":
			err = unpopulate(val, "LatestVersionName", &l.LatestVersionName)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxConfiguration.
func (l LinuxConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disablePasswordAuthentication", l.DisablePasswordAuthentication)
	populate(objectMap, "enableVMAgentPlatformUpdates", l.EnableVMAgentPlatformUpdates)
	populate(objectMap, "patchSettings", l.PatchSettings)
	populate(objectMap, "provisionVMAgent", l.ProvisionVMAgent)
	populate(objectMap, "ssh", l.SSH)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxConfiguration.
func (l *LinuxConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disablePasswordAuthentication":
			err = unpopulate(val, "DisablePasswordAuthentication", &l.DisablePasswordAuthentication)
			delete(rawMsg, key)
		case "enableVMAgentPlatformUpdates":
			err = unpopulate(val, "EnableVMAgentPlatformUpdates", &l.EnableVMAgentPlatformUpdates)
			delete(rawMsg, key)
		case "patchSettings":
			err = unpopulate(val, "PatchSettings", &l.PatchSettings)
			delete(rawMsg, key)
		case "provisionVMAgent":
			err = unpopulate(val, "ProvisionVMAgent", &l.ProvisionVMAgent)
			delete(rawMsg, key)
		case "ssh":
			err = unpopulate(val, "SSH", &l.SSH)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxParameters.
func (l LinuxParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "classificationsToInclude", l.ClassificationsToInclude)
	populate(objectMap, "maintenanceRunId", l.MaintenanceRunID)
	populate(objectMap, "packageNameMasksToExclude", l.PackageNameMasksToExclude)
	populate(objectMap, "packageNameMasksToInclude", l.PackageNameMasksToInclude)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxParameters.
func (l *LinuxParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "classificationsToInclude":
			err = unpopulate(val, "ClassificationsToInclude", &l.ClassificationsToInclude)
			delete(rawMsg, key)
		case "maintenanceRunId":
			err = unpopulate(val, "MaintenanceRunID", &l.MaintenanceRunID)
			delete(rawMsg, key)
		case "packageNameMasksToExclude":
			err = unpopulate(val, "PackageNameMasksToExclude", &l.PackageNameMasksToExclude)
			delete(rawMsg, key)
		case "packageNameMasksToInclude":
			err = unpopulate(val, "PackageNameMasksToInclude", &l.PackageNameMasksToInclude)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxPatchSettings.
func (l LinuxPatchSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assessmentMode", l.AssessmentMode)
	populate(objectMap, "automaticByPlatformSettings", l.AutomaticByPlatformSettings)
	populate(objectMap, "patchMode", l.PatchMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxPatchSettings.
func (l *LinuxPatchSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentMode":
			err = unpopulate(val, "AssessmentMode", &l.AssessmentMode)
			delete(rawMsg, key)
		case "automaticByPlatformSettings":
			err = unpopulate(val, "AutomaticByPlatformSettings", &l.AutomaticByPlatformSettings)
			delete(rawMsg, key)
		case "patchMode":
			err = unpopulate(val, "PatchMode", &l.PatchMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxVMGuestPatchAutomaticByPlatformSettings.
func (l LinuxVMGuestPatchAutomaticByPlatformSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bypassPlatformSafetyChecksOnUserSchedule", l.BypassPlatformSafetyChecksOnUserSchedule)
	populate(objectMap, "rebootSetting", l.RebootSetting)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxVMGuestPatchAutomaticByPlatformSettings.
func (l *LinuxVMGuestPatchAutomaticByPlatformSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bypassPlatformSafetyChecksOnUserSchedule":
			err = unpopulate(val, "BypassPlatformSafetyChecksOnUserSchedule", &l.BypassPlatformSafetyChecksOnUserSchedule)
			delete(rawMsg, key)
		case "rebootSetting":
			err = unpopulate(val, "RebootSetting", &l.RebootSetting)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListUsagesResult.
func (l ListUsagesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListUsagesResult.
func (l *ListUsagesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerConfiguration.
func (l LoadBalancerConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerConfiguration.
func (l *LoadBalancerConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerConfigurationProperties.
func (l LoadBalancerConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "frontendIpConfigurations", l.FrontendIPConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerConfigurationProperties.
func (l *LoadBalancerConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "frontendIpConfigurations":
			err = unpopulate(val, "FrontendIPConfigurations", &l.FrontendIPConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerFrontendIPConfiguration.
func (l LoadBalancerFrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerFrontendIPConfiguration.
func (l *LoadBalancerFrontendIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerFrontendIPConfigurationProperties.
func (l LoadBalancerFrontendIPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateIPAddress", l.PrivateIPAddress)
	populate(objectMap, "publicIPAddress", l.PublicIPAddress)
	populate(objectMap, "subnet", l.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerFrontendIPConfigurationProperties.
func (l *LoadBalancerFrontendIPConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &l.PrivateIPAddress)
			delete(rawMsg, key)
		case "publicIPAddress":
			err = unpopulate(val, "PublicIPAddress", &l.PublicIPAddress)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &l.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogAnalyticsInputBase.
func (l LogAnalyticsInputBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobContainerSasUri", l.BlobContainerSasURI)
	populateDateTimeRFC3339(objectMap, "fromTime", l.FromTime)
	populate(objectMap, "groupByClientApplicationId", l.GroupByClientApplicationID)
	populate(objectMap, "groupByOperationName", l.GroupByOperationName)
	populate(objectMap, "groupByResourceName", l.GroupByResourceName)
	populate(objectMap, "groupByThrottlePolicy", l.GroupByThrottlePolicy)
	populate(objectMap, "groupByUserAgent", l.GroupByUserAgent)
	populateDateTimeRFC3339(objectMap, "toTime", l.ToTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogAnalyticsInputBase.
func (l *LogAnalyticsInputBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobContainerSasUri":
			err = unpopulate(val, "BlobContainerSasURI", &l.BlobContainerSasURI)
			delete(rawMsg, key)
		case "fromTime":
			err = unpopulateDateTimeRFC3339(val, "FromTime", &l.FromTime)
			delete(rawMsg, key)
		case "groupByClientApplicationId":
			err = unpopulate(val, "GroupByClientApplicationID", &l.GroupByClientApplicationID)
			delete(rawMsg, key)
		case "groupByOperationName":
			err = unpopulate(val, "GroupByOperationName", &l.GroupByOperationName)
			delete(rawMsg, key)
		case "groupByResourceName":
			err = unpopulate(val, "GroupByResourceName", &l.GroupByResourceName)
			delete(rawMsg, key)
		case "groupByThrottlePolicy":
			err = unpopulate(val, "GroupByThrottlePolicy", &l.GroupByThrottlePolicy)
			delete(rawMsg, key)
		case "groupByUserAgent":
			err = unpopulate(val, "GroupByUserAgent", &l.GroupByUserAgent)
			delete(rawMsg, key)
		case "toTime":
			err = unpopulateDateTimeRFC3339(val, "ToTime", &l.ToTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogAnalyticsOperationResult.
func (l LogAnalyticsOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", l.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogAnalyticsOperationResult.
func (l *LogAnalyticsOperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogAnalyticsOutput.
func (l LogAnalyticsOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "output", l.Output)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogAnalyticsOutput.
func (l *LogAnalyticsOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "output":
			err = unpopulate(val, "Output", &l.Output)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceRedeployStatus.
func (m MaintenanceRedeployStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isCustomerInitiatedMaintenanceAllowed", m.IsCustomerInitiatedMaintenanceAllowed)
	populate(objectMap, "lastOperationMessage", m.LastOperationMessage)
	populate(objectMap, "lastOperationResultCode", m.LastOperationResultCode)
	populateDateTimeRFC3339(objectMap, "maintenanceWindowEndTime", m.MaintenanceWindowEndTime)
	populateDateTimeRFC3339(objectMap, "maintenanceWindowStartTime", m.MaintenanceWindowStartTime)
	populateDateTimeRFC3339(objectMap, "preMaintenanceWindowEndTime", m.PreMaintenanceWindowEndTime)
	populateDateTimeRFC3339(objectMap, "preMaintenanceWindowStartTime", m.PreMaintenanceWindowStartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceRedeployStatus.
func (m *MaintenanceRedeployStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isCustomerInitiatedMaintenanceAllowed":
			err = unpopulate(val, "IsCustomerInitiatedMaintenanceAllowed", &m.IsCustomerInitiatedMaintenanceAllowed)
			delete(rawMsg, key)
		case "lastOperationMessage":
			err = unpopulate(val, "LastOperationMessage", &m.LastOperationMessage)
			delete(rawMsg, key)
		case "lastOperationResultCode":
			err = unpopulate(val, "LastOperationResultCode", &m.LastOperationResultCode)
			delete(rawMsg, key)
		case "maintenanceWindowEndTime":
			err = unpopulateDateTimeRFC3339(val, "MaintenanceWindowEndTime", &m.MaintenanceWindowEndTime)
			delete(rawMsg, key)
		case "maintenanceWindowStartTime":
			err = unpopulateDateTimeRFC3339(val, "MaintenanceWindowStartTime", &m.MaintenanceWindowStartTime)
			delete(rawMsg, key)
		case "preMaintenanceWindowEndTime":
			err = unpopulateDateTimeRFC3339(val, "PreMaintenanceWindowEndTime", &m.PreMaintenanceWindowEndTime)
			delete(rawMsg, key)
		case "preMaintenanceWindowStartTime":
			err = unpopulateDateTimeRFC3339(val, "PreMaintenanceWindowStartTime", &m.PreMaintenanceWindowStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedArtifact.
func (m ManagedArtifact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedArtifact.
func (m *ManagedArtifact) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedDiskParameters.
func (m ManagedDiskParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSet", m.DiskEncryptionSet)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "securityProfile", m.SecurityProfile)
	populate(objectMap, "storageAccountType", m.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedDiskParameters.
func (m *ManagedDiskParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSet":
			err = unpopulate(val, "DiskEncryptionSet", &m.DiskEncryptionSet)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &m.SecurityProfile)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &m.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfaceReference.
func (n NetworkInterfaceReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "properties", n.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterfaceReference.
func (n *NetworkInterfaceReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfaceReferenceProperties.
func (n NetworkInterfaceReferenceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deleteOption", n.DeleteOption)
	populate(objectMap, "primary", n.Primary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterfaceReferenceProperties.
func (n *NetworkInterfaceReferenceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteOption":
			err = unpopulate(val, "DeleteOption", &n.DeleteOption)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &n.Primary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProfile.
func (n NetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkApiVersion", n.NetworkAPIVersion)
	populate(objectMap, "networkInterfaceConfigurations", n.NetworkInterfaceConfigurations)
	populate(objectMap, "networkInterfaces", n.NetworkInterfaces)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProfile.
func (n *NetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkApiVersion":
			err = unpopulate(val, "NetworkAPIVersion", &n.NetworkAPIVersion)
			delete(rawMsg, key)
		case "networkInterfaceConfigurations":
			err = unpopulate(val, "NetworkInterfaceConfigurations", &n.NetworkInterfaceConfigurations)
			delete(rawMsg, key)
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &n.NetworkInterfaces)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSDisk.
func (o OSDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caching", o.Caching)
	populate(objectMap, "createOption", o.CreateOption)
	populate(objectMap, "deleteOption", o.DeleteOption)
	populate(objectMap, "diffDiskSettings", o.DiffDiskSettings)
	populate(objectMap, "diskSizeGB", o.DiskSizeGB)
	populate(objectMap, "encryptionSettings", o.EncryptionSettings)
	populate(objectMap, "image", o.Image)
	populate(objectMap, "managedDisk", o.ManagedDisk)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "osType", o.OSType)
	populate(objectMap, "vhd", o.Vhd)
	populate(objectMap, "writeAcceleratorEnabled", o.WriteAcceleratorEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSDisk.
func (o *OSDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caching":
			err = unpopulate(val, "Caching", &o.Caching)
			delete(rawMsg, key)
		case "createOption":
			err = unpopulate(val, "CreateOption", &o.CreateOption)
			delete(rawMsg, key)
		case "deleteOption":
			err = unpopulate(val, "DeleteOption", &o.DeleteOption)
			delete(rawMsg, key)
		case "diffDiskSettings":
			err = unpopulate(val, "DiffDiskSettings", &o.DiffDiskSettings)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &o.DiskSizeGB)
			delete(rawMsg, key)
		case "encryptionSettings":
			err = unpopulate(val, "EncryptionSettings", &o.EncryptionSettings)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &o.Image)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &o.ManagedDisk)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &o.OSType)
			delete(rawMsg, key)
		case "vhd":
			err = unpopulate(val, "Vhd", &o.Vhd)
			delete(rawMsg, key)
		case "writeAcceleratorEnabled":
			err = unpopulate(val, "WriteAcceleratorEnabled", &o.WriteAcceleratorEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSDiskImage.
func (o OSDiskImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operatingSystem", o.OperatingSystem)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSDiskImage.
func (o *OSDiskImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operatingSystem":
			err = unpopulate(val, "OperatingSystem", &o.OperatingSystem)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSDiskImageEncryption.
func (o OSDiskImageEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSetId", o.DiskEncryptionSetID)
	populate(objectMap, "securityProfile", o.SecurityProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSDiskImageEncryption.
func (o *OSDiskImageEncryption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &o.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &o.SecurityProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSDiskImageSecurityProfile.
func (o OSDiskImageSecurityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "confidentialVMEncryptionType", o.ConfidentialVMEncryptionType)
	populate(objectMap, "secureVMDiskEncryptionSetId", o.SecureVMDiskEncryptionSetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSDiskImageSecurityProfile.
func (o *OSDiskImageSecurityProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "confidentialVMEncryptionType":
			err = unpopulate(val, "ConfidentialVMEncryptionType", &o.ConfidentialVMEncryptionType)
			delete(rawMsg, key)
		case "secureVMDiskEncryptionSetId":
			err = unpopulate(val, "SecureVMDiskEncryptionSetID", &o.SecureVMDiskEncryptionSetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSFamily.
func (o OSFamily) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "location", o.Location)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSFamily.
func (o *OSFamily) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &o.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSFamilyListResult.
func (o OSFamilyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSFamilyListResult.
func (o *OSFamilyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSFamilyProperties.
func (o OSFamilyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "label", o.Label)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "versions", o.Versions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSFamilyProperties.
func (o *OSFamilyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "label":
			err = unpopulate(val, "Label", &o.Label)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "versions":
			err = unpopulate(val, "Versions", &o.Versions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSImageNotificationProfile.
func (o OSImageNotificationProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enable", o.Enable)
	populate(objectMap, "notBeforeTimeout", o.NotBeforeTimeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSImageNotificationProfile.
func (o *OSImageNotificationProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enable":
			err = unpopulate(val, "Enable", &o.Enable)
			delete(rawMsg, key)
		case "notBeforeTimeout":
			err = unpopulate(val, "NotBeforeTimeout", &o.NotBeforeTimeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSProfile.
func (o OSProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminPassword", o.AdminPassword)
	populate(objectMap, "adminUsername", o.AdminUsername)
	populate(objectMap, "allowExtensionOperations", o.AllowExtensionOperations)
	populate(objectMap, "computerName", o.ComputerName)
	populate(objectMap, "customData", o.CustomData)
	populate(objectMap, "linuxConfiguration", o.LinuxConfiguration)
	populate(objectMap, "requireGuestProvisionSignal", o.RequireGuestProvisionSignal)
	populate(objectMap, "secrets", o.Secrets)
	populate(objectMap, "windowsConfiguration", o.WindowsConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSProfile.
func (o *OSProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminPassword":
			err = unpopulate(val, "AdminPassword", &o.AdminPassword)
			delete(rawMsg, key)
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &o.AdminUsername)
			delete(rawMsg, key)
		case "allowExtensionOperations":
			err = unpopulate(val, "AllowExtensionOperations", &o.AllowExtensionOperations)
			delete(rawMsg, key)
		case "computerName":
			err = unpopulate(val, "ComputerName", &o.ComputerName)
			delete(rawMsg, key)
		case "customData":
			err = unpopulate(val, "CustomData", &o.CustomData)
			delete(rawMsg, key)
		case "linuxConfiguration":
			err = unpopulate(val, "LinuxConfiguration", &o.LinuxConfiguration)
			delete(rawMsg, key)
		case "requireGuestProvisionSignal":
			err = unpopulate(val, "RequireGuestProvisionSignal", &o.RequireGuestProvisionSignal)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &o.Secrets)
			delete(rawMsg, key)
		case "windowsConfiguration":
			err = unpopulate(val, "WindowsConfiguration", &o.WindowsConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSProfileProvisioningData.
func (o OSProfileProvisioningData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminPassword", o.AdminPassword)
	populate(objectMap, "customData", o.CustomData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSProfileProvisioningData.
func (o *OSProfileProvisioningData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminPassword":
			err = unpopulate(val, "AdminPassword", &o.AdminPassword)
			delete(rawMsg, key)
		case "customData":
			err = unpopulate(val, "CustomData", &o.CustomData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSVersion.
func (o OSVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "location", o.Location)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSVersion.
func (o *OSVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &o.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSVersionListResult.
func (o OSVersionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSVersionListResult.
func (o *OSVersionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSVersionProperties.
func (o OSVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "family", o.Family)
	populate(objectMap, "familyLabel", o.FamilyLabel)
	populate(objectMap, "isActive", o.IsActive)
	populate(objectMap, "isDefault", o.IsDefault)
	populate(objectMap, "label", o.Label)
	populate(objectMap, "version", o.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSVersionProperties.
func (o *OSVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "family":
			err = unpopulate(val, "Family", &o.Family)
			delete(rawMsg, key)
		case "familyLabel":
			err = unpopulate(val, "FamilyLabel", &o.FamilyLabel)
			delete(rawMsg, key)
		case "isActive":
			err = unpopulate(val, "IsActive", &o.IsActive)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &o.IsDefault)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &o.Label)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &o.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSVersionPropertiesBase.
func (o OSVersionPropertiesBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isActive", o.IsActive)
	populate(objectMap, "isDefault", o.IsDefault)
	populate(objectMap, "label", o.Label)
	populate(objectMap, "version", o.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSVersionPropertiesBase.
func (o *OSVersionPropertiesBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isActive":
			err = unpopulate(val, "IsActive", &o.IsActive)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &o.IsDefault)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &o.Label)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &o.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationValue.
func (o OperationValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationValue.
func (o *OperationValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationValueDisplay.
func (o OperationValueDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationValueDisplay.
func (o *OperationValueDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrchestrationServiceStateInput.
func (o OrchestrationServiceStateInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", o.Action)
	populate(objectMap, "serviceName", o.ServiceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrchestrationServiceStateInput.
func (o *OrchestrationServiceStateInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &o.Action)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &o.ServiceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrchestrationServiceSummary.
func (o OrchestrationServiceSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceName", o.ServiceName)
	populate(objectMap, "serviceState", o.ServiceState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrchestrationServiceSummary.
func (o *OrchestrationServiceSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceName":
			err = unpopulate(val, "ServiceName", &o.ServiceName)
			delete(rawMsg, key)
		case "serviceState":
			err = unpopulate(val, "ServiceState", &o.ServiceState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchInstallationDetail.
func (p PatchInstallationDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "classifications", p.Classifications)
	populate(objectMap, "installationState", p.InstallationState)
	populate(objectMap, "kbId", p.KbID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "patchId", p.PatchID)
	populate(objectMap, "version", p.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchInstallationDetail.
func (p *PatchInstallationDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "classifications":
			err = unpopulate(val, "Classifications", &p.Classifications)
			delete(rawMsg, key)
		case "installationState":
			err = unpopulate(val, "InstallationState", &p.InstallationState)
			delete(rawMsg, key)
		case "kbId":
			err = unpopulate(val, "KbID", &p.KbID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "patchId":
			err = unpopulate(val, "PatchID", &p.PatchID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &p.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchSettings.
func (p PatchSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assessmentMode", p.AssessmentMode)
	populate(objectMap, "automaticByPlatformSettings", p.AutomaticByPlatformSettings)
	populate(objectMap, "enableHotpatching", p.EnableHotpatching)
	populate(objectMap, "patchMode", p.PatchMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchSettings.
func (p *PatchSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentMode":
			err = unpopulate(val, "AssessmentMode", &p.AssessmentMode)
			delete(rawMsg, key)
		case "automaticByPlatformSettings":
			err = unpopulate(val, "AutomaticByPlatformSettings", &p.AutomaticByPlatformSettings)
			delete(rawMsg, key)
		case "enableHotpatching":
			err = unpopulate(val, "EnableHotpatching", &p.EnableHotpatching)
			delete(rawMsg, key)
		case "patchMode":
			err = unpopulate(val, "PatchMode", &p.PatchMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PirCommunityGalleryResource.
func (p PirCommunityGalleryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identifier", p.Identifier)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PirCommunityGalleryResource.
func (p *PirCommunityGalleryResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identifier":
			err = unpopulate(val, "Identifier", &p.Identifier)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PirResource.
func (p PirResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PirResource.
func (p *PirResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PirSharedGalleryResource.
func (p PirSharedGalleryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identifier", p.Identifier)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PirSharedGalleryResource.
func (p *PirSharedGalleryResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identifier":
			err = unpopulate(val, "Identifier", &p.Identifier)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Plan.
func (p Plan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "product", p.Product)
	populate(objectMap, "promotionCode", p.PromotionCode)
	populate(objectMap, "publisher", p.Publisher)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Plan.
func (p *Plan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &p.Product)
			delete(rawMsg, key)
		case "promotionCode":
			err = unpopulate(val, "PromotionCode", &p.PromotionCode)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &p.Publisher)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyViolation.
func (p PolicyViolation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", p.Category)
	populate(objectMap, "details", p.Details)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyViolation.
func (p *PolicyViolation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &p.Category)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &p.Details)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PriorityMixPolicy.
func (p PriorityMixPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "baseRegularPriorityCount", p.BaseRegularPriorityCount)
	populate(objectMap, "regularPriorityPercentageAboveBase", p.RegularPriorityPercentageAboveBase)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PriorityMixPolicy.
func (p *PriorityMixPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baseRegularPriorityCount":
			err = unpopulate(val, "BaseRegularPriorityCount", &p.BaseRegularPriorityCount)
			delete(rawMsg, key)
		case "regularPriorityPercentageAboveBase":
			err = unpopulate(val, "RegularPriorityPercentageAboveBase", &p.RegularPriorityPercentageAboveBase)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionListResult.
func (p *PrivateEndpointConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceListResult.
func (p PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceListResult.
func (p *PrivateLinkResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceProperties.
func (p *PrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &p.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PropertyUpdatesInProgress.
func (p PropertyUpdatesInProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetTier", p.TargetTier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PropertyUpdatesInProgress.
func (p *PropertyUpdatesInProgress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetTier":
			err = unpopulate(val, "TargetTier", &p.TargetTier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProximityPlacementGroup.
func (p ProximityPlacementGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	populate(objectMap, "zones", p.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProximityPlacementGroup.
func (p *ProximityPlacementGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &p.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProximityPlacementGroupListResult.
func (p ProximityPlacementGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProximityPlacementGroupListResult.
func (p *ProximityPlacementGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProximityPlacementGroupProperties.
func (p ProximityPlacementGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilitySets", p.AvailabilitySets)
	populate(objectMap, "colocationStatus", p.ColocationStatus)
	populate(objectMap, "intent", p.Intent)
	populate(objectMap, "proximityPlacementGroupType", p.ProximityPlacementGroupType)
	populate(objectMap, "virtualMachineScaleSets", p.VirtualMachineScaleSets)
	populate(objectMap, "virtualMachines", p.VirtualMachines)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProximityPlacementGroupProperties.
func (p *ProximityPlacementGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilitySets":
			err = unpopulate(val, "AvailabilitySets", &p.AvailabilitySets)
			delete(rawMsg, key)
		case "colocationStatus":
			err = unpopulate(val, "ColocationStatus", &p.ColocationStatus)
			delete(rawMsg, key)
		case "intent":
			err = unpopulate(val, "Intent", &p.Intent)
			delete(rawMsg, key)
		case "proximityPlacementGroupType":
			err = unpopulate(val, "ProximityPlacementGroupType", &p.ProximityPlacementGroupType)
			delete(rawMsg, key)
		case "virtualMachineScaleSets":
			err = unpopulate(val, "VirtualMachineScaleSets", &p.VirtualMachineScaleSets)
			delete(rawMsg, key)
		case "virtualMachines":
			err = unpopulate(val, "VirtualMachines", &p.VirtualMachines)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProximityPlacementGroupPropertiesIntent.
func (p ProximityPlacementGroupPropertiesIntent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vmSizes", p.VMSizes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProximityPlacementGroupPropertiesIntent.
func (p *ProximityPlacementGroupPropertiesIntent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vmSizes":
			err = unpopulate(val, "VMSizes", &p.VMSizes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProximityPlacementGroupUpdate.
func (p ProximityPlacementGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProximityPlacementGroupUpdate.
func (p *ProximityPlacementGroupUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyAgentSettings.
func (p ProxyAgentSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", p.Enabled)
	populate(objectMap, "keyIncarnationId", p.KeyIncarnationID)
	populate(objectMap, "mode", p.Mode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyAgentSettings.
func (p *ProxyAgentSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &p.Enabled)
			delete(rawMsg, key)
		case "keyIncarnationId":
			err = unpopulate(val, "KeyIncarnationID", &p.KeyIncarnationID)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &p.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyOnlyResource.
func (p ProxyOnlyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyOnlyResource.
func (p *ProxyOnlyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPAddressSKU.
func (p PublicIPAddressSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "tier", p.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPAddressSKU.
func (p *PublicIPAddressSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &p.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PurchasePlan.
func (p PurchasePlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "product", p.Product)
	populate(objectMap, "publisher", p.Publisher)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PurchasePlan.
func (p *PurchasePlan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &p.Product)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &p.Publisher)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendedMachineConfiguration.
func (r RecommendedMachineConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "memory", r.Memory)
	populate(objectMap, "vCPUs", r.VCPUs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendedMachineConfiguration.
func (r *RecommendedMachineConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "memory":
			err = unpopulate(val, "Memory", &r.Memory)
			delete(rawMsg, key)
		case "vCPUs":
			err = unpopulate(val, "VCPUs", &r.VCPUs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryWalkResponse.
func (r RecoveryWalkResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextPlatformUpdateDomain", r.NextPlatformUpdateDomain)
	populate(objectMap, "walkPerformed", r.WalkPerformed)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryWalkResponse.
func (r *RecoveryWalkResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextPlatformUpdateDomain":
			err = unpopulate(val, "NextPlatformUpdateDomain", &r.NextPlatformUpdateDomain)
			delete(rawMsg, key)
		case "walkPerformed":
			err = unpopulate(val, "WalkPerformed", &r.WalkPerformed)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegionalReplicationStatus.
func (r RegionalReplicationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "details", r.Details)
	populate(objectMap, "progress", r.Progress)
	populate(objectMap, "region", r.Region)
	populate(objectMap, "state", r.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegionalReplicationStatus.
func (r *RegionalReplicationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "details":
			err = unpopulate(val, "Details", &r.Details)
			delete(rawMsg, key)
		case "progress":
			err = unpopulate(val, "Progress", &r.Progress)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &r.Region)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &r.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegionalSharingStatus.
func (r RegionalSharingStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "details", r.Details)
	populate(objectMap, "region", r.Region)
	populate(objectMap, "state", r.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegionalSharingStatus.
func (r *RegionalSharingStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "details":
			err = unpopulate(val, "Details", &r.Details)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &r.Region)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &r.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationStatus.
func (r ReplicationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregatedState", r.AggregatedState)
	populate(objectMap, "summary", r.Summary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationStatus.
func (r *ReplicationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregatedState":
			err = unpopulate(val, "AggregatedState", &r.AggregatedState)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &r.Summary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestRateByIntervalInput.
func (r RequestRateByIntervalInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobContainerSasUri", r.BlobContainerSasURI)
	populateDateTimeRFC3339(objectMap, "fromTime", r.FromTime)
	populate(objectMap, "groupByClientApplicationId", r.GroupByClientApplicationID)
	populate(objectMap, "groupByOperationName", r.GroupByOperationName)
	populate(objectMap, "groupByResourceName", r.GroupByResourceName)
	populate(objectMap, "groupByThrottlePolicy", r.GroupByThrottlePolicy)
	populate(objectMap, "groupByUserAgent", r.GroupByUserAgent)
	populate(objectMap, "intervalLength", r.IntervalLength)
	populateDateTimeRFC3339(objectMap, "toTime", r.ToTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestRateByIntervalInput.
func (r *RequestRateByIntervalInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobContainerSasUri":
			err = unpopulate(val, "BlobContainerSasURI", &r.BlobContainerSasURI)
			delete(rawMsg, key)
		case "fromTime":
			err = unpopulateDateTimeRFC3339(val, "FromTime", &r.FromTime)
			delete(rawMsg, key)
		case "groupByClientApplicationId":
			err = unpopulate(val, "GroupByClientApplicationID", &r.GroupByClientApplicationID)
			delete(rawMsg, key)
		case "groupByOperationName":
			err = unpopulate(val, "GroupByOperationName", &r.GroupByOperationName)
			delete(rawMsg, key)
		case "groupByResourceName":
			err = unpopulate(val, "GroupByResourceName", &r.GroupByResourceName)
			delete(rawMsg, key)
		case "groupByThrottlePolicy":
			err = unpopulate(val, "GroupByThrottlePolicy", &r.GroupByThrottlePolicy)
			delete(rawMsg, key)
		case "groupByUserAgent":
			err = unpopulate(val, "GroupByUserAgent", &r.GroupByUserAgent)
			delete(rawMsg, key)
		case "intervalLength":
			err = unpopulate(val, "IntervalLength", &r.IntervalLength)
			delete(rawMsg, key)
		case "toTime":
			err = unpopulateDateTimeRFC3339(val, "ToTime", &r.ToTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResiliencyPolicy.
func (r ResiliencyPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resilientVMCreationPolicy", r.ResilientVMCreationPolicy)
	populate(objectMap, "resilientVMDeletionPolicy", r.ResilientVMDeletionPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResiliencyPolicy.
func (r *ResiliencyPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resilientVMCreationPolicy":
			err = unpopulate(val, "ResilientVMCreationPolicy", &r.ResilientVMCreationPolicy)
			delete(rawMsg, key)
		case "resilientVMDeletionPolicy":
			err = unpopulate(val, "ResilientVMDeletionPolicy", &r.ResilientVMDeletionPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResilientVMCreationPolicy.
func (r ResilientVMCreationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", r.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResilientVMCreationPolicy.
func (r *ResilientVMCreationPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &r.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResilientVMDeletionPolicy.
func (r ResilientVMDeletionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", r.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResilientVMDeletionPolicy.
func (r *ResilientVMDeletionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &r.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceInstanceViewStatus.
func (r ResourceInstanceViewStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", r.Code)
	populate(objectMap, "displayStatus", r.DisplayStatus)
	populate(objectMap, "level", r.Level)
	populate(objectMap, "message", r.Message)
	populateDateTimeRFC3339(objectMap, "time", r.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceInstanceViewStatus.
func (r *ResourceInstanceViewStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &r.Code)
			delete(rawMsg, key)
		case "displayStatus":
			err = unpopulate(val, "DisplayStatus", &r.DisplayStatus)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &r.Level)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		case "time":
			err = unpopulateDateTimeRFC3339(val, "Time", &r.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceRange.
func (r ResourceRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "max", r.Max)
	populate(objectMap, "min", r.Min)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceRange.
func (r *ResourceRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "max":
			err = unpopulate(val, "Max", &r.Max)
			delete(rawMsg, key)
		case "min":
			err = unpopulate(val, "Min", &r.Min)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKU.
func (r ResourceSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersions", r.APIVersions)
	populate(objectMap, "capabilities", r.Capabilities)
	populate(objectMap, "capacity", r.Capacity)
	populate(objectMap, "costs", r.Costs)
	populate(objectMap, "family", r.Family)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "locationInfo", r.LocationInfo)
	populate(objectMap, "locations", r.Locations)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "resourceType", r.ResourceType)
	populate(objectMap, "restrictions", r.Restrictions)
	populate(objectMap, "size", r.Size)
	populate(objectMap, "tier", r.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKU.
func (r *ResourceSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersions":
			err = unpopulate(val, "APIVersions", &r.APIVersions)
			delete(rawMsg, key)
		case "capabilities":
			err = unpopulate(val, "Capabilities", &r.Capabilities)
			delete(rawMsg, key)
		case "capacity":
			err = unpopulate(val, "Capacity", &r.Capacity)
			delete(rawMsg, key)
		case "costs":
			err = unpopulate(val, "Costs", &r.Costs)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &r.Family)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "locationInfo":
			err = unpopulate(val, "LocationInfo", &r.LocationInfo)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &r.Locations)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &r.ResourceType)
			delete(rawMsg, key)
		case "restrictions":
			err = unpopulate(val, "Restrictions", &r.Restrictions)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &r.Size)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &r.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKUCapabilities.
func (r ResourceSKUCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKUCapabilities.
func (r *ResourceSKUCapabilities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKUCapacity.
func (r ResourceSKUCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", r.Default)
	populate(objectMap, "maximum", r.Maximum)
	populate(objectMap, "minimum", r.Minimum)
	populate(objectMap, "scaleType", r.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKUCapacity.
func (r *ResourceSKUCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &r.Default)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &r.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &r.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &r.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKUCosts.
func (r ResourceSKUCosts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedUnit", r.ExtendedUnit)
	populate(objectMap, "meterID", r.MeterID)
	populate(objectMap, "quantity", r.Quantity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKUCosts.
func (r *ResourceSKUCosts) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedUnit":
			err = unpopulate(val, "ExtendedUnit", &r.ExtendedUnit)
			delete(rawMsg, key)
		case "meterID":
			err = unpopulate(val, "MeterID", &r.MeterID)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &r.Quantity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKULocationInfo.
func (r ResourceSKULocationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocations", r.ExtendedLocations)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "type", r.Type)
	populate(objectMap, "zoneDetails", r.ZoneDetails)
	populate(objectMap, "zones", r.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKULocationInfo.
func (r *ResourceSKULocationInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocations":
			err = unpopulate(val, "ExtendedLocations", &r.ExtendedLocations)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		case "zoneDetails":
			err = unpopulate(val, "ZoneDetails", &r.ZoneDetails)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &r.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKURestrictionInfo.
func (r ResourceSKURestrictionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "locations", r.Locations)
	populate(objectMap, "zones", r.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKURestrictionInfo.
func (r *ResourceSKURestrictionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "locations":
			err = unpopulate(val, "Locations", &r.Locations)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &r.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKURestrictions.
func (r ResourceSKURestrictions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reasonCode", r.ReasonCode)
	populate(objectMap, "restrictionInfo", r.RestrictionInfo)
	populate(objectMap, "type", r.Type)
	populate(objectMap, "values", r.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKURestrictions.
func (r *ResourceSKURestrictions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reasonCode":
			err = unpopulate(val, "ReasonCode", &r.ReasonCode)
			delete(rawMsg, key)
		case "restrictionInfo":
			err = unpopulate(val, "RestrictionInfo", &r.RestrictionInfo)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &r.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKUZoneDetails.
func (r ResourceSKUZoneDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", r.Capabilities)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKUZoneDetails.
func (r *ResourceSKUZoneDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &r.Capabilities)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKUsResult.
func (r ResourceSKUsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKUsResult.
func (r *ResourceSKUsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSharingProfile.
func (r ResourceSharingProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subscriptionIds", r.SubscriptionIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSharingProfile.
func (r *ResourceSharingProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subscriptionIds":
			err = unpopulate(val, "SubscriptionIDs", &r.SubscriptionIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceURIList.
func (r ResourceURIList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceURIList.
func (r *ResourceURIList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceWithOptionalLocation.
func (r ResourceWithOptionalLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceWithOptionalLocation.
func (r *ResourceWithOptionalLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePoint.
func (r RestorePoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePoint.
func (r *RestorePoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointCollection.
func (r RestorePointCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointCollection.
func (r *RestorePointCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointCollectionListResult.
func (r RestorePointCollectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointCollectionListResult.
func (r *RestorePointCollectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointCollectionProperties.
func (r RestorePointCollectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "restorePointCollectionId", r.RestorePointCollectionID)
	populate(objectMap, "restorePoints", r.RestorePoints)
	populate(objectMap, "source", r.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointCollectionProperties.
func (r *RestorePointCollectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "restorePointCollectionId":
			err = unpopulate(val, "RestorePointCollectionID", &r.RestorePointCollectionID)
			delete(rawMsg, key)
		case "restorePoints":
			err = unpopulate(val, "RestorePoints", &r.RestorePoints)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &r.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointCollectionSourceProperties.
func (r RestorePointCollectionSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointCollectionSourceProperties.
func (r *RestorePointCollectionSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointCollectionUpdate.
func (r RestorePointCollectionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointCollectionUpdate.
func (r *RestorePointCollectionUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointEncryption.
func (r RestorePointEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSet", r.DiskEncryptionSet)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointEncryption.
func (r *RestorePointEncryption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSet":
			err = unpopulate(val, "DiskEncryptionSet", &r.DiskEncryptionSet)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointInstanceView.
func (r RestorePointInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskRestorePoints", r.DiskRestorePoints)
	populate(objectMap, "statuses", r.Statuses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointInstanceView.
func (r *RestorePointInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskRestorePoints":
			err = unpopulate(val, "DiskRestorePoints", &r.DiskRestorePoints)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &r.Statuses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointProperties.
func (r RestorePointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consistencyMode", r.ConsistencyMode)
	populate(objectMap, "excludeDisks", r.ExcludeDisks)
	populate(objectMap, "instanceView", r.InstanceView)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "sourceMetadata", r.SourceMetadata)
	populate(objectMap, "sourceRestorePoint", r.SourceRestorePoint)
	populateDateTimeRFC3339(objectMap, "timeCreated", r.TimeCreated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointProperties.
func (r *RestorePointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consistencyMode":
			err = unpopulate(val, "ConsistencyMode", &r.ConsistencyMode)
			delete(rawMsg, key)
		case "excludeDisks":
			err = unpopulate(val, "ExcludeDisks", &r.ExcludeDisks)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &r.InstanceView)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "sourceMetadata":
			err = unpopulate(val, "SourceMetadata", &r.SourceMetadata)
			delete(rawMsg, key)
		case "sourceRestorePoint":
			err = unpopulate(val, "SourceRestorePoint", &r.SourceRestorePoint)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateDateTimeRFC3339(val, "TimeCreated", &r.TimeCreated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointSourceMetadata.
func (r RestorePointSourceMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diagnosticsProfile", r.DiagnosticsProfile)
	populate(objectMap, "hardwareProfile", r.HardwareProfile)
	populate(objectMap, "hyperVGeneration", r.HyperVGeneration)
	populate(objectMap, "licenseType", r.LicenseType)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "osProfile", r.OSProfile)
	populate(objectMap, "securityProfile", r.SecurityProfile)
	populate(objectMap, "storageProfile", r.StorageProfile)
	populate(objectMap, "userData", r.UserData)
	populate(objectMap, "vmId", r.VMID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointSourceMetadata.
func (r *RestorePointSourceMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diagnosticsProfile":
			err = unpopulate(val, "DiagnosticsProfile", &r.DiagnosticsProfile)
			delete(rawMsg, key)
		case "hardwareProfile":
			err = unpopulate(val, "HardwareProfile", &r.HardwareProfile)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &r.HyperVGeneration)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &r.LicenseType)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &r.OSProfile)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &r.SecurityProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &r.StorageProfile)
			delete(rawMsg, key)
		case "userData":
			err = unpopulate(val, "UserData", &r.UserData)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &r.VMID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointSourceVMDataDisk.
func (r RestorePointSourceVMDataDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caching", r.Caching)
	populate(objectMap, "diskRestorePoint", r.DiskRestorePoint)
	populate(objectMap, "diskSizeGB", r.DiskSizeGB)
	populate(objectMap, "lun", r.Lun)
	populate(objectMap, "managedDisk", r.ManagedDisk)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "writeAcceleratorEnabled", r.WriteAcceleratorEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointSourceVMDataDisk.
func (r *RestorePointSourceVMDataDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caching":
			err = unpopulate(val, "Caching", &r.Caching)
			delete(rawMsg, key)
		case "diskRestorePoint":
			err = unpopulate(val, "DiskRestorePoint", &r.DiskRestorePoint)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &r.DiskSizeGB)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &r.Lun)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &r.ManagedDisk)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "writeAcceleratorEnabled":
			err = unpopulate(val, "WriteAcceleratorEnabled", &r.WriteAcceleratorEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointSourceVMOSDisk.
func (r RestorePointSourceVMOSDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caching", r.Caching)
	populate(objectMap, "diskRestorePoint", r.DiskRestorePoint)
	populate(objectMap, "diskSizeGB", r.DiskSizeGB)
	populate(objectMap, "encryptionSettings", r.EncryptionSettings)
	populate(objectMap, "managedDisk", r.ManagedDisk)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "osType", r.OSType)
	populate(objectMap, "writeAcceleratorEnabled", r.WriteAcceleratorEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointSourceVMOSDisk.
func (r *RestorePointSourceVMOSDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caching":
			err = unpopulate(val, "Caching", &r.Caching)
			delete(rawMsg, key)
		case "diskRestorePoint":
			err = unpopulate(val, "DiskRestorePoint", &r.DiskRestorePoint)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &r.DiskSizeGB)
			delete(rawMsg, key)
		case "encryptionSettings":
			err = unpopulate(val, "EncryptionSettings", &r.EncryptionSettings)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &r.ManagedDisk)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &r.OSType)
			delete(rawMsg, key)
		case "writeAcceleratorEnabled":
			err = unpopulate(val, "WriteAcceleratorEnabled", &r.WriteAcceleratorEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointSourceVMStorageProfile.
func (r RestorePointSourceVMStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDisks", r.DataDisks)
	populate(objectMap, "diskControllerType", r.DiskControllerType)
	populate(objectMap, "osDisk", r.OSDisk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointSourceVMStorageProfile.
func (r *RestorePointSourceVMStorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDisks":
			err = unpopulate(val, "DataDisks", &r.DataDisks)
			delete(rawMsg, key)
		case "diskControllerType":
			err = unpopulate(val, "DiskControllerType", &r.DiskControllerType)
			delete(rawMsg, key)
		case "osDisk":
			err = unpopulate(val, "OSDisk", &r.OSDisk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RetrieveBootDiagnosticsDataResult.
func (r RetrieveBootDiagnosticsDataResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consoleScreenshotBlobUri", r.ConsoleScreenshotBlobURI)
	populate(objectMap, "serialConsoleLogBlobUri", r.SerialConsoleLogBlobURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RetrieveBootDiagnosticsDataResult.
func (r *RetrieveBootDiagnosticsDataResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consoleScreenshotBlobUri":
			err = unpopulate(val, "ConsoleScreenshotBlobURI", &r.ConsoleScreenshotBlobURI)
			delete(rawMsg, key)
		case "serialConsoleLogBlobUri":
			err = unpopulate(val, "SerialConsoleLogBlobURI", &r.SerialConsoleLogBlobURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleInstance.
func (r RoleInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleInstance.
func (r *RoleInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &r.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleInstanceListResult.
func (r RoleInstanceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleInstanceListResult.
func (r *RoleInstanceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleInstanceNetworkProfile.
func (r RoleInstanceNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkInterfaces", r.NetworkInterfaces)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleInstanceNetworkProfile.
func (r *RoleInstanceNetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &r.NetworkInterfaces)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleInstanceProperties.
func (r RoleInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceView", r.InstanceView)
	populate(objectMap, "networkProfile", r.NetworkProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleInstanceProperties.
func (r *RoleInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceView":
			err = unpopulate(val, "InstanceView", &r.InstanceView)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &r.NetworkProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleInstanceView.
func (r RoleInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "platformFaultDomain", r.PlatformFaultDomain)
	populate(objectMap, "platformUpdateDomain", r.PlatformUpdateDomain)
	populate(objectMap, "privateId", r.PrivateID)
	populate(objectMap, "statuses", r.Statuses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleInstanceView.
func (r *RoleInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "platformFaultDomain":
			err = unpopulate(val, "PlatformFaultDomain", &r.PlatformFaultDomain)
			delete(rawMsg, key)
		case "platformUpdateDomain":
			err = unpopulate(val, "PlatformUpdateDomain", &r.PlatformUpdateDomain)
			delete(rawMsg, key)
		case "privateId":
			err = unpopulate(val, "PrivateID", &r.PrivateID)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &r.Statuses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleInstances.
func (r RoleInstances) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "roleInstances", r.RoleInstances)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleInstances.
func (r *RoleInstances) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "roleInstances":
			err = unpopulate(val, "RoleInstances", &r.RoleInstances)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RollbackStatusInfo.
func (r RollbackStatusInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failedRolledbackInstanceCount", r.FailedRolledbackInstanceCount)
	populate(objectMap, "rollbackError", r.RollbackError)
	populate(objectMap, "successfullyRolledbackInstanceCount", r.SuccessfullyRolledbackInstanceCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RollbackStatusInfo.
func (r *RollbackStatusInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failedRolledbackInstanceCount":
			err = unpopulate(val, "FailedRolledbackInstanceCount", &r.FailedRolledbackInstanceCount)
			delete(rawMsg, key)
		case "rollbackError":
			err = unpopulate(val, "RollbackError", &r.RollbackError)
			delete(rawMsg, key)
		case "successfullyRolledbackInstanceCount":
			err = unpopulate(val, "SuccessfullyRolledbackInstanceCount", &r.SuccessfullyRolledbackInstanceCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RollingUpgradePolicy.
func (r RollingUpgradePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableCrossZoneUpgrade", r.EnableCrossZoneUpgrade)
	populate(objectMap, "maxBatchInstancePercent", r.MaxBatchInstancePercent)
	populate(objectMap, "maxSurge", r.MaxSurge)
	populate(objectMap, "maxUnhealthyInstancePercent", r.MaxUnhealthyInstancePercent)
	populate(objectMap, "maxUnhealthyUpgradedInstancePercent", r.MaxUnhealthyUpgradedInstancePercent)
	populate(objectMap, "pauseTimeBetweenBatches", r.PauseTimeBetweenBatches)
	populate(objectMap, "prioritizeUnhealthyInstances", r.PrioritizeUnhealthyInstances)
	populate(objectMap, "rollbackFailedInstancesOnPolicyBreach", r.RollbackFailedInstancesOnPolicyBreach)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RollingUpgradePolicy.
func (r *RollingUpgradePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableCrossZoneUpgrade":
			err = unpopulate(val, "EnableCrossZoneUpgrade", &r.EnableCrossZoneUpgrade)
			delete(rawMsg, key)
		case "maxBatchInstancePercent":
			err = unpopulate(val, "MaxBatchInstancePercent", &r.MaxBatchInstancePercent)
			delete(rawMsg, key)
		case "maxSurge":
			err = unpopulate(val, "MaxSurge", &r.MaxSurge)
			delete(rawMsg, key)
		case "maxUnhealthyInstancePercent":
			err = unpopulate(val, "MaxUnhealthyInstancePercent", &r.MaxUnhealthyInstancePercent)
			delete(rawMsg, key)
		case "maxUnhealthyUpgradedInstancePercent":
			err = unpopulate(val, "MaxUnhealthyUpgradedInstancePercent", &r.MaxUnhealthyUpgradedInstancePercent)
			delete(rawMsg, key)
		case "pauseTimeBetweenBatches":
			err = unpopulate(val, "PauseTimeBetweenBatches", &r.PauseTimeBetweenBatches)
			delete(rawMsg, key)
		case "prioritizeUnhealthyInstances":
			err = unpopulate(val, "PrioritizeUnhealthyInstances", &r.PrioritizeUnhealthyInstances)
			delete(rawMsg, key)
		case "rollbackFailedInstancesOnPolicyBreach":
			err = unpopulate(val, "RollbackFailedInstancesOnPolicyBreach", &r.RollbackFailedInstancesOnPolicyBreach)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RollingUpgradeProgressInfo.
func (r RollingUpgradeProgressInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failedInstanceCount", r.FailedInstanceCount)
	populate(objectMap, "inProgressInstanceCount", r.InProgressInstanceCount)
	populate(objectMap, "pendingInstanceCount", r.PendingInstanceCount)
	populate(objectMap, "successfulInstanceCount", r.SuccessfulInstanceCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RollingUpgradeProgressInfo.
func (r *RollingUpgradeProgressInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failedInstanceCount":
			err = unpopulate(val, "FailedInstanceCount", &r.FailedInstanceCount)
			delete(rawMsg, key)
		case "inProgressInstanceCount":
			err = unpopulate(val, "InProgressInstanceCount", &r.InProgressInstanceCount)
			delete(rawMsg, key)
		case "pendingInstanceCount":
			err = unpopulate(val, "PendingInstanceCount", &r.PendingInstanceCount)
			delete(rawMsg, key)
		case "successfulInstanceCount":
			err = unpopulate(val, "SuccessfulInstanceCount", &r.SuccessfulInstanceCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RollingUpgradeRunningStatus.
func (r RollingUpgradeRunningStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", r.Code)
	populate(objectMap, "lastAction", r.LastAction)
	populateDateTimeRFC3339(objectMap, "lastActionTime", r.LastActionTime)
	populateDateTimeRFC3339(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RollingUpgradeRunningStatus.
func (r *RollingUpgradeRunningStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &r.Code)
			delete(rawMsg, key)
		case "lastAction":
			err = unpopulate(val, "LastAction", &r.LastAction)
			delete(rawMsg, key)
		case "lastActionTime":
			err = unpopulateDateTimeRFC3339(val, "LastActionTime", &r.LastActionTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RollingUpgradeStatusInfo.
func (r RollingUpgradeStatusInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RollingUpgradeStatusInfo.
func (r *RollingUpgradeStatusInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RollingUpgradeStatusInfoProperties.
func (r RollingUpgradeStatusInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", r.Error)
	populate(objectMap, "policy", r.Policy)
	populate(objectMap, "progress", r.Progress)
	populate(objectMap, "runningStatus", r.RunningStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RollingUpgradeStatusInfoProperties.
func (r *RollingUpgradeStatusInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &r.Error)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &r.Policy)
			delete(rawMsg, key)
		case "progress":
			err = unpopulate(val, "Progress", &r.Progress)
			delete(rawMsg, key)
		case "runningStatus":
			err = unpopulate(val, "RunningStatus", &r.RunningStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunCommandDocument.
func (r RunCommandDocument) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "label", r.Label)
	populate(objectMap, "osType", r.OSType)
	populate(objectMap, "parameters", r.Parameters)
	populate(objectMap, "$schema", r.Schema)
	populate(objectMap, "script", r.Script)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunCommandDocument.
func (r *RunCommandDocument) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &r.Label)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &r.OSType)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &r.Parameters)
			delete(rawMsg, key)
		case "$schema":
			err = unpopulate(val, "Schema", &r.Schema)
			delete(rawMsg, key)
		case "script":
			err = unpopulate(val, "Script", &r.Script)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunCommandDocumentBase.
func (r RunCommandDocumentBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "label", r.Label)
	populate(objectMap, "osType", r.OSType)
	populate(objectMap, "$schema", r.Schema)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunCommandDocumentBase.
func (r *RunCommandDocumentBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &r.Label)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &r.OSType)
			delete(rawMsg, key)
		case "$schema":
			err = unpopulate(val, "Schema", &r.Schema)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunCommandInput.
func (r RunCommandInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "commandId", r.CommandID)
	populate(objectMap, "parameters", r.Parameters)
	populate(objectMap, "script", r.Script)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunCommandInput.
func (r *RunCommandInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commandId":
			err = unpopulate(val, "CommandID", &r.CommandID)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &r.Parameters)
			delete(rawMsg, key)
		case "script":
			err = unpopulate(val, "Script", &r.Script)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunCommandInputParameter.
func (r RunCommandInputParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunCommandInputParameter.
func (r *RunCommandInputParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunCommandListResult.
func (r RunCommandListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunCommandListResult.
func (r *RunCommandListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunCommandManagedIdentity.
func (r RunCommandManagedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", r.ClientID)
	populate(objectMap, "objectId", r.ObjectID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunCommandManagedIdentity.
func (r *RunCommandManagedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &r.ClientID)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &r.ObjectID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunCommandParameterDefinition.
func (r RunCommandParameterDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultValue", r.DefaultValue)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "required", r.Required)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunCommandParameterDefinition.
func (r *RunCommandParameterDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultValue":
			err = unpopulate(val, "DefaultValue", &r.DefaultValue)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "required":
			err = unpopulate(val, "Required", &r.Required)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunCommandResult.
func (r RunCommandResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunCommandResult.
func (r *RunCommandResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHConfiguration.
func (s SSHConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicKeys", s.PublicKeys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHConfiguration.
func (s *SSHConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicKeys":
			err = unpopulate(val, "PublicKeys", &s.PublicKeys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHGenerateKeyPairInputParameters.
func (s SSHGenerateKeyPairInputParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionType", s.EncryptionType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHGenerateKeyPairInputParameters.
func (s *SSHGenerateKeyPairInputParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionType":
			err = unpopulate(val, "EncryptionType", &s.EncryptionType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKey.
func (s SSHPublicKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyData", s.KeyData)
	populate(objectMap, "path", s.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKey.
func (s *SSHPublicKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyData":
			err = unpopulate(val, "KeyData", &s.KeyData)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &s.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKeyGenerateKeyPairResult.
func (s SSHPublicKeyGenerateKeyPairResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "privateKey", s.PrivateKey)
	populate(objectMap, "publicKey", s.PublicKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKeyGenerateKeyPairResult.
func (s *SSHPublicKeyGenerateKeyPairResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "privateKey":
			err = unpopulate(val, "PrivateKey", &s.PrivateKey)
			delete(rawMsg, key)
		case "publicKey":
			err = unpopulate(val, "PublicKey", &s.PublicKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKeyResource.
func (s SSHPublicKeyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKeyResource.
func (s *SSHPublicKeyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKeyResourceProperties.
func (s SSHPublicKeyResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicKey", s.PublicKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKeyResourceProperties.
func (s *SSHPublicKeyResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicKey":
			err = unpopulate(val, "PublicKey", &s.PublicKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKeyUpdateResource.
func (s SSHPublicKeyUpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKeyUpdateResource.
func (s *SSHPublicKeyUpdateResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKeysGroupListResult.
func (s SSHPublicKeysGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKeysGroupListResult.
func (s *SSHPublicKeysGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScaleInPolicy.
func (s ScaleInPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "forceDeletion", s.ForceDeletion)
	populate(objectMap, "rules", s.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScaleInPolicy.
func (s *ScaleInPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "forceDeletion":
			err = unpopulate(val, "ForceDeletion", &s.ForceDeletion)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &s.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduledEventsProfile.
func (s ScheduledEventsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "osImageNotificationProfile", s.OSImageNotificationProfile)
	populate(objectMap, "terminateNotificationProfile", s.TerminateNotificationProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduledEventsProfile.
func (s *ScheduledEventsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "osImageNotificationProfile":
			err = unpopulate(val, "OSImageNotificationProfile", &s.OSImageNotificationProfile)
			delete(rawMsg, key)
		case "terminateNotificationProfile":
			err = unpopulate(val, "TerminateNotificationProfile", &s.TerminateNotificationProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPostureReference.
func (s SecurityPostureReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "excludeExtensions", s.ExcludeExtensions)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPostureReference.
func (s *SecurityPostureReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "excludeExtensions":
			err = unpopulate(val, "ExcludeExtensions", &s.ExcludeExtensions)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityProfile.
func (s SecurityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionAtHost", s.EncryptionAtHost)
	populate(objectMap, "encryptionIdentity", s.EncryptionIdentity)
	populate(objectMap, "proxyAgentSettings", s.ProxyAgentSettings)
	populate(objectMap, "securityType", s.SecurityType)
	populate(objectMap, "uefiSettings", s.UefiSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityProfile.
func (s *SecurityProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionAtHost":
			err = unpopulate(val, "EncryptionAtHost", &s.EncryptionAtHost)
			delete(rawMsg, key)
		case "encryptionIdentity":
			err = unpopulate(val, "EncryptionIdentity", &s.EncryptionIdentity)
			delete(rawMsg, key)
		case "proxyAgentSettings":
			err = unpopulate(val, "ProxyAgentSettings", &s.ProxyAgentSettings)
			delete(rawMsg, key)
		case "securityType":
			err = unpopulate(val, "SecurityType", &s.SecurityType)
			delete(rawMsg, key)
		case "uefiSettings":
			err = unpopulate(val, "UefiSettings", &s.UefiSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceArtifactReference.
func (s ServiceArtifactReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceArtifactReference.
func (s *ServiceArtifactReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ShareInfoElement.
func (s ShareInfoElement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vmUri", s.VMURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ShareInfoElement.
func (s *ShareInfoElement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vmUri":
			err = unpopulate(val, "VMURI", &s.VMURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedGallery.
func (s SharedGallery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identifier", s.Identifier)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGallery.
func (s *SharedGallery) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identifier":
			err = unpopulate(val, "Identifier", &s.Identifier)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedGalleryDataDiskImage.
func (s SharedGalleryDataDiskImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskSizeGB", s.DiskSizeGB)
	populate(objectMap, "hostCaching", s.HostCaching)
	populate(objectMap, "lun", s.Lun)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryDataDiskImage.
func (s *SharedGalleryDataDiskImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &s.DiskSizeGB)
			delete(rawMsg, key)
		case "hostCaching":
			err = unpopulate(val, "HostCaching", &s.HostCaching)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &s.Lun)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedGalleryDiskImage.
func (s SharedGalleryDiskImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskSizeGB", s.DiskSizeGB)
	populate(objectMap, "hostCaching", s.HostCaching)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryDiskImage.
func (s *SharedGalleryDiskImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &s.DiskSizeGB)
			delete(rawMsg, key)
		case "hostCaching":
			err = unpopulate(val, "HostCaching", &s.HostCaching)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedGalleryIdentifier.
func (s SharedGalleryIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "uniqueId", s.UniqueID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryIdentifier.
func (s *SharedGalleryIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "uniqueId":
			err = unpopulate(val, "UniqueID", &s.UniqueID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedGalleryImage.
func (s SharedGalleryImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identifier", s.Identifier)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryImage.
func (s *SharedGalleryImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identifier":
			err = unpopulate(val, "Identifier", &s.Identifier)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedGalleryImageList.
func (s SharedGalleryImageList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryImageList.
func (s *SharedGalleryImageList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedGalleryImageProperties.
func (s SharedGalleryImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "architecture", s.Architecture)
	populate(objectMap, "artifactTags", s.ArtifactTags)
	populate(objectMap, "disallowed", s.Disallowed)
	populateDateTimeRFC3339(objectMap, "endOfLifeDate", s.EndOfLifeDate)
	populate(objectMap, "eula", s.Eula)
	populate(objectMap, "features", s.Features)
	populate(objectMap, "hyperVGeneration", s.HyperVGeneration)
	populate(objectMap, "identifier", s.Identifier)
	populate(objectMap, "osState", s.OSState)
	populate(objectMap, "osType", s.OSType)
	populate(objectMap, "privacyStatementUri", s.PrivacyStatementURI)
	populate(objectMap, "purchasePlan", s.PurchasePlan)
	populate(objectMap, "recommended", s.Recommended)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryImageProperties.
func (s *SharedGalleryImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "architecture":
			err = unpopulate(val, "Architecture", &s.Architecture)
			delete(rawMsg, key)
		case "artifactTags":
			err = unpopulate(val, "ArtifactTags", &s.ArtifactTags)
			delete(rawMsg, key)
		case "disallowed":
			err = unpopulate(val, "Disallowed", &s.Disallowed)
			delete(rawMsg, key)
		case "endOfLifeDate":
			err = unpopulateDateTimeRFC3339(val, "EndOfLifeDate", &s.EndOfLifeDate)
			delete(rawMsg, key)
		case "eula":
			err = unpopulate(val, "Eula", &s.Eula)
			delete(rawMsg, key)
		case "features":
			err = unpopulate(val, "Features", &s.Features)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &s.HyperVGeneration)
			delete(rawMsg, key)
		case "identifier":
			err = unpopulate(val, "Identifier", &s.Identifier)
			delete(rawMsg, key)
		case "osState":
			err = unpopulate(val, "OSState", &s.OSState)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &s.OSType)
			delete(rawMsg, key)
		case "privacyStatementUri":
			err = unpopulate(val, "PrivacyStatementURI", &s.PrivacyStatementURI)
			delete(rawMsg, key)
		case "purchasePlan":
			err = unpopulate(val, "PurchasePlan", &s.PurchasePlan)
			delete(rawMsg, key)
		case "recommended":
			err = unpopulate(val, "Recommended", &s.Recommended)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedGalleryImageVersion.
func (s SharedGalleryImageVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identifier", s.Identifier)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryImageVersion.
func (s *SharedGalleryImageVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identifier":
			err = unpopulate(val, "Identifier", &s.Identifier)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedGalleryImageVersionList.
func (s SharedGalleryImageVersionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryImageVersionList.
func (s *SharedGalleryImageVersionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedGalleryImageVersionProperties.
func (s SharedGalleryImageVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactTags", s.ArtifactTags)
	populateDateTimeRFC3339(objectMap, "endOfLifeDate", s.EndOfLifeDate)
	populate(objectMap, "excludeFromLatest", s.ExcludeFromLatest)
	populateDateTimeRFC3339(objectMap, "publishedDate", s.PublishedDate)
	populate(objectMap, "storageProfile", s.StorageProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryImageVersionProperties.
func (s *SharedGalleryImageVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactTags":
			err = unpopulate(val, "ArtifactTags", &s.ArtifactTags)
			delete(rawMsg, key)
		case "endOfLifeDate":
			err = unpopulateDateTimeRFC3339(val, "EndOfLifeDate", &s.EndOfLifeDate)
			delete(rawMsg, key)
		case "excludeFromLatest":
			err = unpopulate(val, "ExcludeFromLatest", &s.ExcludeFromLatest)
			delete(rawMsg, key)
		case "publishedDate":
			err = unpopulateDateTimeRFC3339(val, "PublishedDate", &s.PublishedDate)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &s.StorageProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedGalleryImageVersionStorageProfile.
func (s SharedGalleryImageVersionStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDiskImages", s.DataDiskImages)
	populate(objectMap, "osDiskImage", s.OSDiskImage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryImageVersionStorageProfile.
func (s *SharedGalleryImageVersionStorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDiskImages":
			err = unpopulate(val, "DataDiskImages", &s.DataDiskImages)
			delete(rawMsg, key)
		case "osDiskImage":
			err = unpopulate(val, "OSDiskImage", &s.OSDiskImage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedGalleryList.
func (s SharedGalleryList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryList.
func (s *SharedGalleryList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedGalleryOSDiskImage.
func (s SharedGalleryOSDiskImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskSizeGB", s.DiskSizeGB)
	populate(objectMap, "hostCaching", s.HostCaching)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryOSDiskImage.
func (s *SharedGalleryOSDiskImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &s.DiskSizeGB)
			delete(rawMsg, key)
		case "hostCaching":
			err = unpopulate(val, "HostCaching", &s.HostCaching)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedGalleryProperties.
func (s SharedGalleryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactTags", s.ArtifactTags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedGalleryProperties.
func (s *SharedGalleryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactTags":
			err = unpopulate(val, "ArtifactTags", &s.ArtifactTags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharingProfile.
func (s SharingProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "communityGalleryInfo", s.CommunityGalleryInfo)
	populate(objectMap, "groups", s.Groups)
	populate(objectMap, "permissions", s.Permissions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharingProfile.
func (s *SharingProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "communityGalleryInfo":
			err = unpopulate(val, "CommunityGalleryInfo", &s.CommunityGalleryInfo)
			delete(rawMsg, key)
		case "groups":
			err = unpopulate(val, "Groups", &s.Groups)
			delete(rawMsg, key)
		case "permissions":
			err = unpopulate(val, "Permissions", &s.Permissions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharingProfileGroup.
func (s SharingProfileGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ids", s.IDs)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharingProfileGroup.
func (s *SharingProfileGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ids":
			err = unpopulate(val, "IDs", &s.IDs)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharingStatus.
func (s SharingStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregatedState", s.AggregatedState)
	populate(objectMap, "summary", s.Summary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharingStatus.
func (s *SharingStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregatedState":
			err = unpopulate(val, "AggregatedState", &s.AggregatedState)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &s.Summary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharingUpdate.
func (s SharingUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groups", s.Groups)
	populate(objectMap, "operationType", s.OperationType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharingUpdate.
func (s *SharingUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groups":
			err = unpopulate(val, "Groups", &s.Groups)
			delete(rawMsg, key)
		case "operationType":
			err = unpopulate(val, "OperationType", &s.OperationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", s.ExtendedLocation)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "managedBy", s.ManagedBy)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Snapshot.
func (s *Snapshot) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &s.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "managedBy":
			err = unpopulate(val, "ManagedBy", &s.ManagedBy)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotList.
func (s SnapshotList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotList.
func (s *SnapshotList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotProperties.
func (s SnapshotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "completionPercent", s.CompletionPercent)
	populate(objectMap, "copyCompletionError", s.CopyCompletionError)
	populate(objectMap, "creationData", s.CreationData)
	populate(objectMap, "dataAccessAuthMode", s.DataAccessAuthMode)
	populate(objectMap, "diskAccessId", s.DiskAccessID)
	populate(objectMap, "diskSizeBytes", s.DiskSizeBytes)
	populate(objectMap, "diskSizeGB", s.DiskSizeGB)
	populate(objectMap, "diskState", s.DiskState)
	populate(objectMap, "encryption", s.Encryption)
	populate(objectMap, "encryptionSettingsCollection", s.EncryptionSettingsCollection)
	populate(objectMap, "hyperVGeneration", s.HyperVGeneration)
	populate(objectMap, "incremental", s.Incremental)
	populate(objectMap, "incrementalSnapshotFamilyId", s.IncrementalSnapshotFamilyID)
	populate(objectMap, "networkAccessPolicy", s.NetworkAccessPolicy)
	populate(objectMap, "osType", s.OSType)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "purchasePlan", s.PurchasePlan)
	populate(objectMap, "securityProfile", s.SecurityProfile)
	populate(objectMap, "supportedCapabilities", s.SupportedCapabilities)
	populate(objectMap, "supportsHibernation", s.SupportsHibernation)
	populateDateTimeRFC3339(objectMap, "timeCreated", s.TimeCreated)
	populate(objectMap, "uniqueId", s.UniqueID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotProperties.
func (s *SnapshotProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completionPercent":
			err = unpopulate(val, "CompletionPercent", &s.CompletionPercent)
			delete(rawMsg, key)
		case "copyCompletionError":
			err = unpopulate(val, "CopyCompletionError", &s.CopyCompletionError)
			delete(rawMsg, key)
		case "creationData":
			err = unpopulate(val, "CreationData", &s.CreationData)
			delete(rawMsg, key)
		case "dataAccessAuthMode":
			err = unpopulate(val, "DataAccessAuthMode", &s.DataAccessAuthMode)
			delete(rawMsg, key)
		case "diskAccessId":
			err = unpopulate(val, "DiskAccessID", &s.DiskAccessID)
			delete(rawMsg, key)
		case "diskSizeBytes":
			err = unpopulate(val, "DiskSizeBytes", &s.DiskSizeBytes)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &s.DiskSizeGB)
			delete(rawMsg, key)
		case "diskState":
			err = unpopulate(val, "DiskState", &s.DiskState)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &s.Encryption)
			delete(rawMsg, key)
		case "encryptionSettingsCollection":
			err = unpopulate(val, "EncryptionSettingsCollection", &s.EncryptionSettingsCollection)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &s.HyperVGeneration)
			delete(rawMsg, key)
		case "incremental":
			err = unpopulate(val, "Incremental", &s.Incremental)
			delete(rawMsg, key)
		case "incrementalSnapshotFamilyId":
			err = unpopulate(val, "IncrementalSnapshotFamilyID", &s.IncrementalSnapshotFamilyID)
			delete(rawMsg, key)
		case "networkAccessPolicy":
			err = unpopulate(val, "NetworkAccessPolicy", &s.NetworkAccessPolicy)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &s.OSType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "purchasePlan":
			err = unpopulate(val, "PurchasePlan", &s.PurchasePlan)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &s.SecurityProfile)
			delete(rawMsg, key)
		case "supportedCapabilities":
			err = unpopulate(val, "SupportedCapabilities", &s.SupportedCapabilities)
			delete(rawMsg, key)
		case "supportsHibernation":
			err = unpopulate(val, "SupportsHibernation", &s.SupportsHibernation)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateDateTimeRFC3339(val, "TimeCreated", &s.TimeCreated)
			delete(rawMsg, key)
		case "uniqueId":
			err = unpopulate(val, "UniqueID", &s.UniqueID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotSKU.
func (s SnapshotSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotSKU.
func (s *SnapshotSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotUpdate.
func (s SnapshotUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotUpdate.
func (s *SnapshotUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotUpdateProperties.
func (s SnapshotUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataAccessAuthMode", s.DataAccessAuthMode)
	populate(objectMap, "diskAccessId", s.DiskAccessID)
	populate(objectMap, "diskSizeGB", s.DiskSizeGB)
	populate(objectMap, "encryption", s.Encryption)
	populate(objectMap, "encryptionSettingsCollection", s.EncryptionSettingsCollection)
	populate(objectMap, "networkAccessPolicy", s.NetworkAccessPolicy)
	populate(objectMap, "osType", s.OSType)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "supportedCapabilities", s.SupportedCapabilities)
	populate(objectMap, "supportsHibernation", s.SupportsHibernation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotUpdateProperties.
func (s *SnapshotUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataAccessAuthMode":
			err = unpopulate(val, "DataAccessAuthMode", &s.DataAccessAuthMode)
			delete(rawMsg, key)
		case "diskAccessId":
			err = unpopulate(val, "DiskAccessID", &s.DiskAccessID)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &s.DiskSizeGB)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &s.Encryption)
			delete(rawMsg, key)
		case "encryptionSettingsCollection":
			err = unpopulate(val, "EncryptionSettingsCollection", &s.EncryptionSettingsCollection)
			delete(rawMsg, key)
		case "networkAccessPolicy":
			err = unpopulate(val, "NetworkAccessPolicy", &s.NetworkAccessPolicy)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &s.OSType)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "supportedCapabilities":
			err = unpopulate(val, "SupportedCapabilities", &s.SupportedCapabilities)
			delete(rawMsg, key)
		case "supportsHibernation":
			err = unpopulate(val, "SupportsHibernation", &s.SupportsHibernation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftDeletePolicy.
func (s SoftDeletePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isSoftDeleteEnabled", s.IsSoftDeleteEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftDeletePolicy.
func (s *SoftDeletePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isSoftDeleteEnabled":
			err = unpopulate(val, "IsSoftDeleteEnabled", &s.IsSoftDeleteEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceVault.
func (s SourceVault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceVault.
func (s *SourceVault) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SpotRestorePolicy.
func (s SpotRestorePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", s.Enabled)
	populate(objectMap, "restoreTimeout", s.RestoreTimeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SpotRestorePolicy.
func (s *SpotRestorePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &s.Enabled)
			delete(rawMsg, key)
		case "restoreTimeout":
			err = unpopulate(val, "RestoreTimeout", &s.RestoreTimeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatusCodeCount.
func (s StatusCodeCount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", s.Code)
	populate(objectMap, "count", s.Count)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatusCodeCount.
func (s *StatusCodeCount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &s.Code)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &s.Count)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageProfile.
func (s StorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDisks", s.DataDisks)
	populate(objectMap, "diskControllerType", s.DiskControllerType)
	populate(objectMap, "imageReference", s.ImageReference)
	populate(objectMap, "osDisk", s.OSDisk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageProfile.
func (s *StorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDisks":
			err = unpopulate(val, "DataDisks", &s.DataDisks)
			delete(rawMsg, key)
		case "diskControllerType":
			err = unpopulate(val, "DiskControllerType", &s.DiskControllerType)
			delete(rawMsg, key)
		case "imageReference":
			err = unpopulate(val, "ImageReference", &s.ImageReference)
			delete(rawMsg, key)
		case "osDisk":
			err = unpopulate(val, "OSDisk", &s.OSDisk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResource.
func (s SubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResource.
func (s *SubResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResourceReadOnly.
func (s SubResourceReadOnly) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResourceReadOnly.
func (s *SubResourceReadOnly) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResourceWithColocationStatus.
func (s SubResourceWithColocationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "colocationStatus", s.ColocationStatus)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResourceWithColocationStatus.
func (s *SubResourceWithColocationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "colocationStatus":
			err = unpopulate(val, "ColocationStatus", &s.ColocationStatus)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SupportedCapabilities.
func (s SupportedCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acceleratedNetwork", s.AcceleratedNetwork)
	populate(objectMap, "architecture", s.Architecture)
	populate(objectMap, "diskControllerTypes", s.DiskControllerTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SupportedCapabilities.
func (s *SupportedCapabilities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acceleratedNetwork":
			err = unpopulate(val, "AcceleratedNetwork", &s.AcceleratedNetwork)
			delete(rawMsg, key)
		case "architecture":
			err = unpopulate(val, "Architecture", &s.Architecture)
			delete(rawMsg, key)
		case "diskControllerTypes":
			err = unpopulate(val, "DiskControllerTypes", &s.DiskControllerTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetRegion.
func (t TargetRegion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryption", t.Encryption)
	populate(objectMap, "excludeFromLatest", t.ExcludeFromLatest)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "regionalReplicaCount", t.RegionalReplicaCount)
	populate(objectMap, "storageAccountType", t.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetRegion.
func (t *TargetRegion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryption":
			err = unpopulate(val, "Encryption", &t.Encryption)
			delete(rawMsg, key)
		case "excludeFromLatest":
			err = unpopulate(val, "ExcludeFromLatest", &t.ExcludeFromLatest)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "regionalReplicaCount":
			err = unpopulate(val, "RegionalReplicaCount", &t.RegionalReplicaCount)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &t.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TerminateNotificationProfile.
func (t TerminateNotificationProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enable", t.Enable)
	populate(objectMap, "notBeforeTimeout", t.NotBeforeTimeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TerminateNotificationProfile.
func (t *TerminateNotificationProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enable":
			err = unpopulate(val, "Enable", &t.Enable)
			delete(rawMsg, key)
		case "notBeforeTimeout":
			err = unpopulate(val, "NotBeforeTimeout", &t.NotBeforeTimeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThrottledRequestsInput.
func (t ThrottledRequestsInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobContainerSasUri", t.BlobContainerSasURI)
	populateDateTimeRFC3339(objectMap, "fromTime", t.FromTime)
	populate(objectMap, "groupByClientApplicationId", t.GroupByClientApplicationID)
	populate(objectMap, "groupByOperationName", t.GroupByOperationName)
	populate(objectMap, "groupByResourceName", t.GroupByResourceName)
	populate(objectMap, "groupByThrottlePolicy", t.GroupByThrottlePolicy)
	populate(objectMap, "groupByUserAgent", t.GroupByUserAgent)
	populateDateTimeRFC3339(objectMap, "toTime", t.ToTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThrottledRequestsInput.
func (t *ThrottledRequestsInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobContainerSasUri":
			err = unpopulate(val, "BlobContainerSasURI", &t.BlobContainerSasURI)
			delete(rawMsg, key)
		case "fromTime":
			err = unpopulateDateTimeRFC3339(val, "FromTime", &t.FromTime)
			delete(rawMsg, key)
		case "groupByClientApplicationId":
			err = unpopulate(val, "GroupByClientApplicationID", &t.GroupByClientApplicationID)
			delete(rawMsg, key)
		case "groupByOperationName":
			err = unpopulate(val, "GroupByOperationName", &t.GroupByOperationName)
			delete(rawMsg, key)
		case "groupByResourceName":
			err = unpopulate(val, "GroupByResourceName", &t.GroupByResourceName)
			delete(rawMsg, key)
		case "groupByThrottlePolicy":
			err = unpopulate(val, "GroupByThrottlePolicy", &t.GroupByThrottlePolicy)
			delete(rawMsg, key)
		case "groupByUserAgent":
			err = unpopulate(val, "GroupByUserAgent", &t.GroupByUserAgent)
			delete(rawMsg, key)
		case "toTime":
			err = unpopulateDateTimeRFC3339(val, "ToTime", &t.ToTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UefiKey.
func (u UefiKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", u.Type)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UefiKey.
func (u *UefiKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UefiKeySignatures.
func (u UefiKeySignatures) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "db", u.Db)
	populate(objectMap, "dbx", u.Dbx)
	populate(objectMap, "kek", u.Kek)
	populate(objectMap, "pk", u.Pk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UefiKeySignatures.
func (u *UefiKeySignatures) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "db":
			err = unpopulate(val, "Db", &u.Db)
			delete(rawMsg, key)
		case "dbx":
			err = unpopulate(val, "Dbx", &u.Dbx)
			delete(rawMsg, key)
		case "kek":
			err = unpopulate(val, "Kek", &u.Kek)
			delete(rawMsg, key)
		case "pk":
			err = unpopulate(val, "Pk", &u.Pk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UefiSettings.
func (u UefiSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secureBootEnabled", u.SecureBootEnabled)
	populate(objectMap, "vTpmEnabled", u.VTpmEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UefiSettings.
func (u *UefiSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secureBootEnabled":
			err = unpopulate(val, "SecureBootEnabled", &u.SecureBootEnabled)
			delete(rawMsg, key)
		case "vTpmEnabled":
			err = unpopulate(val, "VTpmEnabled", &u.VTpmEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateDomain.
func (u UpdateDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "name", u.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateDomain.
func (u *UpdateDomain) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateDomainListResult.
func (u UpdateDomainListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateDomainListResult.
func (u *UpdateDomainListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateResource.
func (u UpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateResource.
func (u *UpdateResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateResourceDefinition.
func (u UpdateResourceDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "tags", u.Tags)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateResourceDefinition.
func (u *UpdateResourceDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpgradeOperationHistoricalStatusInfo.
func (u UpgradeOperationHistoricalStatusInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", u.Location)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpgradeOperationHistoricalStatusInfo.
func (u *UpgradeOperationHistoricalStatusInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &u.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpgradeOperationHistoricalStatusInfoProperties.
func (u UpgradeOperationHistoricalStatusInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", u.Error)
	populate(objectMap, "progress", u.Progress)
	populate(objectMap, "rollbackInfo", u.RollbackInfo)
	populate(objectMap, "runningStatus", u.RunningStatus)
	populate(objectMap, "startedBy", u.StartedBy)
	populate(objectMap, "targetImageReference", u.TargetImageReference)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpgradeOperationHistoricalStatusInfoProperties.
func (u *UpgradeOperationHistoricalStatusInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &u.Error)
			delete(rawMsg, key)
		case "progress":
			err = unpopulate(val, "Progress", &u.Progress)
			delete(rawMsg, key)
		case "rollbackInfo":
			err = unpopulate(val, "RollbackInfo", &u.RollbackInfo)
			delete(rawMsg, key)
		case "runningStatus":
			err = unpopulate(val, "RunningStatus", &u.RunningStatus)
			delete(rawMsg, key)
		case "startedBy":
			err = unpopulate(val, "StartedBy", &u.StartedBy)
			delete(rawMsg, key)
		case "targetImageReference":
			err = unpopulate(val, "TargetImageReference", &u.TargetImageReference)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpgradeOperationHistoryStatus.
func (u UpgradeOperationHistoryStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", u.Code)
	populateDateTimeRFC3339(objectMap, "endTime", u.EndTime)
	populateDateTimeRFC3339(objectMap, "startTime", u.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpgradeOperationHistoryStatus.
func (u *UpgradeOperationHistoryStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &u.Code)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &u.EndTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &u.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpgradePolicy.
func (u UpgradePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "automaticOSUpgradePolicy", u.AutomaticOSUpgradePolicy)
	populate(objectMap, "mode", u.Mode)
	populate(objectMap, "rollingUpgradePolicy", u.RollingUpgradePolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpgradePolicy.
func (u *UpgradePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "automaticOSUpgradePolicy":
			err = unpopulate(val, "AutomaticOSUpgradePolicy", &u.AutomaticOSUpgradePolicy)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &u.Mode)
			delete(rawMsg, key)
		case "rollingUpgradePolicy":
			err = unpopulate(val, "RollingUpgradePolicy", &u.RollingUpgradePolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", u.CurrentValue)
	populate(objectMap, "limit", u.Limit)
	populate(objectMap, "name", u.Name)
	objectMap["unit"] = "Count"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Usage.
func (u *Usage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &u.CurrentValue)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &u.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &u.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageName.
func (u UsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", u.LocalizedValue)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageName.
func (u *UsageName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &u.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserArtifactManage.
func (u UserArtifactManage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "install", u.Install)
	populate(objectMap, "remove", u.Remove)
	populate(objectMap, "update", u.Update)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserArtifactManage.
func (u *UserArtifactManage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "install":
			err = unpopulate(val, "Install", &u.Install)
			delete(rawMsg, key)
		case "remove":
			err = unpopulate(val, "Remove", &u.Remove)
			delete(rawMsg, key)
		case "update":
			err = unpopulate(val, "Update", &u.Update)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserArtifactSettings.
func (u UserArtifactSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configFileName", u.ConfigFileName)
	populate(objectMap, "packageFileName", u.PackageFileName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserArtifactSettings.
func (u *UserArtifactSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configFileName":
			err = unpopulate(val, "ConfigFileName", &u.ConfigFileName)
			delete(rawMsg, key)
		case "packageFileName":
			err = unpopulate(val, "PackageFileName", &u.PackageFileName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserArtifactSource.
func (u UserArtifactSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultConfigurationLink", u.DefaultConfigurationLink)
	populate(objectMap, "mediaLink", u.MediaLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserArtifactSource.
func (u *UserArtifactSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultConfigurationLink":
			err = unpopulate(val, "DefaultConfigurationLink", &u.DefaultConfigurationLink)
			delete(rawMsg, key)
		case "mediaLink":
			err = unpopulate(val, "MediaLink", &u.MediaLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentitiesValue.
func (u UserAssignedIdentitiesValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentitiesValue.
func (u *UserAssignedIdentitiesValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMDiskSecurityProfile.
func (v VMDiskSecurityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSet", v.DiskEncryptionSet)
	populate(objectMap, "securityEncryptionType", v.SecurityEncryptionType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMDiskSecurityProfile.
func (v *VMDiskSecurityProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSet":
			err = unpopulate(val, "DiskEncryptionSet", &v.DiskEncryptionSet)
			delete(rawMsg, key)
		case "securityEncryptionType":
			err = unpopulate(val, "SecurityEncryptionType", &v.SecurityEncryptionType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMGalleryApplication.
func (v VMGalleryApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationReference", v.ConfigurationReference)
	populate(objectMap, "enableAutomaticUpgrade", v.EnableAutomaticUpgrade)
	populate(objectMap, "order", v.Order)
	populate(objectMap, "packageReferenceId", v.PackageReferenceID)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "treatFailureAsDeploymentFailure", v.TreatFailureAsDeploymentFailure)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMGalleryApplication.
func (v *VMGalleryApplication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationReference":
			err = unpopulate(val, "ConfigurationReference", &v.ConfigurationReference)
			delete(rawMsg, key)
		case "enableAutomaticUpgrade":
			err = unpopulate(val, "EnableAutomaticUpgrade", &v.EnableAutomaticUpgrade)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &v.Order)
			delete(rawMsg, key)
		case "packageReferenceId":
			err = unpopulate(val, "PackageReferenceID", &v.PackageReferenceID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "treatFailureAsDeploymentFailure":
			err = unpopulate(val, "TreatFailureAsDeploymentFailure", &v.TreatFailureAsDeploymentFailure)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMImagesInEdgeZoneListResult.
func (v VMImagesInEdgeZoneListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMImagesInEdgeZoneListResult.
func (v *VMImagesInEdgeZoneListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMScaleSetConvertToSinglePlacementGroupInput.
func (v VMScaleSetConvertToSinglePlacementGroupInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activePlacementGroupId", v.ActivePlacementGroupID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMScaleSetConvertToSinglePlacementGroupInput.
func (v *VMScaleSetConvertToSinglePlacementGroupInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activePlacementGroupId":
			err = unpopulate(val, "ActivePlacementGroupID", &v.ActivePlacementGroupID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMSizeProperties.
func (v VMSizeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vCPUsAvailable", v.VCPUsAvailable)
	populate(objectMap, "vCPUsPerCore", v.VCPUsPerCore)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMSizeProperties.
func (v *VMSizeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vCPUsAvailable":
			err = unpopulate(val, "VCPUsAvailable", &v.VCPUsAvailable)
			delete(rawMsg, key)
		case "vCPUsPerCore":
			err = unpopulate(val, "VCPUsPerCore", &v.VCPUsPerCore)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultCertificate.
func (v VaultCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateStore", v.CertificateStore)
	populate(objectMap, "certificateUrl", v.CertificateURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultCertificate.
func (v *VaultCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateStore":
			err = unpopulate(val, "CertificateStore", &v.CertificateStore)
			delete(rawMsg, key)
		case "certificateUrl":
			err = unpopulate(val, "CertificateURL", &v.CertificateURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultSecretGroup.
func (v VaultSecretGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sourceVault", v.SourceVault)
	populate(objectMap, "vaultCertificates", v.VaultCertificates)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultSecretGroup.
func (v *VaultSecretGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceVault":
			err = unpopulate(val, "SourceVault", &v.SourceVault)
			delete(rawMsg, key)
		case "vaultCertificates":
			err = unpopulate(val, "VaultCertificates", &v.VaultCertificates)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualHardDisk.
func (v VirtualHardDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "uri", v.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualHardDisk.
func (v *VirtualHardDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "uri":
			err = unpopulate(val, "URI", &v.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachine.
func (v VirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "managedBy", v.ManagedBy)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "resources", v.Resources)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "zones", v.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachine.
func (v *VirtualMachine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &v.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "managedBy":
			err = unpopulate(val, "ManagedBy", &v.ManagedBy)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &v.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &v.Resources)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &v.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineAgentInstanceView.
func (v VirtualMachineAgentInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extensionHandlers", v.ExtensionHandlers)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "vmAgentVersion", v.VMAgentVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineAgentInstanceView.
func (v *VirtualMachineAgentInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extensionHandlers":
			err = unpopulate(val, "ExtensionHandlers", &v.ExtensionHandlers)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		case "vmAgentVersion":
			err = unpopulate(val, "VMAgentVersion", &v.VMAgentVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineAssessPatchesResult.
func (v VirtualMachineAssessPatchesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assessmentActivityId", v.AssessmentActivityID)
	populate(objectMap, "availablePatches", v.AvailablePatches)
	populate(objectMap, "criticalAndSecurityPatchCount", v.CriticalAndSecurityPatchCount)
	populate(objectMap, "error", v.Error)
	populate(objectMap, "otherPatchCount", v.OtherPatchCount)
	populate(objectMap, "rebootPending", v.RebootPending)
	populateDateTimeRFC3339(objectMap, "startDateTime", v.StartDateTime)
	populate(objectMap, "status", v.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineAssessPatchesResult.
func (v *VirtualMachineAssessPatchesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentActivityId":
			err = unpopulate(val, "AssessmentActivityID", &v.AssessmentActivityID)
			delete(rawMsg, key)
		case "availablePatches":
			err = unpopulate(val, "AvailablePatches", &v.AvailablePatches)
			delete(rawMsg, key)
		case "criticalAndSecurityPatchCount":
			err = unpopulate(val, "CriticalAndSecurityPatchCount", &v.CriticalAndSecurityPatchCount)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &v.Error)
			delete(rawMsg, key)
		case "otherPatchCount":
			err = unpopulate(val, "OtherPatchCount", &v.OtherPatchCount)
			delete(rawMsg, key)
		case "rebootPending":
			err = unpopulate(val, "RebootPending", &v.RebootPending)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateDateTimeRFC3339(val, "StartDateTime", &v.StartDateTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineCaptureParameters.
func (v VirtualMachineCaptureParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationContainerName", v.DestinationContainerName)
	populate(objectMap, "overwriteVhds", v.OverwriteVhds)
	populate(objectMap, "vhdPrefix", v.VhdPrefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineCaptureParameters.
func (v *VirtualMachineCaptureParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationContainerName":
			err = unpopulate(val, "DestinationContainerName", &v.DestinationContainerName)
			delete(rawMsg, key)
		case "overwriteVhds":
			err = unpopulate(val, "OverwriteVhds", &v.OverwriteVhds)
			delete(rawMsg, key)
		case "vhdPrefix":
			err = unpopulate(val, "VhdPrefix", &v.VhdPrefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineCaptureResult.
func (v VirtualMachineCaptureResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentVersion", v.ContentVersion)
	populate(objectMap, "id", v.ID)
	populateAny(objectMap, "parameters", v.Parameters)
	populate(objectMap, "resources", v.Resources)
	populate(objectMap, "$schema", v.Schema)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineCaptureResult.
func (v *VirtualMachineCaptureResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentVersion":
			err = unpopulate(val, "ContentVersion", &v.ContentVersion)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &v.Parameters)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &v.Resources)
			delete(rawMsg, key)
		case "$schema":
			err = unpopulate(val, "Schema", &v.Schema)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtension.
func (v VirtualMachineExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtension.
func (v *VirtualMachineExtension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionHandlerInstanceView.
func (v VirtualMachineExtensionHandlerInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", v.Status)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "typeHandlerVersion", v.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionHandlerInstanceView.
func (v *VirtualMachineExtensionHandlerInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &v.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionImage.
func (v VirtualMachineExtensionImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionImage.
func (v *VirtualMachineExtensionImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionImageProperties.
func (v VirtualMachineExtensionImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeRole", v.ComputeRole)
	populate(objectMap, "handlerSchema", v.HandlerSchema)
	populate(objectMap, "operatingSystem", v.OperatingSystem)
	populate(objectMap, "supportsMultipleExtensions", v.SupportsMultipleExtensions)
	populate(objectMap, "vmScaleSetEnabled", v.VMScaleSetEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionImageProperties.
func (v *VirtualMachineExtensionImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeRole":
			err = unpopulate(val, "ComputeRole", &v.ComputeRole)
			delete(rawMsg, key)
		case "handlerSchema":
			err = unpopulate(val, "HandlerSchema", &v.HandlerSchema)
			delete(rawMsg, key)
		case "operatingSystem":
			err = unpopulate(val, "OperatingSystem", &v.OperatingSystem)
			delete(rawMsg, key)
		case "supportsMultipleExtensions":
			err = unpopulate(val, "SupportsMultipleExtensions", &v.SupportsMultipleExtensions)
			delete(rawMsg, key)
		case "vmScaleSetEnabled":
			err = unpopulate(val, "VMScaleSetEnabled", &v.VMScaleSetEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionInstanceView.
func (v VirtualMachineExtensionInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "substatuses", v.Substatuses)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "typeHandlerVersion", v.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionInstanceView.
func (v *VirtualMachineExtensionInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		case "substatuses":
			err = unpopulate(val, "Substatuses", &v.Substatuses)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &v.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionProperties.
func (v VirtualMachineExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoUpgradeMinorVersion", v.AutoUpgradeMinorVersion)
	populate(objectMap, "enableAutomaticUpgrade", v.EnableAutomaticUpgrade)
	populate(objectMap, "forceUpdateTag", v.ForceUpdateTag)
	populate(objectMap, "instanceView", v.InstanceView)
	populateAny(objectMap, "protectedSettings", v.ProtectedSettings)
	populate(objectMap, "protectedSettingsFromKeyVault", v.ProtectedSettingsFromKeyVault)
	populate(objectMap, "provisionAfterExtensions", v.ProvisionAfterExtensions)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "publisher", v.Publisher)
	populateAny(objectMap, "settings", v.Settings)
	populate(objectMap, "suppressFailures", v.SuppressFailures)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "typeHandlerVersion", v.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionProperties.
func (v *VirtualMachineExtensionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoUpgradeMinorVersion":
			err = unpopulate(val, "AutoUpgradeMinorVersion", &v.AutoUpgradeMinorVersion)
			delete(rawMsg, key)
		case "enableAutomaticUpgrade":
			err = unpopulate(val, "EnableAutomaticUpgrade", &v.EnableAutomaticUpgrade)
			delete(rawMsg, key)
		case "forceUpdateTag":
			err = unpopulate(val, "ForceUpdateTag", &v.ForceUpdateTag)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &v.InstanceView)
			delete(rawMsg, key)
		case "protectedSettings":
			err = unpopulate(val, "ProtectedSettings", &v.ProtectedSettings)
			delete(rawMsg, key)
		case "protectedSettingsFromKeyVault":
			err = unpopulate(val, "ProtectedSettingsFromKeyVault", &v.ProtectedSettingsFromKeyVault)
			delete(rawMsg, key)
		case "provisionAfterExtensions":
			err = unpopulate(val, "ProvisionAfterExtensions", &v.ProvisionAfterExtensions)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &v.Publisher)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &v.Settings)
			delete(rawMsg, key)
		case "suppressFailures":
			err = unpopulate(val, "SuppressFailures", &v.SuppressFailures)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &v.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionUpdate.
func (v VirtualMachineExtensionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionUpdate.
func (v *VirtualMachineExtensionUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionUpdateProperties.
func (v VirtualMachineExtensionUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoUpgradeMinorVersion", v.AutoUpgradeMinorVersion)
	populate(objectMap, "enableAutomaticUpgrade", v.EnableAutomaticUpgrade)
	populate(objectMap, "forceUpdateTag", v.ForceUpdateTag)
	populateAny(objectMap, "protectedSettings", v.ProtectedSettings)
	populate(objectMap, "protectedSettingsFromKeyVault", v.ProtectedSettingsFromKeyVault)
	populate(objectMap, "publisher", v.Publisher)
	populateAny(objectMap, "settings", v.Settings)
	populate(objectMap, "suppressFailures", v.SuppressFailures)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "typeHandlerVersion", v.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionUpdateProperties.
func (v *VirtualMachineExtensionUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoUpgradeMinorVersion":
			err = unpopulate(val, "AutoUpgradeMinorVersion", &v.AutoUpgradeMinorVersion)
			delete(rawMsg, key)
		case "enableAutomaticUpgrade":
			err = unpopulate(val, "EnableAutomaticUpgrade", &v.EnableAutomaticUpgrade)
			delete(rawMsg, key)
		case "forceUpdateTag":
			err = unpopulate(val, "ForceUpdateTag", &v.ForceUpdateTag)
			delete(rawMsg, key)
		case "protectedSettings":
			err = unpopulate(val, "ProtectedSettings", &v.ProtectedSettings)
			delete(rawMsg, key)
		case "protectedSettingsFromKeyVault":
			err = unpopulate(val, "ProtectedSettingsFromKeyVault", &v.ProtectedSettingsFromKeyVault)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &v.Publisher)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &v.Settings)
			delete(rawMsg, key)
		case "suppressFailures":
			err = unpopulate(val, "SuppressFailures", &v.SuppressFailures)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &v.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineExtensionsListResult.
func (v VirtualMachineExtensionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineExtensionsListResult.
func (v *VirtualMachineExtensionsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineHealthStatus.
func (v VirtualMachineHealthStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", v.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineHealthStatus.
func (v *VirtualMachineHealthStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineIPTag.
func (v VirtualMachineIPTag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipTagType", v.IPTagType)
	populate(objectMap, "tag", v.Tag)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineIPTag.
func (v *VirtualMachineIPTag) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipTagType":
			err = unpopulate(val, "IPTagType", &v.IPTagType)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &v.Tag)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineIdentity.
func (v VirtualMachineIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", v.PrincipalID)
	populate(objectMap, "tenantId", v.TenantID)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "userAssignedIdentities", v.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineIdentity.
func (v *VirtualMachineIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &v.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &v.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &v.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineImage.
func (v VirtualMachineImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineImage.
func (v *VirtualMachineImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineImageFeature.
func (v VirtualMachineImageFeature) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineImageFeature.
func (v *VirtualMachineImageFeature) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineImageProperties.
func (v VirtualMachineImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "architecture", v.Architecture)
	populate(objectMap, "automaticOSUpgradeProperties", v.AutomaticOSUpgradeProperties)
	populate(objectMap, "dataDiskImages", v.DataDiskImages)
	populate(objectMap, "disallowed", v.Disallowed)
	populate(objectMap, "features", v.Features)
	populate(objectMap, "hyperVGeneration", v.HyperVGeneration)
	populate(objectMap, "imageDeprecationStatus", v.ImageDeprecationStatus)
	populate(objectMap, "osDiskImage", v.OSDiskImage)
	populate(objectMap, "plan", v.Plan)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineImageProperties.
func (v *VirtualMachineImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "architecture":
			err = unpopulate(val, "Architecture", &v.Architecture)
			delete(rawMsg, key)
		case "automaticOSUpgradeProperties":
			err = unpopulate(val, "AutomaticOSUpgradeProperties", &v.AutomaticOSUpgradeProperties)
			delete(rawMsg, key)
		case "dataDiskImages":
			err = unpopulate(val, "DataDiskImages", &v.DataDiskImages)
			delete(rawMsg, key)
		case "disallowed":
			err = unpopulate(val, "Disallowed", &v.Disallowed)
			delete(rawMsg, key)
		case "features":
			err = unpopulate(val, "Features", &v.Features)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &v.HyperVGeneration)
			delete(rawMsg, key)
		case "imageDeprecationStatus":
			err = unpopulate(val, "ImageDeprecationStatus", &v.ImageDeprecationStatus)
			delete(rawMsg, key)
		case "osDiskImage":
			err = unpopulate(val, "OSDiskImage", &v.OSDiskImage)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &v.Plan)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineImageResource.
func (v VirtualMachineImageResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineImageResource.
func (v *VirtualMachineImageResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineInstallPatchesParameters.
func (v VirtualMachineInstallPatchesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linuxParameters", v.LinuxParameters)
	populate(objectMap, "maximumDuration", v.MaximumDuration)
	populate(objectMap, "rebootSetting", v.RebootSetting)
	populate(objectMap, "windowsParameters", v.WindowsParameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineInstallPatchesParameters.
func (v *VirtualMachineInstallPatchesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linuxParameters":
			err = unpopulate(val, "LinuxParameters", &v.LinuxParameters)
			delete(rawMsg, key)
		case "maximumDuration":
			err = unpopulate(val, "MaximumDuration", &v.MaximumDuration)
			delete(rawMsg, key)
		case "rebootSetting":
			err = unpopulate(val, "RebootSetting", &v.RebootSetting)
			delete(rawMsg, key)
		case "windowsParameters":
			err = unpopulate(val, "WindowsParameters", &v.WindowsParameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineInstallPatchesResult.
func (v VirtualMachineInstallPatchesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", v.Error)
	populate(objectMap, "excludedPatchCount", v.ExcludedPatchCount)
	populate(objectMap, "failedPatchCount", v.FailedPatchCount)
	populate(objectMap, "installationActivityId", v.InstallationActivityID)
	populate(objectMap, "installedPatchCount", v.InstalledPatchCount)
	populate(objectMap, "maintenanceWindowExceeded", v.MaintenanceWindowExceeded)
	populate(objectMap, "notSelectedPatchCount", v.NotSelectedPatchCount)
	populate(objectMap, "patches", v.Patches)
	populate(objectMap, "pendingPatchCount", v.PendingPatchCount)
	populate(objectMap, "rebootStatus", v.RebootStatus)
	populateDateTimeRFC3339(objectMap, "startDateTime", v.StartDateTime)
	populate(objectMap, "status", v.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineInstallPatchesResult.
func (v *VirtualMachineInstallPatchesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &v.Error)
			delete(rawMsg, key)
		case "excludedPatchCount":
			err = unpopulate(val, "ExcludedPatchCount", &v.ExcludedPatchCount)
			delete(rawMsg, key)
		case "failedPatchCount":
			err = unpopulate(val, "FailedPatchCount", &v.FailedPatchCount)
			delete(rawMsg, key)
		case "installationActivityId":
			err = unpopulate(val, "InstallationActivityID", &v.InstallationActivityID)
			delete(rawMsg, key)
		case "installedPatchCount":
			err = unpopulate(val, "InstalledPatchCount", &v.InstalledPatchCount)
			delete(rawMsg, key)
		case "maintenanceWindowExceeded":
			err = unpopulate(val, "MaintenanceWindowExceeded", &v.MaintenanceWindowExceeded)
			delete(rawMsg, key)
		case "notSelectedPatchCount":
			err = unpopulate(val, "NotSelectedPatchCount", &v.NotSelectedPatchCount)
			delete(rawMsg, key)
		case "patches":
			err = unpopulate(val, "Patches", &v.Patches)
			delete(rawMsg, key)
		case "pendingPatchCount":
			err = unpopulate(val, "PendingPatchCount", &v.PendingPatchCount)
			delete(rawMsg, key)
		case "rebootStatus":
			err = unpopulate(val, "RebootStatus", &v.RebootStatus)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateDateTimeRFC3339(val, "StartDateTime", &v.StartDateTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineInstanceView.
func (v VirtualMachineInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignedHost", v.AssignedHost)
	populate(objectMap, "bootDiagnostics", v.BootDiagnostics)
	populate(objectMap, "computerName", v.ComputerName)
	populate(objectMap, "disks", v.Disks)
	populate(objectMap, "extensions", v.Extensions)
	populate(objectMap, "hyperVGeneration", v.HyperVGeneration)
	populate(objectMap, "isVMInStandbyPool", v.IsVMInStandbyPool)
	populate(objectMap, "maintenanceRedeployStatus", v.MaintenanceRedeployStatus)
	populate(objectMap, "osName", v.OSName)
	populate(objectMap, "osVersion", v.OSVersion)
	populate(objectMap, "patchStatus", v.PatchStatus)
	populate(objectMap, "platformFaultDomain", v.PlatformFaultDomain)
	populate(objectMap, "platformUpdateDomain", v.PlatformUpdateDomain)
	populate(objectMap, "rdpThumbPrint", v.RdpThumbPrint)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "vmAgent", v.VMAgent)
	populate(objectMap, "vmHealth", v.VMHealth)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineInstanceView.
func (v *VirtualMachineInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignedHost":
			err = unpopulate(val, "AssignedHost", &v.AssignedHost)
			delete(rawMsg, key)
		case "bootDiagnostics":
			err = unpopulate(val, "BootDiagnostics", &v.BootDiagnostics)
			delete(rawMsg, key)
		case "computerName":
			err = unpopulate(val, "ComputerName", &v.ComputerName)
			delete(rawMsg, key)
		case "disks":
			err = unpopulate(val, "Disks", &v.Disks)
			delete(rawMsg, key)
		case "extensions":
			err = unpopulate(val, "Extensions", &v.Extensions)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &v.HyperVGeneration)
			delete(rawMsg, key)
		case "isVMInStandbyPool":
			err = unpopulate(val, "IsVMInStandbyPool", &v.IsVMInStandbyPool)
			delete(rawMsg, key)
		case "maintenanceRedeployStatus":
			err = unpopulate(val, "MaintenanceRedeployStatus", &v.MaintenanceRedeployStatus)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &v.OSName)
			delete(rawMsg, key)
		case "osVersion":
			err = unpopulate(val, "OSVersion", &v.OSVersion)
			delete(rawMsg, key)
		case "patchStatus":
			err = unpopulate(val, "PatchStatus", &v.PatchStatus)
			delete(rawMsg, key)
		case "platformFaultDomain":
			err = unpopulate(val, "PlatformFaultDomain", &v.PlatformFaultDomain)
			delete(rawMsg, key)
		case "platformUpdateDomain":
			err = unpopulate(val, "PlatformUpdateDomain", &v.PlatformUpdateDomain)
			delete(rawMsg, key)
		case "rdpThumbPrint":
			err = unpopulate(val, "RdpThumbPrint", &v.RdpThumbPrint)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		case "vmAgent":
			err = unpopulate(val, "VMAgent", &v.VMAgent)
			delete(rawMsg, key)
		case "vmHealth":
			err = unpopulate(val, "VMHealth", &v.VMHealth)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineListResult.
func (v VirtualMachineListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineListResult.
func (v *VirtualMachineListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineNetworkInterfaceConfiguration.
func (v VirtualMachineNetworkInterfaceConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineNetworkInterfaceConfiguration.
func (v *VirtualMachineNetworkInterfaceConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineNetworkInterfaceConfigurationProperties.
func (v VirtualMachineNetworkInterfaceConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auxiliaryMode", v.AuxiliaryMode)
	populate(objectMap, "auxiliarySku", v.AuxiliarySKU)
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "disableTcpStateTracking", v.DisableTCPStateTracking)
	populate(objectMap, "dscpConfiguration", v.DscpConfiguration)
	populate(objectMap, "enableAcceleratedNetworking", v.EnableAcceleratedNetworking)
	populate(objectMap, "enableFpga", v.EnableFpga)
	populate(objectMap, "enableIPForwarding", v.EnableIPForwarding)
	populate(objectMap, "ipConfigurations", v.IPConfigurations)
	populate(objectMap, "networkSecurityGroup", v.NetworkSecurityGroup)
	populate(objectMap, "primary", v.Primary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineNetworkInterfaceConfigurationProperties.
func (v *VirtualMachineNetworkInterfaceConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auxiliaryMode":
			err = unpopulate(val, "AuxiliaryMode", &v.AuxiliaryMode)
			delete(rawMsg, key)
		case "auxiliarySku":
			err = unpopulate(val, "AuxiliarySKU", &v.AuxiliarySKU)
			delete(rawMsg, key)
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &v.DNSSettings)
			delete(rawMsg, key)
		case "deleteOption":
			err = unpopulate(val, "DeleteOption", &v.DeleteOption)
			delete(rawMsg, key)
		case "disableTcpStateTracking":
			err = unpopulate(val, "DisableTCPStateTracking", &v.DisableTCPStateTracking)
			delete(rawMsg, key)
		case "dscpConfiguration":
			err = unpopulate(val, "DscpConfiguration", &v.DscpConfiguration)
			delete(rawMsg, key)
		case "enableAcceleratedNetworking":
			err = unpopulate(val, "EnableAcceleratedNetworking", &v.EnableAcceleratedNetworking)
			delete(rawMsg, key)
		case "enableFpga":
			err = unpopulate(val, "EnableFpga", &v.EnableFpga)
			delete(rawMsg, key)
		case "enableIPForwarding":
			err = unpopulate(val, "EnableIPForwarding", &v.EnableIPForwarding)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &v.IPConfigurations)
			delete(rawMsg, key)
		case "networkSecurityGroup":
			err = unpopulate(val, "NetworkSecurityGroup", &v.NetworkSecurityGroup)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &v.Primary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineNetworkInterfaceDNSSettingsConfiguration.
func (v VirtualMachineNetworkInterfaceDNSSettingsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsServers", v.DNSServers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineNetworkInterfaceDNSSettingsConfiguration.
func (v *VirtualMachineNetworkInterfaceDNSSettingsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &v.DNSServers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineNetworkInterfaceIPConfiguration.
func (v VirtualMachineNetworkInterfaceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineNetworkInterfaceIPConfiguration.
func (v *VirtualMachineNetworkInterfaceIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineNetworkInterfaceIPConfigurationProperties.
func (v VirtualMachineNetworkInterfaceIPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationGatewayBackendAddressPools", v.ApplicationGatewayBackendAddressPools)
	populate(objectMap, "applicationSecurityGroups", v.ApplicationSecurityGroups)
	populate(objectMap, "loadBalancerBackendAddressPools", v.LoadBalancerBackendAddressPools)
	populate(objectMap, "primary", v.Primary)
	populate(objectMap, "privateIPAddressVersion", v.PrivateIPAddressVersion)
	populate(objectMap, "publicIPAddressConfiguration", v.PublicIPAddressConfiguration)
	populate(objectMap, "subnet", v.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineNetworkInterfaceIPConfigurationProperties.
func (v *VirtualMachineNetworkInterfaceIPConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationGatewayBackendAddressPools":
			err = unpopulate(val, "ApplicationGatewayBackendAddressPools", &v.ApplicationGatewayBackendAddressPools)
			delete(rawMsg, key)
		case "applicationSecurityGroups":
			err = unpopulate(val, "ApplicationSecurityGroups", &v.ApplicationSecurityGroups)
			delete(rawMsg, key)
		case "loadBalancerBackendAddressPools":
			err = unpopulate(val, "LoadBalancerBackendAddressPools", &v.LoadBalancerBackendAddressPools)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &v.Primary)
			delete(rawMsg, key)
		case "privateIPAddressVersion":
			err = unpopulate(val, "PrivateIPAddressVersion", &v.PrivateIPAddressVersion)
			delete(rawMsg, key)
		case "publicIPAddressConfiguration":
			err = unpopulate(val, "PublicIPAddressConfiguration", &v.PublicIPAddressConfiguration)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &v.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachinePatchStatus.
func (v VirtualMachinePatchStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availablePatchSummary", v.AvailablePatchSummary)
	populate(objectMap, "configurationStatuses", v.ConfigurationStatuses)
	populate(objectMap, "lastPatchInstallationSummary", v.LastPatchInstallationSummary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachinePatchStatus.
func (v *VirtualMachinePatchStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availablePatchSummary":
			err = unpopulate(val, "AvailablePatchSummary", &v.AvailablePatchSummary)
			delete(rawMsg, key)
		case "configurationStatuses":
			err = unpopulate(val, "ConfigurationStatuses", &v.ConfigurationStatuses)
			delete(rawMsg, key)
		case "lastPatchInstallationSummary":
			err = unpopulate(val, "LastPatchInstallationSummary", &v.LastPatchInstallationSummary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineProperties.
func (v VirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalCapabilities", v.AdditionalCapabilities)
	populate(objectMap, "applicationProfile", v.ApplicationProfile)
	populate(objectMap, "availabilitySet", v.AvailabilitySet)
	populate(objectMap, "billingProfile", v.BillingProfile)
	populate(objectMap, "capacityReservation", v.CapacityReservation)
	populate(objectMap, "diagnosticsProfile", v.DiagnosticsProfile)
	populate(objectMap, "evictionPolicy", v.EvictionPolicy)
	populate(objectMap, "extensionsTimeBudget", v.ExtensionsTimeBudget)
	populate(objectMap, "hardwareProfile", v.HardwareProfile)
	populate(objectMap, "host", v.Host)
	populate(objectMap, "hostGroup", v.HostGroup)
	populate(objectMap, "instanceView", v.InstanceView)
	populate(objectMap, "licenseType", v.LicenseType)
	populate(objectMap, "networkProfile", v.NetworkProfile)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "platformFaultDomain", v.PlatformFaultDomain)
	populate(objectMap, "priority", v.Priority)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "proximityPlacementGroup", v.ProximityPlacementGroup)
	populate(objectMap, "scheduledEventsProfile", v.ScheduledEventsProfile)
	populate(objectMap, "securityProfile", v.SecurityProfile)
	populate(objectMap, "storageProfile", v.StorageProfile)
	populateDateTimeRFC3339(objectMap, "timeCreated", v.TimeCreated)
	populate(objectMap, "userData", v.UserData)
	populate(objectMap, "vmId", v.VMID)
	populate(objectMap, "virtualMachineScaleSet", v.VirtualMachineScaleSet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineProperties.
func (v *VirtualMachineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalCapabilities":
			err = unpopulate(val, "AdditionalCapabilities", &v.AdditionalCapabilities)
			delete(rawMsg, key)
		case "applicationProfile":
			err = unpopulate(val, "ApplicationProfile", &v.ApplicationProfile)
			delete(rawMsg, key)
		case "availabilitySet":
			err = unpopulate(val, "AvailabilitySet", &v.AvailabilitySet)
			delete(rawMsg, key)
		case "billingProfile":
			err = unpopulate(val, "BillingProfile", &v.BillingProfile)
			delete(rawMsg, key)
		case "capacityReservation":
			err = unpopulate(val, "CapacityReservation", &v.CapacityReservation)
			delete(rawMsg, key)
		case "diagnosticsProfile":
			err = unpopulate(val, "DiagnosticsProfile", &v.DiagnosticsProfile)
			delete(rawMsg, key)
		case "evictionPolicy":
			err = unpopulate(val, "EvictionPolicy", &v.EvictionPolicy)
			delete(rawMsg, key)
		case "extensionsTimeBudget":
			err = unpopulate(val, "ExtensionsTimeBudget", &v.ExtensionsTimeBudget)
			delete(rawMsg, key)
		case "hardwareProfile":
			err = unpopulate(val, "HardwareProfile", &v.HardwareProfile)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &v.Host)
			delete(rawMsg, key)
		case "hostGroup":
			err = unpopulate(val, "HostGroup", &v.HostGroup)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &v.InstanceView)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &v.NetworkProfile)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "platformFaultDomain":
			err = unpopulate(val, "PlatformFaultDomain", &v.PlatformFaultDomain)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &v.Priority)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "proximityPlacementGroup":
			err = unpopulate(val, "ProximityPlacementGroup", &v.ProximityPlacementGroup)
			delete(rawMsg, key)
		case "scheduledEventsProfile":
			err = unpopulate(val, "ScheduledEventsProfile", &v.ScheduledEventsProfile)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &v.SecurityProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &v.StorageProfile)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateDateTimeRFC3339(val, "TimeCreated", &v.TimeCreated)
			delete(rawMsg, key)
		case "userData":
			err = unpopulate(val, "UserData", &v.UserData)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &v.VMID)
			delete(rawMsg, key)
		case "virtualMachineScaleSet":
			err = unpopulate(val, "VirtualMachineScaleSet", &v.VirtualMachineScaleSet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachinePublicIPAddressConfiguration.
func (v VirtualMachinePublicIPAddressConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "sku", v.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachinePublicIPAddressConfiguration.
func (v *VirtualMachinePublicIPAddressConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &v.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachinePublicIPAddressConfigurationProperties.
func (v VirtualMachinePublicIPAddressConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "ipTags", v.IPTags)
	populate(objectMap, "idleTimeoutInMinutes", v.IdleTimeoutInMinutes)
	populate(objectMap, "publicIPAddressVersion", v.PublicIPAddressVersion)
	populate(objectMap, "publicIPAllocationMethod", v.PublicIPAllocationMethod)
	populate(objectMap, "publicIPPrefix", v.PublicIPPrefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachinePublicIPAddressConfigurationProperties.
func (v *VirtualMachinePublicIPAddressConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &v.DNSSettings)
			delete(rawMsg, key)
		case "deleteOption":
			err = unpopulate(val, "DeleteOption", &v.DeleteOption)
			delete(rawMsg, key)
		case "ipTags":
			err = unpopulate(val, "IPTags", &v.IPTags)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &v.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "publicIPAddressVersion":
			err = unpopulate(val, "PublicIPAddressVersion", &v.PublicIPAddressVersion)
			delete(rawMsg, key)
		case "publicIPAllocationMethod":
			err = unpopulate(val, "PublicIPAllocationMethod", &v.PublicIPAllocationMethod)
			delete(rawMsg, key)
		case "publicIPPrefix":
			err = unpopulate(val, "PublicIPPrefix", &v.PublicIPPrefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachinePublicIPAddressDNSSettingsConfiguration.
func (v VirtualMachinePublicIPAddressDNSSettingsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainNameLabel", v.DomainNameLabel)
	populate(objectMap, "domainNameLabelScope", v.DomainNameLabelScope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachinePublicIPAddressDNSSettingsConfiguration.
func (v *VirtualMachinePublicIPAddressDNSSettingsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainNameLabel":
			err = unpopulate(val, "DomainNameLabel", &v.DomainNameLabel)
			delete(rawMsg, key)
		case "domainNameLabelScope":
			err = unpopulate(val, "DomainNameLabelScope", &v.DomainNameLabelScope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineReimageParameters.
func (v VirtualMachineReimageParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exactVersion", v.ExactVersion)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "tempDisk", v.TempDisk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineReimageParameters.
func (v *VirtualMachineReimageParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exactVersion":
			err = unpopulate(val, "ExactVersion", &v.ExactVersion)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "tempDisk":
			err = unpopulate(val, "TempDisk", &v.TempDisk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineRunCommand.
func (v VirtualMachineRunCommand) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineRunCommand.
func (v *VirtualMachineRunCommand) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineRunCommandInstanceView.
func (v VirtualMachineRunCommandInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", v.EndTime)
	populate(objectMap, "error", v.Error)
	populate(objectMap, "executionMessage", v.ExecutionMessage)
	populate(objectMap, "executionState", v.ExecutionState)
	populate(objectMap, "exitCode", v.ExitCode)
	populate(objectMap, "output", v.Output)
	populateDateTimeRFC3339(objectMap, "startTime", v.StartTime)
	populate(objectMap, "statuses", v.Statuses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineRunCommandInstanceView.
func (v *VirtualMachineRunCommandInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &v.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &v.Error)
			delete(rawMsg, key)
		case "executionMessage":
			err = unpopulate(val, "ExecutionMessage", &v.ExecutionMessage)
			delete(rawMsg, key)
		case "executionState":
			err = unpopulate(val, "ExecutionState", &v.ExecutionState)
			delete(rawMsg, key)
		case "exitCode":
			err = unpopulate(val, "ExitCode", &v.ExitCode)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &v.Output)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &v.StartTime)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineRunCommandProperties.
func (v VirtualMachineRunCommandProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asyncExecution", v.AsyncExecution)
	populate(objectMap, "errorBlobManagedIdentity", v.ErrorBlobManagedIdentity)
	populate(objectMap, "errorBlobUri", v.ErrorBlobURI)
	populate(objectMap, "instanceView", v.InstanceView)
	populate(objectMap, "outputBlobManagedIdentity", v.OutputBlobManagedIdentity)
	populate(objectMap, "outputBlobUri", v.OutputBlobURI)
	populate(objectMap, "parameters", v.Parameters)
	populate(objectMap, "protectedParameters", v.ProtectedParameters)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "runAsPassword", v.RunAsPassword)
	populate(objectMap, "runAsUser", v.RunAsUser)
	populate(objectMap, "source", v.Source)
	populate(objectMap, "timeoutInSeconds", v.TimeoutInSeconds)
	populate(objectMap, "treatFailureAsDeploymentFailure", v.TreatFailureAsDeploymentFailure)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineRunCommandProperties.
func (v *VirtualMachineRunCommandProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asyncExecution":
			err = unpopulate(val, "AsyncExecution", &v.AsyncExecution)
			delete(rawMsg, key)
		case "errorBlobManagedIdentity":
			err = unpopulate(val, "ErrorBlobManagedIdentity", &v.ErrorBlobManagedIdentity)
			delete(rawMsg, key)
		case "errorBlobUri":
			err = unpopulate(val, "ErrorBlobURI", &v.ErrorBlobURI)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &v.InstanceView)
			delete(rawMsg, key)
		case "outputBlobManagedIdentity":
			err = unpopulate(val, "OutputBlobManagedIdentity", &v.OutputBlobManagedIdentity)
			delete(rawMsg, key)
		case "outputBlobUri":
			err = unpopulate(val, "OutputBlobURI", &v.OutputBlobURI)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &v.Parameters)
			delete(rawMsg, key)
		case "protectedParameters":
			err = unpopulate(val, "ProtectedParameters", &v.ProtectedParameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "runAsPassword":
			err = unpopulate(val, "RunAsPassword", &v.RunAsPassword)
			delete(rawMsg, key)
		case "runAsUser":
			err = unpopulate(val, "RunAsUser", &v.RunAsUser)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &v.Source)
			delete(rawMsg, key)
		case "timeoutInSeconds":
			err = unpopulate(val, "TimeoutInSeconds", &v.TimeoutInSeconds)
			delete(rawMsg, key)
		case "treatFailureAsDeploymentFailure":
			err = unpopulate(val, "TreatFailureAsDeploymentFailure", &v.TreatFailureAsDeploymentFailure)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineRunCommandScriptSource.
func (v VirtualMachineRunCommandScriptSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "commandId", v.CommandID)
	populate(objectMap, "script", v.Script)
	populate(objectMap, "scriptUri", v.ScriptURI)
	populate(objectMap, "scriptUriManagedIdentity", v.ScriptURIManagedIdentity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineRunCommandScriptSource.
func (v *VirtualMachineRunCommandScriptSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commandId":
			err = unpopulate(val, "CommandID", &v.CommandID)
			delete(rawMsg, key)
		case "script":
			err = unpopulate(val, "Script", &v.Script)
			delete(rawMsg, key)
		case "scriptUri":
			err = unpopulate(val, "ScriptURI", &v.ScriptURI)
			delete(rawMsg, key)
		case "scriptUriManagedIdentity":
			err = unpopulate(val, "ScriptURIManagedIdentity", &v.ScriptURIManagedIdentity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineRunCommandUpdate.
func (v VirtualMachineRunCommandUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineRunCommandUpdate.
func (v *VirtualMachineRunCommandUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineRunCommandsListResult.
func (v VirtualMachineRunCommandsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineRunCommandsListResult.
func (v *VirtualMachineRunCommandsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSet.
func (v VirtualMachineScaleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "sku", v.SKU)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "zones", v.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSet.
func (v *VirtualMachineScaleSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &v.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &v.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &v.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &v.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetDataDisk.
func (v VirtualMachineScaleSetDataDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caching", v.Caching)
	populate(objectMap, "createOption", v.CreateOption)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "diskIOPSReadWrite", v.DiskIOPSReadWrite)
	populate(objectMap, "diskMBpsReadWrite", v.DiskMBpsReadWrite)
	populate(objectMap, "diskSizeGB", v.DiskSizeGB)
	populate(objectMap, "lun", v.Lun)
	populate(objectMap, "managedDisk", v.ManagedDisk)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "writeAcceleratorEnabled", v.WriteAcceleratorEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetDataDisk.
func (v *VirtualMachineScaleSetDataDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caching":
			err = unpopulate(val, "Caching", &v.Caching)
			delete(rawMsg, key)
		case "createOption":
			err = unpopulate(val, "CreateOption", &v.CreateOption)
			delete(rawMsg, key)
		case "deleteOption":
			err = unpopulate(val, "DeleteOption", &v.DeleteOption)
			delete(rawMsg, key)
		case "diskIOPSReadWrite":
			err = unpopulate(val, "DiskIOPSReadWrite", &v.DiskIOPSReadWrite)
			delete(rawMsg, key)
		case "diskMBpsReadWrite":
			err = unpopulate(val, "DiskMBpsReadWrite", &v.DiskMBpsReadWrite)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &v.DiskSizeGB)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &v.Lun)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &v.ManagedDisk)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "writeAcceleratorEnabled":
			err = unpopulate(val, "WriteAcceleratorEnabled", &v.WriteAcceleratorEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetExtension.
func (v VirtualMachineScaleSetExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetExtension.
func (v *VirtualMachineScaleSetExtension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetExtensionListResult.
func (v VirtualMachineScaleSetExtensionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetExtensionListResult.
func (v *VirtualMachineScaleSetExtensionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetExtensionProfile.
func (v VirtualMachineScaleSetExtensionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extensions", v.Extensions)
	populate(objectMap, "extensionsTimeBudget", v.ExtensionsTimeBudget)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetExtensionProfile.
func (v *VirtualMachineScaleSetExtensionProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extensions":
			err = unpopulate(val, "Extensions", &v.Extensions)
			delete(rawMsg, key)
		case "extensionsTimeBudget":
			err = unpopulate(val, "ExtensionsTimeBudget", &v.ExtensionsTimeBudget)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetExtensionProperties.
func (v VirtualMachineScaleSetExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoUpgradeMinorVersion", v.AutoUpgradeMinorVersion)
	populate(objectMap, "enableAutomaticUpgrade", v.EnableAutomaticUpgrade)
	populate(objectMap, "forceUpdateTag", v.ForceUpdateTag)
	populateAny(objectMap, "protectedSettings", v.ProtectedSettings)
	populate(objectMap, "protectedSettingsFromKeyVault", v.ProtectedSettingsFromKeyVault)
	populate(objectMap, "provisionAfterExtensions", v.ProvisionAfterExtensions)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "publisher", v.Publisher)
	populateAny(objectMap, "settings", v.Settings)
	populate(objectMap, "suppressFailures", v.SuppressFailures)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "typeHandlerVersion", v.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetExtensionProperties.
func (v *VirtualMachineScaleSetExtensionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoUpgradeMinorVersion":
			err = unpopulate(val, "AutoUpgradeMinorVersion", &v.AutoUpgradeMinorVersion)
			delete(rawMsg, key)
		case "enableAutomaticUpgrade":
			err = unpopulate(val, "EnableAutomaticUpgrade", &v.EnableAutomaticUpgrade)
			delete(rawMsg, key)
		case "forceUpdateTag":
			err = unpopulate(val, "ForceUpdateTag", &v.ForceUpdateTag)
			delete(rawMsg, key)
		case "protectedSettings":
			err = unpopulate(val, "ProtectedSettings", &v.ProtectedSettings)
			delete(rawMsg, key)
		case "protectedSettingsFromKeyVault":
			err = unpopulate(val, "ProtectedSettingsFromKeyVault", &v.ProtectedSettingsFromKeyVault)
			delete(rawMsg, key)
		case "provisionAfterExtensions":
			err = unpopulate(val, "ProvisionAfterExtensions", &v.ProvisionAfterExtensions)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &v.Publisher)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &v.Settings)
			delete(rawMsg, key)
		case "suppressFailures":
			err = unpopulate(val, "SuppressFailures", &v.SuppressFailures)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &v.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetExtensionUpdate.
func (v VirtualMachineScaleSetExtensionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetExtensionUpdate.
func (v *VirtualMachineScaleSetExtensionUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetHardwareProfile.
func (v VirtualMachineScaleSetHardwareProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vmSizeProperties", v.VMSizeProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetHardwareProfile.
func (v *VirtualMachineScaleSetHardwareProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vmSizeProperties":
			err = unpopulate(val, "VMSizeProperties", &v.VMSizeProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetIPConfiguration.
func (v VirtualMachineScaleSetIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetIPConfiguration.
func (v *VirtualMachineScaleSetIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetIPConfigurationProperties.
func (v VirtualMachineScaleSetIPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationGatewayBackendAddressPools", v.ApplicationGatewayBackendAddressPools)
	populate(objectMap, "applicationSecurityGroups", v.ApplicationSecurityGroups)
	populate(objectMap, "loadBalancerBackendAddressPools", v.LoadBalancerBackendAddressPools)
	populate(objectMap, "loadBalancerInboundNatPools", v.LoadBalancerInboundNatPools)
	populate(objectMap, "primary", v.Primary)
	populate(objectMap, "privateIPAddressVersion", v.PrivateIPAddressVersion)
	populate(objectMap, "publicIPAddressConfiguration", v.PublicIPAddressConfiguration)
	populate(objectMap, "subnet", v.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetIPConfigurationProperties.
func (v *VirtualMachineScaleSetIPConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationGatewayBackendAddressPools":
			err = unpopulate(val, "ApplicationGatewayBackendAddressPools", &v.ApplicationGatewayBackendAddressPools)
			delete(rawMsg, key)
		case "applicationSecurityGroups":
			err = unpopulate(val, "ApplicationSecurityGroups", &v.ApplicationSecurityGroups)
			delete(rawMsg, key)
		case "loadBalancerBackendAddressPools":
			err = unpopulate(val, "LoadBalancerBackendAddressPools", &v.LoadBalancerBackendAddressPools)
			delete(rawMsg, key)
		case "loadBalancerInboundNatPools":
			err = unpopulate(val, "LoadBalancerInboundNatPools", &v.LoadBalancerInboundNatPools)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &v.Primary)
			delete(rawMsg, key)
		case "privateIPAddressVersion":
			err = unpopulate(val, "PrivateIPAddressVersion", &v.PrivateIPAddressVersion)
			delete(rawMsg, key)
		case "publicIPAddressConfiguration":
			err = unpopulate(val, "PublicIPAddressConfiguration", &v.PublicIPAddressConfiguration)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &v.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetIPTag.
func (v VirtualMachineScaleSetIPTag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipTagType", v.IPTagType)
	populate(objectMap, "tag", v.Tag)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetIPTag.
func (v *VirtualMachineScaleSetIPTag) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipTagType":
			err = unpopulate(val, "IPTagType", &v.IPTagType)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &v.Tag)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetIdentity.
func (v VirtualMachineScaleSetIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", v.PrincipalID)
	populate(objectMap, "tenantId", v.TenantID)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "userAssignedIdentities", v.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetIdentity.
func (v *VirtualMachineScaleSetIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &v.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &v.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &v.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetInstanceView.
func (v VirtualMachineScaleSetInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extensions", v.Extensions)
	populate(objectMap, "orchestrationServices", v.OrchestrationServices)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "virtualMachine", v.VirtualMachine)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetInstanceView.
func (v *VirtualMachineScaleSetInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extensions":
			err = unpopulate(val, "Extensions", &v.Extensions)
			delete(rawMsg, key)
		case "orchestrationServices":
			err = unpopulate(val, "OrchestrationServices", &v.OrchestrationServices)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		case "virtualMachine":
			err = unpopulate(val, "VirtualMachine", &v.VirtualMachine)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetInstanceViewStatusesSummary.
func (v VirtualMachineScaleSetInstanceViewStatusesSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "statusesSummary", v.StatusesSummary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetInstanceViewStatusesSummary.
func (v *VirtualMachineScaleSetInstanceViewStatusesSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "statusesSummary":
			err = unpopulate(val, "StatusesSummary", &v.StatusesSummary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetListOSUpgradeHistory.
func (v VirtualMachineScaleSetListOSUpgradeHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetListOSUpgradeHistory.
func (v *VirtualMachineScaleSetListOSUpgradeHistory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetListResult.
func (v VirtualMachineScaleSetListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetListResult.
func (v *VirtualMachineScaleSetListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetListSKUsResult.
func (v VirtualMachineScaleSetListSKUsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetListSKUsResult.
func (v *VirtualMachineScaleSetListSKUsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetListWithLinkResult.
func (v VirtualMachineScaleSetListWithLinkResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetListWithLinkResult.
func (v *VirtualMachineScaleSetListWithLinkResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetManagedDiskParameters.
func (v VirtualMachineScaleSetManagedDiskParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSet", v.DiskEncryptionSet)
	populate(objectMap, "securityProfile", v.SecurityProfile)
	populate(objectMap, "storageAccountType", v.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetManagedDiskParameters.
func (v *VirtualMachineScaleSetManagedDiskParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSet":
			err = unpopulate(val, "DiskEncryptionSet", &v.DiskEncryptionSet)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &v.SecurityProfile)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &v.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetNetworkConfiguration.
func (v VirtualMachineScaleSetNetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetNetworkConfiguration.
func (v *VirtualMachineScaleSetNetworkConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetNetworkConfigurationDNSSettings.
func (v VirtualMachineScaleSetNetworkConfigurationDNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsServers", v.DNSServers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetNetworkConfigurationDNSSettings.
func (v *VirtualMachineScaleSetNetworkConfigurationDNSSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &v.DNSServers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetNetworkConfigurationProperties.
func (v VirtualMachineScaleSetNetworkConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auxiliaryMode", v.AuxiliaryMode)
	populate(objectMap, "auxiliarySku", v.AuxiliarySKU)
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "disableTcpStateTracking", v.DisableTCPStateTracking)
	populate(objectMap, "enableAcceleratedNetworking", v.EnableAcceleratedNetworking)
	populate(objectMap, "enableFpga", v.EnableFpga)
	populate(objectMap, "enableIPForwarding", v.EnableIPForwarding)
	populate(objectMap, "ipConfigurations", v.IPConfigurations)
	populate(objectMap, "networkSecurityGroup", v.NetworkSecurityGroup)
	populate(objectMap, "primary", v.Primary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetNetworkConfigurationProperties.
func (v *VirtualMachineScaleSetNetworkConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auxiliaryMode":
			err = unpopulate(val, "AuxiliaryMode", &v.AuxiliaryMode)
			delete(rawMsg, key)
		case "auxiliarySku":
			err = unpopulate(val, "AuxiliarySKU", &v.AuxiliarySKU)
			delete(rawMsg, key)
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &v.DNSSettings)
			delete(rawMsg, key)
		case "deleteOption":
			err = unpopulate(val, "DeleteOption", &v.DeleteOption)
			delete(rawMsg, key)
		case "disableTcpStateTracking":
			err = unpopulate(val, "DisableTCPStateTracking", &v.DisableTCPStateTracking)
			delete(rawMsg, key)
		case "enableAcceleratedNetworking":
			err = unpopulate(val, "EnableAcceleratedNetworking", &v.EnableAcceleratedNetworking)
			delete(rawMsg, key)
		case "enableFpga":
			err = unpopulate(val, "EnableFpga", &v.EnableFpga)
			delete(rawMsg, key)
		case "enableIPForwarding":
			err = unpopulate(val, "EnableIPForwarding", &v.EnableIPForwarding)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &v.IPConfigurations)
			delete(rawMsg, key)
		case "networkSecurityGroup":
			err = unpopulate(val, "NetworkSecurityGroup", &v.NetworkSecurityGroup)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &v.Primary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetNetworkProfile.
func (v VirtualMachineScaleSetNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "healthProbe", v.HealthProbe)
	populate(objectMap, "networkApiVersion", v.NetworkAPIVersion)
	populate(objectMap, "networkInterfaceConfigurations", v.NetworkInterfaceConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetNetworkProfile.
func (v *VirtualMachineScaleSetNetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthProbe":
			err = unpopulate(val, "HealthProbe", &v.HealthProbe)
			delete(rawMsg, key)
		case "networkApiVersion":
			err = unpopulate(val, "NetworkAPIVersion", &v.NetworkAPIVersion)
			delete(rawMsg, key)
		case "networkInterfaceConfigurations":
			err = unpopulate(val, "NetworkInterfaceConfigurations", &v.NetworkInterfaceConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetOSDisk.
func (v VirtualMachineScaleSetOSDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caching", v.Caching)
	populate(objectMap, "createOption", v.CreateOption)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "diffDiskSettings", v.DiffDiskSettings)
	populate(objectMap, "diskSizeGB", v.DiskSizeGB)
	populate(objectMap, "image", v.Image)
	populate(objectMap, "managedDisk", v.ManagedDisk)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "vhdContainers", v.VhdContainers)
	populate(objectMap, "writeAcceleratorEnabled", v.WriteAcceleratorEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetOSDisk.
func (v *VirtualMachineScaleSetOSDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caching":
			err = unpopulate(val, "Caching", &v.Caching)
			delete(rawMsg, key)
		case "createOption":
			err = unpopulate(val, "CreateOption", &v.CreateOption)
			delete(rawMsg, key)
		case "deleteOption":
			err = unpopulate(val, "DeleteOption", &v.DeleteOption)
			delete(rawMsg, key)
		case "diffDiskSettings":
			err = unpopulate(val, "DiffDiskSettings", &v.DiffDiskSettings)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &v.DiskSizeGB)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &v.Image)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &v.ManagedDisk)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "vhdContainers":
			err = unpopulate(val, "VhdContainers", &v.VhdContainers)
			delete(rawMsg, key)
		case "writeAcceleratorEnabled":
			err = unpopulate(val, "WriteAcceleratorEnabled", &v.WriteAcceleratorEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetOSProfile.
func (v VirtualMachineScaleSetOSProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminPassword", v.AdminPassword)
	populate(objectMap, "adminUsername", v.AdminUsername)
	populate(objectMap, "allowExtensionOperations", v.AllowExtensionOperations)
	populate(objectMap, "computerNamePrefix", v.ComputerNamePrefix)
	populate(objectMap, "customData", v.CustomData)
	populate(objectMap, "linuxConfiguration", v.LinuxConfiguration)
	populate(objectMap, "requireGuestProvisionSignal", v.RequireGuestProvisionSignal)
	populate(objectMap, "secrets", v.Secrets)
	populate(objectMap, "windowsConfiguration", v.WindowsConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetOSProfile.
func (v *VirtualMachineScaleSetOSProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminPassword":
			err = unpopulate(val, "AdminPassword", &v.AdminPassword)
			delete(rawMsg, key)
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &v.AdminUsername)
			delete(rawMsg, key)
		case "allowExtensionOperations":
			err = unpopulate(val, "AllowExtensionOperations", &v.AllowExtensionOperations)
			delete(rawMsg, key)
		case "computerNamePrefix":
			err = unpopulate(val, "ComputerNamePrefix", &v.ComputerNamePrefix)
			delete(rawMsg, key)
		case "customData":
			err = unpopulate(val, "CustomData", &v.CustomData)
			delete(rawMsg, key)
		case "linuxConfiguration":
			err = unpopulate(val, "LinuxConfiguration", &v.LinuxConfiguration)
			delete(rawMsg, key)
		case "requireGuestProvisionSignal":
			err = unpopulate(val, "RequireGuestProvisionSignal", &v.RequireGuestProvisionSignal)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &v.Secrets)
			delete(rawMsg, key)
		case "windowsConfiguration":
			err = unpopulate(val, "WindowsConfiguration", &v.WindowsConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetProperties.
func (v VirtualMachineScaleSetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalCapabilities", v.AdditionalCapabilities)
	populate(objectMap, "automaticRepairsPolicy", v.AutomaticRepairsPolicy)
	populate(objectMap, "constrainedMaximumCapacity", v.ConstrainedMaximumCapacity)
	populate(objectMap, "doNotRunExtensionsOnOverprovisionedVMs", v.DoNotRunExtensionsOnOverprovisionedVMs)
	populate(objectMap, "hostGroup", v.HostGroup)
	populate(objectMap, "orchestrationMode", v.OrchestrationMode)
	populate(objectMap, "overprovision", v.Overprovision)
	populate(objectMap, "platformFaultDomainCount", v.PlatformFaultDomainCount)
	populate(objectMap, "priorityMixPolicy", v.PriorityMixPolicy)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "proximityPlacementGroup", v.ProximityPlacementGroup)
	populate(objectMap, "resiliencyPolicy", v.ResiliencyPolicy)
	populate(objectMap, "scaleInPolicy", v.ScaleInPolicy)
	populate(objectMap, "singlePlacementGroup", v.SinglePlacementGroup)
	populate(objectMap, "spotRestorePolicy", v.SpotRestorePolicy)
	populateDateTimeRFC3339(objectMap, "timeCreated", v.TimeCreated)
	populate(objectMap, "uniqueId", v.UniqueID)
	populate(objectMap, "upgradePolicy", v.UpgradePolicy)
	populate(objectMap, "virtualMachineProfile", v.VirtualMachineProfile)
	populate(objectMap, "zoneBalance", v.ZoneBalance)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetProperties.
func (v *VirtualMachineScaleSetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalCapabilities":
			err = unpopulate(val, "AdditionalCapabilities", &v.AdditionalCapabilities)
			delete(rawMsg, key)
		case "automaticRepairsPolicy":
			err = unpopulate(val, "AutomaticRepairsPolicy", &v.AutomaticRepairsPolicy)
			delete(rawMsg, key)
		case "constrainedMaximumCapacity":
			err = unpopulate(val, "ConstrainedMaximumCapacity", &v.ConstrainedMaximumCapacity)
			delete(rawMsg, key)
		case "doNotRunExtensionsOnOverprovisionedVMs":
			err = unpopulate(val, "DoNotRunExtensionsOnOverprovisionedVMs", &v.DoNotRunExtensionsOnOverprovisionedVMs)
			delete(rawMsg, key)
		case "hostGroup":
			err = unpopulate(val, "HostGroup", &v.HostGroup)
			delete(rawMsg, key)
		case "orchestrationMode":
			err = unpopulate(val, "OrchestrationMode", &v.OrchestrationMode)
			delete(rawMsg, key)
		case "overprovision":
			err = unpopulate(val, "Overprovision", &v.Overprovision)
			delete(rawMsg, key)
		case "platformFaultDomainCount":
			err = unpopulate(val, "PlatformFaultDomainCount", &v.PlatformFaultDomainCount)
			delete(rawMsg, key)
		case "priorityMixPolicy":
			err = unpopulate(val, "PriorityMixPolicy", &v.PriorityMixPolicy)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "proximityPlacementGroup":
			err = unpopulate(val, "ProximityPlacementGroup", &v.ProximityPlacementGroup)
			delete(rawMsg, key)
		case "resiliencyPolicy":
			err = unpopulate(val, "ResiliencyPolicy", &v.ResiliencyPolicy)
			delete(rawMsg, key)
		case "scaleInPolicy":
			err = unpopulate(val, "ScaleInPolicy", &v.ScaleInPolicy)
			delete(rawMsg, key)
		case "singlePlacementGroup":
			err = unpopulate(val, "SinglePlacementGroup", &v.SinglePlacementGroup)
			delete(rawMsg, key)
		case "spotRestorePolicy":
			err = unpopulate(val, "SpotRestorePolicy", &v.SpotRestorePolicy)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateDateTimeRFC3339(val, "TimeCreated", &v.TimeCreated)
			delete(rawMsg, key)
		case "uniqueId":
			err = unpopulate(val, "UniqueID", &v.UniqueID)
			delete(rawMsg, key)
		case "upgradePolicy":
			err = unpopulate(val, "UpgradePolicy", &v.UpgradePolicy)
			delete(rawMsg, key)
		case "virtualMachineProfile":
			err = unpopulate(val, "VirtualMachineProfile", &v.VirtualMachineProfile)
			delete(rawMsg, key)
		case "zoneBalance":
			err = unpopulate(val, "ZoneBalance", &v.ZoneBalance)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetPublicIPAddressConfiguration.
func (v VirtualMachineScaleSetPublicIPAddressConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "sku", v.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetPublicIPAddressConfiguration.
func (v *VirtualMachineScaleSetPublicIPAddressConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &v.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings.
func (v VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainNameLabel", v.DomainNameLabel)
	populate(objectMap, "domainNameLabelScope", v.DomainNameLabelScope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings.
func (v *VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainNameLabel":
			err = unpopulate(val, "DomainNameLabel", &v.DomainNameLabel)
			delete(rawMsg, key)
		case "domainNameLabelScope":
			err = unpopulate(val, "DomainNameLabelScope", &v.DomainNameLabelScope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetPublicIPAddressConfigurationProperties.
func (v VirtualMachineScaleSetPublicIPAddressConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "ipTags", v.IPTags)
	populate(objectMap, "idleTimeoutInMinutes", v.IdleTimeoutInMinutes)
	populate(objectMap, "publicIPAddressVersion", v.PublicIPAddressVersion)
	populate(objectMap, "publicIPPrefix", v.PublicIPPrefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetPublicIPAddressConfigurationProperties.
func (v *VirtualMachineScaleSetPublicIPAddressConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &v.DNSSettings)
			delete(rawMsg, key)
		case "deleteOption":
			err = unpopulate(val, "DeleteOption", &v.DeleteOption)
			delete(rawMsg, key)
		case "ipTags":
			err = unpopulate(val, "IPTags", &v.IPTags)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &v.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "publicIPAddressVersion":
			err = unpopulate(val, "PublicIPAddressVersion", &v.PublicIPAddressVersion)
			delete(rawMsg, key)
		case "publicIPPrefix":
			err = unpopulate(val, "PublicIPPrefix", &v.PublicIPPrefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetReimageParameters.
func (v VirtualMachineScaleSetReimageParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exactVersion", v.ExactVersion)
	populate(objectMap, "instanceIds", v.InstanceIDs)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "tempDisk", v.TempDisk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetReimageParameters.
func (v *VirtualMachineScaleSetReimageParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exactVersion":
			err = unpopulate(val, "ExactVersion", &v.ExactVersion)
			delete(rawMsg, key)
		case "instanceIds":
			err = unpopulate(val, "InstanceIDs", &v.InstanceIDs)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "tempDisk":
			err = unpopulate(val, "TempDisk", &v.TempDisk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetSKU.
func (v VirtualMachineScaleSetSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", v.Capacity)
	populate(objectMap, "resourceType", v.ResourceType)
	populate(objectMap, "sku", v.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetSKU.
func (v *VirtualMachineScaleSetSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &v.Capacity)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &v.ResourceType)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &v.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetSKUCapacity.
func (v VirtualMachineScaleSetSKUCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultCapacity", v.DefaultCapacity)
	populate(objectMap, "maximum", v.Maximum)
	populate(objectMap, "minimum", v.Minimum)
	populate(objectMap, "scaleType", v.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetSKUCapacity.
func (v *VirtualMachineScaleSetSKUCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultCapacity":
			err = unpopulate(val, "DefaultCapacity", &v.DefaultCapacity)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &v.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &v.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &v.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetStorageProfile.
func (v VirtualMachineScaleSetStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDisks", v.DataDisks)
	populate(objectMap, "diskControllerType", v.DiskControllerType)
	populate(objectMap, "imageReference", v.ImageReference)
	populate(objectMap, "osDisk", v.OSDisk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetStorageProfile.
func (v *VirtualMachineScaleSetStorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDisks":
			err = unpopulate(val, "DataDisks", &v.DataDisks)
			delete(rawMsg, key)
		case "diskControllerType":
			err = unpopulate(val, "DiskControllerType", &v.DiskControllerType)
			delete(rawMsg, key)
		case "imageReference":
			err = unpopulate(val, "ImageReference", &v.ImageReference)
			delete(rawMsg, key)
		case "osDisk":
			err = unpopulate(val, "OSDisk", &v.OSDisk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdate.
func (v VirtualMachineScaleSetUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "sku", v.SKU)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdate.
func (v *VirtualMachineScaleSetUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &v.Identity)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &v.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &v.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateIPConfiguration.
func (v VirtualMachineScaleSetUpdateIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateIPConfiguration.
func (v *VirtualMachineScaleSetUpdateIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateIPConfigurationProperties.
func (v VirtualMachineScaleSetUpdateIPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationGatewayBackendAddressPools", v.ApplicationGatewayBackendAddressPools)
	populate(objectMap, "applicationSecurityGroups", v.ApplicationSecurityGroups)
	populate(objectMap, "loadBalancerBackendAddressPools", v.LoadBalancerBackendAddressPools)
	populate(objectMap, "loadBalancerInboundNatPools", v.LoadBalancerInboundNatPools)
	populate(objectMap, "primary", v.Primary)
	populate(objectMap, "privateIPAddressVersion", v.PrivateIPAddressVersion)
	populate(objectMap, "publicIPAddressConfiguration", v.PublicIPAddressConfiguration)
	populate(objectMap, "subnet", v.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateIPConfigurationProperties.
func (v *VirtualMachineScaleSetUpdateIPConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationGatewayBackendAddressPools":
			err = unpopulate(val, "ApplicationGatewayBackendAddressPools", &v.ApplicationGatewayBackendAddressPools)
			delete(rawMsg, key)
		case "applicationSecurityGroups":
			err = unpopulate(val, "ApplicationSecurityGroups", &v.ApplicationSecurityGroups)
			delete(rawMsg, key)
		case "loadBalancerBackendAddressPools":
			err = unpopulate(val, "LoadBalancerBackendAddressPools", &v.LoadBalancerBackendAddressPools)
			delete(rawMsg, key)
		case "loadBalancerInboundNatPools":
			err = unpopulate(val, "LoadBalancerInboundNatPools", &v.LoadBalancerInboundNatPools)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &v.Primary)
			delete(rawMsg, key)
		case "privateIPAddressVersion":
			err = unpopulate(val, "PrivateIPAddressVersion", &v.PrivateIPAddressVersion)
			delete(rawMsg, key)
		case "publicIPAddressConfiguration":
			err = unpopulate(val, "PublicIPAddressConfiguration", &v.PublicIPAddressConfiguration)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &v.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateNetworkConfiguration.
func (v VirtualMachineScaleSetUpdateNetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateNetworkConfiguration.
func (v *VirtualMachineScaleSetUpdateNetworkConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateNetworkConfigurationProperties.
func (v VirtualMachineScaleSetUpdateNetworkConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auxiliaryMode", v.AuxiliaryMode)
	populate(objectMap, "auxiliarySku", v.AuxiliarySKU)
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "disableTcpStateTracking", v.DisableTCPStateTracking)
	populate(objectMap, "enableAcceleratedNetworking", v.EnableAcceleratedNetworking)
	populate(objectMap, "enableFpga", v.EnableFpga)
	populate(objectMap, "enableIPForwarding", v.EnableIPForwarding)
	populate(objectMap, "ipConfigurations", v.IPConfigurations)
	populate(objectMap, "networkSecurityGroup", v.NetworkSecurityGroup)
	populate(objectMap, "primary", v.Primary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateNetworkConfigurationProperties.
func (v *VirtualMachineScaleSetUpdateNetworkConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auxiliaryMode":
			err = unpopulate(val, "AuxiliaryMode", &v.AuxiliaryMode)
			delete(rawMsg, key)
		case "auxiliarySku":
			err = unpopulate(val, "AuxiliarySKU", &v.AuxiliarySKU)
			delete(rawMsg, key)
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &v.DNSSettings)
			delete(rawMsg, key)
		case "deleteOption":
			err = unpopulate(val, "DeleteOption", &v.DeleteOption)
			delete(rawMsg, key)
		case "disableTcpStateTracking":
			err = unpopulate(val, "DisableTCPStateTracking", &v.DisableTCPStateTracking)
			delete(rawMsg, key)
		case "enableAcceleratedNetworking":
			err = unpopulate(val, "EnableAcceleratedNetworking", &v.EnableAcceleratedNetworking)
			delete(rawMsg, key)
		case "enableFpga":
			err = unpopulate(val, "EnableFpga", &v.EnableFpga)
			delete(rawMsg, key)
		case "enableIPForwarding":
			err = unpopulate(val, "EnableIPForwarding", &v.EnableIPForwarding)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &v.IPConfigurations)
			delete(rawMsg, key)
		case "networkSecurityGroup":
			err = unpopulate(val, "NetworkSecurityGroup", &v.NetworkSecurityGroup)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &v.Primary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateNetworkProfile.
func (v VirtualMachineScaleSetUpdateNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "healthProbe", v.HealthProbe)
	populate(objectMap, "networkApiVersion", v.NetworkAPIVersion)
	populate(objectMap, "networkInterfaceConfigurations", v.NetworkInterfaceConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateNetworkProfile.
func (v *VirtualMachineScaleSetUpdateNetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthProbe":
			err = unpopulate(val, "HealthProbe", &v.HealthProbe)
			delete(rawMsg, key)
		case "networkApiVersion":
			err = unpopulate(val, "NetworkAPIVersion", &v.NetworkAPIVersion)
			delete(rawMsg, key)
		case "networkInterfaceConfigurations":
			err = unpopulate(val, "NetworkInterfaceConfigurations", &v.NetworkInterfaceConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateOSDisk.
func (v VirtualMachineScaleSetUpdateOSDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caching", v.Caching)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "diskSizeGB", v.DiskSizeGB)
	populate(objectMap, "image", v.Image)
	populate(objectMap, "managedDisk", v.ManagedDisk)
	populate(objectMap, "vhdContainers", v.VhdContainers)
	populate(objectMap, "writeAcceleratorEnabled", v.WriteAcceleratorEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateOSDisk.
func (v *VirtualMachineScaleSetUpdateOSDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caching":
			err = unpopulate(val, "Caching", &v.Caching)
			delete(rawMsg, key)
		case "deleteOption":
			err = unpopulate(val, "DeleteOption", &v.DeleteOption)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &v.DiskSizeGB)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &v.Image)
			delete(rawMsg, key)
		case "managedDisk":
			err = unpopulate(val, "ManagedDisk", &v.ManagedDisk)
			delete(rawMsg, key)
		case "vhdContainers":
			err = unpopulate(val, "VhdContainers", &v.VhdContainers)
			delete(rawMsg, key)
		case "writeAcceleratorEnabled":
			err = unpopulate(val, "WriteAcceleratorEnabled", &v.WriteAcceleratorEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateOSProfile.
func (v VirtualMachineScaleSetUpdateOSProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customData", v.CustomData)
	populate(objectMap, "linuxConfiguration", v.LinuxConfiguration)
	populate(objectMap, "secrets", v.Secrets)
	populate(objectMap, "windowsConfiguration", v.WindowsConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateOSProfile.
func (v *VirtualMachineScaleSetUpdateOSProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customData":
			err = unpopulate(val, "CustomData", &v.CustomData)
			delete(rawMsg, key)
		case "linuxConfiguration":
			err = unpopulate(val, "LinuxConfiguration", &v.LinuxConfiguration)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &v.Secrets)
			delete(rawMsg, key)
		case "windowsConfiguration":
			err = unpopulate(val, "WindowsConfiguration", &v.WindowsConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateProperties.
func (v VirtualMachineScaleSetUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalCapabilities", v.AdditionalCapabilities)
	populate(objectMap, "automaticRepairsPolicy", v.AutomaticRepairsPolicy)
	populate(objectMap, "doNotRunExtensionsOnOverprovisionedVMs", v.DoNotRunExtensionsOnOverprovisionedVMs)
	populate(objectMap, "overprovision", v.Overprovision)
	populate(objectMap, "priorityMixPolicy", v.PriorityMixPolicy)
	populate(objectMap, "proximityPlacementGroup", v.ProximityPlacementGroup)
	populate(objectMap, "resiliencyPolicy", v.ResiliencyPolicy)
	populate(objectMap, "scaleInPolicy", v.ScaleInPolicy)
	populate(objectMap, "singlePlacementGroup", v.SinglePlacementGroup)
	populate(objectMap, "spotRestorePolicy", v.SpotRestorePolicy)
	populate(objectMap, "upgradePolicy", v.UpgradePolicy)
	populate(objectMap, "virtualMachineProfile", v.VirtualMachineProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateProperties.
func (v *VirtualMachineScaleSetUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalCapabilities":
			err = unpopulate(val, "AdditionalCapabilities", &v.AdditionalCapabilities)
			delete(rawMsg, key)
		case "automaticRepairsPolicy":
			err = unpopulate(val, "AutomaticRepairsPolicy", &v.AutomaticRepairsPolicy)
			delete(rawMsg, key)
		case "doNotRunExtensionsOnOverprovisionedVMs":
			err = unpopulate(val, "DoNotRunExtensionsOnOverprovisionedVMs", &v.DoNotRunExtensionsOnOverprovisionedVMs)
			delete(rawMsg, key)
		case "overprovision":
			err = unpopulate(val, "Overprovision", &v.Overprovision)
			delete(rawMsg, key)
		case "priorityMixPolicy":
			err = unpopulate(val, "PriorityMixPolicy", &v.PriorityMixPolicy)
			delete(rawMsg, key)
		case "proximityPlacementGroup":
			err = unpopulate(val, "ProximityPlacementGroup", &v.ProximityPlacementGroup)
			delete(rawMsg, key)
		case "resiliencyPolicy":
			err = unpopulate(val, "ResiliencyPolicy", &v.ResiliencyPolicy)
			delete(rawMsg, key)
		case "scaleInPolicy":
			err = unpopulate(val, "ScaleInPolicy", &v.ScaleInPolicy)
			delete(rawMsg, key)
		case "singlePlacementGroup":
			err = unpopulate(val, "SinglePlacementGroup", &v.SinglePlacementGroup)
			delete(rawMsg, key)
		case "spotRestorePolicy":
			err = unpopulate(val, "SpotRestorePolicy", &v.SpotRestorePolicy)
			delete(rawMsg, key)
		case "upgradePolicy":
			err = unpopulate(val, "UpgradePolicy", &v.UpgradePolicy)
			delete(rawMsg, key)
		case "virtualMachineProfile":
			err = unpopulate(val, "VirtualMachineProfile", &v.VirtualMachineProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdatePublicIPAddressConfiguration.
func (v VirtualMachineScaleSetUpdatePublicIPAddressConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdatePublicIPAddressConfiguration.
func (v *VirtualMachineScaleSetUpdatePublicIPAddressConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties.
func (v VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsSettings", v.DNSSettings)
	populate(objectMap, "deleteOption", v.DeleteOption)
	populate(objectMap, "idleTimeoutInMinutes", v.IdleTimeoutInMinutes)
	populate(objectMap, "publicIPPrefix", v.PublicIPPrefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties.
func (v *VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &v.DNSSettings)
			delete(rawMsg, key)
		case "deleteOption":
			err = unpopulate(val, "DeleteOption", &v.DeleteOption)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &v.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "publicIPPrefix":
			err = unpopulate(val, "PublicIPPrefix", &v.PublicIPPrefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateStorageProfile.
func (v VirtualMachineScaleSetUpdateStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDisks", v.DataDisks)
	populate(objectMap, "diskControllerType", v.DiskControllerType)
	populate(objectMap, "imageReference", v.ImageReference)
	populate(objectMap, "osDisk", v.OSDisk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateStorageProfile.
func (v *VirtualMachineScaleSetUpdateStorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDisks":
			err = unpopulate(val, "DataDisks", &v.DataDisks)
			delete(rawMsg, key)
		case "diskControllerType":
			err = unpopulate(val, "DiskControllerType", &v.DiskControllerType)
			delete(rawMsg, key)
		case "imageReference":
			err = unpopulate(val, "ImageReference", &v.ImageReference)
			delete(rawMsg, key)
		case "osDisk":
			err = unpopulate(val, "OSDisk", &v.OSDisk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetUpdateVMProfile.
func (v VirtualMachineScaleSetUpdateVMProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingProfile", v.BillingProfile)
	populate(objectMap, "diagnosticsProfile", v.DiagnosticsProfile)
	populate(objectMap, "extensionProfile", v.ExtensionProfile)
	populate(objectMap, "hardwareProfile", v.HardwareProfile)
	populate(objectMap, "licenseType", v.LicenseType)
	populate(objectMap, "networkProfile", v.NetworkProfile)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "scheduledEventsProfile", v.ScheduledEventsProfile)
	populate(objectMap, "securityProfile", v.SecurityProfile)
	populate(objectMap, "storageProfile", v.StorageProfile)
	populate(objectMap, "userData", v.UserData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetUpdateVMProfile.
func (v *VirtualMachineScaleSetUpdateVMProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingProfile":
			err = unpopulate(val, "BillingProfile", &v.BillingProfile)
			delete(rawMsg, key)
		case "diagnosticsProfile":
			err = unpopulate(val, "DiagnosticsProfile", &v.DiagnosticsProfile)
			delete(rawMsg, key)
		case "extensionProfile":
			err = unpopulate(val, "ExtensionProfile", &v.ExtensionProfile)
			delete(rawMsg, key)
		case "hardwareProfile":
			err = unpopulate(val, "HardwareProfile", &v.HardwareProfile)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &v.NetworkProfile)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "scheduledEventsProfile":
			err = unpopulate(val, "ScheduledEventsProfile", &v.ScheduledEventsProfile)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &v.SecurityProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &v.StorageProfile)
			delete(rawMsg, key)
		case "userData":
			err = unpopulate(val, "UserData", &v.UserData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVM.
func (v VirtualMachineScaleSetVM) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "instanceId", v.InstanceID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "resources", v.Resources)
	populate(objectMap, "sku", v.SKU)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "zones", v.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVM.
func (v *VirtualMachineScaleSetVM) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &v.Identity)
			delete(rawMsg, key)
		case "instanceId":
			err = unpopulate(val, "InstanceID", &v.InstanceID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &v.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &v.Resources)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &v.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &v.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMExtension.
func (v VirtualMachineScaleSetVMExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMExtension.
func (v *VirtualMachineScaleSetVMExtension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMExtensionUpdate.
func (v VirtualMachineScaleSetVMExtensionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMExtensionUpdate.
func (v *VirtualMachineScaleSetVMExtensionUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMExtensionsListResult.
func (v VirtualMachineScaleSetVMExtensionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMExtensionsListResult.
func (v *VirtualMachineScaleSetVMExtensionsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMExtensionsSummary.
func (v VirtualMachineScaleSetVMExtensionsSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "statusesSummary", v.StatusesSummary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMExtensionsSummary.
func (v *VirtualMachineScaleSetVMExtensionsSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "statusesSummary":
			err = unpopulate(val, "StatusesSummary", &v.StatusesSummary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMInstanceIDs.
func (v VirtualMachineScaleSetVMInstanceIDs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceIds", v.InstanceIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMInstanceIDs.
func (v *VirtualMachineScaleSetVMInstanceIDs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceIds":
			err = unpopulate(val, "InstanceIDs", &v.InstanceIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMInstanceRequiredIDs.
func (v VirtualMachineScaleSetVMInstanceRequiredIDs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceIds", v.InstanceIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMInstanceRequiredIDs.
func (v *VirtualMachineScaleSetVMInstanceRequiredIDs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceIds":
			err = unpopulate(val, "InstanceIDs", &v.InstanceIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMInstanceView.
func (v VirtualMachineScaleSetVMInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignedHost", v.AssignedHost)
	populate(objectMap, "bootDiagnostics", v.BootDiagnostics)
	populate(objectMap, "computerName", v.ComputerName)
	populate(objectMap, "disks", v.Disks)
	populate(objectMap, "extensions", v.Extensions)
	populate(objectMap, "hyperVGeneration", v.HyperVGeneration)
	populate(objectMap, "maintenanceRedeployStatus", v.MaintenanceRedeployStatus)
	populate(objectMap, "osName", v.OSName)
	populate(objectMap, "osVersion", v.OSVersion)
	populate(objectMap, "placementGroupId", v.PlacementGroupID)
	populate(objectMap, "platformFaultDomain", v.PlatformFaultDomain)
	populate(objectMap, "platformUpdateDomain", v.PlatformUpdateDomain)
	populate(objectMap, "rdpThumbPrint", v.RdpThumbPrint)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "vmAgent", v.VMAgent)
	populate(objectMap, "vmHealth", v.VMHealth)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMInstanceView.
func (v *VirtualMachineScaleSetVMInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignedHost":
			err = unpopulate(val, "AssignedHost", &v.AssignedHost)
			delete(rawMsg, key)
		case "bootDiagnostics":
			err = unpopulate(val, "BootDiagnostics", &v.BootDiagnostics)
			delete(rawMsg, key)
		case "computerName":
			err = unpopulate(val, "ComputerName", &v.ComputerName)
			delete(rawMsg, key)
		case "disks":
			err = unpopulate(val, "Disks", &v.Disks)
			delete(rawMsg, key)
		case "extensions":
			err = unpopulate(val, "Extensions", &v.Extensions)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &v.HyperVGeneration)
			delete(rawMsg, key)
		case "maintenanceRedeployStatus":
			err = unpopulate(val, "MaintenanceRedeployStatus", &v.MaintenanceRedeployStatus)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &v.OSName)
			delete(rawMsg, key)
		case "osVersion":
			err = unpopulate(val, "OSVersion", &v.OSVersion)
			delete(rawMsg, key)
		case "placementGroupId":
			err = unpopulate(val, "PlacementGroupID", &v.PlacementGroupID)
			delete(rawMsg, key)
		case "platformFaultDomain":
			err = unpopulate(val, "PlatformFaultDomain", &v.PlatformFaultDomain)
			delete(rawMsg, key)
		case "platformUpdateDomain":
			err = unpopulate(val, "PlatformUpdateDomain", &v.PlatformUpdateDomain)
			delete(rawMsg, key)
		case "rdpThumbPrint":
			err = unpopulate(val, "RdpThumbPrint", &v.RdpThumbPrint)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		case "vmAgent":
			err = unpopulate(val, "VMAgent", &v.VMAgent)
			delete(rawMsg, key)
		case "vmHealth":
			err = unpopulate(val, "VMHealth", &v.VMHealth)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMListResult.
func (v VirtualMachineScaleSetVMListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMListResult.
func (v *VirtualMachineScaleSetVMListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMNetworkProfileConfiguration.
func (v VirtualMachineScaleSetVMNetworkProfileConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkInterfaceConfigurations", v.NetworkInterfaceConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMNetworkProfileConfiguration.
func (v *VirtualMachineScaleSetVMNetworkProfileConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkInterfaceConfigurations":
			err = unpopulate(val, "NetworkInterfaceConfigurations", &v.NetworkInterfaceConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMProfile.
func (v VirtualMachineScaleSetVMProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationProfile", v.ApplicationProfile)
	populate(objectMap, "billingProfile", v.BillingProfile)
	populate(objectMap, "capacityReservation", v.CapacityReservation)
	populate(objectMap, "diagnosticsProfile", v.DiagnosticsProfile)
	populate(objectMap, "evictionPolicy", v.EvictionPolicy)
	populate(objectMap, "extensionProfile", v.ExtensionProfile)
	populate(objectMap, "hardwareProfile", v.HardwareProfile)
	populate(objectMap, "licenseType", v.LicenseType)
	populate(objectMap, "networkProfile", v.NetworkProfile)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "priority", v.Priority)
	populate(objectMap, "scheduledEventsProfile", v.ScheduledEventsProfile)
	populate(objectMap, "securityPostureReference", v.SecurityPostureReference)
	populate(objectMap, "securityProfile", v.SecurityProfile)
	populate(objectMap, "serviceArtifactReference", v.ServiceArtifactReference)
	populate(objectMap, "storageProfile", v.StorageProfile)
	populateDateTimeRFC3339(objectMap, "timeCreated", v.TimeCreated)
	populate(objectMap, "userData", v.UserData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMProfile.
func (v *VirtualMachineScaleSetVMProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationProfile":
			err = unpopulate(val, "ApplicationProfile", &v.ApplicationProfile)
			delete(rawMsg, key)
		case "billingProfile":
			err = unpopulate(val, "BillingProfile", &v.BillingProfile)
			delete(rawMsg, key)
		case "capacityReservation":
			err = unpopulate(val, "CapacityReservation", &v.CapacityReservation)
			delete(rawMsg, key)
		case "diagnosticsProfile":
			err = unpopulate(val, "DiagnosticsProfile", &v.DiagnosticsProfile)
			delete(rawMsg, key)
		case "evictionPolicy":
			err = unpopulate(val, "EvictionPolicy", &v.EvictionPolicy)
			delete(rawMsg, key)
		case "extensionProfile":
			err = unpopulate(val, "ExtensionProfile", &v.ExtensionProfile)
			delete(rawMsg, key)
		case "hardwareProfile":
			err = unpopulate(val, "HardwareProfile", &v.HardwareProfile)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &v.NetworkProfile)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &v.Priority)
			delete(rawMsg, key)
		case "scheduledEventsProfile":
			err = unpopulate(val, "ScheduledEventsProfile", &v.ScheduledEventsProfile)
			delete(rawMsg, key)
		case "securityPostureReference":
			err = unpopulate(val, "SecurityPostureReference", &v.SecurityPostureReference)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &v.SecurityProfile)
			delete(rawMsg, key)
		case "serviceArtifactReference":
			err = unpopulate(val, "ServiceArtifactReference", &v.ServiceArtifactReference)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &v.StorageProfile)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateDateTimeRFC3339(val, "TimeCreated", &v.TimeCreated)
			delete(rawMsg, key)
		case "userData":
			err = unpopulate(val, "UserData", &v.UserData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMProperties.
func (v VirtualMachineScaleSetVMProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalCapabilities", v.AdditionalCapabilities)
	populate(objectMap, "availabilitySet", v.AvailabilitySet)
	populate(objectMap, "diagnosticsProfile", v.DiagnosticsProfile)
	populate(objectMap, "hardwareProfile", v.HardwareProfile)
	populate(objectMap, "instanceView", v.InstanceView)
	populate(objectMap, "latestModelApplied", v.LatestModelApplied)
	populate(objectMap, "licenseType", v.LicenseType)
	populate(objectMap, "modelDefinitionApplied", v.ModelDefinitionApplied)
	populate(objectMap, "networkProfile", v.NetworkProfile)
	populate(objectMap, "networkProfileConfiguration", v.NetworkProfileConfiguration)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "protectionPolicy", v.ProtectionPolicy)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "securityProfile", v.SecurityProfile)
	populate(objectMap, "storageProfile", v.StorageProfile)
	populateDateTimeRFC3339(objectMap, "timeCreated", v.TimeCreated)
	populate(objectMap, "userData", v.UserData)
	populate(objectMap, "vmId", v.VMID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMProperties.
func (v *VirtualMachineScaleSetVMProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalCapabilities":
			err = unpopulate(val, "AdditionalCapabilities", &v.AdditionalCapabilities)
			delete(rawMsg, key)
		case "availabilitySet":
			err = unpopulate(val, "AvailabilitySet", &v.AvailabilitySet)
			delete(rawMsg, key)
		case "diagnosticsProfile":
			err = unpopulate(val, "DiagnosticsProfile", &v.DiagnosticsProfile)
			delete(rawMsg, key)
		case "hardwareProfile":
			err = unpopulate(val, "HardwareProfile", &v.HardwareProfile)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &v.InstanceView)
			delete(rawMsg, key)
		case "latestModelApplied":
			err = unpopulate(val, "LatestModelApplied", &v.LatestModelApplied)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "modelDefinitionApplied":
			err = unpopulate(val, "ModelDefinitionApplied", &v.ModelDefinitionApplied)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &v.NetworkProfile)
			delete(rawMsg, key)
		case "networkProfileConfiguration":
			err = unpopulate(val, "NetworkProfileConfiguration", &v.NetworkProfileConfiguration)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "protectionPolicy":
			err = unpopulate(val, "ProtectionPolicy", &v.ProtectionPolicy)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &v.SecurityProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &v.StorageProfile)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateDateTimeRFC3339(val, "TimeCreated", &v.TimeCreated)
			delete(rawMsg, key)
		case "userData":
			err = unpopulate(val, "UserData", &v.UserData)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &v.VMID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMProtectionPolicy.
func (v VirtualMachineScaleSetVMProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "protectFromScaleIn", v.ProtectFromScaleIn)
	populate(objectMap, "protectFromScaleSetActions", v.ProtectFromScaleSetActions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMProtectionPolicy.
func (v *VirtualMachineScaleSetVMProtectionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "protectFromScaleIn":
			err = unpopulate(val, "ProtectFromScaleIn", &v.ProtectFromScaleIn)
			delete(rawMsg, key)
		case "protectFromScaleSetActions":
			err = unpopulate(val, "ProtectFromScaleSetActions", &v.ProtectFromScaleSetActions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineScaleSetVMReimageParameters.
func (v VirtualMachineScaleSetVMReimageParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exactVersion", v.ExactVersion)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "tempDisk", v.TempDisk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineScaleSetVMReimageParameters.
func (v *VirtualMachineScaleSetVMReimageParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exactVersion":
			err = unpopulate(val, "ExactVersion", &v.ExactVersion)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "tempDisk":
			err = unpopulate(val, "TempDisk", &v.TempDisk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineSize.
func (v VirtualMachineSize) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxDataDiskCount", v.MaxDataDiskCount)
	populate(objectMap, "memoryInMB", v.MemoryInMB)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "numberOfCores", v.NumberOfCores)
	populate(objectMap, "osDiskSizeInMB", v.OSDiskSizeInMB)
	populate(objectMap, "resourceDiskSizeInMB", v.ResourceDiskSizeInMB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSize.
func (v *VirtualMachineSize) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxDataDiskCount":
			err = unpopulate(val, "MaxDataDiskCount", &v.MaxDataDiskCount)
			delete(rawMsg, key)
		case "memoryInMB":
			err = unpopulate(val, "MemoryInMB", &v.MemoryInMB)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "numberOfCores":
			err = unpopulate(val, "NumberOfCores", &v.NumberOfCores)
			delete(rawMsg, key)
		case "osDiskSizeInMB":
			err = unpopulate(val, "OSDiskSizeInMB", &v.OSDiskSizeInMB)
			delete(rawMsg, key)
		case "resourceDiskSizeInMB":
			err = unpopulate(val, "ResourceDiskSizeInMB", &v.ResourceDiskSizeInMB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineSizeListResult.
func (v VirtualMachineSizeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSizeListResult.
func (v *VirtualMachineSizeListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineSoftwarePatchProperties.
func (v VirtualMachineSoftwarePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activityId", v.ActivityID)
	populate(objectMap, "assessmentState", v.AssessmentState)
	populate(objectMap, "classifications", v.Classifications)
	populate(objectMap, "kbId", v.KbID)
	populateDateTimeRFC3339(objectMap, "lastModifiedDateTime", v.LastModifiedDateTime)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "patchId", v.PatchID)
	populateDateTimeRFC3339(objectMap, "publishedDate", v.PublishedDate)
	populate(objectMap, "rebootBehavior", v.RebootBehavior)
	populate(objectMap, "version", v.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSoftwarePatchProperties.
func (v *VirtualMachineSoftwarePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activityId":
			err = unpopulate(val, "ActivityID", &v.ActivityID)
			delete(rawMsg, key)
		case "assessmentState":
			err = unpopulate(val, "AssessmentState", &v.AssessmentState)
			delete(rawMsg, key)
		case "classifications":
			err = unpopulate(val, "Classifications", &v.Classifications)
			delete(rawMsg, key)
		case "kbId":
			err = unpopulate(val, "KbID", &v.KbID)
			delete(rawMsg, key)
		case "lastModifiedDateTime":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedDateTime", &v.LastModifiedDateTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "patchId":
			err = unpopulate(val, "PatchID", &v.PatchID)
			delete(rawMsg, key)
		case "publishedDate":
			err = unpopulateDateTimeRFC3339(val, "PublishedDate", &v.PublishedDate)
			delete(rawMsg, key)
		case "rebootBehavior":
			err = unpopulate(val, "RebootBehavior", &v.RebootBehavior)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &v.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineStatusCodeCount.
func (v VirtualMachineStatusCodeCount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", v.Code)
	populate(objectMap, "count", v.Count)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineStatusCodeCount.
func (v *VirtualMachineStatusCodeCount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &v.Code)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &v.Count)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineUpdate.
func (v VirtualMachineUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "plan", v.Plan)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "zones", v.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineUpdate.
func (v *VirtualMachineUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &v.Identity)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &v.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &v.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WinRMConfiguration.
func (w WinRMConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "listeners", w.Listeners)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WinRMConfiguration.
func (w *WinRMConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "listeners":
			err = unpopulate(val, "Listeners", &w.Listeners)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WinRMListener.
func (w WinRMListener) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateUrl", w.CertificateURL)
	populate(objectMap, "protocol", w.Protocol)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WinRMListener.
func (w *WinRMListener) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateUrl":
			err = unpopulate(val, "CertificateURL", &w.CertificateURL)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &w.Protocol)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WindowsConfiguration.
func (w WindowsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalUnattendContent", w.AdditionalUnattendContent)
	populate(objectMap, "enableAutomaticUpdates", w.EnableAutomaticUpdates)
	populate(objectMap, "enableVMAgentPlatformUpdates", w.EnableVMAgentPlatformUpdates)
	populate(objectMap, "patchSettings", w.PatchSettings)
	populate(objectMap, "provisionVMAgent", w.ProvisionVMAgent)
	populate(objectMap, "timeZone", w.TimeZone)
	populate(objectMap, "winRM", w.WinRM)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WindowsConfiguration.
func (w *WindowsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalUnattendContent":
			err = unpopulate(val, "AdditionalUnattendContent", &w.AdditionalUnattendContent)
			delete(rawMsg, key)
		case "enableAutomaticUpdates":
			err = unpopulate(val, "EnableAutomaticUpdates", &w.EnableAutomaticUpdates)
			delete(rawMsg, key)
		case "enableVMAgentPlatformUpdates":
			err = unpopulate(val, "EnableVMAgentPlatformUpdates", &w.EnableVMAgentPlatformUpdates)
			delete(rawMsg, key)
		case "patchSettings":
			err = unpopulate(val, "PatchSettings", &w.PatchSettings)
			delete(rawMsg, key)
		case "provisionVMAgent":
			err = unpopulate(val, "ProvisionVMAgent", &w.ProvisionVMAgent)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &w.TimeZone)
			delete(rawMsg, key)
		case "winRM":
			err = unpopulate(val, "WinRM", &w.WinRM)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WindowsParameters.
func (w WindowsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "classificationsToInclude", w.ClassificationsToInclude)
	populate(objectMap, "excludeKbsRequiringReboot", w.ExcludeKbsRequiringReboot)
	populate(objectMap, "kbNumbersToExclude", w.KbNumbersToExclude)
	populate(objectMap, "kbNumbersToInclude", w.KbNumbersToInclude)
	populateDateTimeRFC3339(objectMap, "maxPatchPublishDate", w.MaxPatchPublishDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WindowsParameters.
func (w *WindowsParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "classificationsToInclude":
			err = unpopulate(val, "ClassificationsToInclude", &w.ClassificationsToInclude)
			delete(rawMsg, key)
		case "excludeKbsRequiringReboot":
			err = unpopulate(val, "ExcludeKbsRequiringReboot", &w.ExcludeKbsRequiringReboot)
			delete(rawMsg, key)
		case "kbNumbersToExclude":
			err = unpopulate(val, "KbNumbersToExclude", &w.KbNumbersToExclude)
			delete(rawMsg, key)
		case "kbNumbersToInclude":
			err = unpopulate(val, "KbNumbersToInclude", &w.KbNumbersToInclude)
			delete(rawMsg, key)
		case "maxPatchPublishDate":
			err = unpopulateDateTimeRFC3339(val, "MaxPatchPublishDate", &w.MaxPatchPublishDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WindowsVMGuestPatchAutomaticByPlatformSettings.
func (w WindowsVMGuestPatchAutomaticByPlatformSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bypassPlatformSafetyChecksOnUserSchedule", w.BypassPlatformSafetyChecksOnUserSchedule)
	populate(objectMap, "rebootSetting", w.RebootSetting)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WindowsVMGuestPatchAutomaticByPlatformSettings.
func (w *WindowsVMGuestPatchAutomaticByPlatformSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bypassPlatformSafetyChecksOnUserSchedule":
			err = unpopulate(val, "BypassPlatformSafetyChecksOnUserSchedule", &w.BypassPlatformSafetyChecksOnUserSchedule)
			delete(rawMsg, key)
		case "rebootSetting":
			err = unpopulate(val, "RebootSetting", &w.RebootSetting)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
