/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
	"os"
)


// UploadsAPIService UploadsAPI service
type UploadsAPIService service

type UploadsAPIUploadsAddRoleRequest struct {
	ctx context.Context
	ApiService *UploadsAPIService
	uploadHref string
	upload *Upload
}

func (r UploadsAPIUploadsAddRoleRequest) Upload(upload Upload) UploadsAPIUploadsAddRoleRequest {
	r.upload = &upload
	return r
}

func (r UploadsAPIUploadsAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.UploadsAddRoleExecute(r)
}

/*
UploadsAddRole Method for UploadsAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param uploadHref
 @return UploadsAPIUploadsAddRoleRequest
*/
func (a *UploadsAPIService) UploadsAddRole(ctx context.Context, uploadHref string) UploadsAPIUploadsAddRoleRequest {
	return UploadsAPIUploadsAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		uploadHref: uploadHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *UploadsAPIService) UploadsAddRoleExecute(r UploadsAPIUploadsAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UploadsAPIService.UploadsAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{upload_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"upload_href"+"}", parameterValueToString(r.uploadHref, "uploadHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.upload == nil {
		return localVarReturnValue, nil, reportError("upload is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.upload
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UploadsAPIUploadsCommitRequest struct {
	ctx context.Context
	ApiService *UploadsAPIService
	uploadHref string
	uploadCommit *UploadCommit
}

func (r UploadsAPIUploadsCommitRequest) UploadCommit(uploadCommit UploadCommit) UploadsAPIUploadsCommitRequest {
	r.uploadCommit = &uploadCommit
	return r
}

func (r UploadsAPIUploadsCommitRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.UploadsCommitExecute(r)
}

/*
UploadsCommit Finish an Upload

Queues a Task that creates an Artifact, and the Upload gets deleted and cannot be re-used.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param uploadHref
 @return UploadsAPIUploadsCommitRequest
*/
func (a *UploadsAPIService) UploadsCommit(ctx context.Context, uploadHref string) UploadsAPIUploadsCommitRequest {
	return UploadsAPIUploadsCommitRequest{
		ApiService: a,
		ctx: ctx,
		uploadHref: uploadHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *UploadsAPIService) UploadsCommitExecute(r UploadsAPIUploadsCommitRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UploadsAPIService.UploadsCommit")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{upload_href}commit/"
	localVarPath = strings.Replace(localVarPath, "{"+"upload_href"+"}", parameterValueToString(r.uploadHref, "uploadHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.uploadCommit == nil {
		return localVarReturnValue, nil, reportError("uploadCommit is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.uploadCommit
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UploadsAPIUploadsCreateRequest struct {
	ctx context.Context
	ApiService *UploadsAPIService
	upload *Upload
}

func (r UploadsAPIUploadsCreateRequest) Upload(upload Upload) UploadsAPIUploadsCreateRequest {
	r.upload = &upload
	return r
}

func (r UploadsAPIUploadsCreateRequest) Execute() (*UploadResponse, *http.Response, error) {
	return r.ApiService.UploadsCreateExecute(r)
}

/*
UploadsCreate Create an upload

View for chunked uploads.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return UploadsAPIUploadsCreateRequest
*/
func (a *UploadsAPIService) UploadsCreate(ctx context.Context) UploadsAPIUploadsCreateRequest {
	return UploadsAPIUploadsCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return UploadResponse
func (a *UploadsAPIService) UploadsCreateExecute(r UploadsAPIUploadsCreateRequest) (*UploadResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *UploadResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UploadsAPIService.UploadsCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/uploads/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.upload == nil {
		return localVarReturnValue, nil, reportError("upload is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.upload
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UploadsAPIUploadsDeleteRequest struct {
	ctx context.Context
	ApiService *UploadsAPIService
	uploadHref string
}

func (r UploadsAPIUploadsDeleteRequest) Execute() (*http.Response, error) {
	return r.ApiService.UploadsDeleteExecute(r)
}

/*
UploadsDelete Delete an upload

View for chunked uploads.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param uploadHref
 @return UploadsAPIUploadsDeleteRequest
*/
func (a *UploadsAPIService) UploadsDelete(ctx context.Context, uploadHref string) UploadsAPIUploadsDeleteRequest {
	return UploadsAPIUploadsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		uploadHref: uploadHref,
	}
}

// Execute executes the request
func (a *UploadsAPIService) UploadsDeleteExecute(r UploadsAPIUploadsDeleteRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UploadsAPIService.UploadsDelete")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{upload_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"upload_href"+"}", parameterValueToString(r.uploadHref, "uploadHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type UploadsAPIUploadsListRequest struct {
	ctx context.Context
	ApiService *UploadsAPIService
	limit *int32
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	size *int32
	sizeGt *int32
	sizeLt *int32
	sizeRange *[]int32
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r UploadsAPIUploadsListRequest) Limit(limit int32) UploadsAPIUploadsListRequest {
	r.limit = &limit
	return r
}

// The initial index from which to return the results.
func (r UploadsAPIUploadsListRequest) Offset(offset int32) UploadsAPIUploadsListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;size&#x60; - Size * &#x60;-size&#x60; - Size (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r UploadsAPIUploadsListRequest) Ordering(ordering []string) UploadsAPIUploadsListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r UploadsAPIUploadsListRequest) PulpHrefIn(pulpHrefIn []string) UploadsAPIUploadsListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r UploadsAPIUploadsListRequest) PulpIdIn(pulpIdIn []string) UploadsAPIUploadsListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter results where size matches value
func (r UploadsAPIUploadsListRequest) Size(size int32) UploadsAPIUploadsListRequest {
	r.size = &size
	return r
}

// Filter results where size is greater than value
func (r UploadsAPIUploadsListRequest) SizeGt(sizeGt int32) UploadsAPIUploadsListRequest {
	r.sizeGt = &sizeGt
	return r
}

// Filter results where size is less than value
func (r UploadsAPIUploadsListRequest) SizeLt(sizeLt int32) UploadsAPIUploadsListRequest {
	r.sizeLt = &sizeLt
	return r
}

// Filter results where size is between two comma separated values
func (r UploadsAPIUploadsListRequest) SizeRange(sizeRange []int32) UploadsAPIUploadsListRequest {
	r.sizeRange = &sizeRange
	return r
}

// A list of fields to include in the response.
func (r UploadsAPIUploadsListRequest) Fields(fields []string) UploadsAPIUploadsListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r UploadsAPIUploadsListRequest) ExcludeFields(excludeFields []string) UploadsAPIUploadsListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r UploadsAPIUploadsListRequest) Execute() (*PaginatedUploadResponseList, *http.Response, error) {
	return r.ApiService.UploadsListExecute(r)
}

/*
UploadsList List uploads

View for chunked uploads.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return UploadsAPIUploadsListRequest
*/
func (a *UploadsAPIService) UploadsList(ctx context.Context) UploadsAPIUploadsListRequest {
	return UploadsAPIUploadsListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedUploadResponseList
func (a *UploadsAPIService) UploadsListExecute(r UploadsAPIUploadsListRequest) (*PaginatedUploadResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedUploadResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UploadsAPIService.UploadsList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/uploads/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.size != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "size", r.size, "")
	}
	if r.sizeGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "size__gt", r.sizeGt, "")
	}
	if r.sizeLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "size__lt", r.sizeLt, "")
	}
	if r.sizeRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "size__range", r.sizeRange, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UploadsAPIUploadsListRolesRequest struct {
	ctx context.Context
	ApiService *UploadsAPIService
	uploadHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r UploadsAPIUploadsListRolesRequest) Fields(fields []string) UploadsAPIUploadsListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r UploadsAPIUploadsListRolesRequest) ExcludeFields(excludeFields []string) UploadsAPIUploadsListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r UploadsAPIUploadsListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.UploadsListRolesExecute(r)
}

/*
UploadsListRoles Method for UploadsListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param uploadHref
 @return UploadsAPIUploadsListRolesRequest
*/
func (a *UploadsAPIService) UploadsListRoles(ctx context.Context, uploadHref string) UploadsAPIUploadsListRolesRequest {
	return UploadsAPIUploadsListRolesRequest{
		ApiService: a,
		ctx: ctx,
		uploadHref: uploadHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *UploadsAPIService) UploadsListRolesExecute(r UploadsAPIUploadsListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UploadsAPIService.UploadsListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{upload_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"upload_href"+"}", parameterValueToString(r.uploadHref, "uploadHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UploadsAPIUploadsMyPermissionsRequest struct {
	ctx context.Context
	ApiService *UploadsAPIService
	uploadHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r UploadsAPIUploadsMyPermissionsRequest) Fields(fields []string) UploadsAPIUploadsMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r UploadsAPIUploadsMyPermissionsRequest) ExcludeFields(excludeFields []string) UploadsAPIUploadsMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r UploadsAPIUploadsMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.UploadsMyPermissionsExecute(r)
}

/*
UploadsMyPermissions Method for UploadsMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param uploadHref
 @return UploadsAPIUploadsMyPermissionsRequest
*/
func (a *UploadsAPIService) UploadsMyPermissions(ctx context.Context, uploadHref string) UploadsAPIUploadsMyPermissionsRequest {
	return UploadsAPIUploadsMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		uploadHref: uploadHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *UploadsAPIService) UploadsMyPermissionsExecute(r UploadsAPIUploadsMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UploadsAPIService.UploadsMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{upload_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"upload_href"+"}", parameterValueToString(r.uploadHref, "uploadHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UploadsAPIUploadsReadRequest struct {
	ctx context.Context
	ApiService *UploadsAPIService
	uploadHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r UploadsAPIUploadsReadRequest) Fields(fields []string) UploadsAPIUploadsReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r UploadsAPIUploadsReadRequest) ExcludeFields(excludeFields []string) UploadsAPIUploadsReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r UploadsAPIUploadsReadRequest) Execute() (*UploadDetailResponse, *http.Response, error) {
	return r.ApiService.UploadsReadExecute(r)
}

/*
UploadsRead Inspect an upload

View for chunked uploads.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param uploadHref
 @return UploadsAPIUploadsReadRequest
*/
func (a *UploadsAPIService) UploadsRead(ctx context.Context, uploadHref string) UploadsAPIUploadsReadRequest {
	return UploadsAPIUploadsReadRequest{
		ApiService: a,
		ctx: ctx,
		uploadHref: uploadHref,
	}
}

// Execute executes the request
//  @return UploadDetailResponse
func (a *UploadsAPIService) UploadsReadExecute(r UploadsAPIUploadsReadRequest) (*UploadDetailResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *UploadDetailResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UploadsAPIService.UploadsRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{upload_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"upload_href"+"}", parameterValueToString(r.uploadHref, "uploadHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UploadsAPIUploadsRemoveRoleRequest struct {
	ctx context.Context
	ApiService *UploadsAPIService
	uploadHref string
	upload *Upload
}

func (r UploadsAPIUploadsRemoveRoleRequest) Upload(upload Upload) UploadsAPIUploadsRemoveRoleRequest {
	r.upload = &upload
	return r
}

func (r UploadsAPIUploadsRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.UploadsRemoveRoleExecute(r)
}

/*
UploadsRemoveRole Method for UploadsRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param uploadHref
 @return UploadsAPIUploadsRemoveRoleRequest
*/
func (a *UploadsAPIService) UploadsRemoveRole(ctx context.Context, uploadHref string) UploadsAPIUploadsRemoveRoleRequest {
	return UploadsAPIUploadsRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		uploadHref: uploadHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *UploadsAPIService) UploadsRemoveRoleExecute(r UploadsAPIUploadsRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UploadsAPIService.UploadsRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{upload_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"upload_href"+"}", parameterValueToString(r.uploadHref, "uploadHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.upload == nil {
		return localVarReturnValue, nil, reportError("upload is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.upload
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UploadsAPIUploadsUpdateRequest struct {
	ctx context.Context
	ApiService *UploadsAPIService
	contentRange *string
	uploadHref string
	file *os.File
	sha256 *string
}

// The Content-Range header specifies the location of the file chunk within the file.
func (r UploadsAPIUploadsUpdateRequest) ContentRange(contentRange string) UploadsAPIUploadsUpdateRequest {
	r.contentRange = &contentRange
	return r
}

// A chunk of the uploaded file.
func (r UploadsAPIUploadsUpdateRequest) File(file *os.File) UploadsAPIUploadsUpdateRequest {
	r.file = file
	return r
}

// The SHA-256 checksum of the chunk if available.
func (r UploadsAPIUploadsUpdateRequest) Sha256(sha256 string) UploadsAPIUploadsUpdateRequest {
	r.sha256 = &sha256
	return r
}

func (r UploadsAPIUploadsUpdateRequest) Execute() (*UploadResponse, *http.Response, error) {
	return r.ApiService.UploadsUpdateExecute(r)
}

/*
UploadsUpdate Upload a file chunk

Upload a chunk for an upload.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param uploadHref
 @return UploadsAPIUploadsUpdateRequest
*/
func (a *UploadsAPIService) UploadsUpdate(ctx context.Context, uploadHref string) UploadsAPIUploadsUpdateRequest {
	return UploadsAPIUploadsUpdateRequest{
		ApiService: a,
		ctx: ctx,
		uploadHref: uploadHref,
	}
}

// Execute executes the request
//  @return UploadResponse
func (a *UploadsAPIService) UploadsUpdateExecute(r UploadsAPIUploadsUpdateRequest) (*UploadResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *UploadResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UploadsAPIService.UploadsUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{upload_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"upload_href"+"}", parameterValueToString(r.uploadHref, "uploadHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.contentRange == nil {
		return localVarReturnValue, nil, reportError("contentRange is required and must be specified")
	}
	if r.file == nil {
		return localVarReturnValue, nil, reportError("file is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"multipart/form-data", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	parameterAddToHeaderOrQuery(localVarHeaderParams, "Content-Range", r.contentRange, "")
	var fileLocalVarFormFileName string
	var fileLocalVarFileName     string
	var fileLocalVarFileBytes    []byte

	fileLocalVarFormFileName = "file"


	fileLocalVarFile := r.file

	if fileLocalVarFile != nil {
		fbs, _ := io.ReadAll(fileLocalVarFile)

		fileLocalVarFileBytes = fbs
		fileLocalVarFileName = fileLocalVarFile.Name()
		fileLocalVarFile.Close()
		formFiles = append(formFiles, formFile{fileBytes: fileLocalVarFileBytes, fileName: fileLocalVarFileName, formFileName: fileLocalVarFormFileName})
	}
	if r.sha256 != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "sha256", r.sha256, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
