/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.ca.CertificateAuthority;
import com.netscape.ca.GetCertStatus;
import com.netscape.ca.GetCertsForChallenge;
import com.netscape.ca.IServant;
import com.netscape.ca.ServiceCert4Crl;
import com.netscape.ca.ServiceCheckChallenge;
import com.netscape.ca.ServiceGetCAChain;
import com.netscape.ca.ServiceGetCRL;
import com.netscape.ca.ServiceGetCertificates;
import com.netscape.ca.ServiceGetRevocationInfo;
import com.netscape.ca.ServiceIssue;
import com.netscape.ca.ServiceRenewal;
import com.netscape.ca.ServiceRevoke;
import com.netscape.ca.ServiceUnCert4Crl;
import com.netscape.ca.ServiceUnrevoke;
import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.ca.CANotFoundException;
import com.netscape.certsrv.ca.ECAException;
import com.netscape.certsrv.connector.Connector;
import com.netscape.certsrv.connector.ConnectorConfig;
import com.netscape.certsrv.connector.ConnectorsConfig;
import com.netscape.certsrv.dbs.ModificationSet;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.SecurityDataArchivalRequestEvent;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.request.IService;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.connector.HttpConnector;
import com.netscape.cmscore.connector.LocalConnector;
import com.netscape.cmscore.connector.RemoteAuthority;
import com.netscape.cmscore.crmf.CRMFParser;
import com.netscape.cmscore.crmf.PKIArchiveOptionsContainer;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.RevocationInfo;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.dogtagpki.ct.CTEngine;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.extensions.CertInfo;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateIssuerName;
import org.mozilla.jss.netscape.security.x509.CertificateSerialNumber;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.LdapDNStrConverter;
import org.mozilla.jss.netscape.security.x509.LdapV3DNStrConverter;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.SerialNumber;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X500NameAttrMap;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509ExtensionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAService
implements IService {
    public static Logger logger = LoggerFactory.getLogger(CAService.class);
    public static final String CRMF_REQUEST = "CRMFRequest";
    public static final String CHALLENGE_PHRASE = "challengePhrase";
    public static final String SERIALNO_ARRAY = "serialNoArray";
    protected static Connector mCLAConnector = null;
    private CertificateAuthority mCA = null;
    private Hashtable<String, IServant> mServants = new Hashtable();
    private Connector mKRAConnector = null;
    private ConnectorsConfig connectorsConfig;
    private boolean mArchivalRequired = true;

    public CAService(CertificateAuthority ca) {
        this.mCA = ca;
        this.mServants.put("enrollment", new ServiceIssue(this));
        this.mServants.put("renewal", new ServiceRenewal(this));
        this.mServants.put("revocation", new ServiceRevoke(this));
        this.mServants.put("CMCRevReq", new ServiceRevoke(this));
        this.mServants.put("revocationChallenge", new ServiceCheckChallenge(this));
        this.mServants.put("getCertsForChallenge", new GetCertsForChallenge(this));
        this.mServants.put("unrevocation", new ServiceUnrevoke(this));
        this.mServants.put("getCAChain", new ServiceGetCAChain(this));
        this.mServants.put("getCRL", new ServiceGetCRL(this));
        this.mServants.put("getRevocationInfo", new ServiceGetRevocationInfo(this));
        this.mServants.put("getCertificates", new ServiceGetCertificates(this));
        this.mServants.put("cert4crl", new ServiceCert4Crl(this));
        this.mServants.put("uncert4crl", new ServiceUnCert4Crl(this));
        this.mServants.put("getCertStatus", new GetCertStatus(this));
    }

    public void init(ConnectorsConfig connectorsConfig) throws EBaseException {
        this.connectorsConfig = connectorsConfig;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            logger.debug("CertificateFactory Type : " + cf.getType());
            logger.debug("CertificateFactory Provider : " + cf.getProvider().getInfo());
        }
        catch (CertificateException e) {
            logger.warn("Something is happen in install CMS provider !" + e.toString());
        }
    }

    public void startup() throws EBaseException {
        ConnectorConfig claConfig;
        ConnectorConfig kraConfig = this.connectorsConfig.getConnectorConfig("KRA");
        if (kraConfig != null) {
            this.mArchivalRequired = kraConfig.getBoolean("archivalRequired", true);
            this.mKRAConnector = this.getConnector(kraConfig);
            if (this.mKRAConnector != null) {
                logger.info("Started KRA Connector");
                this.mKRAConnector.start();
            }
        }
        if ((claConfig = this.connectorsConfig.getConnectorConfig("CLA")) != null && (mCLAConnector = this.getConnector(claConfig)) != null) {
            logger.debug(CMS.getLogMessage((String)"CMSCORE_CA_START_CONNECTOR", (Object[])new Object[0]));
            logger.info("Started CLA Connector in CCA");
            mCLAConnector.start();
        }
    }

    protected CertificateAuthority getCA() {
        return this.mCA;
    }

    public Connector getKRAConnector() {
        return this.mKRAConnector;
    }

    public void setKRAConnector(Connector c) {
        this.mKRAConnector = c;
    }

    public Connector getConnector(ConnectorConfig config) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        Connector connector = null;
        if (config == null || config.size() <= 0) {
            return null;
        }
        boolean enable = config.getEnable();
        String extConnector = config.getClassName();
        if (extConnector != null) {
            try {
                connector = (Connector)Class.forName(extConnector).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                connector.setCMSEngine((CMSEngine)engine);
                connector.init();
                return connector;
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_LOAD_CONNECTOR", (Object[])new Object[]{extConnector, e.toString()}), (Throwable)e);
            }
        }
        if (!enable) {
            return null;
        }
        boolean local = config.getLocal();
        IAuthority authority = null;
        if (local) {
            String id = config.getID();
            authority = (IAuthority)engine.getSubsystem(id);
            if (authority == null) {
                String msg = "local authority " + id + " not found.";
                logger.error(CMS.getLogMessage((String)"CMSCORE_CA_AUTHORITY_NOT_FOUND", (Object[])new Object[]{id}));
                throw new EBaseException(msg);
            }
            connector = new LocalConnector(this.mCA, authority);
            connector.setCMSEngine((CMSEngine)engine);
            connector.init();
        } else {
            String host = config.getHost();
            int port = config.getPort();
            String uri = config.getURI();
            Object nickname = config.getNickname();
            if (nickname == null) {
                nickname = cs.getString("ca.subsystem.nickname");
                String tokenname = cs.getString("ca.subsystem.tokenname", "");
                if (!CryptoUtil.isInternalToken((String)tokenname)) {
                    nickname = tokenname + ":" + (String)nickname;
                }
            }
            int resendInterval = config.getResendInterval();
            int timeout = config.getInteger("timeout", 0);
            RemoteAuthority remauthority = new RemoteAuthority(host, port, uri, timeout);
            String clientCiphers = config.getClientCiphers();
            connector = timeout == 0 ? new HttpConnector((String)nickname, clientCiphers, remauthority, resendInterval, config) : new HttpConnector((String)nickname, clientCiphers, remauthority, resendInterval, config, timeout);
            connector.setCMSEngine((CMSEngine)engine);
            connector.init();
        }
        return connector;
    }

    public boolean isProfileRequest(Request request) {
        String profileId = request.getExtDataInString("profileId");
        return profileId != null && !profileId.equals("");
    }

    public void serviceProfileRequest(Request request) throws EBaseException {
        logger.debug("CAService: serviceProfileRequest requestId=" + request.getRequestId().toString());
        String profileId = request.getExtDataInString("profileId");
        if (profileId == null || profileId.equals("")) {
            throw new EBaseException("profileId not found");
        }
        CAEngine engine = CAEngine.getInstance();
        ProfileSubsystem ps = engine.getProfileSubsystem();
        Profile profile = null;
        try {
            profile = ps.getProfile(profileId);
        }
        catch (EProfileException eProfileException) {
            // empty catch block
        }
        if (profile == null) {
            throw new EProfileException("Profile not found " + profileId);
        }
        request.setExtData("dbStatus", "NOT_UPDATED");
        profile.validate(request);
        profile.execute(request);
    }

    public boolean serviceRequest(Request request) {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditRequesterID = this.auditRequesterID();
        RequestId requestId = request.getRequestId();
        boolean completed = false;
        if (this.isProfileRequest(request)) {
            try {
                logger.debug("CAService: x0 requestStatus=" + request.getRequestStatus().toString() + " instance=" + request);
                this.serviceProfileRequest(request);
                request.setExtData("Result", Request.RES_SUCCESS);
                logger.debug("CAService: x1 requestStatus=" + request.getRequestStatus().toString());
                return true;
            }
            catch (EBaseException e) {
                logger.debug("CAService: x2 requestStatus=" + request.getRequestStatus().toString());
                logger.debug("CAService: serviceRequest " + e.toString());
                request.setExtData("Result", Request.RES_ERROR);
                request.setExtData("Error", e.toString());
                return false;
            }
        }
        String type = request.getRequestType();
        IServant servant = this.mServants.get(type);
        if (servant == null) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_INVALID_REQUEST_TYPE", (Object[])new Object[]{type}));
            request.setExtData("Result", Request.RES_ERROR);
            request.setExtData("Error", (Throwable)new ECAException(CMS.getUserMessage((String)"CMS_CA_UNRECOGNIZED_REQUEST_TYPE", (String[])new String[]{type})));
            return true;
        }
        try {
            if (type.equals("enrollment") && this.isPKIArchiveOptionPresent(request) && this.mKRAConnector != null) {
                logger.debug("CAService: Sending enrollment request to KRA");
                auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createSuccessEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null));
                boolean sendStatus = this.mKRAConnector.send(request);
                if (this.mArchivalRequired) {
                    String message;
                    if (!sendStatus) {
                        String message2 = CMS.getUserMessage((String)"CMS_CA_SEND_KRA_REQUEST", (String[])new String[0]);
                        request.setExtData("Result", Request.RES_ERROR);
                        request.setExtData("Error", (Throwable)new ECAException(message2));
                        auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, (String)message2));
                        return true;
                    }
                    if (request.getExtDataInString("Error") != null) {
                        request.setExtData("Result", Request.RES_SUCCESS);
                        request.deleteExtData("Error");
                    }
                    if ((message = request.getExtDataInString("Error")) != null) {
                        auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, (String)message));
                        return true;
                    }
                }
            } else {
                logger.debug("*** NOT Send to KRA type=" + type + " ENROLLMENT=enrollment");
            }
            completed = servant.service(request);
            request.setExtData("Result", Request.RES_SUCCESS);
        }
        catch (EBaseException e) {
            request.setExtData("Result", Request.RES_ERROR);
            request.setExtData("Error", (Throwable)e);
            if (!(type.equals("revocation") || type.equals("unrevocation") || type.equals("CMCRevReq"))) {
                auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, (Exception)((Object)e)));
            }
            return true;
        }
        logger.debug("serviceRequest completed = " + completed);
        if (!(type.equals("revocation") || type.equals("unrevocation") || type.equals("CMCRevReq"))) {
            auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createSuccessEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null));
        }
        return completed;
    }

    private boolean isPKIArchiveOptionPresent(Request request) {
        String crmfBlob = request.getExtDataInString("HTTP_PARAMS", CRMF_REQUEST);
        if (crmfBlob != null) {
            try {
                PKIArchiveOptionsContainer[] opts = CRMFParser.getPKIArchiveOptions((String)crmfBlob);
                if (opts != null) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        logger.debug("CRMF not found");
        return false;
    }

    public X509CertImpl issueX509Cert(AuthorityID aid, X509CertInfo certi, String profileId, String rid) throws EBaseException {
        logger.debug("issueX509Cert");
        X509CertImpl certImpl = this.issueX509Cert(aid, "", certi, false, null);
        logger.debug("storeX509Cert " + certImpl.getSerialNumber());
        this.storeX509Cert(profileId, rid, certImpl);
        logger.debug("done storeX509Cert");
        return certImpl;
    }

    X509CertImpl issueX509Cert(String rid, X509CertInfo certi) throws EBaseException {
        return this.issueX509Cert(rid, certi, false, null);
    }

    void storeX509Cert(String profileId, String rid, X509CertImpl cert) throws EBaseException {
        this.storeX509Cert(rid, cert, false, null, null, null, profileId);
    }

    void storeX509Cert(String rid, X509CertImpl cert, String crmfReqId) throws EBaseException {
        this.storeX509Cert(rid, cert, false, null, crmfReqId, null, null);
    }

    void storeX509Cert(String rid, X509CertImpl cert, String crmfReqId, String challengePassword) throws EBaseException {
        this.storeX509Cert(rid, cert, false, null, crmfReqId, challengePassword, null);
    }

    X509CertImpl issueX509Cert(String rid, X509CertInfo certi, boolean renewal, BigInteger oldSerialNo) throws EBaseException {
        return this.issueX509Cert(null, rid, certi, renewal, oldSerialNo);
    }

    private X509CertImpl issueX509Cert(AuthorityID aid, String rid, X509CertInfo certi, boolean renewal, BigInteger oldSerialNo) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository cr = engine.getCertificateRepository();
        CertificateAuthority ca = engine.getCA(aid);
        if (ca == null) {
            throw new CANotFoundException("No such CA: " + aid);
        }
        String algname = null;
        X509CertImpl cert = null;
        boolean doUTF8 = this.connectorsConfig.getBoolean("dnUTF8Encoding", false);
        logger.debug("dnUTF8Encoding " + doUTF8);
        CertificateExtensions exts = null;
        try {
            if (certi.get("subject") == null || certi.get("key") == null) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_CA_MISSING_ATTR", (Object[])new Object[0]));
                throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_REQD_FIELDS_IN_CERTISSUE", (String[])new String[0]));
            }
            if (certi.get("version") == null) {
                certi.set("version", (Object)engine.getDefaultCertVersion());
            }
            CertificateValidity validity = (CertificateValidity)certi.get("validity");
            Date begin = null;
            Date end = null;
            if (validity != null) {
                begin = (Date)validity.get("notBefore");
                end = (Date)validity.get("notAfter");
            }
            if (validity == null || begin.getTime() == 0L && end.getTime() == 0L) {
                logger.debug("setting default validity");
                begin = new Date();
                end = new Date(begin.getTime() + engine.getDefaultCertValidity());
                certi.set("validity", (Object)new CertificateValidity(begin, end));
            }
            boolean is_ca = false;
            BasicConstraintsExtension bc_ext = null;
            try {
                exts = (CertificateExtensions)certi.get("extensions");
                if (exts != null) {
                    Enumeration e = exts.getAttributes();
                    while (e.hasMoreElements()) {
                        Extension ext = (Extension)e.nextElement();
                        if (!ext.getExtensionId().toString().equals(PKIXExtensions.BasicConstraints_Id.toString())) continue;
                        bc_ext = (BasicConstraintsExtension)ext;
                    }
                    if (bc_ext != null) {
                        Boolean isCA = (Boolean)bc_ext.get("is_ca");
                        is_ca = isCA;
                    }
                }
            }
            catch (Exception e) {
                logger.warn("EnrollDefault: getExtension " + e.toString());
            }
            Date caNotAfter = ca.getSigningUnit().getCertImpl().getNotAfter();
            if (begin.after(caNotAfter)) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_CA_PAST_VALIDITY", (Object[])new Object[0]));
                throw new ECAException(CMS.getUserMessage((String)"CMS_CA_CERT_BEGIN_AFTER_CA_VALIDITY", (String[])new String[0]));
            }
            if (end.after(caNotAfter)) {
                logger.debug("CAService: issueX509Cert: notAfter past CA's NOT_AFTER");
                if (!is_ca) {
                    if (!engine.getEnablePastCATime()) {
                        end = caNotAfter;
                        certi.set("validity", (Object)new CertificateValidity(begin, caNotAfter));
                        logger.debug("CAService: issueX509Cert: ca.enablePastCATime != true...resetting to match CA's notAfter");
                    } else {
                        logger.debug("CAService: issueX509Cert: ca.enablePastCATime = true...not resetting");
                    }
                } else {
                    logger.debug("CAService: issueX509Cert: request issuance of a ca signing cert");
                    if (!engine.getEnablePastCATime_caCert()) {
                        end = caNotAfter;
                        certi.set("validity", (Object)new CertificateValidity(begin, caNotAfter));
                        logger.debug("CAService: issueX509Cert: ca.enablePastCATime_caCert != true...resetting to match CA's notAfter");
                    } else {
                        logger.debug("CAService: issueX509Cert: ca.enablePastCATime_caCert = true...not resetting");
                    }
                }
                logger.info(CMS.getLogMessage((String)"CMSCORE_CA_PAST_NOT_AFTER", (Object[])new Object[0]));
            }
            AlgorithmId algid = null;
            CertificateAlgorithmId algor = (CertificateAlgorithmId)certi.get("algorithmID");
            if (algor == null || algor.toString().equals(CertInfo.SERIALIZE_ALGOR.toString())) {
                algname = ca.getSigningUnit().getDefaultAlgorithm();
                algid = AlgorithmId.get((String)algname);
                certi.set("algorithmID", (Object)new CertificateAlgorithmId(algid));
            } else {
                algid = (AlgorithmId)algor.get("algorithm");
                algname = algid.getName();
            }
        }
        catch (CertificateException e) {
            String message = CMS.getLogMessage((String)"CMSCORE_CA_BAD_FIELD", (Object[])new Object[]{e.toString()});
            logger.error(message, (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_ERROR_GETTING_FIELDS_IN_ISSUE", (String[])new String[0]));
        }
        catch (IOException e) {
            String message = CMS.getLogMessage((String)"CMSCORE_CA_BAD_FIELD", (Object[])new Object[]{e.toString()});
            logger.error(message, (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_ERROR_GETTING_FIELDS_IN_ISSUE", (String[])new String[0]));
        }
        catch (NoSuchAlgorithmException e) {
            String message = CMS.getLogMessage((String)"CMSCORE_CA_SIGNING_ALG_NOT_SUPPORTED", (Object[])new Object[]{algname});
            logger.error(message, (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SIGNING_ALGOR_NOT_SUPPORTED", (String[])new String[]{algname}));
        }
        if (renewal) {
            try {
                CertificateSerialNumber serialno = (CertificateSerialNumber)certi.get("serialNumber");
                if (serialno == null) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_CA_NULL_SERIAL_NUMBER", (Object[])new Object[0]));
                    throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_INFO_IN_RENEWREQ", (String[])new String[0]));
                }
                SerialNumber serialnum = (SerialNumber)serialno.get("number");
                if (serialnum == null) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_CA_NULL_SERIAL_NUMBER", (Object[])new Object[0]));
                    throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_INFO_IN_RENEWREQ", (String[])new String[0]));
                }
            }
            catch (CertificateException e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_CA_NO_ORG_SERIAL", (Object[])new Object[]{e.getMessage()}));
                throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_INFO_IN_RENEWREQ", (String[])new String[0]));
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_CA_NO_ORG_SERIAL", (Object[])new Object[]{e.getMessage()}));
                throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_INFO_IN_RENEWREQ", (String[])new String[0]));
            }
        }
        try {
            BigInteger serialNo = cr.getNextSerialNumber();
            logger.info("CAService: Signing cert 0x" + serialNo.toString(16));
            certi.set("serialNumber", (Object)new CertificateSerialNumber(serialNo));
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_NO_NEXT_SERIAL", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_NOSERIALNO", (String[])new String[]{rid}), (Throwable)e);
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_SET_SERIAL", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SET_SERIALNO_FAILED", (String[])new String[]{rid}), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_SET_SERIAL", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SET_SERIALNO_FAILED", (String[])new String[]{rid}), (Throwable)e);
        }
        try {
            if (ca.getIssuerObj() != null) {
                logger.debug("CAService: issueX509Cert: setting issuerDN using exact CA signing cert subjectDN encoding");
                certi.set("issuer", (Object)ca.getIssuerObj());
            } else {
                logger.debug("CAService: issueX509Cert: ca.getIssuerObj() is null, creating new CertificateIssuerName");
                certi.set("issuer", (Object)new CertificateIssuerName(ca.getX500Name()));
            }
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_SET_ISSUER", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SET_ISSUER_FAILED", (String[])new String[]{rid}), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_SET_ISSUER", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SET_ISSUER_FAILED", (String[])new String[]{rid}), (Throwable)e);
        }
        byte[] utf8_encodingOrder = new byte[]{12};
        if (doUTF8) {
            try {
                logger.debug("doUTF8 true, updating subject.");
                String subject = certi.get("subject").toString();
                certi.set("subject", (Object)new CertificateSubjectName(new X500Name(subject, (LdapDNStrConverter)new LdapV3DNStrConverter(X500NameAttrMap.getDirDefault(), true), utf8_encodingOrder)));
            }
            catch (CertificateException e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_CA_SET_SUBJECT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SET_ISSUER_FAILED", (String[])new String[]{rid}), (Throwable)e);
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_CA_SET_SUBJECT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ECAException(CMS.getUserMessage((String)"CMS_CA_SET_ISSUER_FAILED", (String[])new String[]{rid}), (Throwable)e);
            }
        }
        CTEngine ctEngine = new CTEngine();
        ctEngine.process(certi, this.mCA, aid, algname);
        logger.debug("CAService: issueX509Cert: About to ca.sign cert.");
        cert = ca.sign(certi, algname);
        return cert;
    }

    void storeX509Cert(String rid, X509CertImpl cert, boolean renewal, BigInteger oldSerialNo) throws EBaseException {
        this.storeX509Cert(rid, cert, renewal, oldSerialNo, null, null, null);
    }

    void storeX509Cert(String rid, X509CertImpl cert, boolean renewal, BigInteger oldSerialNo, String crmfReqId, String challengePassword, String profileId) throws EBaseException {
        logger.info("CAService: Storing cert 0x" + cert.getSerialNumber().toString(16));
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository cr = engine.getCertificateRepository();
        try {
            BigInteger newSerialNo = cert.getSerialNumber();
            MetaInfo metaInfo = new MetaInfo();
            if (profileId != null) {
                metaInfo.set("profileId", (Object)profileId);
            }
            if (rid != null) {
                metaInfo.set("requestId", (Object)rid);
            }
            if (challengePassword != null && !challengePassword.equals("")) {
                metaInfo.set(CHALLENGE_PHRASE, (Object)challengePassword);
            }
            if (crmfReqId != null) {
                metaInfo.set("crmfReqId", (Object)crmfReqId);
            }
            if (renewal) {
                metaInfo.set("oldCertSerialNo", (Object)oldSerialNo.toString());
            }
            cr.addCertificateRecord(new CertRecord(newSerialNo, (Certificate)cert, metaInfo));
            if (renewal) {
                logger.info("CAService: Updating old cert 0x" + oldSerialNo.toString(16));
                MetaInfo oldMeta = null;
                CertRecord oldCertRec = cr.readCertificateRecord(oldSerialNo);
                if (oldCertRec == null) {
                    String message = CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{"Cannot read cert record for " + oldSerialNo});
                    EBaseException e = new EBaseException(message);
                    logger.warn(message, (Throwable)e);
                }
                if (oldCertRec != null) {
                    oldMeta = oldCertRec.getMetaInfo();
                }
                if (oldMeta == null) {
                    logger.debug("No meta info! for " + oldSerialNo);
                    oldMeta = new MetaInfo();
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Old meta info");
                    Enumeration n = oldMeta.getElements();
                    while (n.hasMoreElements()) {
                        String name = (String)n.nextElement();
                        logger.debug("name " + name + " value " + oldMeta.get(name));
                    }
                }
                oldMeta.set("renewedCertSerialNo", (Object)newSerialNo.toString());
                ModificationSet modSet = new ModificationSet();
                modSet.add("certAutoRenew", 2, (Object)"DONE");
                modSet.add("certMetaInfo", 2, (Object)oldMeta);
                cr.modifyCertificateRecord(oldSerialNo, modSet);
                logger.info(CMS.getLogMessage((String)"CMSCORE_CA_MARK_SERIAL", (Object[])new Object[]{oldSerialNo.toString(16), newSerialNo.toString(16)}));
                if (logger.isDebugEnabled()) {
                    CertRecord check = cr.readCertificateRecord(oldSerialNo);
                    MetaInfo meta = check.getMetaInfo();
                    Enumeration n = oldMeta.getElements();
                    while (n.hasMoreElements()) {
                        String string = (String)n.nextElement();
                    }
                }
            }
        }
        catch (EBaseException e) {
            String message = CMS.getLogMessage((String)"CMSCORE_CA_NO_STORE_SERIAL", (Object[])new Object[]{cert.getSerialNumber().toString(16)});
            logger.error(message, (Throwable)e);
            throw e;
        }
    }

    public void revokeCert(RevokedCertImpl crlentry) throws EBaseException {
        this.revokeCert(crlentry, null);
    }

    public void revokeCert(RevokedCertImpl crlentry, String requestId) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository cr = engine.getCertificateRepository();
        String method = "CAService.revokeCert";
        BigInteger serialno = crlentry.getSerialNumber();
        Date revdate = crlentry.getRevocationDate();
        CRLExtensions crlentryexts = crlentry.getExtensions();
        String msg = "";
        logger.debug("CAService.revokeCert: begins: serial:" + serialno.toString());
        Enumeration enum1 = crlentryexts.getElements();
        RevocationReason revReason = null;
        while (enum1.hasMoreElements()) {
            Extension ext = (Extension)enum1.nextElement();
            if (!(ext instanceof CRLReasonExtension)) continue;
            revReason = ((CRLReasonExtension)ext).getReason();
            break;
        }
        if (revReason == null) {
            logger.error("CAService.revokeCert:" + CMS.getLogMessage((String)"CMSCORE_CA_MISSING_REV_REASON", (Object[])new Object[]{serialno.toString(16)}));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_REV_REASON", (String[])new String[]{"0x" + serialno.toString(16)}));
        }
        logger.debug("CAService.revokeCert: revocaton request revocation reason: " + revReason.toString());
        CertRecord certRec = cr.readCertificateRecord(serialno);
        if (certRec == null) {
            logger.error("CAService.revokeCert: " + CMS.getLogMessage((String)"CMSCORE_CA_CERT_NOT_FOUND", (Object[])new Object[]{serialno.toString(16)}));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_CANT_FIND_CERT_SERIAL", (String[])new String[]{"0x" + serialno.toString(16)}));
        }
        String certStatus = certRec.getStatus();
        RevocationReason recRevReason = null;
        if (certStatus.equals("REVOKED")) {
            try {
                recRevReason = certRec.getRevReason();
            }
            catch (Exception e) {
                throw new EBaseException(e);
            }
            if (recRevReason == null) {
                msg = "existing revoked cert missing revocation reason";
                logger.error("CAService.revokeCert: " + msg);
                throw new EBaseException(msg);
            }
            logger.debug("CAService.revokeCert: already revoked cert with existing revocation reason:" + recRevReason.toString());
        }
        if (certStatus.equals("REVOKED") && !certRec.isCertOnHold() && (recRevReason != RevocationReason.SUPERSEDED || revReason != RevocationReason.KEY_COMPROMISE) || certStatus.equals("REVOKED_EXPIRED")) {
            logger.debug("CAService.revokeCert: cert already revoked:" + serialno.toString());
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_CERT_ALREADY_REVOKED", (String[])new String[]{"0x" + Long.toHexString(serialno.longValue())}));
        }
        try {
            logger.debug("CAService.revokeCert: about to call markAsRevoked");
            if (certStatus.equals("REVOKED")) {
                cr.markAsRevoked(serialno, new RevocationInfo(revdate, crlentryexts), true);
                logger.debug("CAService.revokeCert: Already-revoked cert marked revoked");
                logger.info(CMS.getLogMessage((String)"CMSCORE_CA_CERT_REVO_INFO_UPDATE", (Object[])new Object[]{recRevReason.toString(), revReason.toString(), serialno.toString(16)}));
            } else {
                cr.markAsRevoked(serialno, new RevocationInfo(revdate, crlentryexts));
            }
            logger.info(CMS.getLogMessage((String)"CMSCORE_CA_CERT_REVOKED", (Object[])new Object[]{serialno.toString(16)}));
            for (CRLIssuingPoint ip : engine.getCRLIssuingPoints()) {
                String profileId;
                MetaInfo metaInfo;
                X509CertImpl cert;
                if (ip == null) continue;
                boolean b = true;
                if (ip.isCACertsOnly() && (cert = certRec.getCertificate()) != null) {
                    b = cert.getBasicConstraintsIsCA();
                }
                if (ip.isProfileCertsOnly() && (metaInfo = certRec.getMetaInfo()) != null && (profileId = (String)metaInfo.get("profileId")) != null) {
                    b = ip.checkCurrentProfile(profileId);
                }
                if (!b) continue;
                ip.addRevokedCert(serialno, crlentry, requestId);
            }
        }
        catch (EBaseException e) {
            String message = CMS.getLogMessage((String)"CMSCORE_CA_ERROR_REVOCATION", (Object[])new Object[]{serialno.toString(), e.toString()});
            logger.error("CAService.revokeCert:" + message, (Throwable)e);
            throw e;
        }
    }

    void unrevokeCert(BigInteger serialNo) throws EBaseException {
        this.unrevokeCert(serialNo, null);
    }

    void unrevokeCert(BigInteger serialNo, String requestId) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository cr = engine.getCertificateRepository();
        CertRecord certRec = cr.readCertificateRecord(serialNo);
        if (certRec == null) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CERT_NOT_FOUND", (Object[])new Object[]{serialNo.toString(16)}));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_CANT_FIND_CERT_SERIAL", (String[])new String[]{"0x" + serialNo.toString(16)}));
        }
        RevocationInfo revInfo = certRec.getRevocationInfo();
        CRLExtensions exts = null;
        CRLReasonExtension reasonext = null;
        if (revInfo == null) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CERT_ON_HOLD", (Object[])new Object[]{serialNo.toString()}));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_IS_NOT_ON_HOLD", (String[])new String[]{serialNo.toString()}));
        }
        exts = revInfo.getCRLEntryExtensions();
        if (exts != null) {
            try {
                reasonext = (CRLReasonExtension)exts.get("CRLReason");
            }
            catch (X509ExtensionException e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CERT_ON_HOLD", (Object[])new Object[]{serialNo.toString()}), (Throwable)e);
                throw new ECAException(CMS.getUserMessage((String)"CMS_CA_IS_NOT_ON_HOLD", (String[])new String[]{serialNo.toString()}), (Throwable)e);
            }
        } else {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CERT_ON_HOLD", (Object[])new Object[]{serialNo.toString()}));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_IS_NOT_ON_HOLD", (String[])new String[]{serialNo.toString()}));
        }
        if ((certRec.getStatus().equals("REVOKED") || certRec.getStatus().equals("REVOKED_EXPIRED")) && reasonext != null && reasonext.getReason() == RevocationReason.CERTIFICATE_HOLD) {
            try {
                cr.unmarkRevoked(serialNo, revInfo, certRec.getRevokedOn(), certRec.getRevokedBy());
                logger.info(CMS.getLogMessage((String)"CMSCORE_CA_CERT_UNREVOKED", (Object[])new Object[]{serialNo.toString(16)}));
                for (CRLIssuingPoint ip : engine.getCRLIssuingPoints()) {
                    String profileId;
                    MetaInfo metaInfo;
                    X509CertImpl cert;
                    if (ip == null) continue;
                    boolean b = true;
                    if (ip.isCACertsOnly() && (cert = certRec.getCertificate()) != null) {
                        b = cert.getBasicConstraintsIsCA();
                    }
                    if (ip.isProfileCertsOnly() && (metaInfo = certRec.getMetaInfo()) != null && (profileId = (String)metaInfo.get("profileId")) != null) {
                        b = ip.checkCurrentProfile(profileId);
                    }
                    if (!b) continue;
                    ip.addUnrevokedCert(serialNo, requestId);
                }
            }
            catch (EBaseException e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CERT_ERROR_UNREVOKE", (Object[])new Object[]{serialNo.toString(16)}), (Throwable)e);
                throw e;
            }
        } else {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CERT_ON_HOLD", (Object[])new Object[]{serialNo.toString()}));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_IS_NOT_ON_HOLD", (String[])new String[]{"0x" + serialNo.toString(16)}));
        }
    }

    private String auditSubjectID() {
        String subjectID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        subjectID = auditContext != null ? ((subjectID = (String)auditContext.get((Object)"userid")) != null ? subjectID.trim() : "$NonRoleUser$") : "$Unidentified$";
        return subjectID;
    }

    private String auditRequesterID() {
        String requesterID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        requesterID = auditContext != null ? ((requesterID = (String)auditContext.get((Object)"requesterID")) != null ? requesterID.trim() : "$Unidentified$") : "$Unidentified$";
        return requesterID;
    }
}

