/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CAService;
import com.netscape.ca.IServant;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ca.ECAException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceIssue
implements IServant {
    public static Logger logger = LoggerFactory.getLogger(ServiceIssue.class);
    private CAService mService;

    public ServiceIssue(CAService service) {
        this.mService = service;
    }

    @Override
    public boolean service(Request request) throws EBaseException {
        boolean requestContentsAreNull = request.getExtDataInCertInfoArray("CERT_INFO") == null;
        return !requestContentsAreNull && this.serviceX509(request);
    }

    public boolean serviceX509(Request request) throws EBaseException {
        int i;
        X509CertInfo[] certinfos = request.getExtDataInCertInfoArray("CERT_INFO");
        if (certinfos == null || certinfos[0] == null) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CERT_REQUEST_NOT_FOUND", (Object[])new Object[]{request.getRequestId().toString()}));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_INFO_IN_ISSUEREQ", (String[])new String[0]));
        }
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository cr = engine.getCertificateRepository();
        String challengePassword = request.getExtDataInString("challengePhrase");
        X509CertImpl[] certs = new X509CertImpl[certinfos.length];
        String rid = request.getRequestId().toString();
        for (i = 0; i < certinfos.length; ++i) {
            try {
                certs[i] = this.mService.issueX509Cert(rid, certinfos[i]);
                continue;
            }
            catch (EBaseException e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_CA_ISSUE_ERROR", (Object[])new Object[]{Integer.toString(i), rid, e.toString()}), (Throwable)e);
                throw e;
            }
        }
        String crmfReqId = request.getExtDataInString("crmfReqId");
        EBaseException ex = null;
        for (i = 0; i < certs.length; ++i) {
            try {
                this.mService.storeX509Cert(rid, certs[i], crmfReqId, challengePassword);
                continue;
            }
            catch (EBaseException e) {
                String message = CMS.getLogMessage((String)"CMSCORE_CA_STORE_ERROR", (Object[])new Object[]{Integer.toString(i), rid, e.toString()});
                logger.warn(message, (Throwable)e);
                ex = e;
                break;
            }
        }
        if (ex != null) {
            for (int j = 0; j < i; ++j) {
                BigInteger serialNo = certs[i].getSerialNumber();
                try {
                    cr.deleteCertificateRecord(serialNo);
                    continue;
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_DELETE_CERT_ERROR", (Object[])new Object[]{serialNo.toString(), e.toString()}), (Throwable)e);
                }
            }
            throw ex;
        }
        request.setExtData("issuedCerts", certs);
        return true;
    }
}

