/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapAnonConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class nsNKeySubjectNameDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(nsNKeySubjectNameDefault.class);
    public static final String PROP_LDAP = "ldap";
    public static final String PROP_PARAMS = "params";
    public static final String CONFIG_DNPATTERN = "dnpattern";
    public static final String CONFIG_LDAP_STRING_ATTRS = "ldapStringAttributes";
    public static final String CONFIG_LDAP_HOST = "ldap.ldapconn.host";
    public static final String CONFIG_LDAP_PORT = "ldap.ldapconn.port";
    public static final String CONFIG_LDAP_SEC_CONN = "ldap.ldapconn.secureConn";
    public static final String CONFIG_LDAP_VER = "ldap.ldapconn.Version";
    public static final String CONFIG_LDAP_BASEDN = "ldap.basedn";
    public static final String CONFIG_LDAP_MIN_CONN = "ldap.minConns";
    public static final String CONFIG_LDAP_MAX_CONN = "ldap.maxConns";
    public static final String VAL_NAME = "name";
    public static final String CONFIG_LDAP_VERS = "2,3";
    protected static String DEFAULT_DNPATTERN = "CN=$request.aoluid$, E=$request.mail$";
    boolean mInitialized = false;
    protected ConfigStore mInstConfig;
    protected LDAPConfig mLdapConfig;
    protected ConfigStore mParamsConfig;
    protected String mBaseDN = null;
    protected LdapAnonConnFactory mConnFactory;
    protected String[] mLdapStringAttrs = null;

    public nsNKeySubjectNameDefault() {
        this.addConfigName(CONFIG_DNPATTERN);
        this.addConfigName(CONFIG_LDAP_STRING_ATTRS);
        this.addConfigName(CONFIG_LDAP_HOST);
        this.addConfigName(CONFIG_LDAP_PORT);
        this.addConfigName(CONFIG_LDAP_SEC_CONN);
        this.addConfigName(CONFIG_LDAP_VER);
        this.addConfigName(CONFIG_LDAP_BASEDN);
        this.addConfigName(CONFIG_LDAP_MIN_CONN);
        this.addConfigName(CONFIG_LDAP_MAX_CONN);
        this.addValueName(CONFIG_DNPATTERN);
        this.addValueName(CONFIG_LDAP_STRING_ATTRS);
        this.addValueName(CONFIG_LDAP_HOST);
        this.addValueName(CONFIG_LDAP_PORT);
        this.addValueName(CONFIG_LDAP_SEC_CONN);
        this.addValueName(CONFIG_LDAP_VER);
        this.addValueName(CONFIG_LDAP_BASEDN);
        this.addValueName(CONFIG_LDAP_MIN_CONN);
        this.addValueName(CONFIG_LDAP_MAX_CONN);
    }

    @Override
    public void init(CAEngineConfig engineConfig, ConfigStore config) throws EProfileException {
        super.init(engineConfig, config);
        this.mInstConfig = config;
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        logger.debug("nsNKeySubjectNameDefault: in getConfigDescriptor, name=" + name);
        if (name.equals(CONFIG_DNPATTERN)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_STRING_ATTRS)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NSNKEY_LDAP_STRING_ATTRS", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_HOST)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NSNKEY_HOST_NAME", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_PORT)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NSNKEY_PORT_NUMBER", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_SEC_CONN)) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NSNKEY_SECURE_CONN", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_VER)) {
            return new Descriptor("choice", CONFIG_LDAP_VERS, "3", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NSNKEY_LDAP_VERSION", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_BASEDN)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NSNKEY_BASEDN", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_MIN_CONN)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NSNKEY_LDAP_MIN_CONN", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LDAP_MAX_CONN)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NSNKEY_LDAP_MAX_CONN", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        logger.debug("nsNKeySubjectNameDefault: in getValueDescriptor name=" + name);
        if (name.equals(VAL_NAME)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        logger.debug("nsNKeySubjectNameDefault: in setValue, value=" + value);
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_NAME)) {
            X500Name x500name = null;
            try {
                x500name = new X500Name(value);
            }
            catch (IOException e) {
                logger.warn("nsNKeySubjectNameDefault: setValue " + e.getMessage(), (Throwable)e);
            }
            logger.debug("nsNKeySubjectNameDefault: setValue name=" + x500name);
            try {
                info.set("subject", (Object)new CertificateSubjectName(x500name));
            }
            catch (Exception e) {
                logger.error("nsNKeySubjectNameDefault: setValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        logger.debug("nsNKeySubjectNameDefault: in getValue, name=" + name);
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_NAME)) {
            CertificateSubjectName sn = null;
            try {
                logger.debug("nsNKeySubjectNameDefault: getValue info=" + info);
                sn = (CertificateSubjectName)info.get("subject");
                logger.debug("nsNKeySubjectNameDefault: getValue name=" + sn);
                return sn.toString();
            }
            catch (Exception e) {
                logger.warn("nsNKeySubjectNameDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        logger.debug("nsNKeySubjectNameDefault: in getText");
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[]{this.getConfig(CONFIG_DNPATTERN)});
    }

    public void ldapInit() throws EProfileException {
        if (this.mInitialized) {
            return;
        }
        logger.debug("nsNKeySubjectNameDefault: ldapInit(): begin");
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        PKISocketConfig socketConfig = cs.getSocketConfig();
        try {
            String ldapStringAttrs;
            this.mParamsConfig = this.mInstConfig.getSubStore(PROP_PARAMS, ConfigStore.class);
            this.mLdapConfig = (LDAPConfig)this.mParamsConfig.getSubStore(PROP_LDAP, LDAPConfig.class);
            this.mBaseDN = this.mParamsConfig.getString(CONFIG_LDAP_BASEDN, null);
            this.mConnFactory = new LdapAnonConnFactory("nsNKeySubjectNameDefault");
            this.mConnFactory.setCMSEngine((CMSEngine)engine);
            this.mConnFactory.init(socketConfig, this.mLdapConfig);
            String pattern = this.mParamsConfig.getString(CONFIG_DNPATTERN, null);
            if (pattern == null || pattern.length() == 0) {
                pattern = DEFAULT_DNPATTERN;
            }
            if ((ldapStringAttrs = this.mParamsConfig.getString(CONFIG_LDAP_STRING_ATTRS, null)) != null && ldapStringAttrs.length() != 0) {
                StringTokenizer pAttrs = new StringTokenizer(ldapStringAttrs, ",", false);
                this.mLdapStringAttrs = new String[pAttrs.countTokens()];
                for (int i = 0; i < this.mLdapStringAttrs.length; ++i) {
                    this.mLdapStringAttrs[i] = ((String)pAttrs.nextElement()).trim();
                }
            }
            logger.debug("nsNKeySubjectNameDefault: ldapInit(): done");
            this.mInitialized = true;
        }
        catch (Exception e) {
            logger.error("nsNKeySubjectNameDefault: ldapInit(): " + e.getMessage(), (Throwable)e);
            throw new EProfileException("ldap init failure: " + e.toString());
        }
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        X500Name name = null;
        logger.debug("nsNKeySubjectNameDefault: in populate");
        this.ldapInit();
        try {
            String subjectName = this.getSubjectName(request);
            logger.debug("subjectName=" + subjectName);
            if (subjectName == null || subjectName.equals("")) {
                return;
            }
            name = new X500Name(subjectName);
        }
        catch (IOException e) {
            logger.warn("nsNKeySubjectNameDefault: populate " + e.getMessage(), (Throwable)e);
        }
        if (name == null) {
            // empty if block
        }
        try {
            info.set("subject", (Object)new CertificateSubjectName(name));
        }
        catch (Exception e) {
            logger.warn("nsNKeySubjectNameDefault: populate " + e.getMessage(), (Throwable)e);
        }
    }

    private String getSubjectName(Request request) throws EProfileException, IOException {
        logger.debug("nsNKeySubjectNameDefault: in getSubjectName");
        String pattern = this.getConfig(CONFIG_DNPATTERN);
        if (pattern == null || pattern.equals("")) {
            pattern = " ";
        }
        LDAPConnection conn = null;
        String userdn = null;
        String sbjname = "";
        try {
            if (this.mConnFactory == null) {
                conn = null;
                logger.error("nsNKeySubjectNameDefault: getSubjectName(): no LDAP connection");
                throw new EProfileException("no LDAP connection");
            }
            conn = this.mConnFactory.getConn();
            if (conn == null) {
                logger.error("nsNKeySubjectNameDefault::getSubjectName() - no LDAP connection");
                throw new EProfileException("no LDAP connection");
            }
            logger.debug("nsNKeySubjectNameDefault: getSubjectName(): got LDAP connection");
            if (request == null) {
                logger.error("nsNKeySubjectNameDefault::getSubjectName() - request is null!");
                throw new EProfileException("request is null");
            }
            logger.debug("pattern = " + pattern);
            sbjname = this.mapPattern(request, pattern);
            logger.debug("nsNKeySubjectNameDefault: getSubjectName(): subject name mapping done");
            logger.debug("nsNKeySubjectNameDefault: getSubjectName(): about to search with basedn = " + this.mBaseDN);
            LDAPSearchResults res = conn.search(this.mBaseDN, 2, "(aoluid=" + request.getExtDataInString("aoluid") + ")", null, false);
            if (!res.hasMoreElements()) {
                logger.error("nsNKeySubjectNameDefault: getSubjectName(): screen name does not exist");
                throw new EProfileException("screenname does not exist");
            }
            LDAPEntry entry = res.next();
            userdn = entry.getDN();
            logger.debug("nsNKeySubjectNameDefault: getSubjectName(): retrieved entry for aoluid = " + request.getExtDataInString("aoluid"));
            entry = null;
            logger.debug("nsNKeySubjectNameDefault: getSubjectName(): about to search with " + this.mLdapStringAttrs.length + " attributes");
            LDAPSearchResults results = conn.search(userdn, 0, "objectclass=*", this.mLdapStringAttrs, false);
            if (!results.hasMoreElements()) {
                logger.error("nsNKeySubjectNameDefault: getSubjectName(): no attributes");
                throw new EProfileException("no ldap attributes found");
            }
            entry = results.next();
            for (int i = 0; i < this.mLdapStringAttrs.length; ++i) {
                LDAPAttribute la = entry.getAttribute(this.mLdapStringAttrs[i]);
                if (la == null) continue;
                String[] sla = la.getStringValueArray();
                logger.debug("nsNKeySubjectNameDefault: getSubjectName(): got attribute: " + sla[0]);
                request.setExtData(this.mLdapStringAttrs[i], sla[0]);
            }
            logger.debug("nsNKeySubjectNameDefault: getSubjectName(): attributes set in request");
        }
        catch (Exception e) {
            logger.error("nsNKeySubjectNameDefault: getSubjectName(): " + e.getMessage(), (Throwable)e);
            throw new EProfileException("getSubjectName() failure: " + e.toString());
        }
        finally {
            try {
                if (conn != null) {
                    this.mConnFactory.returnConn(conn);
                }
            }
            catch (Exception e) {
                throw new EProfileException("nsNKeySubjectNameDefault: getSubjectName(): connection return failure");
            }
        }
        return sbjname;
    }
}

