/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.mappers;

import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.publish.ECompSyntaxErr;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPDN;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.AVA;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.LdapV3DNStrConverter;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.SubjectAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MapAVAPattern {
    public static Logger logger = LoggerFactory.getLogger(MapAVAPattern.class);
    public static final String TYPE_REQ = "$req";
    public static final String TYPE_SUBJ = "$subj";
    public static final String TYPE_EXT = "$ext";
    public static final String TYPE_RDN = "$rdn";
    public static final String TYPE_CONSTANT = "constant";
    public static final String[] GENERAL_NAME_TYPE = new String[]{"ANY", "RFC822Name", "DNSName", "X400Name", "DIRECTORYName", "EDIName", "URIName", "IPAddress", "OIDName"};
    private static final LdapV3DNStrConverter mLdapDNStrConverter = new LdapV3DNStrConverter();
    protected String[] mReqAttrs = null;
    protected String[] mCertAttrs = null;
    protected String mType = null;
    protected String mAttr = null;
    protected String mValue = null;
    protected String mGNType = null;
    protected String mPrefix = null;
    protected int mElement = 0;
    protected String mTestDN = null;

    public MapAVAPattern(String component) throws ELdapException {
        if (component == null || component.length() == 0) {
            throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{component}));
        }
        this.parse(new PushbackReader(new StringReader(component)));
    }

    public MapAVAPattern(PushbackReader in) throws ELdapException {
        this.parse(in);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse(PushbackReader in) throws ELdapException {
        int c;
        try {
            while ((c = in.read()) == 32 || c == 9) {
            }
        }
        catch (IOException e) {
            throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"All blank"}));
        }
        if (c == -1) {
            throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"All blank"}));
        }
        if (c == 36) {
            this.mType = TYPE_RDN;
            try {
                if (in.read() != 114 || in.read() != 100 || in.read() != 110 || in.read() != 46) {
                    throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"Invalid $ syntax, expecting $rdn"}));
                }
            }
            catch (IOException e) {
                throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"Invalid $ syntax, expecting $rdn"}));
            }
            StringBuffer rdnNumberBuf = new StringBuffer();
            try {
                while ((c = in.read()) != 44 && c != -1 && c != 43) {
                    rdnNumberBuf.append((char)c);
                }
                if (c != -1) {
                    in.unread(c);
                }
            }
            catch (IOException e) {
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
            }
            String rdnNumber = rdnNumberBuf.toString().trim();
            if (rdnNumber.length() == 0) {
                throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"$rdn number not set in ava pattern"}));
            }
            try {
                this.mElement = Integer.parseInt(rdnNumber) - 1;
                return;
            }
            catch (NumberFormatException e) {
                throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"Invalid $rdn number in ava pattern"}));
            }
        }
        StringBuffer attrBuf = new StringBuffer();
        try {
            while (c != 61 && c != -1 && c != 44 && c != 43) {
                attrBuf.append((char)c);
                c = in.read();
            }
            if (c == 44 || c == 43) {
                in.unread(c);
            }
        }
        catch (IOException e) {
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
        }
        if (c != 61) {
            throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"Missing \"=\" in ava pattern"}));
        }
        try {
            while ((c = in.read()) == 32 || c == 9) {
            }
        }
        catch (IOException e) {
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
        }
        if (c == -1) {
            throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"no value after = in ava pattern"}));
        }
        if (c == 36) {
            try {
                c = in.read();
            }
            catch (IOException e) {
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
            }
            if (c == -1) {
                throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"expecting $subj or $req in ava pattern"}));
            }
            if (c == 114) {
                try {
                    if (in.read() != 101 || in.read() != 113 || in.read() != 46) {
                        throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"expecting $req in ava pattern"}));
                    }
                }
                catch (IOException e) {
                    throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
                }
                this.mType = TYPE_REQ;
            } else if (c == 115) {
                try {
                    if (in.read() != 117 || in.read() != 98 || in.read() != 106 || in.read() != 46) {
                        throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"expecting $subj in ava pattern"}));
                    }
                }
                catch (IOException e) {
                    throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
                }
                this.mType = TYPE_SUBJ;
            } else {
                if (c != 101) throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"unknown keyword. expecting $subj $ext or $req."}));
                try {
                    if (in.read() != 120 || in.read() != 116 || in.read() != 46) {
                        throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"expecting $ext in ava pattern"}));
                    }
                }
                catch (IOException e) {
                    throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
                }
                this.mType = TYPE_EXT;
            }
            String attrName = attrBuf.toString().trim();
            if (attrName.length() == 0) {
                throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"attribute name expected"}));
            }
            this.mAttr = attrName;
            StringBuffer valueBuf = new StringBuffer();
            try {
                while ((c = in.read()) != 44 && c != -1 && c != 46 && c != 43) {
                    valueBuf.append((char)c);
                }
                if (c == 43 || c == 44) {
                    in.unread(c);
                }
            }
            catch (IOException e) {
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
            }
            this.mValue = valueBuf.toString().trim();
            if (this.mValue.length() == 0) {
                throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"$subj or $req attribute name expected"}));
            }
            if (c != 46) return;
            StringBuffer attrNumberBuf = new StringBuffer();
            try {
                while ((c = in.read()) != 44 && c != -1 && c != 46 && c != 43) {
                    attrNumberBuf.append((char)c);
                }
                if (c == 44 || c == 43) {
                    in.unread(c);
                }
            }
            catch (IOException e) {
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
            }
            String attrNumber = attrNumberBuf.toString().trim();
            if (attrNumber.length() == 0) {
                throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"nth element $req $ext or $subj expected"}));
            }
            try {
                this.mElement = Integer.parseInt(attrNumber) - 1;
                return;
            }
            catch (NumberFormatException e) {
                if (TYPE_REQ.equals(this.mType)) {
                    this.mPrefix = this.mValue;
                    this.mValue = attrNumber;
                } else {
                    if (!TYPE_EXT.equals(this.mType)) throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"Invalid format in nth element $req $ext or $subj"}));
                    this.mGNType = attrNumber;
                }
                if (c != 46) return;
                StringBuffer attrNumberBuf1 = new StringBuffer();
                try {
                    while ((c = in.read()) != 44 && c != -1 && c != 43) {
                        attrNumberBuf1.append((char)c);
                    }
                    if (c != -1) {
                        in.unread(c);
                    }
                }
                catch (IOException ex) {
                    throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{ex.toString()}));
                }
                String attrNumber1 = attrNumberBuf1.toString().trim();
                if (attrNumber1.length() == 0) {
                    throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"nth element $req expected"}));
                }
                try {
                    this.mElement = Integer.parseInt(attrNumber1) - 1;
                    return;
                }
                catch (NumberFormatException ex) {
                    throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{"Invalid format in nth element $req."}));
                }
            }
        }
        this.mType = TYPE_CONSTANT;
        StringBuffer valueBuf = new StringBuffer();
        valueBuf.append((char)c);
        try {
            while ((c = in.read()) != 44 && c != -1) {
                valueBuf.append((char)c);
            }
            if (c == 43 || c == 44) {
                in.unread(c);
            }
        }
        catch (IOException e) {
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
        }
        try {
            AVA ava = mLdapDNStrConverter.parseAVA(attrBuf + "=" + valueBuf);
            this.mValue = ava.toLdapDNString();
            return;
        }
        catch (IOException e) {
            throw new ECompSyntaxErr(CMS.getUserMessage((String)"CMS_AUTHENTICATION_COMPONENT_SYNTAX", (String[])new String[]{e.toString()}));
        }
    }

    public String formAVA(Request req, X500Name subject, CertificateExtensions extensions) throws ELdapException {
        if (TYPE_CONSTANT.equals(this.mType)) {
            return this.mValue;
        }
        if (TYPE_RDN.equals(this.mType)) {
            String[] rdns;
            String dn = subject.toString();
            if (this.mTestDN != null) {
                dn = this.mTestDN;
            }
            if (this.mElement >= (rdns = LDAPDN.explodeDN((String)dn, (boolean)false)).length) {
                return null;
            }
            return rdns[this.mElement];
        }
        if (TYPE_SUBJ.equals(this.mType)) {
            String dn = subject.toString();
            if (this.mTestDN != null) {
                dn = this.mTestDN;
            }
            String[] rdns = LDAPDN.explodeDN((String)dn, (boolean)false);
            String value = null;
            int nFound = -1;
            block2: for (int i = 0; i < rdns.length; ++i) {
                String[] avas = MapAVAPattern.explodeRDN(rdns[i]);
                for (int j = 0; j < avas.length; ++j) {
                    String[] exploded = MapAVAPattern.explodeAVA(avas[j]);
                    if (!exploded[0].equalsIgnoreCase(this.mValue) || ++nFound != this.mElement) continue;
                    value = exploded[1];
                    continue block2;
                }
            }
            if (value == null) {
                logger.warn("MapAVAPattern: attr " + this.mAttr + " not formed from: cert subject " + dn + "-- no subject component : " + this.mValue);
                return null;
            }
            return this.mAttr + "=" + value;
        }
        if (TYPE_EXT.equals(this.mType)) {
            if (extensions != null) {
                for (int i = 0; i < extensions.size(); ++i) {
                    Extension ext = (Extension)extensions.elementAt(i);
                    String extName = OIDMap.getName((ObjectIdentifier)ext.getExtensionId());
                    int index = extName.lastIndexOf(".");
                    if (index != -1) {
                        extName = extName.substring(index + 1);
                    }
                    if (!extName.equals(this.mValue) || !this.mValue.equalsIgnoreCase("SubjectAlternativeName")) continue;
                    try {
                        GeneralName gn;
                        String gname;
                        GeneralNames subjectNames = (GeneralNames)((SubjectAlternativeNameExtension)ext).get("subject_name");
                        if (subjectNames.size() == 0) break;
                        int j = 0;
                        Enumeration n = subjectNames.elements();
                        while (n.hasMoreElements() && (index = (gname = (gn = (GeneralName)n.nextElement()).toString()).indexOf(":")) != -1) {
                            String gType = gname.substring(0, index);
                            if (this.mGNType != null) {
                                if (!this.mGNType.equalsIgnoreCase(gType)) continue;
                                if (this.mElement == j) {
                                    gname = gname.substring(index + 2);
                                    return this.mAttr + "=" + gname;
                                }
                                ++j;
                                continue;
                            }
                            if (this.mElement == j) {
                                gname = gname.substring(index + 2);
                                return this.mAttr + "=" + gname;
                            }
                            ++j;
                        }
                        continue;
                    }
                    catch (IOException e) {
                        logger.warn("MapAVAPattern: Publishing attr not formed from extension.-- no attr : " + this.mValue + ": " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            logger.debug("MapAVAPattern: Publishing:attr not formed from extension -- no attr : " + this.mValue);
            return null;
        }
        if (TYPE_REQ.equals(this.mType)) {
            String reqAttr = req.getExtDataInString(this.mPrefix, this.mValue);
            if (reqAttr == null) {
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_REQUEST", (String[])new String[]{this.mValue, this.mAttr}));
            }
            return this.mAttr + "=" + reqAttr;
        }
        return null;
    }

    public String getReqAttr() {
        return TYPE_REQ.equals(this.mType) ? this.mValue : null;
    }

    public String getCertAttr() {
        return TYPE_SUBJ.equals(this.mType) ? this.mValue : null;
    }

    public static String[] explodeRDN(String rdn) {
        int plus = rdn.indexOf(43);
        if (plus == -1) {
            return new String[]{rdn};
        }
        Vector<String> avas = new Vector<String>();
        StringTokenizer token = new StringTokenizer(rdn, "+");
        while (token.hasMoreTokens()) {
            avas.addElement(token.nextToken());
        }
        Object[] theAvas = new String[avas.size()];
        avas.copyInto(theAvas);
        return theAvas;
    }

    public static String[] explodeAVA(String ava) {
        int equals = ava.indexOf(61);
        if (equals == -1) {
            return null;
        }
        return new String[]{ava.substring(0, equals).trim(), ava.substring(equals + 1).trim()};
    }
}

