/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.base.BadRequestDataException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileInput;
import com.netscape.cms.servlet.cert.CertProcessor;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.profile.SSLClientCertProvider;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrollmentProcessor
extends CertProcessor {
    public static Logger logger = LoggerFactory.getLogger(EnrollmentProcessor.class);

    public EnrollmentProcessor(String id, Locale locale) {
        super(id, locale);
    }

    private void setInputsIntoContext(CertEnrollmentRequest data, Profile profile, Map<String, String> ctx) {
        HashMap<String, String> dataInputs = new HashMap<String, String>();
        for (com.netscape.certsrv.profile.ProfileInput input : data.getInputs()) {
            for (ProfileAttribute attr : input.getAttributes()) {
                dataInputs.put(attr.getName(), attr.getValue());
            }
        }
        Enumeration<String> inputIds = profile.getProfileInputIds();
        if (inputIds != null) {
            while (inputIds.hasMoreElements()) {
                String inputId = inputIds.nextElement();
                ProfileInput profileInput = profile.getProfileInput(inputId);
                Enumeration<String> inputNames = profileInput.getValueNames();
                while (inputNames.hasMoreElements()) {
                    String inputName = inputNames.nextElement();
                    if (!dataInputs.containsKey(inputName)) continue;
                    if (inputName.matches("^sn_.*")) {
                        ctx.put(inputName, LDAPUtil.escapeRDNValue(dataInputs.get(inputName)));
                        continue;
                    }
                    ctx.put(inputName, (String)dataInputs.get(inputName));
                }
            }
        }
    }

    public HashMap<String, Object> processEnrollment(CertEnrollmentRequest data, HttpServletRequest request, AuthorityID aid, AuthCredentials credentials) throws Exception {
        return this.processEnrollment(data, request, aid, credentials, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> processEnrollment(CertEnrollmentRequest data, HttpServletRequest request, AuthorityID aid, AuthCredentials credentials, AuthToken authToken) throws Exception {
        try {
            if (logger.isDebugEnabled()) {
                HashMap params = data.toParams();
                this.printParameterValues(params);
            }
            logger.debug("EnrollmentProcessor: isRenewal false");
            this.startTiming("enrollment");
            String profileId = this.profileID == null ? data.getProfileId() : this.profileID;
            logger.debug("EnrollmentProcessor: profileId " + profileId);
            Profile profile = this.ps.getProfile(profileId);
            if (profile == null) {
                logger.error(CMS.getUserMessage((Locale)this.locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)profileId)}));
                throw new BadRequestDataException(CMS.getUserMessage((Locale)this.locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)profileId)}));
            }
            if (!this.ps.isProfileEnable(profileId)) {
                logger.error("EnrollmentProcessor: Profile " + profileId + " not enabled");
                throw new BadRequestDataException("Profile " + profileId + " not enabled");
            }
            HashMap<String, String> ctx = new HashMap<String, String>();
            String userData = null;
            if (request != null) {
                userData = request.getParameter("user-data");
            }
            if (userData != null) {
                ctx.put("req_user_data", userData);
            }
            if (aid != null) {
                ctx.put("req_authority_id", aid.toString());
            }
            logger.debug("EnrollmentProcessor: set Inputs into profile Context");
            this.setInputsIntoContext(data, profile, ctx);
            AuthManager authenticator = this.ps.getProfileAuthenticator(profile);
            if (authenticator != null) {
                logger.debug("EnrollmentProcessor: authenticator " + authenticator.getName() + " found");
                this.setCredentialsIntoContext(request, credentials, authenticator, ctx);
            }
            SessionContext context = SessionContext.getContext();
            context.put((Object)"profileContext", ctx);
            context.put((Object)"sslClientCertProvider", (Object)new SSLClientCertProvider(request));
            logger.debug("EnrollmentProcessor: set sslClientCertProvider");
            if (authToken == null && authenticator != null) {
                authToken = this.authenticate(request, null, authenticator, context, false, credentials);
            }
            this.authorize(profileId, profile, authToken);
            this.startTiming("request_population");
            Request[] reqs = profile.createRequests(ctx, this.locale);
            this.populateRequests(data, false, this.locale, null, null, null, profileId, profile, ctx, authenticator, authToken, reqs);
            this.endTiming("request_population");
            for (Request request2 : reqs) {
                String realm = request2.getRealm();
                if (!StringUtils.isNotBlank((CharSequence)realm)) continue;
                this.authz.checkRealm(realm, authToken, null, "certServer.ca.request.enrollment", "submit");
            }
            String errorCode = this.submitRequests(this.locale, profile, authToken, reqs);
            String errorReason = null;
            ArrayList<String> errors = new ArrayList<String>();
            if (errorCode != null) {
                for (Request req : reqs) {
                    String error = req.getError(this.locale);
                    if (error == null) continue;
                    String code = req.getErrorCode(this.locale);
                    errors.add(this.codeToReason(this.locale, code, error, req.getRequestId()));
                }
                errorReason = StringUtils.join(errors, (char)'\n');
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("requests", reqs);
            hashMap.put("errorCode", errorCode);
            hashMap.put("errorReason", errorReason);
            hashMap.put("profile", profile);
            logger.debug("EnrollmentSubmitter: done serving");
            this.endTiming("enrollment");
            HashMap<String, Object> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            SessionContext.releaseContext();
            this.endAllEvents();
        }
    }
}

