/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.request;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.RawJS;
import com.netscape.cms.servlet.request.ReqParser;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.request.Request;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.netscape.security.extensions.NSCertTypeExtension;
import org.mozilla.jss.netscape.security.util.CertPrettyPrint;
import org.mozilla.jss.netscape.security.util.ExtPrettyPrint;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertReqParser
extends ReqParser {
    public static Logger logger = LoggerFactory.getLogger(CertReqParser.class);
    public static final CertReqParser DETAIL_PARSER = new CertReqParser(true);
    public static final CertReqParser NODETAIL_PARSER = new CertReqParser(false);
    private boolean mDetails = true;
    private PrettyPrintFormat pp;
    private static final String EXT_PRETTYPRINT = "ext_prettyprint";
    private static final String LB = "[";
    private static final String RB = "]";
    private static final String EQ = " = ";

    public CertReqParser() {
        this.pp = new PrettyPrintFormat(":");
    }

    public CertReqParser(boolean details) {
        this.mDetails = details;
        this.pp = new PrettyPrintFormat(":");
    }

    public void fillRequestIntoArg(Locale l, Request req, CMSTemplateParams argSet, ArgBlock arg) throws EBaseException {
        if (req.getExtDataInCertInfo("req_x509info") == null && req.getExtDataInCertInfo("CERT_INFO") == null && arg.getValueAsString("subject", "").equals("")) {
            try {
                X500Name name;
                CertificateSubjectName sbjName;
                String subjectnamevalue = req.getExtDataInString("req_subject_name");
                if (subjectnamevalue != null && !subjectnamevalue.equals("") && (sbjName = new CertificateSubjectName(name = new X500Name(Utils.base64decode((String)subjectnamevalue)))) != null) {
                    arg.addStringValue("subject", sbjName.toString());
                }
            }
            catch (Exception ee) {
                logger.warn("CertReqParser.fillRequestIntoArg: Exception:" + ee.getMessage(), (Throwable)ee);
            }
        }
        if (req.getExtDataInCertInfoArray("CERT_INFO") != null) {
            this.fillX509RequestIntoArg(l, req, argSet, arg);
        } else if (req.getExtDataInRevokedCertArray("CERT_INFO") != null) {
            this.fillRevokeRequestIntoArg(l, req, argSet, arg);
        } else {
            this.fillRevokeRequestIntoArg(l, req, argSet, arg);
        }
    }

    private void fillX509RequestIntoArg(Locale l, Request req, CMSTemplateParams argSet, ArgBlock arg) throws EBaseException {
        super.fillRequestIntoArg(l, req, argSet, arg);
        arg.addStringValue("certExtsEnabled", "yes");
        int saCounter = 0;
        Enumeration enum1 = req.getExtDataKeys();
        String prefix = "record.";
        if (argSet.getHeader() == arg) {
            prefix = "header.";
        }
        while (enum1.hasMoreElements()) {
            Hashtable fingerprints;
            byte[] certChainData;
            X509CertImpl[] oldCert;
            BigInteger[] oldSerialNo;
            X509CertInfo[] certInfo;
            Vector errorStrings;
            String name = (String)enum1.nextElement();
            if (this.mDetails) {
                if (name.equalsIgnoreCase("HTTP_PARAMS")) {
                    String presenceServerExt;
                    Hashtable http_params = req.getExtDataInHashtable(name);
                    String certType = (String)http_params.get("certType");
                    if (certType != null) {
                        arg.addStringValue("certType", certType);
                    }
                    if ((presenceServerExt = (String)http_params.get("PresenceServerExtension")) != null) {
                        arg.addStringValue("PresenceServerExtension", presenceServerExt);
                    }
                    int counter = 0;
                    Enumeration elms = http_params.keys();
                    while (elms.hasMoreElements()) {
                        String parami = "HTTP_PARAMS[" + String.valueOf(counter++) + RB;
                        String n = (String)elms.nextElement();
                        rawJS = "new Object;\n\r" + prefix + parami + ".name=\"" + CMSTemplate.escapeJavaScriptString((String)n) + "\";\n\r" + prefix + parami + ".value=\"" + CMSTemplate.escapeJavaScriptStringHTML((String)((String)http_params.get(n)).toString()) + "\"";
                        arg.set(parami, (Object)new RawJS(rawJS));
                    }
                } else if (name.equalsIgnoreCase("HTTP_HEADERS")) {
                    Hashtable http_hdrs = req.getExtDataInHashtable(name);
                    Enumeration elms = http_hdrs.keys();
                    int counter = 0;
                    while (elms.hasMoreElements()) {
                        String parami = "HTTP_HEADERS[" + String.valueOf(counter++) + RB;
                        n = (String)elms.nextElement();
                        String rawJS = "new Object;\n\r" + prefix + parami + ".name=\"" + CMSTemplate.escapeJavaScriptString((String)n) + "\";\n\r" + prefix + parami + ".value=\"" + CMSTemplate.escapeJavaScriptStringHTML((String)((String)http_hdrs.get(n)).toString()) + "\"";
                        arg.set(parami, (Object)new RawJS(rawJS));
                    }
                } else if (name.equalsIgnoreCase("AUTH_TOKEN")) {
                    AuthToken auth_token = req.getExtDataInAuthToken(name);
                    Enumeration elms = auth_token.getElements();
                    int counter = 0;
                    while (elms.hasMoreElements()) {
                        String parami = "AUTH_TOKEN[" + String.valueOf(counter++) + RB;
                        n = (String)elms.nextElement();
                        Object authTokenValue = auth_token.getInStringArray(n);
                        if (authTokenValue == null) {
                            authTokenValue = auth_token.getInString(n);
                        }
                        String v = this.expandValue(prefix + parami + ".value", authTokenValue);
                        rawJS = "new Object;\n\r" + prefix + parami + ".name=\"" + CMSTemplate.escapeJavaScriptString((String)n) + "\";\n" + v;
                        arg.set(parami, (Object)new RawJS(rawJS));
                    }
                } else {
                    X509CertInfo[] certInfo2;
                    Object val;
                    if (req.isSimpleExtDataValue(name)) {
                        val = req.getExtDataInString(name);
                    } else {
                        val = req.getExtDataInStringArray(name);
                        if (val == null) {
                            val = req.getExtDataInHashtable(name);
                        }
                    }
                    String valstr = "";
                    String parami = "SERVER_ATTRS[" + String.valueOf(saCounter++) + RB;
                    if (name.equalsIgnoreCase("issuedCerts") && this.mDetails && (req.getRequestStatus() == RequestStatus.COMPLETE || req.getRequestType().equals("getRevocationInfo"))) {
                        X509CertImpl[] issuedCert = req.getExtDataInCertArray("issuedCerts");
                        if (issuedCert != null && issuedCert[0] != null) {
                            val = "<pre>" + new CertPrettyPrint((Certificate)issuedCert[0]).toString(l) + "</pre>";
                        }
                    } else if (name.equalsIgnoreCase("CERT_INFO") && this.mDetails && (certInfo2 = req.getExtDataInCertInfoArray("CERT_INFO")) != null && certInfo2[0] != null) {
                        val = "<pre>" + certInfo2[0].toString() + "</pre>";
                    }
                    valstr = this.expandValue(prefix + parami + ".value", val);
                    String rawJS = "new Object;\n\r" + prefix + parami + ".name=\"" + CMSTemplate.escapeJavaScriptString((String)name) + "\";\n" + valstr;
                    arg.set(parami, (Object)new RawJS(rawJS));
                }
            }
            if (name.equalsIgnoreCase("csrRequestorPhone") || name.equalsIgnoreCase("csrRequestorEmail") || name.equalsIgnoreCase("csrRequestorComments") || name.equalsIgnoreCase("Result") || name.equalsIgnoreCase("requestTrustedManagerPrivilege")) {
                arg.addStringValue(name, req.getExtDataInString(name));
            }
            if (name.equalsIgnoreCase("csrRequestorName")) {
                String requestorName = req.getExtDataInString(name);
                if ((requestorName = requestorName.trim()).length() > 0) {
                    arg.addStringValue(name, requestorName);
                }
            }
            if (name.equalsIgnoreCase("errors") && (errorStrings = req.getExtDataInStringVector(name)) != null) {
                StringBuffer errInfo = new StringBuffer();
                for (int i = 0; i < errorStrings.size(); ++i) {
                    errInfo.append((String)errorStrings.elementAt(i));
                    errInfo.append("\n");
                }
                arg.addStringValue("errors", errInfo.toString());
            }
            if (name.equalsIgnoreCase("Error")) {
                arg.addStringValue("errors", req.getExtDataInString(name));
            }
            if (name.equalsIgnoreCase("CERT_INFO") && (certInfo = req.getExtDataInCertInfoArray("CERT_INFO")) != null && certInfo[0] != null) {
                CertificateSubjectName subjectName = null;
                String signatureAlgorithm = null;
                String signatureAlgorithmName = null;
                try {
                    subjectName = (CertificateSubjectName)certInfo[0].get("subject");
                }
                catch (IOException n) {
                }
                catch (CertificateException n) {
                    // empty catch block
                }
                if (subjectName != null) {
                    String sn;
                    try {
                        sn = subjectName.toString();
                    }
                    catch (IllegalArgumentException e) {
                        sn = "* * Malformed Subject Name * *";
                    }
                    String subjectnamevalue = sn;
                    arg.addStringValue("subject", subjectnamevalue);
                }
                if (this.mDetails) {
                    try {
                        CertificateAlgorithmId certAlgId = (CertificateAlgorithmId)certInfo[0].get("algorithmID");
                        AlgorithmId algId = (AlgorithmId)certAlgId.get("algorithm");
                        signatureAlgorithm = algId.getOID().toString();
                        signatureAlgorithmName = algId.getName();
                    }
                    catch (Exception certAlgId) {
                        // empty catch block
                    }
                    if (signatureAlgorithm != null) {
                        arg.addStringValue("signatureAlgorithm", signatureAlgorithm);
                    }
                    if (signatureAlgorithmName != null) {
                        arg.addStringValue("signatureAlgorithmName", signatureAlgorithmName);
                    }
                    CertificateExtensions extensions = null;
                    try {
                        extensions = (CertificateExtensions)certInfo[0].get("extensions");
                    }
                    catch (Exception algId) {
                        // empty catch block
                    }
                    if (extensions != null) {
                        Enumeration exts = extensions.getAttributes();
                        while (exts.hasMoreElements()) {
                            Extension ext = (Extension)exts.nextElement();
                            if (ext instanceof NSCertTypeExtension) {
                                NSCertTypeExtension nsExtensions = (NSCertTypeExtension)ext;
                                try {
                                    arg.addStringValue("ext_ssl_server", nsExtensions.get("ssl_server").toString());
                                    arg.addStringValue("ext_ssl_client", nsExtensions.get("ssl_client").toString());
                                    arg.addStringValue("ext_email", nsExtensions.get("email").toString());
                                    arg.addStringValue("ext_object_signing", nsExtensions.get("object_signing").toString());
                                    arg.addStringValue("ext_ssl_ca", nsExtensions.get("ssl_ca").toString());
                                    arg.addStringValue("ext_email_ca", nsExtensions.get("email_ca").toString());
                                    arg.addStringValue("ext_object_signing_ca", nsExtensions.get("object_signing_ca").toString());
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                            if (ext instanceof BasicConstraintsExtension) {
                                BasicConstraintsExtension bcExt = (BasicConstraintsExtension)ext;
                                Integer pathLength = null;
                                Boolean isCA = null;
                                try {
                                    pathLength = (Integer)bcExt.get("path_len");
                                    isCA = (Boolean)bcExt.get("is_ca");
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                if (pathLength != null) {
                                    arg.addIntegerValue("pathLenBasicConstraints", pathLength.intValue());
                                }
                                if (isCA == null) continue;
                                arg.addBooleanValue("isCABasicConstraints", isCA.booleanValue());
                                continue;
                            }
                            if (argSet == null) continue;
                            ArgBlock rr = new ArgBlock();
                            rr.addStringValue(EXT_PRETTYPRINT, new ExtPrettyPrint(ext, 0).toString());
                            argSet.addRepeatRecord(rr);
                        }
                    }
                    CertificateX509Key certKey = null;
                    try {
                        certKey = (CertificateX509Key)certInfo[0].get("key");
                    }
                    catch (IOException ext) {
                    }
                    catch (CertificateException ext) {
                        // empty catch block
                    }
                    X509Key key = null;
                    try {
                        key = (X509Key)certKey.get("value");
                    }
                    catch (IOException rr) {
                        // empty catch block
                    }
                    if (key != null) {
                        arg.addStringValue("subjectPublicKeyInfo", key.getAlgorithm() + " - " + key.getAlgorithmId().getOID().toString());
                        arg.addStringValue("subjectPublicKey", this.pp.toHexString(key.getKey(), 0, 16));
                    }
                    CertificateValidity validity = null;
                    try {
                        validity = (CertificateValidity)certInfo[0].get("validity");
                        if (validity != null) {
                            long validityLength = (((Date)validity.get("notAfter")).getTime() - ((Date)validity.get("notBefore")).getTime()) / 1000L;
                            arg.addLongValue("validityLength", validityLength);
                        }
                    }
                    catch (IOException iOException) {
                    }
                    catch (CertificateException certificateException) {
                        // empty catch block
                    }
                }
            }
            if (name.equalsIgnoreCase("OLD_SERIALS") && this.mDetails && (oldSerialNo = req.getExtDataInBigIntegerArray("OLD_SERIALS")) != null && argSet != null) {
                for (int i = 0; i < oldSerialNo.length; ++i) {
                    ArgBlock rarg = new ArgBlock();
                    rarg.addBigIntegerValue("serialNumber", oldSerialNo[i], 16);
                    argSet.addRepeatRecord(rarg);
                }
            }
            if (name.equalsIgnoreCase("issuedCerts") && this.mDetails && (req.getRequestStatus() == RequestStatus.COMPLETE || req.getRequestType().equals("getRevocationInfo"))) {
                X509CertImpl[] issuedCert = req.getExtDataInCertArray("issuedCerts");
                arg.addBigIntegerValue("serialNumber", issuedCert[0].getSerialNumber(), 16);
                if (issuedCert.length == 2) {
                    arg.addBigIntegerValue("serialNumber2", issuedCert[1].getSerialNumber(), 16);
                }
            }
            if (name.equalsIgnoreCase("OLD_CERTS") && this.mDetails && (oldCert = req.getExtDataInCertArray("OLD_CERTS")) != null && oldCert.length > 0) {
                arg.addBigIntegerValue("serialNumber", oldCert[0].getSerialNumber(), 16);
                arg.addStringValue("subject", oldCert[0].getSubjectName().toString());
                if (req.getRequestType().equals("getCertificates")) {
                    for (int i = 0; i < oldCert.length; ++i) {
                        ArgBlock rarg = new ArgBlock();
                        rarg.addBigIntegerValue("serialNumber", oldCert[i].getSerialNumber(), 16);
                        argSet.addRepeatRecord(rarg);
                    }
                }
            }
            if (name.equalsIgnoreCase("CACertChain") && this.mDetails && (certChainData = req.getExtDataInByteArray("CACertChain")) != null) {
                CertificateChain certChain = new CertificateChain();
                try {
                    certChain.decode((InputStream)new ByteArrayInputStream(certChainData));
                    X509Certificate[] cert = certChain.getChain();
                    for (int i = 0; i < cert.length; ++i) {
                        ArgBlock rarg = new ArgBlock();
                        rarg.addBigIntegerValue("serialNumber", cert[i].getSerialNumber(), 16);
                        argSet.addRepeatRecord(rarg);
                    }
                }
                catch (IOException cert) {
                    // empty catch block
                }
            }
            if (!name.equalsIgnoreCase("fingerprints") || !this.mDetails || (fingerprints = req.getExtDataInHashtable("fingerprints")) == null) continue;
            String namesAndHashes = null;
            Enumeration enumFingerprints = fingerprints.keys();
            while (enumFingerprints.hasMoreElements()) {
                String hashname = (String)enumFingerprints.nextElement();
                String hashvalue = (String)fingerprints.get(hashname);
                byte[] fingerprint = Utils.base64decode((String)hashvalue);
                String ppFingerprint = this.pp.toHexString(fingerprint, 0);
                if (hashname == null || ppFingerprint == null) continue;
                if (namesAndHashes != null) {
                    namesAndHashes = namesAndHashes + "+" + hashname + "+" + ppFingerprint;
                    continue;
                }
                namesAndHashes = hashname + "+" + ppFingerprint;
            }
            if (namesAndHashes == null) continue;
            arg.addStringValue("fingerprints", namesAndHashes);
        }
    }

    protected String expandValue(String valuename, Object v) {
        try {
            Object valstr = "";
            if (v instanceof Vector) {
                valstr = valuename + "= new Array";
                int j = 0;
                StringBuffer sb = new StringBuffer();
                Enumeration n = ((Vector)v).elements();
                while (n.hasMoreElements()) {
                    sb.append(";\n");
                    sb.append(valuename);
                    sb.append(LB);
                    sb.append(j);
                    sb.append(RB);
                    sb.append(EQ);
                    sb.append("\"");
                    sb.append(CMSTemplate.escapeJavaScriptStringHTML((String)((String)n.nextElement()).toString()));
                    sb.append("\";\n");
                    ++j;
                }
                sb.append("\n");
                valstr = sb.toString();
                return valstr;
            }
            int len = -1;
            try {
                len = Array.getLength(v);
            }
            catch (IllegalArgumentException sb) {
                // empty catch block
            }
            if (len >= 0) {
                valstr = valuename + "= new Array";
                for (int i = 0; i < len; ++i) {
                    if (Array.get(v, i) == null) continue;
                    valstr = (String)valstr + ";\n" + valuename + LB + i + "] = \"" + CMSTemplate.escapeJavaScriptStringHTML((String)Array.get(v, i).toString()) + "\";\n";
                }
                return valstr;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return valuename + "=\"" + CMSTemplate.escapeJavaScriptStringHTML((String)v.toString()) + "\"";
    }

    public String getCertSubjectDN(Request request) {
        block6: {
            try {
                String cert = request.getExtDataInString("cert");
                if (cert == null) {
                    cert = request.getExtDataInString("req_issued_cert");
                }
                if (cert == null) break block6;
                X509CertImpl theCert = null;
                try {
                    theCert = new X509CertImpl(Utils.base64decode((String)cert));
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
                if (theCert != null) {
                    String subject = theCert.getSubjectName().toString();
                    return subject;
                }
            }
            catch (Exception e) {
                logger.warn("CertReqParser: getCertSubjectDN " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public String getRequestorDN(Request request) {
        try {
            X509CertInfo info = request.getExtDataInCertInfo("req_x509info");
            if (info == null) {
                return null;
            }
            CertificateSubjectName sn = (CertificateSubjectName)info.get("subject");
            return sn.toString();
        }
        catch (Exception e) {
            logger.warn("CertReqParser: getRequestorDN " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getKeyID(Request request) {
        try {
            String uid;
            Object kid = null;
            String cid = request.getExtDataInString("CUID");
            if (cid == null) {
                cid = "";
            }
            if ((uid = request.getExtDataInString("USERID")) == null) {
                uid = "";
            }
            if (((String)(kid = cid + ":" + uid)).equals(":")) {
                kid = "";
            }
            return kid;
        }
        catch (Exception e) {
            logger.warn("CertReqParser: getKeyID " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void fillRevokeRequestIntoArg(Locale l, Request req, CMSTemplateParams argSet, ArgBlock arg) throws EBaseException {
        super.fillRequestIntoArg(l, req, argSet, arg);
        arg.addStringValue("certExtsEnabled", "yes");
        String profile = req.getExtDataInString("profile");
        String reqType = req.getExtDataInString("requestType");
        if (profile != null) {
            arg.addStringValue("profile", profile);
            String requestorDN = this.getRequestorDN(req);
            if (requestorDN == null) {
                requestorDN = this.getCertSubjectDN(req);
            }
            if (requestorDN != null) {
                arg.addStringValue("subject", requestorDN);
            }
        } else if ("recovery".equals(reqType)) {
            arg.addStringValue("profile", "false");
            String subjectDN = this.getCertSubjectDN(req);
            arg.addStringValue("subject", subjectDN);
        } else {
            arg.addStringValue("profile", "false");
            String keyID = this.getKeyID(req);
            if (keyID != null && !keyID.isEmpty()) {
                arg.addStringValue("subject", keyID);
            }
        }
        int saCounter = 0;
        Enumeration enum1 = req.getExtDataKeys();
        String prefix = "record.";
        if (argSet.getHeader() == arg) {
            prefix = "header.";
        }
        while (enum1.hasMoreElements()) {
            X509CertImpl[] oldCert;
            BigInteger[] oldSerialNo;
            RevokedCertImpl[] revokedCert;
            Vector errorsVector;
            String name = (String)enum1.nextElement();
            if (this.mDetails) {
                if (name.equalsIgnoreCase("HTTP_PARAMS")) {
                    Hashtable http_params = req.getExtDataInHashtable(name);
                    String certType = (String)http_params.get("certType");
                    if (certType != null) {
                        arg.addStringValue("certType", certType);
                    }
                    int counter = 0;
                    Enumeration elms = http_params.keys();
                    while (elms.hasMoreElements()) {
                        String parami = "HTTP_PARAMS[" + String.valueOf(counter++) + RB;
                        String n = (String)elms.nextElement();
                        rawJS = "new Object;\n\r" + prefix + parami + ".name=\"" + CMSTemplate.escapeJavaScriptString((String)n) + "\";\n\r" + prefix + parami + ".value=\"" + CMSTemplate.escapeJavaScriptStringHTML((String)((String)http_params.get(n)).toString()) + "\"";
                        arg.set(parami, (Object)new RawJS(rawJS));
                    }
                } else if (name.equalsIgnoreCase("HTTP_HEADERS")) {
                    Hashtable http_hdrs = req.getExtDataInHashtable(name);
                    Enumeration elms = http_hdrs.keys();
                    int counter = 0;
                    while (elms.hasMoreElements()) {
                        String parami = "HTTP_HEADERS[" + String.valueOf(counter++) + RB;
                        String n = (String)elms.nextElement();
                        String rawJS = "new Object;\n\r" + prefix + parami + ".name=\"" + CMSTemplate.escapeJavaScriptString((String)n) + "\";\n\r" + prefix + parami + ".value=\"" + CMSTemplate.escapeJavaScriptStringHTML((String)((String)http_hdrs.get(n)).toString()) + "\"";
                        arg.set(parami, (Object)new RawJS(rawJS));
                    }
                } else if (name.equalsIgnoreCase("AUTH_TOKEN")) {
                    AuthToken auth_token = req.getExtDataInAuthToken(name);
                    Enumeration elms = auth_token.getElements();
                    int counter = 0;
                    while (elms.hasMoreElements()) {
                        String parami = "AUTH_TOKEN[" + String.valueOf(counter++) + RB;
                        String n = (String)elms.nextElement();
                        String v = this.expandValue(prefix + parami + ".value", auth_token.getInString(n));
                        rawJS = "new Object;\n\r" + prefix + parami + ".name=\"" + CMSTemplate.escapeJavaScriptString((String)n) + "\";\n" + v;
                        arg.set(parami, (Object)new RawJS(rawJS));
                    }
                } else {
                    Object val;
                    if (req.isSimpleExtDataValue(name)) {
                        val = req.getExtDataInString(name);
                    } else {
                        val = req.getExtDataInStringArray(name);
                        if (val == null) {
                            val = req.getExtDataInHashtable(name);
                        }
                    }
                    String valstr = "";
                    String parami = "SERVER_ATTRS[" + String.valueOf(saCounter++) + RB;
                    valstr = this.expandValue(prefix + parami + ".value", val);
                    String rawJS = "new Object;\n\r" + prefix + parami + ".name=\"" + CMSTemplate.escapeJavaScriptString((String)name) + "\";\n" + valstr;
                    arg.set(parami, (Object)new RawJS(rawJS));
                }
            }
            if (name.equalsIgnoreCase("csrRequestorPhone") || name.equalsIgnoreCase("csrRequestorEmail") || name.equalsIgnoreCase("csrRequestorComments") || name.equalsIgnoreCase("Result") || name.equalsIgnoreCase("requestTrustedManagerPrivilege")) {
                arg.addStringValue(name, req.getExtDataInString(name));
            }
            if (name.equalsIgnoreCase("csrRequestorName")) {
                String requestorName = req.getExtDataInString(name);
                if ((requestorName = requestorName.trim()).length() > 0) {
                    arg.addStringValue(name, requestorName);
                }
            }
            if (name.equalsIgnoreCase("errors") && (errorsVector = req.getExtDataInStringVector(name)) != null) {
                StringBuffer errInfo = new StringBuffer();
                for (int i = 0; i < errorsVector.size(); ++i) {
                    errInfo.append((String)errorsVector.elementAt(i));
                    errInfo.append("\n");
                }
                arg.addStringValue("errors", errInfo.toString());
            }
            if (name.equalsIgnoreCase("Error")) {
                arg.addStringValue("errors", req.getExtDataInString(name));
            }
            if (name.equalsIgnoreCase("CERT_INFO")) {
                revokedCert = req.getExtDataInRevokedCertArray("CERT_INFO");
                if (this.mDetails && revokedCert != null) {
                    if (argSet != null) {
                        for (int i = 0; i < revokedCert.length; ++i) {
                            ArgBlock rarg = new ArgBlock();
                            rarg.addBigIntegerValue("serialNumber", revokedCert[i].getSerialNumber(), 16);
                            CRLExtensions crlExtensions = revokedCert[i].getExtensions();
                            if (crlExtensions != null) {
                                for (int k = 0; k < crlExtensions.size(); ++k) {
                                    Extension ext = (Extension)crlExtensions.elementAt(k);
                                    if (!(ext instanceof CRLReasonExtension)) continue;
                                    rarg.addStringValue("reason", ((CRLReasonExtension)ext).getReason().toString());
                                }
                            } else {
                                rarg.addStringValue("reason", RevocationReason.UNSPECIFIED.toString());
                            }
                            argSet.addRepeatRecord(rarg);
                        }
                    } else {
                        arg.addBigIntegerValue("serialNumber", revokedCert[0].getSerialNumber(), 16);
                    }
                }
            }
            if (name.equalsIgnoreCase("OLD_SERIALS") && this.mDetails && (oldSerialNo = req.getExtDataInBigIntegerArray("OLD_SERIALS")) != null && argSet != null) {
                for (int i = 0; i < oldSerialNo.length; ++i) {
                    ArgBlock rarg = new ArgBlock();
                    rarg.addBigIntegerValue("serialNumber", oldSerialNo[i], 16);
                    argSet.addRepeatRecord(rarg);
                }
            }
            if (name.equalsIgnoreCase("OLD_CERTS") && this.mDetails && (oldCert = req.getExtDataInCertArray("OLD_CERTS")) != null && oldCert.length > 0 && oldCert[0] instanceof X509CertImpl) {
                X509CertImpl xcert = oldCert[0];
                arg.addBigIntegerValue("serialNumber", xcert.getSerialNumber(), 16);
                arg.addStringValue("subject", xcert.getSubjectName().toString());
                if (req.getRequestType().equals("getCertificates")) {
                    for (int i = 0; i < oldCert.length; ++i) {
                        ArgBlock rarg = new ArgBlock();
                        xcert = oldCert[i];
                        rarg.addBigIntegerValue("serialNumber", xcert.getSerialNumber(), 16);
                        argSet.addRepeatRecord(rarg);
                    }
                }
            }
            if (!name.equalsIgnoreCase("revokedCerts") || !this.mDetails || !req.getRequestType().equals("getRevocationInfo") || (revokedCert = req.getExtDataInRevokedCertArray("revokedCerts")) == null || revokedCert[0] == null) continue;
            boolean reasonFound = false;
            CRLExtensions crlExtensions = revokedCert[0].getExtensions();
            for (int k = 0; k < crlExtensions.size(); ++k) {
                Extension ext = (Extension)crlExtensions.elementAt(k);
                if (!(ext instanceof CRLReasonExtension)) continue;
                arg.addStringValue("reason", ((CRLReasonExtension)ext).getReason().toString());
                reasonFound = true;
            }
            if (reasonFound) continue;
            arg.addStringValue("reason", "unknown");
        }
    }
}

