/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.extensions.ExtendedKeyUsageExtension;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

public class ExtendedKeyUsageExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static final String PROP_CRITICAL = "critical";
    protected static final String PROP_PURPOSE_ID = "id";
    protected static final String PROP_NUM_IDS = "numIds";
    protected static int MAX_PURPOSE_ID = 10;
    private boolean mCritical = false;
    private ConfigStore mConfig;
    private Vector<ObjectIdentifier> mUsages = null;
    private String[] mParams = null;
    public static final boolean DEFAULT_CRITICALITY = false;
    private ExtendedKeyUsageExtension mExtendedKeyUsage = null;

    public ExtendedKeyUsageExt() {
        this.NAME = "ExtendedKeyUsageExt";
        this.DESC = "Sets ExtendedKeyUsage extension for certificates";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mConfig = config;
        this.setExtendedPluginInfo();
        this.setupParams();
        try {
            this.mExtendedKeyUsage = new ExtendedKeyUsageExtension(this.mCritical, this.mUsages);
        }
        catch (IOException e) {
            throw new EBaseException((Exception)e);
        }
    }

    public PolicyResult apply(Request req) {
        if (this.mExtendedKeyUsage == null) {
            return PolicyResult.ACCEPTED;
        }
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certRes = this.applyCert(req, ci[i]);
            if (certRes != PolicyResult.REJECTED) continue;
            return certRes;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        try {
            CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
            if (extensions == null) {
                certInfo.set("version", (Object)new CertificateVersion(2));
                extensions = new CertificateExtensions();
                certInfo.set("version", (Object)new CertificateVersion(2));
                certInfo.set("extensions", (Object)extensions);
            } else {
                try {
                    extensions.delete("ExtendedKeyUsageExtension");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            extensions.set("ExtendedKeyUsageExtension", (Object)this.mExtendedKeyUsage);
            return PolicyResult.ACCEPTED;
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"BASE_IO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
            return PolicyResult.REJECTED;
        }
        catch (CertificateException e) {
            logger.warn(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
            return PolicyResult.REJECTED;
        }
    }

    public Vector<String> getInstanceParams() {
        Vector<String> params = new Vector<String>();
        params.addElement("critical=" + this.mCritical);
        int numIds = MAX_PURPOSE_ID;
        try {
            numIds = this.mConfig.getInteger(PROP_NUM_IDS, MAX_PURPOSE_ID);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        params.addElement("numIds=" + numIds);
        String usage = null;
        for (int i = 0; i < numIds; ++i) {
            if (this.mUsages.size() <= i) {
                params.addElement(PROP_PURPOSE_ID + Integer.toString(i) + "=");
                continue;
            }
            usage = this.mUsages.elementAt(i).toString();
            if (usage == null) {
                params.addElement(PROP_PURPOSE_ID + Integer.toString(i) + "=");
                continue;
            }
            params.addElement(PROP_PURPOSE_ID + Integer.toString(i) + "=" + usage);
        }
        return params;
    }

    private void setExtendedPluginInfo() {
        Vector<Object> v = new Vector<Object>();
        int mNum = MAX_PURPOSE_ID;
        if (this.mConfig != null) {
            try {
                this.mConfig.getInteger(PROP_NUM_IDS, MAX_PURPOSE_ID);
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
        }
        for (int i = 0; i < mNum; ++i) {
            v.addElement(PROP_PURPOSE_ID + Integer.toString(i) + ";string;A unique,valid OID specified in dot-separated numeric component notation. e.g. 2.16.840.1.113730.1.99");
        }
        v.addElement("numIds;number;The total number of policy IDs.");
        v.addElement("critical;boolean;RFC 2459 recommendation: This extension may, at the option of the certificate issuer, be either critical or non-critical.");
        v.addElement("HELP_TOKEN;configuration-policyrules-extendedkeyusage");
        v.addElement("HELP_TEXT;Adds Extended Key Usage Extension. Defined in RFC 2459 (4.2.1.13)");
        this.mParams = Utils.getStringArrayFromVector(v);
    }

    public String[] getExtendedPluginInfo() {
        if (this.mParams == null) {
            this.setExtendedPluginInfo();
        }
        return this.mParams;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> defParams = new Vector<String>();
        defParams.addElement("critical=false");
        defParams.addElement("numIds=" + MAX_PURPOSE_ID);
        for (int i = 0; i < MAX_PURPOSE_ID; ++i) {
            defParams.addElement(PROP_PURPOSE_ID + Integer.toString(i) + "=");
        }
        return defParams;
    }

    private void setupParams() throws EBaseException {
        this.mCritical = this.mConfig.getBoolean(PROP_CRITICAL, false);
        if (this.mUsages == null) {
            this.mUsages = new Vector();
        }
        int mNum = this.mConfig.getInteger(PROP_NUM_IDS, MAX_PURPOSE_ID);
        for (int i = 0; i < mNum; ++i) {
            ObjectIdentifier usageOID = null;
            String usage = this.mConfig.getString(PROP_PURPOSE_ID + Integer.toString(i), null);
            try {
                if (usage == null || (usage = usage.trim()).equals("")) break;
                usageOID = usage.equalsIgnoreCase("ocspsigning") ? ObjectIdentifier.getObjectIdentifier((String)"1.3.6.1.5.5.7.3.9") : (usage.equalsIgnoreCase("codesigning") ? ObjectIdentifier.getObjectIdentifier((String)"1.3.6.1.5.5.7.3.3") : ObjectIdentifier.getObjectIdentifier((String)usage));
            }
            catch (IOException ex) {
                throw new EBaseException(((Object)((Object)this)).getClass().getName() + ":" + ex.getMessage());
            }
            catch (NumberFormatException ex) {
                throw new EBaseException(((Object)((Object)this)).getClass().getName() + ":OID '" + usage + "' format error");
            }
            this.mUsages.addElement(usageOID);
        }
    }
}

