/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;
import org.dogtagpki.legacy.core.policy.SubjAltNameGN;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.policy.ISubjAltNameConfig;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.SubjectAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAltNameExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(SubjectAltNameExt.class);
    protected static final String PROP_CRITICAL = "critical";
    protected static final boolean DEF_CRITICAL = false;
    protected ConfigStore mConfig;
    protected boolean mEnabled = false;
    protected boolean mCritical = false;
    protected int mNumGNs = 0;
    protected ISubjAltNameConfig[] mGNs = null;
    Vector<String> mInstanceParams = new Vector();
    private static Vector<String> mDefParams = new Vector();
    private String[] mExtendedPluginInfo = null;

    public SubjectAltNameExt() {
        this.NAME = "SubjectAltNameExt";
        this.DESC = "Sets alternative subject names for certificates";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mConfig = config;
        this.mCritical = this.mConfig.getBoolean(PROP_CRITICAL, false);
        this.mEnabled = this.mConfig.getBoolean("enable", false);
        this.mNumGNs = this.mConfig.getInteger("numGeneralNames");
        if (this.mNumGNs <= 0) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_MUST_BE_POSITIVE_NUMBER", (String[])new String[]{"numGeneralNames"}));
        }
        this.mGNs = new ISubjAltNameConfig[this.mNumGNs];
        for (int i = 0; i < this.mNumGNs; ++i) {
            String name = "generalName" + i;
            ConfigStore substore = this.mConfig.getSubStore(name, ConfigStore.class);
            this.mGNs[i] = new SubjAltNameGN(name, substore, this.mEnabled);
        }
        this.mInstanceParams.addElement("critical=" + this.mCritical);
        this.mInstanceParams.addElement("numGeneralNames=" + this.mNumGNs);
        for (int j = 0; j < this.mGNs.length; ++j) {
            this.mGNs[j].getInstanceParams(this.mInstanceParams);
        }
    }

    public PolicyResult apply(Request req) {
        PolicyResult res = PolicyResult.ACCEPTED;
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certRes = this.applyCert(req, ci[i]);
            if (certRes != PolicyResult.REJECTED) continue;
            return certRes;
        }
        return res;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        PolicyResult res = PolicyResult.ACCEPTED;
        try {
            CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
            if (extensions != null) {
                String sourceId = req.getSourceId();
                if (sourceId != null && sourceId.length() > 0) {
                    return res;
                }
                try {
                    extensions.delete("SubjectAlternativeName");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            GeneralNames gns = new GeneralNames();
            for (int i = 0; i < this.mNumGNs; ++i) {
                Vector gn;
                String value = null;
                value = req.getExtDataInString(this.mGNs[i].getPfx(), this.mGNs[i].getAttr());
                if (value == null || (gn = this.mGNs[i].formGeneralNames((Object)value)).size() == 0) continue;
                Enumeration n = gn.elements();
                while (n.hasMoreElements()) {
                    gns.addElement((Object)((GeneralNameInterface)n.nextElement()));
                }
            }
            if (gns.size() == 0) {
                return res;
            }
            String subject = certInfo.get("subject").toString();
            boolean curCritical = this.mCritical;
            if (subject.equals("")) {
                curCritical = true;
            }
            SubjectAlternativeNameExtension sa = new SubjectAlternativeNameExtension(curCritical, gns);
            if (extensions == null) {
                extensions = this.createCertificateExtensions(certInfo);
            }
            extensions.set("SubjectAlternativeName", (Object)sa);
            return res;
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"BASE_IO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
            return PolicyResult.REJECTED;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Certificate Info Error");
            return PolicyResult.REJECTED;
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"BASE_INTERNAL_ERROR_1", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Internal Error");
            return PolicyResult.REJECTED;
        }
    }

    protected CertificateExtensions createCertificateExtensions(X509CertInfo certInfo) throws IOException, CertificateException {
        certInfo.set("version", (Object)new CertificateVersion(2));
        CertificateExtensions extensions = new CertificateExtensions();
        certInfo.set("extensions", (Object)extensions);
        return extensions;
    }

    public Vector<String> getInstanceParams() {
        return this.mInstanceParams;
    }

    public Vector<String> getDefaultParams() {
        return mDefParams;
    }

    public String[] getExtendedPluginInfo() {
        Vector<String> info = new Vector<String>();
        info.addElement("critical;boolean;RFC2459 recommendation: If the certificate subject field contains an empty sequence, the extension MUST be marked critical.");
        info.addElement("numGeneralNames;number;The total number of alternative names or identities permitted in the extension.");
        for (int i = 0; i < 8; ++i) {
            SubjAltNameGN.getExtendedPluginInfo((String)("generalName" + i), info);
        }
        info.addElement("HELP_TOKEN;configuration-policyrules-subjaltname");
        info.addElement("HELP_TEXT;This policy inserts the Subject Alternative Name Extension into the certificate. See RFC 2459 (4.2.1.7). * Note: you probably want to use this policy in conjunction with an authentication manager which sets the 'mail' or 'mailalternateaddress' values in the authToken. See the 'ldapStringAttrs' parameter in the Directory-based authentication plugin");
        this.mExtendedPluginInfo = new String[info.size()];
        info.copyInto(this.mExtendedPluginInfo);
        return this.mExtendedPluginInfo;
    }

    static {
        mDefParams.addElement("critical=false");
        mDefParams.addElement("numGeneralNames=8");
        for (int i = 0; i < 8; ++i) {
            SubjAltNameGN.getDefaultParams((String)("generalName" + i), mDefParams);
        }
    }
}

