/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.util.CertPrettyPrint;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

public class PrettyPrintCert {
    public static final int ARGC = 2;
    public static final String HEADER = "-----BEGIN";
    public static final String TRAILER = "-----END";

    public static void usageAndExit() {
        System.out.println("Usage:  PrettyPrintCert [options] <input filename> [output filename]");
        System.out.println("\n options: ");
        System.out.println("    -simpleinfo     :  prints limited cert info in easy to parse format");
        System.exit(0);
    }

    public static void main(String[] argv) {
        BufferedReader inputCert = null;
        StringBuffer encodedBASE64Cert = new StringBuffer();
        byte[] decodedBASE64Cert = null;
        X509CertImpl cert = null;
        Locale aLocale = null;
        CertPrettyPrint certDetails = null;
        StringBuilder pp = new StringBuilder();
        FileOutputStream outputCert = null;
        boolean mSimpleInfo = false;
        String inputfile = null;
        String outputfile = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("")) continue;
            if (argv[i].charAt(0) == '-') {
                if (argv[i].equals("-simpleinfo")) {
                    mSimpleInfo = true;
                    continue;
                }
                System.out.println("Illegal option: " + argv[i]);
                PrettyPrintCert.usageAndExit();
            }
            if (inputfile == null) {
                inputfile = argv[i];
                continue;
            }
            if (outputfile == null) {
                outputfile = argv[i];
                continue;
            }
            System.out.println("Error - Too many arguments");
            System.exit(0);
        }
        if (inputfile == null) {
            PrettyPrintCert.usageAndExit();
        }
        try {
            inputCert = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(inputfile))));
        }
        catch (FileNotFoundException e) {
            System.out.println("PrettyPrintCert:  can't find file " + inputfile + ":\n" + e);
            return;
        }
        try {
            String encodedBASE64CertChunk;
            while ((encodedBASE64CertChunk = inputCert.readLine()) != null) {
                if (encodedBASE64CertChunk.startsWith(HEADER) || encodedBASE64CertChunk.startsWith(TRAILER)) continue;
                encodedBASE64Cert.append(encodedBASE64CertChunk.trim());
            }
        }
        catch (IOException e) {
            System.out.println("PrettyPrintCert:  Unexpected BASE64 encoded error encountered in readLine():\n" + e);
        }
        try {
            inputCert.close();
        }
        catch (IOException e) {
            System.out.println("PrettyPrintCert:  Unexpected BASE64 encoded error encountered in close():\n" + e);
        }
        decodedBASE64Cert = Utils.base64decode((String)encodedBASE64Cert.toString());
        try {
            cert = new X509CertImpl(decodedBASE64Cert);
        }
        catch (CertificateException e) {
            System.out.println("PrettyPrintCert:  Error encountered on parsing certificate :\n" + e);
        }
        if (mSimpleInfo) {
            try {
                X509CertInfo certinfo = (X509CertInfo)cert.get("x509.INFO");
                CertificateSubjectName csn = (CertificateSubjectName)certinfo.get("subject");
                X500Name dname = (X500Name)csn.get("dname");
                RDN[] rdns = dname.getNames();
                for (int i = rdns.length - 1; i >= 0; --i) {
                    pp.append(rdns[i] + "\n");
                }
            }
            catch (Exception e) {
                System.out.println("ERROR");
                e.printStackTrace();
            }
        } else {
            aLocale = Locale.getDefault();
            certDetails = new CertPrettyPrint((Certificate)cert);
            pp.append(certDetails.toString(aLocale));
        }
        if (outputfile == null) {
            System.out.println(pp);
        } else {
            try {
                outputCert = new FileOutputStream(outputfile);
            }
            catch (Exception e) {
                System.out.println("PrettyPrintCert:  unable to open file " + argv[1] + " for writing:\n" + e);
                return;
            }
            try {
                outputCert.write(pp.toString().getBytes());
            }
            catch (IOException e) {
                System.out.println("PrettyPrintCert:  Unexpected error encountered while attempting to write() " + outputfile + ":\n" + e);
            }
            try {
                outputCert.close();
            }
            catch (IOException e) {
                System.out.println("PrettyPrintCert:  Unexpected error encountered while attempting to close() " + outputfile + ":\n" + e);
            }
        }
    }
}

