/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.kra;

import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.key.KeyClient;
import com.netscape.certsrv.key.KeyInfo;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.kra.KRAKeyCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAKeyModifyCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(KRAKeyModifyCLI.class);
    public KRAKeyCLI keyCLI;

    public KRAKeyModifyCLI(KRAKeyCLI keyCLI) {
        super("mod", "Modify the status of a key", (CLI)keyCLI);
        this.keyCLI = keyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Key ID> --status <status> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "status", true, "Status of the key.\nValid values: active, inactive");
        option.setArgName("status");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No Key ID specified.");
        }
        String status = cmd.getOptionValue("status");
        if (status == null) {
            throw new Exception("Missing key status");
        }
        KeyId keyId = new KeyId(cmdArgs[0]);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        KeyClient keyClient = this.keyCLI.getKeyClient();
        keyClient.modifyKeyStatus(keyId, status);
        KeyInfo keyInfo = keyClient.getKeyInfo(keyId);
        KRAKeyCLI.printKeyInfo(keyInfo);
    }
}

