/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.profile;

import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.profile.ProfileClient;
import com.netscape.certsrv.profile.ProfileData;
import com.netscape.certsrv.profile.ProfileDataInfo;
import com.netscape.certsrv.profile.ProfileInput;
import com.netscape.certsrv.profile.ProfileOutput;
import com.netscape.cmstools.ca.CACLI;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.profile.ProfileAddCLI;
import com.netscape.cmstools.profile.ProfileDisableCLI;
import com.netscape.cmstools.profile.ProfileEditCLI;
import com.netscape.cmstools.profile.ProfileEnableCLI;
import com.netscape.cmstools.profile.ProfileFindCLI;
import com.netscape.cmstools.profile.ProfileModifyCLI;
import com.netscape.cmstools.profile.ProfileRemoveCLI;
import com.netscape.cmstools.profile.ProfileShowCLI;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Properties;
import org.dogtagpki.cli.CLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileCLI
extends CLI {
    public static Logger logger = LoggerFactory.getLogger(ProfileCLI.class);
    public CACLI caCLI;
    public ProfileClient profileClient;

    public ProfileCLI(CACLI caCLI) {
        super("profile", "Profile management commands", (CLI)caCLI);
        this.caCLI = caCLI;
        this.addModule((CLI)new ProfileFindCLI(this));
        this.addModule((CLI)new ProfileShowCLI(this));
        this.addModule((CLI)new ProfileAddCLI(this));
        this.addModule((CLI)new ProfileModifyCLI(this));
        this.addModule((CLI)new ProfileEditCLI(this));
        this.addModule((CLI)new ProfileRemoveCLI(this));
        this.addModule((CLI)new ProfileEnableCLI(this));
        this.addModule((CLI)new ProfileDisableCLI(this));
    }

    public String getFullName() {
        return this.parent instanceof MainCLI ? this.name : this.parent.getFullName() + "-" + this.name;
    }

    public String getManPage() {
        return "pki-ca-profile";
    }

    public ProfileClient getProfileClient() throws Exception {
        if (this.profileClient != null) {
            return this.profileClient;
        }
        PKIClient client = this.getClient();
        String subsystem = client.getSubsystem();
        if (subsystem == null) {
            subsystem = "ca";
        }
        this.profileClient = new ProfileClient(client, subsystem);
        return this.profileClient;
    }

    public static void printProfileDataInfo(ProfileDataInfo info) {
        System.out.println("  Profile ID: " + info.getProfileId());
        logger.info("URL: " + info.getProfileURL());
        System.out.println("  Name: " + info.getProfileName());
        System.out.println("  Description: " + info.getProfileDescription());
    }

    public static void printProfile(ProfileData data) {
        System.out.println("  Profile ID: " + data.getId());
        System.out.println("  Name: " + data.getName());
        System.out.println("  Description: " + data.getDescription());
        for (ProfileInput input : data.getInputs()) {
            System.out.println();
            System.out.println("  Name: " + input.getName());
            System.out.println("  Class: " + input.getClassId());
            for (ProfileAttribute attr : input.getAttributes()) {
                System.out.println();
                System.out.println("    Attribute Name: " + attr.getName());
                System.out.println("    Attribute Description: " + attr.getDescriptor().getDescription(Locale.getDefault()));
                System.out.println("    Attribute Syntax: " + attr.getDescriptor().getSyntax());
            }
        }
        for (ProfileOutput output : data.getOutputs()) {
            System.out.println();
            System.out.println("  Name: " + output.getName());
            System.out.println("  Class: " + output.getClassId());
            for (ProfileAttribute attr : output.getAttrs()) {
                System.out.println();
                System.out.println("    Attribute Name: " + attr.getName());
                System.out.println("    Attribute Description: " + attr.getDescriptor().getDescription(Locale.getDefault()));
                System.out.println("    Attribute Syntax: " + attr.getDescriptor().getSyntax());
            }
        }
    }

    public static void saveProfileToFile(String filename, ProfileData data) throws Exception {
        try (FileWriter out = new FileWriter(filename);){
            out.write(data.toXML());
        }
        MainCLI.printMessage("Saved profile " + data.getId() + " to " + filename);
    }

    public static ProfileData readProfileFromFile(String filename) throws Exception {
        String xml = Files.readString(Path.of(filename, new String[0]));
        return ProfileData.fromXML((String)xml);
    }

    public static byte[] readRawProfileFromFile(Path path) throws PKIException, IOException {
        byte[] s = Files.readAllBytes(path);
        ProfileCLI.checkConfiguration(s, true, false);
        return s;
    }

    public static byte[] readRawProfileFromFile(String path) throws PKIException, IOException {
        return ProfileCLI.readRawProfileFromFile(Paths.get(path, new String[0]));
    }

    public static void checkConfiguration(byte[] in, boolean requireProfileId, boolean requireDisabled) throws PKIException {
        Properties p = new Properties();
        try {
            p.load(new ByteArrayInputStream(in));
        }
        catch (IOException e) {
            throw new PKIException("Failed to parse profile configuration", (Throwable)e);
        }
        if (requireProfileId && p.getProperty("profileId") == null) {
            throw new PKIException("Missing profileId property in profile data.");
        }
        String enabled = p.getProperty("enable");
        if (requireDisabled && Boolean.valueOf(enabled).booleanValue()) {
            throw new PKIException("Cannot edit profile. Profile must be disabled.");
        }
    }

    public static void saveEnrollmentTemplateToFile(String filename, CertEnrollmentRequest request) throws Exception {
        try (FileWriter out = new FileWriter(filename);){
            out.write(request.toXML());
        }
        MainCLI.printMessage("Saved enrollment template for " + request.getProfileId() + " to " + filename);
    }

    public static void printEnrollmentTemplate(CertEnrollmentRequest request) {
        System.out.println("  Profile ID: " + request.getProfileId());
        System.out.println("  Renewal: " + request.isRenewal());
        for (ProfileInput input : request.getInputs()) {
            System.out.println();
            System.out.println("  Name: " + input.getName());
            System.out.println("  Class: " + input.getClassId());
            for (ProfileAttribute attr : input.getAttributes()) {
                System.out.println();
                System.out.println("    Attribute Name: " + attr.getName());
                System.out.println("    Attribute Description: " + attr.getDescriptor().getDescription(Locale.getDefault()));
                System.out.println("    Attribute Syntax: " + attr.getDescriptor().getSyntax());
            }
        }
        for (ProfileOutput output : request.getOutputs()) {
            System.out.println();
            System.out.println("  Name: " + output.getName());
            System.out.println("  Class: " + output.getClassId());
            for (ProfileAttribute attr : output.getAttrs()) {
                System.out.println();
                System.out.println("    Attribute Name: " + attr.getName());
                System.out.println("    Attribute Description: " + attr.getDescriptor().getDescription(Locale.getDefault()));
                System.out.println("    Attribute Syntax: " + attr.getDescriptor().getSyntax());
            }
        }
    }
}

