/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.ca;

import com.fasterxml.jackson.databind.JsonNode;
import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.authority.AuthorityClient;
import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.client.ClientConfig;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.client.SubsystemClient;
import com.netscape.certsrv.group.GroupClient;
import com.netscape.certsrv.profile.ProfileClient;
import com.netscape.certsrv.selftests.SelfTestClient;
import com.netscape.certsrv.system.FeatureClient;
import com.netscape.certsrv.system.KRAConnectorInfo;
import com.netscape.certsrv.user.UserClient;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.cmsutil.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAClient
extends SubsystemClient {
    public static final Logger logger = LoggerFactory.getLogger(CAClient.class);

    public CAClient(PKIClient client) throws Exception {
        super(client, "ca");
        this.init();
    }

    public void init() throws Exception {
        this.addClient(new AuthorityClient(this.client, this.name));
        this.addClient(new CACertClient(this.client, this.name));
        this.addClient(new FeatureClient(this.client, this.name));
        this.addClient(new GroupClient(this));
        this.addClient(new ProfileClient(this.client, this.name));
        this.addClient(new SelfTestClient(this.client, this.name));
        this.addClient(new UserClient(this));
    }

    public PKCS7 getCertChain() throws Exception {
        ClientConfig config = this.client.getConfig();
        URL serverURL = config.getServerURL();
        logger.info("Getting certificate chain from " + serverURL);
        String c = this.client.get("ca/admin/ca/getCertChain", String.class);
        logger.debug("Response: " + c);
        if (c == null) {
            throw new IOException("Unable to get certificate chain from " + serverURL);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(c.getBytes());
        JSONObject jsonObj = new JSONObject(bis);
        JsonNode responseNode = jsonObj.getJsonNode().get("Response");
        String chain = responseNode.get("ChainBase64").asText();
        if (chain == null || chain.length() <= 0) {
            throw new IOException("Missing certificate chain");
        }
        byte[] bytes = CryptoUtil.base64Decode(CryptoUtil.normalizeCertStr(chain));
        return new PKCS7(bytes);
    }

    public void addKRAConnector(KRAConnectorInfo info, String sessionID) throws Exception {
        MultivaluedHashMap content = new MultivaluedHashMap();
        content.putSingle((Object)"ca.connector.KRA.enable", (Object)info.getEnable());
        content.putSingle((Object)"ca.connector.KRA.local", (Object)info.getLocal());
        content.putSingle((Object)"ca.connector.KRA.timeout", (Object)info.getTimeout());
        content.putSingle((Object)"ca.connector.KRA.uri", (Object)info.getUri());
        content.putSingle((Object)"ca.connector.KRA.host", (Object)info.getHost());
        content.putSingle((Object)"ca.connector.KRA.port", (Object)info.getPort());
        content.putSingle((Object)"ca.connector.KRA.subsystemCert", (Object)info.getSubsystemCert());
        content.putSingle((Object)"ca.connector.KRA.transportCert", (Object)info.getTransportCert());
        content.putSingle((Object)"ca.connector.KRA.transportCertNickname", (Object)info.getTransportCertNickname());
        content.putSingle((Object)"sessionID", (Object)sessionID);
        logger.debug("CAClient: content: " + (MultivaluedMap)content);
        String response = this.client.post("ca/admin/ca/updateConnector", (MultivaluedMap<String, String>)content, String.class);
        logger.debug("CAClient: Response: " + response);
        if (response == null || response.equals("")) {
            logger.error("CAClient: Unable to update connector: No response");
            throw new IOException("Unable to update connector: No response");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(response.getBytes());
        JSONObject jsonObj = new JSONObject(bis);
        JsonNode responseNode = jsonObj.getJsonNode().get("Response");
        String status = responseNode.get("Status").asText();
        logger.debug("CAClient: status: " + status);
        if (!status.equals("0")) {
            if (status.equals("2")) {
                logger.error("CAClient: Unable to update connector: Authentication failure");
                throw new EAuthException("Unable to update connector: Authentication failure");
            }
            String error = jsonObj.getJsonNode().get("Error").asText();
            logger.error("CAClient: Unable to update connector: " + error);
            throw new IOException("Unable to update connector: " + error);
        }
        logger.debug("CAClient: Connector updated");
    }

    public void addOCSPPublisher(URL url, String subsystemCert, String sessionID) throws Exception {
        MultivaluedHashMap content = new MultivaluedHashMap();
        content.putSingle((Object)"xmlOutput", (Object)"true");
        content.putSingle((Object)"ocsp_host", (Object)url.getHost());
        content.putSingle((Object)"ocsp_port", (Object)("" + url.getPort()));
        content.putSingle((Object)"subsystemCert", (Object)subsystemCert);
        content.putSingle((Object)"sessionID", (Object)sessionID);
        logger.debug("CAClient: content: " + (MultivaluedMap)content);
        String response = this.client.post("ca/ee/ca/updateOCSPConfig", (MultivaluedMap<String, String>)content, String.class);
        logger.debug("CAClient: Response: " + response);
        if (response == null || response.equals("")) {
            logger.error("CAClient: Unable to update publisher: No response");
            throw new IOException("Unable to update publisher: No response");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(response.getBytes());
        JSONObject jsonObj = new JSONObject(bis);
        JsonNode responseNode = jsonObj.getJsonNode().get("Response");
        String status = responseNode.get("Status").asText();
        logger.debug("CAClient: status: " + status);
        if (!status.equals("0")) {
            if (status.equals("2")) {
                logger.error("CAClient: Unable to update publisher: Authentication failure");
                throw new EAuthException("Unable to update publisher: Authentication failure");
            }
            String error = responseNode.get("Error").asText();
            logger.error("CAClient: Unable to update publisher: " + error);
            throw new IOException("Unable to update publisher: " + error);
        }
        logger.debug("CAClient: Publisher updated");
    }
}

