/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.key;

import com.netscape.certsrv.base.RESTMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class KeyGenerationRequest
extends RESTMessage {
    protected static final String CLIENT_KEY_ID = "clientKeyID";
    protected static final String KEY_SIZE = "keySize";
    protected static final String KEY_ALGORITHM = "keyAlgorithm";
    protected static final String KEY_USAGE = "keyUsage";
    protected static final String TRANS_WRAPPED_SESSION_KEY = "transWrappedSessionKey";
    protected static final String REALM = "realm";

    public List<String> getUsages() {
        String usageString = (String)this.attributes.get(KEY_USAGE);
        if (!StringUtils.isBlank((CharSequence)usageString)) {
            return new ArrayList<String>(Arrays.asList(usageString.split(",")));
        }
        return new ArrayList<String>();
    }

    public void setUsages(List<String> usages) {
        this.attributes.put(KEY_USAGE, StringUtils.join(usages, (String)","));
    }

    public void addUsage(String usage) {
        List<String> usages = this.getUsages();
        for (String u : usages) {
            if (!u.equals(usage)) continue;
            return;
        }
        usages.add(usage);
        this.setUsages(usages);
    }

    public String getClientKeyId() {
        return (String)this.attributes.get(CLIENT_KEY_ID);
    }

    public void setClientKeyId(String clientKeyId) {
        this.attributes.put(CLIENT_KEY_ID, clientKeyId);
    }

    public Integer getKeySize() {
        try {
            return Integer.valueOf((String)this.attributes.get(KEY_SIZE));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void setKeySize(Integer keySize) {
        this.attributes.put(KEY_SIZE, keySize.toString());
    }

    public String getKeyAlgorithm() {
        return (String)this.attributes.get(KEY_ALGORITHM);
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.attributes.put(KEY_ALGORITHM, keyAlgorithm);
    }

    public String getTransWrappedSessionKey() {
        return (String)this.attributes.get(TRANS_WRAPPED_SESSION_KEY);
    }

    public void setTransWrappedSessionKey(String transWrappedSessionKey) {
        this.attributes.put(TRANS_WRAPPED_SESSION_KEY, transWrappedSessionKey);
    }

    public String getRealm() {
        return (String)this.attributes.get(REALM);
    }

    public void setRealm(String realm) {
        if (realm != null) {
            this.attributes.put(REALM, realm);
        } else {
            this.attributes.remove(REALM);
        }
    }
}

