/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.usrgrp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmscore.apps.CMS;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import netscape.ldap.LDAPAttribute;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class User
implements JSONSerializer {
    public static final String ATTR_SCOPE = "userScope";
    public static final String ATTR_NAME = "userName";
    public static final String ATTR_ID = "userId";
    public static final String ATTR_FULLNAME = "userFullName";
    public static final String ATTR_PASSWORD = "userPassword";
    public static final String ATTR_STATE = "userstate";
    public static final String ATTR_EMAIL = "userEmail";
    public static final String ATTR_USERTYPE = "usertype";
    public static final String ATTR_TPS_PROFILES = "tpsProfiles";
    public static final String ATTR_X509_CERTIFICATES = "userCertificates";
    public static final String ATTRIBUTES = "attributes";
    public static final String CMS_BASE_INVALID_ATTRIBUTE = "CMS_BASE_INVALID_ATTRIBUTE";
    private String userid;
    private String userDN;
    private String fullName;
    private String password;
    private String email;
    private String phone;
    private String state;
    private String certDN;
    private String userType;
    private X509Certificate[] x509Certs;
    private List<String> tpsProfiles;
    private List<LDAPAttribute> attrs;
    private static final Set<String> names = Set.of("userName", "userId", "userFullName", "userPassword", "userstate", "userEmail", "userCertificates", "usertype", "tpsProfiles", "attributes");

    public List<String> getTpsProfiles() {
        return this.tpsProfiles;
    }

    public void setTpsProfiles(List<String> tpsProfiles) {
        if (tpsProfiles == null) {
            this.tpsProfiles = null;
            return;
        }
        boolean setAll = false;
        for (String profile : tpsProfiles) {
            if (!profile.equals("All Profiles")) continue;
            setAll = true;
            break;
        }
        if (!setAll) {
            this.tpsProfiles = tpsProfiles;
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add("All Profiles");
            this.tpsProfiles = list;
        }
    }

    public User() {
    }

    @Deprecated
    public User(String userid) {
        this.userid = userid;
    }

    @JsonIgnore
    @Deprecated
    public String getName() {
        return this.userid;
    }

    @JsonProperty(value="id")
    public String getUserID() {
        return this.userid;
    }

    public void setUserID(String userID) {
        this.userid = userID;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String name) {
        this.fullName = name;
    }

    public String getUserDN() {
        return this.userDN;
    }

    public void setUserDN(String userdn) {
        this.userDN = userdn;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getState() {
        return this.state;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setState(String state) {
        this.state = state;
    }

    public X509Certificate[] getX509Certificates() {
        return this.x509Certs;
    }

    public void setX509Certificates(X509Certificate[] certs) {
        this.x509Certs = certs;
    }

    public String getCertDN() {
        return this.certDN;
    }

    public void setCertDN(String dn) {
        this.certDN = dn;
    }

    public List<LDAPAttribute> getAttributes() {
        return this.attrs;
    }

    public void setAttributes(List<LDAPAttribute> attributes) {
        this.attrs = attributes;
    }

    public void set(String name, Object object) throws EBaseException {
        if (name.equals(ATTR_NAME)) {
            throw new EBaseException(CMS.getUserMessage(CMS_BASE_INVALID_ATTRIBUTE, name));
        }
        if (name.equals(ATTR_ID)) {
            throw new EBaseException(CMS.getUserMessage(CMS_BASE_INVALID_ATTRIBUTE, name));
        }
        if (name.equals(ATTR_FULLNAME)) {
            this.setFullName((String)object);
        } else if (name.equals(ATTR_STATE)) {
            this.setState((String)object);
        } else if (name.equals(ATTR_PASSWORD)) {
            this.setPassword((String)object);
        } else if (name.equals(ATTR_X509_CERTIFICATES)) {
            this.setX509Certificates((X509Certificate[])object);
        } else if (name.equals(ATTR_USERTYPE)) {
            this.setUserType((String)object);
        } else if (name.equals(ATTR_TPS_PROFILES)) {
            this.setTpsProfiles((List)object);
        } else if (name.equals(ATTRIBUTES)) {
            this.setAttributes((List)object);
        } else {
            throw new EBaseException(CMS.getUserMessage(CMS_BASE_INVALID_ATTRIBUTE, name));
        }
    }

    public Object get(String name) throws EBaseException {
        if (name.equals(ATTR_NAME)) {
            return this.getUserID();
        }
        if (name.equals(ATTR_ID)) {
            return this.getUserID();
        }
        if (name.equals(ATTR_STATE)) {
            return this.getState();
        }
        if (name.equals(ATTR_FULLNAME)) {
            return this.getFullName();
        }
        if (name.equals(ATTR_PASSWORD)) {
            return this.getPassword();
        }
        if (name.equals(ATTR_X509_CERTIFICATES)) {
            return this.getX509Certificates();
        }
        if (name.equals(ATTR_USERTYPE)) {
            return this.getUserType();
        }
        if (name.equals(ATTR_TPS_PROFILES)) {
            return this.getTpsProfiles();
        }
        if (name.equals(ATTRIBUTES)) {
            return this.getAttributes();
        }
        throw new EBaseException(CMS.getUserMessage(CMS_BASE_INVALID_ATTRIBUTE, name));
    }

    public void delete(String name) throws EBaseException {
        throw new EBaseException(CMS.getUserMessage(CMS_BASE_INVALID_ATTRIBUTE, name));
    }

    @JsonIgnore
    public Enumeration<String> getElements() {
        return Collections.enumeration(names);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.x509Certs);
        result = 31 * result + Objects.hash(this.attrs, this.certDN, this.email, this.fullName, this.password, this.phone, this.state, this.userDN, this.userType, this.userid, this.tpsProfiles);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.attrs, other.attrs) && Objects.equals(this.certDN, other.certDN) && Objects.equals(this.email, other.email) && Objects.equals(this.fullName, other.fullName) && Objects.equals(this.password, other.password) && Objects.equals(this.phone, other.phone) && Objects.equals(this.state, other.state) && Objects.equals(this.userDN, other.userDN) && Objects.equals(this.userType, other.userType) && Objects.equals(this.userid, other.userid) && Arrays.equals(this.x509Certs, other.x509Certs) && Objects.equals(this.tpsProfiles, other.tpsProfiles);
    }

    public static void main(String[] args) throws Exception {
        User before = new User();
        before.setUserID("testuser");
        before.setFullName("Test User");
        before.setEmail("testuser@example.com");
        String json = before.toJSON();
        System.out.println("Before: " + json);
        User after = (User)JSONSerializer.fromJSON((String)json, User.class);
        System.out.println("After: " + after.toJSON());
        System.out.println(before.equals(after));
    }
}

