/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.dogtagpki.acme.ACMEAccount;
import org.dogtagpki.acme.ACMEAuthorization;
import org.dogtagpki.acme.ACMEChallenge;
import org.dogtagpki.acme.ACMEError;
import org.dogtagpki.acme.ACMEOrder;
import org.dogtagpki.acme.ValidationResult;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.validator.ACMEValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACMEChallengeProcessor
implements Runnable {
    public static Logger logger = LoggerFactory.getLogger(ACMEChallengeProcessor.class);
    ACMEAccount account;
    ACMEAuthorization authorization;
    ACMEChallenge challenge;
    ACMEValidator validator;

    public ACMEChallengeProcessor(ACMEAccount account, ACMEAuthorization authorization, ACMEChallenge challenge, ACMEValidator validator) {
        this.account = account;
        this.authorization = authorization;
        this.challenge = challenge;
        this.validator = validator;
    }

    @Override
    public void run() {
        try {
            this.processChallenge();
        }
        catch (Exception e) {
            logger.error("Unable to process challenge " + this.challenge.getID() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void processChallenge() throws Exception {
        String challengeID = this.challenge.getID();
        logger.info("Processing challenge " + challengeID);
        int maxAttempts = 5;
        int delaySeconds = 5;
        int attempts = 0;
        ValidationResult r = null;
        while (attempts++ < maxAttempts) {
            try {
                r = this.validator.validateChallenge(this.authorization, this.challenge);
            }
            catch (Exception e) {
                ACMEError error = new ACMEError();
                error.setType("urn:ietf:params:acme:error:serverInternal");
                error.setDetail("Internal server error: " + e);
                r = ValidationResult.fail((ACMEError)error);
            }
            if (r.isOK()) break;
            Thread.sleep(delaySeconds * 1000);
        }
        if (r.isOK()) {
            this.finalizeValidAuthorization();
        } else {
            this.finalizeInvalidAuthorization(r.getError());
        }
    }

    public void finalizeValidAuthorization() throws Exception {
        Date currentTime = new Date();
        ACMEEngine engine = ACMEEngine.getInstance();
        String authzID = this.authorization.getID();
        String challengeID = this.challenge.getID();
        logger.info("Challenge " + challengeID + " is valid");
        this.challenge.setStatus("valid");
        this.challenge.setValidationTime(currentTime);
        ArrayList<ACMEChallenge> challenges = new ArrayList<ACMEChallenge>();
        challenges.add(this.challenge);
        this.authorization.setChallenges(challenges);
        logger.info("Authorization " + authzID + " is valid");
        this.authorization.setStatus("valid");
        Date expirationTime = engine.getPolicy().getValidAuthorizationExpirationTime(currentTime);
        this.authorization.setExpirationTime(expirationTime);
        engine.updateAuthorization(this.account, this.authorization);
        logger.info("Updating pending orders");
        Collection<ACMEOrder> orders = engine.getOrdersByAuthorizationAndStatus(this.account, authzID, "pending");
        for (ACMEOrder order : orders) {
            boolean allAuthorizationsValid = true;
            for (String orderAuthzID : order.getAuthzIDs()) {
                ACMEAuthorization authz = engine.getAuthorization(this.account, orderAuthzID);
                if (authz.getStatus().equals("valid")) continue;
                allAuthorizationsValid = false;
                break;
            }
            if (!allAuthorizationsValid) continue;
            logger.info("Order " + order.getID() + " is ready");
            order.setStatus("ready");
            Date orderExpirationTime = engine.getPolicy().getReadyOrderExpirationTime(currentTime);
            order.setExpirationTime(orderExpirationTime);
            engine.updateOrder(this.account, order);
        }
    }

    public void finalizeInvalidAuthorization(ACMEError err) throws Exception {
        Date currentTime = new Date();
        ACMEEngine engine = ACMEEngine.getInstance();
        String authzID = this.authorization.getID();
        String challengeID = this.challenge.getID();
        logger.info("Challenge " + challengeID + " is invalid");
        this.challenge.setStatus("invalid");
        this.challenge.setError(err.toJSON());
        ArrayList<ACMEChallenge> challenges = new ArrayList<ACMEChallenge>();
        challenges.add(this.challenge);
        this.authorization.setChallenges(challenges);
        logger.info("Authorization " + authzID + " is invalid");
        this.authorization.setStatus("invalid");
        Date expirationTime = engine.getPolicy().getInvalidAuthorizationExpirationTime(currentTime);
        this.authorization.setExpirationTime(expirationTime);
        engine.updateAuthorization(this.account, this.authorization);
        logger.info("Updating pending orders");
        Collection<ACMEOrder> orders = engine.getOrdersByAuthorizationAndStatus(this.account, authzID, "pending");
        for (ACMEOrder order : orders) {
            boolean allAuthorizationsValid = true;
            for (String orderAuthzID : order.getAuthzIDs()) {
                ACMEAuthorization authz = engine.getAuthorization(this.account, orderAuthzID);
                if (authz.getStatus().equals("valid")) continue;
                allAuthorizationsValid = false;
                break;
            }
            if (allAuthorizationsValid) continue;
            logger.info("Order " + order.getID() + " is invalid");
            order.setStatus("invalid");
            Date orderExpirationTime = engine.getPolicy().getInvalidOrderExpirationTime(currentTime);
            order.setExpirationTime(orderExpirationTime);
            engine.updateOrder(this.account, order);
        }
    }
}

