/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.kra.rest;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.authorization.EAuthzUnknownRealm;
import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.HTTPGoneException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.base.UnauthorizedException;
import com.netscape.certsrv.dbs.EDBRecordNotFoundException;
import com.netscape.certsrv.dbs.ModificationSet;
import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.key.KeyData;
import com.netscape.certsrv.key.KeyInfo;
import com.netscape.certsrv.key.KeyInfoCollection;
import com.netscape.certsrv.key.KeyNotFoundException;
import com.netscape.certsrv.key.KeyRecoveryRequest;
import com.netscape.certsrv.key.KeyResource;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.SecurityDataExportEvent;
import com.netscape.certsrv.logging.event.SecurityDataInfoEvent;
import com.netscape.certsrv.logging.event.SecurityDataRecoveryEvent;
import com.netscape.certsrv.logging.event.SecurityDataRecoveryProcessedEvent;
import com.netscape.certsrv.logging.event.SecurityDataStatusChangeEvent;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cms.servlet.base.SubsystemService;
import com.netscape.cms.servlet.key.KeyRequestDAO;
import com.netscape.cmscore.authorization.AuthzSubsystem;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.request.RequestRepository;
import com.netscape.cmsutil.ldap.LDAPUtil;
import com.netscape.kra.KeyRecoveryAuthority;
import java.math.BigInteger;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyService
extends SubsystemService
implements KeyResource {
    public static Logger logger = LoggerFactory.getLogger(KeyService.class);
    public static final int DEFAULT_MAXRESULTS = 100;
    public static final int DEFAULT_MAXTIME = 10;
    public static final String ATTR_SERIALNO = "serialNumber";
    private KeyRepository repo;
    private KeyRecoveryAuthority kra;
    private RequestRepository requestRepository;
    private RequestQueue queue;
    private KeyRecoveryAuthority service;
    private RequestId requestId;
    private KeyId keyId;
    private String auditInfo;
    private String approvers;

    public KeyService() {
        KRAEngine engine = KRAEngine.getInstance();
        this.kra = (KeyRecoveryAuthority)engine.getSubsystem("kra");
        this.repo = this.kra.getKeyRepository();
        this.requestRepository = engine.getRequestRepository();
        this.queue = engine.getRequestQueue();
        this.service = this.kra;
    }

    public Response retrieveKey(KeyRecoveryRequest data) {
        logger.info("KeyService: Processing key recovery request");
        try {
            Response response = this.retrieveKeyImpl(data);
            return response;
        }
        catch (RuntimeException e) {
            logger.error("Unable to recover key: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to recover key: " + e.getMessage(), (Throwable)e);
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public Response retrieveKeyImpl(KeyRecoveryRequest data) throws Exception {
        if (data == null) {
            this.auditRetrieveKeyError("KeyService: Missing key recovery request");
            throw new BadRequestException("Missing key recovery request");
        }
        logger.info("KeyService: Request:\n" + data.toJSON());
        this.auditInfo = "KeyService.retrieveKey";
        String realm = null;
        boolean synchronous = false;
        boolean ephemeral = false;
        this.requestId = data.getRequestId();
        Request request = null;
        if (this.requestId != null) {
            logger.debug("KeyService: Searching for asynchronous request " + this.requestId);
            this.auditInfo = this.auditInfo + ";requestID=" + this.requestId;
            try {
                request = this.requestRepository.readRequest(this.requestId);
            }
            catch (EBaseException e) {
                this.auditRetrieveKeyError(e.getMessage());
                throw new PKIException(e.getMessage(), (Throwable)e);
            }
            if (request == null) {
                this.auditRetrieveKeyError("Request not found: " + this.requestId);
                throw new BadRequestException("Request not found: " + this.requestId);
            }
            this.keyId = new KeyId(request.getExtDataInString(ATTR_SERIALNO));
            logger.debug("KeyService: Request found for key " + this.keyId);
            this.auditInfo = this.auditInfo + ";keyID=" + this.keyId;
            data.setKeyId(this.keyId);
        } else {
            this.keyId = data.getKeyId();
            logger.info("KeyService: Retrieving key " + this.keyId);
            if (this.keyId == null) {
                this.auditRetrieveKeyError("Missing recovery request ID and key ID");
                throw new BadRequestException("Missing recovery request ID and key ID");
            }
            this.auditInfo = this.auditInfo + ";keyID=" + this.keyId;
            logger.info("KeyService: realm: " + realm);
            synchronous = this.kra.isRetrievalSynchronous(realm);
            logger.info("KeyService: synchronous: " + synchronous);
            ephemeral = this.kra.isEphemeral(realm);
            logger.info("KeyService: ephemeral: " + ephemeral);
            if (!synchronous) {
                ephemeral = false;
            }
            this.auditInfo = this.auditInfo + ";synchronous=" + synchronous;
            this.auditInfo = this.auditInfo + ";ephemeral=" + ephemeral;
            logger.info("KeyService: Creating recovery request");
            KeyRequestDAO reqDAO = new KeyRequestDAO();
            try {
                request = reqDAO.createRecoveryRequest(data, this.uriInfo, this.getRequestor(), this.getAuthToken(), ephemeral);
            }
            catch (EBaseException e) {
                this.auditRetrieveKeyError("Unable to create recovery request: " + e.getMessage());
                throw new PKIException("Unable to create recovery request: " + e.getMessage(), (Throwable)e);
            }
            this.requestId = request.getRequestId();
            logger.info("KeyService: Created request " + this.requestId);
            this.auditInfo = this.auditInfo + ";requestID=" + this.requestId;
            if (!synchronous) {
                logger.info("KeyService: Storing request in database");
                try {
                    this.requestRepository.updateRequest(request);
                }
                catch (EBaseException e) {
                    logger.error("KeyService: " + e.getMessage(), (Throwable)e);
                    this.auditRecoveryRequest("Failure");
                    throw new PKIException(e.getMessage(), (Throwable)e);
                }
                this.auditRecoveryRequest("Success");
                logger.info("KeyService: Returning created recovery request");
                KeyData keyData = new KeyData();
                keyData.setRequestID(this.requestId);
                logger.info("KeyService: Response:\n" + keyData.toJSON());
                return this.createOKResponse(keyData);
            }
            this.auditRecoveryRequest("Success");
        }
        data.setRequestId(this.requestId);
        String type = request.getRequestType();
        logger.debug("KeyService: request type: " + type);
        this.auditInfo = this.auditInfo + ";request type:" + type;
        KeyData keyData = null;
        try {
            switch (type) {
                case "recovery": {
                    logger.info("KeyService: Processing key recovery request");
                    keyData = this.recoverKey(data);
                    break;
                }
                case "securityDataRecovery": {
                    logger.info("KeyService: Processing security data recovery request");
                    if (synchronous) {
                        request.setRequestStatus(RequestStatus.APPROVED);
                    }
                    this.validateRequest(data, request);
                    keyData = this.getKey(this.keyId, request, data, synchronous, ephemeral);
                    break;
                }
                default: {
                    throw new BadRequestException("Invalid request type: " + type);
                }
            }
        }
        catch (Exception e) {
            this.auditRecoveryRequestProcessed("Failure", e.getMessage());
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
        if (keyData == null) {
            this.auditRecoveryRequestProcessed("Failure", "No key record");
            throw new HTTPGoneException("No key record.");
        }
        this.approvers = request.getExtDataInString("approvingAgents");
        this.auditRecoveryRequestProcessed("Success", null);
        logger.info("KeyService: Response:\n" + keyData.toJSON());
        this.auditRetrieveKey("Success");
        return this.createOKResponse(keyData);
    }

    public Response retrieveKey(MultivaluedMap<String, String> form) {
        logger.debug("KeyService.retrieveKey with form: begins.");
        KeyRecoveryRequest data = new KeyRecoveryRequest(form);
        return this.retrieveKey(data);
    }

    public KeyData getKey(KeyId keyId, Request request, KeyRecoveryRequest data, boolean synchronous, boolean ephemeral) throws EBaseException {
        byte[] pubKeyBytes;
        Integer keySize;
        KeyData keyData;
        String method;
        this.auditInfo = method = "KeyService.getKey:";
        KeyRequestDAO dao = new KeyRequestDAO();
        logger.debug(method + "begins.");
        if (data == null) {
            logger.warn(method + "KeyRecoveryRequest is null");
            return null;
        }
        if (request == null) {
            logger.warn(method + "request null");
            return null;
        }
        KeyRecord rec = this.repo.readKeyRecord(keyId.toBigInteger());
        if (rec == null) {
            logger.warn(method + "key record null");
            return null;
        }
        this.auditInfo = this.auditInfo + ";keyID=" + keyId.toString();
        this.auditInfo = this.auditInfo + ";requestID=" + this.requestId.toString();
        this.auditInfo = this.auditInfo + ";synchronous=" + Boolean.toString(synchronous);
        this.auditInfo = this.auditInfo + ";ephemeral=" + Boolean.toString(ephemeral);
        Hashtable<String, Object> requestParams = dao.getTransientData(request);
        String sessWrappedKeyData = (String)requestParams.get("sessWrappedSecData");
        String passWrappedKeyData = (String)requestParams.get("passPhraseWrappedData");
        String nonceData = (String)requestParams.get("iv_out");
        if (sessWrappedKeyData != null || passWrappedKeyData != null) {
            keyData = new KeyData();
        } else {
            nonceData = data.getNonceData();
            dao.setTransientData(data, request);
            try {
                if (!synchronous) {
                    request.setRequestStatus(RequestStatus.BEGIN);
                    this.queue.processRequest(request);
                } else {
                    this.kra.processSynchronousRequest(request);
                }
            }
            catch (EBaseException e) {
                this.kra.destroyVolatileRequest(request.getRequestId());
                throw new PKIException(e.getMessage(), (Throwable)e);
            }
            keyData = new KeyData();
            sessWrappedKeyData = (String)requestParams.get("sessWrappedSecData");
            passWrappedKeyData = (String)requestParams.get("passPhraseWrappedData");
            nonceData = (String)requestParams.get("iv_out");
        }
        if (sessWrappedKeyData != null) {
            keyData.setWrappedPrivateData(sessWrappedKeyData);
        }
        if (passWrappedKeyData != null) {
            keyData.setWrappedPrivateData(passWrappedKeyData);
        }
        if (nonceData != null) {
            keyData.setNonceData(nonceData);
        }
        keyData.setType((String)requestParams.get("dataType"));
        String payloadWrapped = (String)requestParams.get("payloadWrapped");
        if (payloadWrapped.equalsIgnoreCase("true")) {
            keyData.setWrapAlgorithm((String)requestParams.get("payloadWrappingName"));
        } else {
            keyData.setEncryptAlgorithmOID((String)requestParams.get("payloadEncryptionOID"));
        }
        String algorithm = rec.getAlgorithm();
        if (algorithm != null) {
            keyData.setAlgorithm(algorithm);
        }
        if ((keySize = rec.getKeySize()) != null) {
            keyData.setSize(keySize);
        }
        if ((pubKeyBytes = rec.getPublicKeyData()) != null) {
            keyData.setPublicKey(Utils.base64encode((byte[])pubKeyBytes, (boolean)true));
        }
        this.kra.destroyVolatileRequest(request.getRequestId());
        if (!synchronous) {
            this.queue.markAsServiced(request);
        } else {
            request.setRequestStatus(RequestStatus.COMPLETE);
            if (!ephemeral) {
                this.requestRepository.updateRequest(request);
            }
        }
        return keyData;
    }

    private void validateRequest(KeyRecoveryRequest data, Request request) {
        String method = "KeyService.validateRequest: ";
        logger.debug(method + "begins.");
        if (data.getTransWrappedSessionKey() == null) {
            throw new BadRequestException("No wrapping method found.");
        }
        String keyID = request.getExtDataInString(ATTR_SERIALNO);
        if (!data.getKeyId().toString().contentEquals(keyID)) {
            throw new UnauthorizedException("Key IDs do not match");
        }
        String retriever = this.servletRequest.getUserPrincipal().getName();
        String originator = request.getExtDataInString("requestOwner");
        if (!originator.equals(retriever)) {
            throw new UnauthorizedException("Data can only be retrieved by the originators of the request");
        }
        RequestStatus status = request.getRequestStatus();
        if (!status.equals((Object)RequestStatus.APPROVED)) {
            throw new UnauthorizedException("Recovery request not approved.");
        }
    }

    public Response listKeys(String clientKeyID, String status, Integer maxResults, Integer maxTime, Integer start, Integer size, String realm, String ownerName) {
        KeyInfoCollection keys = this.listKeyInfos(clientKeyID, status, maxResults, maxTime, start, size, realm, ownerName);
        try {
            return this.createOKResponse(keys);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public KeyInfoCollection listKeyInfos(String clientKeyID, String status, Integer maxResults, Integer maxTime, Integer start, Integer size, String realm, String ownerName) {
        logger.info("KeyService: Searching for keys");
        logger.info("KeyService: - client key ID: " + clientKeyID);
        logger.info("KeyService: - status: " + status);
        this.auditInfo = "KeyService.listKeyInfos; status =" + status;
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        KRAEngine engine = (KRAEngine)this.getCMSEngine();
        if (realm != null) {
            try {
                AuthzSubsystem authz = engine.getAuthzSubsystem();
                authz.checkRealm(realm, this.getAuthToken(), null, "certServer.kra.keys", "list");
            }
            catch (EAuthzAccessDenied e) {
                throw new UnauthorizedException("Unauthorized: " + e.getMessage(), (Throwable)e);
            }
            catch (EAuthzUnknownRealm e) {
                throw new BadRequestException("Unknown realm: " + e.getMessage(), (Throwable)e);
            }
            catch (EBaseException e) {
                logger.error("Unable to access realm: " + e.getMessage(), (Throwable)e);
                throw new PKIException("Unable to access realm: " + e.getMessage(), (Throwable)e);
            }
        }
        String filter = this.createSearchFilter(status, clientKeyID, realm, ownerName);
        logger.info("KeyService: - filter: " + filter);
        maxResults = maxResults == null ? 100 : maxResults;
        maxTime = maxTime == null ? 10 : maxTime;
        KeyInfoCollection infos = new KeyInfoCollection();
        try {
            Enumeration<KeyRecord> e = this.repo.searchKeys(filter, maxResults, maxTime);
            if (e == null) {
                return infos;
            }
            logger.info("KeyService: Results:");
            ArrayList<KeyInfo> results = new ArrayList<KeyInfo>();
            while (e.hasMoreElements()) {
                KeyRecord rec = e.nextElement();
                if (rec == null) continue;
                KeyInfo info = this.createKeyDataInfo(rec, false);
                logger.info("KeyService: - key " + info.getKeyId());
                results.add(info);
                this.auditKeyInfoSuccess(info.getKeyId(), null);
            }
            int total = results.size();
            logger.info("KeyService: Total: " + total);
            infos.setTotal(total);
            for (int i = start.intValue(); i < start + size && i < total; ++i) {
                infos.addEntry((Object)((KeyInfo)results.get(i)));
            }
        }
        catch (EBaseException e) {
            throw new PKIException("Unable to list keys: " + e.getMessage(), (Throwable)e);
        }
        return infos;
    }

    public Response getActiveKeyInfo(String clientKeyID) {
        try {
            return this.getActiveKeyInfoImpl(clientKeyID);
        }
        catch (RuntimeException e) {
            this.auditKeyInfoError(null, clientKeyID, e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.auditKeyInfoError(null, clientKeyID, e.getMessage());
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public Response getActiveKeyInfoImpl(String clientKeyID) {
        String method = "KeyService.getActiveKeyInfo: ";
        this.auditInfo = "KeyService.getActiveKeyInfo";
        logger.debug(method + "begins.");
        KeyInfoCollection infos = this.listKeyInfos(clientKeyID, "active", null, null, null, null, null, null);
        KRAEngine engine = (KRAEngine)this.getCMSEngine();
        Collection list = infos.getEntries();
        for (KeyInfo info : list) {
            if (info == null) continue;
            try {
                AuthzSubsystem authz = engine.getAuthzSubsystem();
                authz.checkRealm(info.getRealm(), this.getAuthToken(), info.getOwnerName(), "certServer.kra.key", "read");
            }
            catch (EAuthzAccessDenied e) {
                throw new UnauthorizedException("Not authorized to read this key", (Throwable)e);
            }
            catch (EBaseException e) {
                logger.error("listRequests: unable to authorize realm: " + e.getMessage(), (Throwable)e);
                throw new PKIException(e.toString(), (Throwable)e);
            }
            this.auditKeyInfoSuccess(info.getKeyId(), clientKeyID);
            return this.createOKResponse(info);
        }
        throw new ResourceNotFoundException("Key not found");
    }

    public KeyInfo createKeyDataInfo(KeyRecord rec, boolean getPublicKey) throws EBaseException {
        String realm;
        String method = "KeyService.createKeyDataInfo: ";
        logger.debug(method + "begins.");
        KeyInfo ret = new KeyInfo();
        ret.setClientKeyID(rec.getClientId());
        ret.setStatus(rec.getKeyStatus());
        ret.setAlgorithm(rec.getAlgorithm());
        ret.setSize(rec.getKeySize());
        ret.setOwnerName(rec.getOwnerName());
        if (rec.getPublicKeyData() != null && getPublicKey) {
            ret.setPublicKey(rec.getPublicKeyData());
        }
        if ((realm = rec.getRealm()) != null) {
            ret.setRealm(realm);
        }
        Path keyPath = KeyResource.class.getAnnotation(Path.class);
        BigInteger serial = rec.getSerialNumber();
        KeyId keyID = new KeyId(serial);
        ret.setKeyId(keyID);
        UriBuilder keyBuilder = this.uriInfo.getBaseUriBuilder();
        keyBuilder.path(keyPath.value() + "/" + keyID.toHexString());
        ret.setKeyURL(keyBuilder.build(new Object[0]).toString());
        return ret;
    }

    private String createSearchFilter(String status, String clientKeyID, String realm, String ownerName) {
        Object filter = "";
        int matches = 0;
        if (status == null && clientKeyID == null && ownerName == null) {
            filter = "(serialno=*)";
            ++matches;
        }
        if (ownerName != null) {
            filter = "(keyOwnerName=" + LDAPUtil.escapeFilter((Object)ownerName) + ")";
            ++matches;
        }
        if (status != null) {
            filter = (String)filter + "(status=" + LDAPUtil.escapeFilter((Object)status) + ")";
            ++matches;
        }
        if (clientKeyID != null) {
            filter = (String)filter + "(clientID=" + LDAPUtil.escapeFilter((Object)clientKeyID) + ")";
            ++matches;
        }
        if (realm != null) {
            filter = (String)filter + "(realm=" + LDAPUtil.escapeFilter((Object)realm) + ")";
            ++matches;
        } else {
            filter = (String)filter + "(!(realm=*))";
            ++matches;
        }
        if (matches > 1) {
            filter = "(&" + (String)filter + ")";
        }
        return filter;
    }

    public void auditRetrieveKey(String status, String reason) {
        Auditor auditor = this.getCMSEngine().getAuditor();
        auditor.log((LogEvent)new SecurityDataExportEvent(this.servletRequest.getUserPrincipal().getName(), status, this.requestId, this.keyId, (String)(reason != null ? this.auditInfo + ";" + reason : this.auditInfo), null));
    }

    public void auditRetrieveKey(String status) {
        this.auditRetrieveKey(status, null);
    }

    public void auditRetrieveKeyError(String message) {
        logger.warn(message);
        this.auditRetrieveKey("Failure", message);
    }

    public void auditKeyInfo(KeyId keyId, String clientKeyId, String status, String reason) {
        Auditor auditor = this.getCMSEngine().getAuditor();
        auditor.log((LogEvent)new SecurityDataInfoEvent(this.servletRequest.getUserPrincipal().getName(), status, keyId, clientKeyId, (String)(reason != null ? this.auditInfo + ";" + reason : this.auditInfo), null));
    }

    public void auditKeyInfoSuccess(KeyId keyId, String clientKeyId) {
        this.auditKeyInfo(keyId, clientKeyId, "Success", null);
    }

    public void auditKeyInfoError(KeyId keyId, String clientKeyId, String message) {
        logger.warn(message);
        this.auditKeyInfo(keyId, clientKeyId, "Failure", message);
    }

    public void auditKeyStatusChange(String status, KeyId keyID, String oldKeyStatus, String newKeyStatus, String info) {
        Auditor auditor = this.getCMSEngine().getAuditor();
        auditor.log((LogEvent)new SecurityDataStatusChangeEvent(this.servletRequest.getUserPrincipal().getName(), status, keyID, oldKeyStatus, newKeyStatus, info));
    }

    public void auditRecoveryRequest(String status) {
        Auditor auditor = this.getCMSEngine().getAuditor();
        auditor.log((LogEvent)new SecurityDataRecoveryEvent(this.servletRequest.getUserPrincipal().getName(), status, this.requestId, this.keyId, null));
    }

    public void auditRecoveryRequestProcessed(String status, String reason) {
        Auditor auditor = this.getCMSEngine().getAuditor();
        auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(this.servletRequest.getUserPrincipal().getName(), status, this.requestId, this.keyId, (String)(reason != null ? this.auditInfo + ";" + reason : this.auditInfo), this.approvers));
    }

    private KeyData recoverKey(KeyRecoveryRequest data) throws Exception {
        String method = "KeyService.recoverKey: ";
        this.auditInfo = "KeyService.recoverKey";
        logger.debug(method + "begins.");
        RequestId reqId = data.getRequestId();
        Request request = this.requestRepository.readRequest(reqId);
        if (request == null) {
            throw new HTTPGoneException("Request not found: " + reqId);
        }
        String type = request.getRequestType();
        RequestStatus status = request.getRequestStatus();
        if (!"recovery".equals(type) || !status.equals((Object)RequestStatus.APPROVED)) {
            throw new UnauthorizedException("Request not approved");
        }
        KeyRequestDAO dao = new KeyRequestDAO();
        try {
            dao.setTransientData(data, request);
        }
        catch (EBaseException e) {
            throw new PKIException("Unable to set transient data: " + e.getMessage(), (Throwable)e);
        }
        String passphrase = data.getPassphrase();
        byte[] pkcs12 = this.service.doKeyRecovery(reqId.toString(), passphrase);
        if (pkcs12 == null) {
            throw new HTTPGoneException("Unable to generate PKCS #12 file");
        }
        String pkcs12base64encoded = Utils.base64encode((byte[])pkcs12, (boolean)false);
        KeyData keyData = new KeyData();
        keyData.setP12Data(pkcs12base64encoded);
        try {
            this.queue.processRequest(request);
            logger.debug(method + "queue.processRequest returned");
            this.queue.markAsServiced(request);
        }
        catch (EBaseException e) {
            logger.debug(method + "queue.processRequest failed bug ignored: " + e.toString());
        }
        return keyData;
    }

    public Response getKeyInfo(KeyId keyId) {
        try {
            return this.getKeyInfoImpl(keyId);
        }
        catch (RuntimeException e) {
            this.auditKeyInfoError(keyId, null, e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.auditKeyInfoError(keyId, null, e.getMessage());
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public Response getKeyInfoImpl(KeyId keyId) {
        String method = "KeyService.getKeyInfo: ";
        this.auditInfo = "KeyService.getKeyInfo";
        logger.debug(method + "begins.");
        KRAEngine engine = (KRAEngine)this.getCMSEngine();
        KeyRecord rec = null;
        try {
            rec = this.repo.readKeyRecord(keyId.toBigInteger());
            AuthzSubsystem authz = engine.getAuthzSubsystem();
            authz.checkRealm(rec.getRealm(), this.getAuthToken(), rec.getOwnerName(), "certServer.kra.key", "read");
            KeyInfo info = this.createKeyDataInfo(rec, true);
            this.auditKeyInfoSuccess(keyId, null);
            return this.createOKResponse(info);
        }
        catch (EAuthzAccessDenied e) {
            throw new UnauthorizedException("Unauthorized access for key record", (Throwable)e);
        }
        catch (EDBRecordNotFoundException e) {
            throw new KeyNotFoundException(keyId, "key not found", (Throwable)e);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    private AuthToken getAuthToken() {
        Principal principal = this.servletRequest.getUserPrincipal();
        PKIPrincipal pkiprincipal = (PKIPrincipal)principal;
        AuthToken authToken = pkiprincipal.getAuthToken();
        return authToken;
    }

    public Response modifyKeyStatus(KeyId keyId, String status) {
        String method = "KeyService.modifyKeyStatus: ";
        this.auditInfo = "KeyService.modifyKeyStatus";
        logger.info("Modifying key " + keyId + " status to " + status);
        KeyRecord rec = null;
        KeyInfo info = null;
        try {
            rec = this.repo.readKeyRecord(keyId.toBigInteger());
            info = this.createKeyDataInfo(rec, true);
            ModificationSet mods = new ModificationSet();
            mods.add("status", 2, (Object)status);
            this.repo.modifyKeyRecord(keyId.toBigInteger(), mods);
            logger.info("Key status modified");
            this.auditKeyStatusChange("Success", keyId, info != null ? info.getStatus() : null, status, this.auditInfo);
            return this.createNoContentResponse();
        }
        catch (EDBRecordNotFoundException e) {
            logger.error("Unable to modify key status: " + e.getMessage(), (Throwable)e);
            this.auditInfo = this.auditInfo + ":" + e.getMessage();
            this.auditKeyStatusChange("Failure", keyId, info != null ? info.getStatus() : null, status, this.auditInfo);
            throw new KeyNotFoundException(keyId, "key not found to modify", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unable to modify key status: " + e.getMessage(), (Throwable)e);
            this.auditInfo = this.auditInfo + ":" + e.getMessage();
            this.auditKeyStatusChange("Failure", keyId, info != null ? info.getStatus() : null, status, this.auditInfo);
            throw new PKIException("Unable to modify key status: " + e.getMessage(), (Throwable)e);
        }
    }

    private String getRequestor() {
        return this.servletRequest.getUserPrincipal().getName();
    }
}

