/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.tomcat;

import com.netscape.cms.tomcat.ExternalPrincipal;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalAuthenticationValve
extends ValveBase {
    static final Logger logger = LoggerFactory.getLogger(ExternalAuthenticationValve.class);

    public void invoke(Request req, Response resp) throws IOException, ServletException {
        logger.info("ExternalAuthenticationValve: authType: " + req.getAuthType());
        logger.info("ExternalAuthenticationValve: principal: " + req.getUserPrincipal());
        org.apache.coyote.Request coyoteReq = req.getCoyoteRequest();
        Object principal = req.getUserPrincipal();
        if (principal != null) {
            Integer numGroups = 0;
            String numGroupsStr = (String)coyoteReq.getAttribute("REMOTE_USER_GROUP_N");
            if (numGroupsStr != null) {
                try {
                    numGroups = Integer.valueOf(numGroupsStr);
                }
                catch (NumberFormatException e) {
                    logger.warn("ExternalAuthenticationValve: invalid REMOTE_USER_GROUP_N value: " + e);
                }
            }
            ArrayList<String> groups = new ArrayList<String>();
            for (int i = 1; i <= numGroups; ++i) {
                String k = "REMOTE_USER_GROUP_" + i;
                String s = (String)coyoteReq.getAttribute(k);
                if (s != null && !s.isEmpty()) {
                    groups.add(s);
                    continue;
                }
                logger.warn("ExternalAuthenticationValve: missing or empty attribute: " + k);
            }
            principal = new ExternalPrincipal(principal.getName(), null, groups, coyoteReq.getAttributes());
            logger.info("ExternalAuthenticationValve: setting new principal: " + principal);
            req.setUserPrincipal(principal);
            Session session = req.getSessionInternal();
            session.setAuthType(req.getAuthType());
            session.setPrincipal(principal);
        }
        this.getNext().invoke(req, resp);
    }
}

