/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.coding;

import java.util.List;
import java.util.Optional;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;

@Rule(key="ComplexityCheck")
public final class ComplexityCheck
extends AbstractPageCheck {
    private static final int DEFAULT_MAX_COMPLEXITY = 10;
    @RuleProperty(key="max", description="Maximum allowed complexity", defaultValue="10")
    public int max = 10;

    @Override
    public void startDocument(List<Node> nodes) {
        int complexity = Optional.ofNullable(this.getHtmlSourceCode().getMeasure(CoreMetrics.COMPLEXITY)).orElse(0);
        if (complexity > this.max) {
            String msg = String.format("Split this file to reduce complexity per file from %d to no more than the %d authorized.", complexity, this.max);
            this.createViolation(0, msg, Double.valueOf(complexity - this.max));
        }
    }
}

