/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonVisitorCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S1066")
public class CollapsibleIfStatementsCheck
extends PythonVisitorCheck {
    public static final String CHECK_KEY = "S1066";
    private static final String MESSAGE = "Merge this if statement with the enclosing one.";
    private Set<Tree> ignored = new HashSet<Tree>();

    @Override
    public void scanFile(PythonVisitorContext visitorContext) {
        this.ignored.clear();
        super.scanFile(visitorContext);
    }

    @Override
    public void visitIfStatement(IfStatement ifStatement) {
        List<Statement> statements = ifStatement.body().statements();
        if (!ifStatement.elifBranches().isEmpty()) {
            if (ifStatement.elseBranch() == null) {
                this.ignored.addAll(ifStatement.elifBranches().subList(0, ifStatement.elifBranches().size() - 1));
            } else {
                this.ignored.addAll(ifStatement.elifBranches());
            }
        }
        if (!this.ignored.contains(ifStatement) && ifStatement.elseBranch() == null && ifStatement.elifBranches().isEmpty() && statements.size() == 1 && statements.get(0).is(Tree.Kind.IF_STMT)) {
            IfStatement singleIfChild = (IfStatement)statements.get(0);
            if (singleIfChild.isElif() || singleIfChild.elseBranch() != null || !singleIfChild.elifBranches().isEmpty()) {
                return;
            }
            this.addIssue(singleIfChild.keyword(), MESSAGE).secondary(ifStatement.keyword(), "enclosing");
        }
        super.visitIfStatement(ifStatement);
    }
}

