/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.impl.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.internal.DefaultNewRepository;
import org.sonar.api.server.rule.internal.DefaultRepository;
import org.sonar.api.utils.Preconditions;

public class RulesDefinitionContext
extends RulesDefinition.Context {
    private final Map<String, RulesDefinition.Repository> repositoriesByKey = new HashMap<String, RulesDefinition.Repository>();
    private String currentPluginKey = null;

    @Override
    public RulesDefinition.NewRepository createRepository(String key, String language) {
        return new DefaultNewRepository(this, key, language, false);
    }

    @Override
    public RulesDefinition.NewRepository createExternalRepository(String engineId, String language) {
        return new DefaultNewRepository(this, "external_" + engineId, language, true);
    }

    @Override
    @Deprecated
    public RulesDefinition.NewRepository extendRepository(String key, String language) {
        return this.createRepository(key, language);
    }

    @Override
    @CheckForNull
    public RulesDefinition.Repository repository(String key) {
        return this.repositoriesByKey.get(key);
    }

    @Override
    public List<RulesDefinition.Repository> repositories() {
        return Collections.unmodifiableList(new ArrayList<RulesDefinition.Repository>(this.repositoriesByKey.values()));
    }

    @Override
    @Deprecated
    public List<RulesDefinition.ExtendedRepository> extendedRepositories(String repositoryKey) {
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    public List<RulesDefinition.ExtendedRepository> extendedRepositories() {
        return Collections.emptyList();
    }

    @Override
    public void registerRepository(DefaultNewRepository newRepository) {
        RulesDefinition.Repository existing = this.repositoriesByKey.get(newRepository.key());
        if (existing != null) {
            String existingLanguage = existing.language();
            Preconditions.checkState(existingLanguage.equals(newRepository.language()), "The rule repository '%s' must not be defined for two different languages: %s and %s", newRepository.key(), existingLanguage, newRepository.language());
        }
        this.repositoriesByKey.put(newRepository.key(), new DefaultRepository(newRepository, existing));
    }

    @Override
    public String currentPluginKey() {
        return this.currentPluginKey;
    }

    @Override
    public void setCurrentPluginKey(@Nullable String pluginKey) {
        this.currentPluginKey = pluginKey;
    }
}

