/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scm.git.JGitUtils;

public class IncludedFilesRepository {
    private static final Logger LOG = Loggers.get(IncludedFilesRepository.class);
    private final Set<Path> includedFiles = new HashSet<Path>();

    public IncludedFilesRepository(Path baseDir) throws IOException {
        this.indexFiles(baseDir);
        LOG.debug("{} non excluded files in this Git repository", (Object)this.includedFiles.size());
    }

    public boolean contains(Path absolutePath) {
        return this.includedFiles.contains(absolutePath);
    }

    private void indexFiles(Path baseDir) throws IOException {
        try (Repository repo = JGitUtils.buildRepository(baseDir);){
            Path workTreeRoot = repo.getWorkTree().toPath();
            FileTreeIterator workingTreeIt = new FileTreeIterator(repo);
            try (TreeWalk treeWalk = new TreeWalk(repo);){
                treeWalk.setRecursive(true);
                if (!baseDir.equals(workTreeRoot)) {
                    Path relativeBaseDir = workTreeRoot.relativize(baseDir);
                    treeWalk.setFilter(PathFilterGroup.createFromStrings(relativeBaseDir.toString().replace('\\', '/')));
                }
                treeWalk.addTree(workingTreeIt);
                while (treeWalk.next()) {
                    WorkingTreeIterator workingTreeIterator = treeWalk.getTree(0, WorkingTreeIterator.class);
                    if (workingTreeIterator.isEntryIgnored()) continue;
                    this.includedFiles.add(workTreeRoot.resolve(treeWalk.getPathString()));
                }
            }
        }
    }
}

