/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Version;
import org.sonar.updatecenter.common.exception.DependencyCycleException;
import org.sonar.updatecenter.common.exception.IncompatiblePluginVersionException;
import org.sonar.updatecenter.common.exception.PluginNotFoundException;

public class PluginReferential {
    private Set<Plugin> plugins = new TreeSet<Plugin>();

    private PluginReferential() {
    }

    public static PluginReferential create(List<Plugin> pluginList) {
        PluginReferential pluginReferential = new PluginReferential();
        for (Plugin plugin : pluginList) {
            pluginReferential.add(plugin);
        }
        return pluginReferential;
    }

    public static PluginReferential createEmpty() {
        return PluginReferential.create(new ArrayList<Plugin>());
    }

    public List<Plugin> getLastMasterReleasePlugins() {
        return this.plugins.stream().filter(plugin -> plugin.getLastRelease() != null).collect(Collectors.toList());
    }

    public List<Plugin> getPlugins() {
        return new ArrayList<Plugin>(this.plugins);
    }

    public Plugin findPlugin(String key) {
        return this.plugins.stream().filter(plugin -> plugin.getKey().equals(key)).findFirst().orElseThrow(() -> new NoSuchElementException("Unable to find plugin with key " + key));
    }

    public boolean doesContainPlugin(String key) {
        return this.plugins.stream().anyMatch(plugin -> plugin.getKey().equals(key));
    }

    public boolean doesContainRelease(String key, Version version) {
        for (Plugin plugin : this.plugins) {
            if (!plugin.getKey().equals(key) || !plugin.doesContainVersion(version)) continue;
            return true;
        }
        return false;
    }

    public List<String> findLastReleasesWithDependencies(String pluginKey) {
        Release pluginRelease;
        ArrayList<String> removablePlugins = new ArrayList<String>();
        Plugin plugin = this.findPlugin(pluginKey);
        if (plugin != null && (pluginRelease = plugin.getLastRelease()) != null) {
            removablePlugins.add(plugin.getKey());
            for (Release incomingDependencies : pluginRelease.getIncomingDependencies()) {
                removablePlugins.addAll(this.findLastReleasesWithDependencies(incomingDependencies.getArtifact().getKey()));
            }
        }
        return removablePlugins;
    }

    public void addOutgoingDependency(Release release, String requiredPluginReleaseKey, String requiredMinimumReleaseVersion) {
        try {
            Plugin requiredPlugin = this.findPlugin(requiredPluginReleaseKey);
            Release minimalRequiredRelease = requiredPlugin.getMinimalRelease(Version.create(requiredMinimumReleaseVersion));
            if (minimalRequiredRelease != null) {
                release.addOutgoingDependency(minimalRequiredRelease);
                minimalRequiredRelease.addIncomingDependency(release);
                this.checkDependencyCycle(release);
            } else {
                Release latest = requiredPlugin.getLastRelease();
                if (latest != null) {
                    throw new IncompatiblePluginVersionException(String.format("The plugin '%s' is in version %s whereas the plugin '%s' requires a least a version %s.", requiredPlugin.getKey(), latest.getVersion().getName(), release.getArtifact().getKey(), requiredMinimumReleaseVersion));
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new PluginNotFoundException(String.format("The plugin '%s' required by '%s' is missing.", requiredPluginReleaseKey, release.getArtifact().getKey()), e);
        }
    }

    private void checkDependencyCycle(Release release) {
        ArrayList<Release> releases = new ArrayList<Release>();
        try {
            PluginReferential.checkDependencyCycle(release, releases);
        }
        catch (DependencyCycleException e) {
            String releaseKeys = releases.stream().map(rel -> rel.getArtifact().getKey()).collect(Collectors.joining("', '"));
            throw new DependencyCycleException("There is a dependency cycle between plugins '" + releaseKeys + "' that must be cut.", e);
        }
    }

    private static void checkDependencyCycle(Release release, List<Release> releases) {
        for (Release outgoingDependency : release.getOutgoingDependencies()) {
            if (releases.contains(outgoingDependency)) {
                throw new DependencyCycleException();
            }
            releases.add(outgoingDependency);
            PluginReferential.checkDependencyCycle(outgoingDependency, releases);
        }
    }

    List<Release> getLastMasterReleases() {
        ArrayList<Release> releases = new ArrayList<Release>();
        for (Plugin plugin : this.getLastMasterReleasePlugins()) {
            releases.add(plugin.getLastRelease());
        }
        return releases;
    }

    private PluginReferential add(Plugin plugin) {
        this.plugins.add(plugin);
        return this;
    }
}

