/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2912")
public class IndexOfStartPositionCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final MethodMatchers INDEX_OF_METHOD = MethodMatchers.create().ofTypes("java.lang.String").names("indexOf").addParametersMatcher("java.lang.String").build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO);
    }

    @Override
    public void visitNode(Tree tree) {
        ExpressionTree leftOperand = ExpressionUtils.skipParentheses(((BinaryExpressionTree)tree).leftOperand());
        ExpressionTree rightOperand = ExpressionUtils.skipParentheses(((BinaryExpressionTree)tree).rightOperand());
        if (leftOperand.is(Tree.Kind.METHOD_INVOCATION)) {
            this.checkIndexOfInvocation((MethodInvocationTree)leftOperand, rightOperand);
        } else if (rightOperand.is(Tree.Kind.METHOD_INVOCATION)) {
            this.checkIndexOfInvocation((MethodInvocationTree)rightOperand, leftOperand);
        }
    }

    private void checkIndexOfInvocation(MethodInvocationTree mit, ExpressionTree other) {
        if (INDEX_OF_METHOD.matches(mit)) {
            ExpressionTree firstPar = (ExpressionTree)mit.arguments().get(0);
            String replaceMessage = firstPar.is(Tree.Kind.STRING_LITERAL) ? ((LiteralTree)firstPar).value() : (firstPar.is(Tree.Kind.IDENTIFIER) ? ((IdentifierTree)firstPar).name() : "xxx");
            Long otherValue = LiteralUtils.longLiteralValue(other);
            if (otherValue != null && otherValue != -1L && otherValue != 0L) {
                this.reportIssue(ExpressionUtils.methodName(mit), "Use \".indexOf(" + replaceMessage + ",n) > -1\" instead.");
            }
        }
    }
}

