/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3740")
public class RawTypeCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitMethod(MethodTree tree) {
        if (!tree.symbol().overriddenSymbols().isEmpty()) {
            this.scan(tree.block());
        } else {
            this.checkTypeTree(tree.returnType());
            super.visitMethod(tree);
        }
    }

    @Override
    public void visitParameterizedType(ParameterizedTypeTree tree) {
        tree.typeArguments().stream().filter(TypeTree.class::isInstance).map(TypeTree.class::cast).forEach(this::checkTypeTree);
        super.visitParameterizedType(tree);
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
        this.checkTypeTree(tree.identifier());
        super.visitNewClass(tree);
    }

    @Override
    public void visitVariable(VariableTree tree) {
        this.checkTypeTree(tree.type());
        super.visitVariable(tree);
    }

    @Override
    public void visitClass(ClassTree tree) {
        tree.superInterfaces().forEach(this::checkTypeTree);
        this.checkTypeTree(tree.superClass());
        super.visitClass(tree);
    }

    private void checkTypeTree(@Nullable TypeTree typeTree) {
        if (typeTree == null) {
            return;
        }
        if (typeTree.is(Tree.Kind.IDENTIFIER)) {
            this.checkIdentifier((IdentifierTree)typeTree);
        } else if (typeTree.is(Tree.Kind.MEMBER_SELECT)) {
            this.checkIdentifier(((MemberSelectExpressionTree)typeTree).identifier());
        }
    }

    private void checkIdentifier(IdentifierTree identifier) {
        Type type = identifier.symbolType();
        if (JUtils.isRawType(type) && !type.equals(JUtils.declaringType(type))) {
            this.context.reportIssue(this, identifier, "Provide the parametrized type for this generic.");
        }
    }
}

