/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2301")
public class SelectorMethodArgumentCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (Boolean.TRUE.equals(methodTree.isOverriding())) {
            return;
        }
        List<Symbol> booleanParameterSymbols = SelectorMethodArgumentCheck.getBooleanParametersAsSymbol(methodTree.parameters());
        BlockTree blockTree = methodTree.block();
        if (SelectorMethodArgumentCheck.isPublic(methodTree) && blockTree != null && !booleanParameterSymbols.isEmpty()) {
            for (Symbol variable : booleanParameterSymbols) {
                List<IdentifierTree> usages = variable.usages();
                if (usages.size() != 1) continue;
                blockTree.accept(new ConditionalStatementVisitor(variable.name(), usages.get(0), methodTree));
            }
        }
    }

    private static boolean isPublic(MethodTree methodTree) {
        return ModifiersUtils.hasModifier(methodTree.modifiers(), Modifier.PUBLIC);
    }

    private static List<Symbol> getBooleanParametersAsSymbol(List<VariableTree> parameters) {
        LinkedList<Symbol> booleanParameters = new LinkedList<Symbol>();
        for (VariableTree variableTree : parameters) {
            if (!SelectorMethodArgumentCheck.isBooleanVariable(variableTree)) continue;
            booleanParameters.add(variableTree.symbol());
        }
        return booleanParameters;
    }

    private static boolean isBooleanVariable(VariableTree variableTree) {
        return variableTree.type().symbolType().isPrimitive(Type.Primitives.BOOLEAN);
    }

    private class ConditionalStatementVisitor
    extends BaseTreeVisitor {
        private final String variableName;
        private final MethodTree method;
        private final IdentifierTree usage;

        public ConditionalStatementVisitor(String variableName, IdentifierTree usage, MethodTree method) {
            this.variableName = variableName;
            this.usage = usage;
            this.method = method;
        }

        @Override
        public void visitIfStatement(IfStatementTree tree) {
            this.checkParameterUsage(tree.condition());
        }

        @Override
        public void visitConditionalExpression(ConditionalExpressionTree tree) {
            this.checkParameterUsage(tree.condition());
        }

        private void checkParameterUsage(ExpressionTree condition) {
            if (this.usage.equals(condition)) {
                SelectorMethodArgumentCheck.this.reportIssue(this.method.simpleName(), MessageFormat.format("Provide multiple methods instead of using \"{0}\" to determine which action to take.", this.variableName));
            }
        }
    }
}

