/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1449")
public class StringMethodsWithLocaleCheck
extends AbstractMethodDetection {
    private static final String STRING = "java.lang.String";
    private static final MethodMatchers STRING_FORMAT = MethodMatchers.create().ofTypes("java.lang.String").names("format").withAnyParameters().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofTypes(STRING).names("toUpperCase", "toLowerCase").addWithoutParametersMatcher().build(), STRING_FORMAT);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree report = mit.methodSelect();
        if (STRING_FORMAT.matches(mit) && (StringMethodsWithLocaleCheck.isLocaleVariant(mit) || !StringMethodsWithLocaleCheck.usesLocaleDependentFormatteer((ExpressionTree)mit.arguments().get(0)))) {
            return;
        }
        if (report.is(Tree.Kind.MEMBER_SELECT)) {
            report = ((MemberSelectExpressionTree)report).identifier();
        }
        this.reportIssue(report, "Define the locale to be used in this String operation.");
    }

    private static boolean isLocaleVariant(MethodInvocationTree mit) {
        return ((Symbol.MethodSymbol)mit.symbol()).parameterTypes().get(0).is("java.util.Locale");
    }

    private static boolean usesLocaleDependentFormatteer(ExpressionTree firstArg) {
        FormatterVisitor visitor = new FormatterVisitor();
        firstArg.accept(visitor);
        return visitor.hasLocaleDependantFormatter;
    }

    private static class FormatterVisitor
    extends BaseTreeVisitor {
        private static final String ARGUMENT_INDEX = "(\\d+\\$)?";
        private static final String FLAGS = "([-,#+ 0(]*)?";
        private static final String FLAGS_WITH_FORCED_COMMA = "([-#+ 0(]*,[-#+ 0(]*)";
        private static final String WIDTH = "([0-9]*\\.?[0-9]*)?";
        private static final String INTEGER_LOCAL_SPECIFIC_FORMAT = "([-#+ 0(]*,[-#+ 0(]*)([0-9]*\\.?[0-9]*)?d";
        private static final String DATE_TIME_FLOATING_POINT_LOCAL_SPECIFIC_FORMAT = "([-,#+ 0(]*)?([0-9]*\\.?[0-9]*)?[eEfgGaAtT]";
        private static final Pattern LOCALE_DEPENDENT_FORMATTERS = Pattern.compile("(.*)%(\\d+\\$)?(([-#+ 0(]*,[-#+ 0(]*)([0-9]*\\.?[0-9]*)?d|([-,#+ 0(]*)?([0-9]*\\.?[0-9]*)?[eEfgGaAtT])(.*)");
        private boolean hasLocaleDependantFormatter = false;

        private FormatterVisitor() {
        }

        @Override
        public void visitLiteral(LiteralTree tree) {
            String value = tree.value().replace("%%", "");
            if (tree.is(Tree.Kind.STRING_LITERAL) && LOCALE_DEPENDENT_FORMATTERS.matcher(value).matches()) {
                this.hasLocaleDependantFormatter = true;
            }
            super.visitLiteral(tree);
        }
    }
}

