/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.visitors.LinesOfCodeVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.SwitchTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1151")
public class SwitchCaseTooBigCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAX = 5;
    @RuleProperty(description="Maximum number of lines", defaultValue="5")
    public int max = 5;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.SWITCH_STATEMENT, Tree.Kind.SWITCH_EXPRESSION);
    }

    @Override
    public void visitNode(Tree tree) {
        SwitchTree switchTree = (SwitchTree)tree;
        LinesOfCodeVisitor locVisitor = new LinesOfCodeVisitor();
        switchTree.cases().forEach(cgt -> {
            int lines = cgt.body().stream().mapToInt(locVisitor::linesOfCode).sum();
            if (lines > this.max) {
                this.reportIssue(cgt.labels().get(cgt.labels().size() - 1), "Reduce this switch case number of lines from " + lines + " to at most " + this.max + ", for example by extracting code into methods.");
            }
        });
    }
}

