/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4829")
public class StandardInputReadCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers METHOD_MATCHERS = MethodMatchers.or(MethodMatchers.create().ofTypes("java.lang.System").names("setIn").withAnyParameters().build(), MethodMatchers.create().ofTypes("java.io.Console").name(name -> name.startsWith("read")).withAnyParameters().build());
    private static final MethodMatchers CLOSE_METHOD = MethodMatchers.create().ofAnyType().names("close").addWithoutParametersMatcher().build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.METHOD_REFERENCE, Tree.Kind.IDENTIFIER);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.METHOD_INVOCATION) && METHOD_MATCHERS.matches((MethodInvocationTree)tree)) {
            this.reportIssue(tree);
        } else if (tree.is(Tree.Kind.METHOD_REFERENCE) && METHOD_MATCHERS.matches((MethodReferenceTree)tree)) {
            this.reportIssue(tree);
        } else if (tree.is(Tree.Kind.IDENTIFIER)) {
            this.checkIdentifier((IdentifierTree)tree);
        }
    }

    private void checkIdentifier(IdentifierTree identifier) {
        Symbol symbol = identifier.symbol();
        if (!symbol.isVariableSymbol()) {
            return;
        }
        Symbol owner = symbol.owner();
        if (!owner.isUnknown() && owner.type().is("java.lang.System") && symbol.type().is("java.io.InputStream") && identifier.name().equals("in") && !StandardInputReadCheck.isClosingStream(identifier.parent())) {
            this.reportIssue(identifier);
        }
    }

    private static boolean isClosingStream(Tree parentExpression) {
        if (parentExpression.is(Tree.Kind.PARENTHESIZED_EXPRESSION) || parentExpression.is(Tree.Kind.MEMBER_SELECT)) {
            return StandardInputReadCheck.isClosingStream(parentExpression.parent());
        }
        if (parentExpression.is(Tree.Kind.METHOD_INVOCATION)) {
            return CLOSE_METHOD.matches((MethodInvocationTree)parentExpression);
        }
        if (parentExpression.is(Tree.Kind.METHOD_REFERENCE)) {
            return CLOSE_METHOD.matches((MethodReferenceTree)parentExpression);
        }
        return false;
    }

    private void reportIssue(Tree tree) {
        this.reportIssue(tree, "Make sure that reading the standard input is safe here.");
    }
}

